/*==========================================================================
* BLKWRT.C - Copyright (c) 1994 ATI Technologies Inc. All rights reserved  *
*                                                                          *
* PGL functions to enable and disable the block write engine feature.      *
* ======================================================================== */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>
#include <memory.h>
#include <dos.h>

#include "..\inc\atim64.h"
#include "..\inc\pgl.h"
#include "..\inc\pglglob.h"

/* --------------------------------------------------------------------------
  PGL_enableblockwrite - enables block write feature
  
  This function enables the block write feature of the Mach64 engine. The
  PGL functions do not disturb this bit on the GEN_TEST_CNTL register, so
  this function can be used dynamically.
-------------------------------------------------------------------------- */
void PGL_enableblockwrite(void)
{
    // block write is only available on Mach64 GX with VRAM memory variant
    if (PGL_modecfg.chip_type == CHIP_GX_ID)
    {
        regw(GEN_TEST_CNTL, regr(GEN_TEST_CNTL) | BLOCKWRITE_ENABLE);
    }
}

/* --------------------------------------------------------------------------
  PGL_disableblockwrite - disables block write feature
  
  This function disables the block write feature of the Mach64 engine. The
  PGL functions do not disturb this bit on the GEN_TEST_CNTL register, so
  this function can be used dynamically.
-------------------------------------------------------------------------- */
void PGL_disableblockwrite(void)
{
    // block write is only available on Mach64 GX with VRAM memory variant
    if (PGL_modecfg.chip_type == CHIP_GX_ID)
    {
        regw(GEN_TEST_CNTL, regr(GEN_TEST_CNTL) & (~BLOCKWRITE_ENABLE));
    }
}

