/*==========================================================================
* BOUNDS.C - Copyright (c) 1993 ATI Technologies Inc. All rights reserved  *
*                                                                          *
* PGL functions that control bounds setting.                               *
* ======================================================================== */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>
#include <memory.h>

#include "..\inc\atim64.h"
#include "..\inc\pgl.h"
#include "..\inc\pglglob.h"

/* --------------------------------------------------------------------------
  PGL_setclippsize - set the clipping rectangle size.

  The given coordinates are inclusive.
-------------------------------------------------------------------------- */
void PGL_setclipsize(int left, int top, int right, int bottom)
{
    if (PGL_modecfg.bpp == 24)
    {
        left = left * 3;
        right = right * 3;
    }

    PGL_waitforfifo(4);
    regw(SC_LEFT, left);
    regw(SC_TOP, top);
    regw(SC_RIGHT, right);
    regw(SC_BOTTOM, bottom);
}

/* --------------------------------------------------------------------------
  PGL_getclipsize - get the clipping rectangle size.
-------------------------------------------------------------------------- */
void PGL_getclipsize(PGL_scissor *scissor)
{
    PGL_waitforidle();
    scissor->left = (int)regr(SC_LEFT);
    scissor->top = (int)regr(SC_TOP);
    scissor->right = (int)regr(SC_RIGHT);
    scissor->bottom = (int)regr(SC_BOTTOM);

    if (PGL_modecfg.bpp == 24)
    {
        scissor->left = scissor->left / 3;
        scissor->right = scissor->right / 3;
    }
}

