/*==========================================================================
* CRTTABLE.C - Copyright (c) 1994 ATI Technologies Inc. All rights reserved*
*                                                                          *
* PGL functions to get predefined VESA compliant CRT tables. These         *
* functions should only be used if the hardware & monitor can support it.  *
* ======================================================================== */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>
#include <dos.h>
#include <malloc.h>

#include "..\inc\atim64.h"
#include "..\inc\pgl.h"
#include "..\inc\pglglob.h"

// IBM VGA mode CRT table
PGL_crttable mode_640x480_60 =       // clock code = 08h
{
    0x00, 0x00, 0x80, 0x00, 0x0800,
    0x63, 0x4f, 0x51, 0x2c,
    0x020c, 0x01df, 0x1e9, 0x22,
    0xff, 0x09d6,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

// VESA mode CRT tables
PGL_crttable mode_640x480_72 =       // clock code = 08h
{
    0x00, 0x00, 0x80, 0x00, 0x0800,
    0x67, 0x4f, 0x52, 0x25,
    0x0207, 0x01df, 0x1e8, 0x23,
    0xff, 0x0c30,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
PGL_crttable mode_640x480_75 =       // clock code = 08h
{
    0x00, 0x00, 0x80, 0x00, 0x0800,
    0x68, 0x4f, 0x51, 0x28,
    0x01f3, 0x01df, 0x1e0, 0x23,
    0xff, 0x0c4e,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
PGL_crttable mode_800x600_56 =       // clock code = 08h
{
    0x00, 0x00, 0x80, 0x00, 0x0800,
    0x7f, 0x63, 0x66, 0x09,
    0x0270, 0x0257, 0x258, 0x02,
    0xff, 0x0e10,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
PGL_crttable mode_800x600_60  =      // clock code = 04h
{
    0x00, 0x00, 0x80, 0x00, 0x0800,
    0x83, 0x63, 0x68, 0x10,
    0x0273, 0x0257, 0x258, 0x04,
    0xff, 0x0fa0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
PGL_crttable mode_800x600_72  =      // clock code = 07h
{
    0x00, 0x00, 0x80, 0x00, 0x0800,
    0x81, 0x63, 0x6a, 0x0f,
    0x029b, 0x0257, 0x27c, 0x06,
    0xff, 0x1388,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
PGL_crttable mode_800x600_75  =      // clock code = 06h
{
    0x00, 0x00, 0x80, 0x00, 0x0800,
    0x83, 0x63, 0x65, 0x0a,
    0x0270, 0x0257, 0x258, 0x03,
    0xff, 0x1356,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
PGL_crttable mode_1024x768_60  =     // clock code = 0fh
{
    0x00, 0x00, 0x80, 0x00, 0x0800,
    0xa7, 0x7f, 0x82, 0x31,
    0x0325, 0x02ff, 0x302, 0x26,
    0xff, 0x1964,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
PGL_crttable mode_1024x768_70  =     // clock code = 0eh
{
    0x00, 0x00, 0x80, 0x00, 0x0800,
    0xa5, 0x7f, 0x82, 0x11,
    0x0325, 0x02ff, 0x302, 0x06,
    0xff, 0x1d4c,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
PGL_crttable mode_1024x768_75  =     // clock code = 08h
{
    0x00, 0x00, 0x80, 0x00, 0x0800,
    0xa3, 0x7f, 0x81, 0x0c,
    0x031f, 0x02ff, 0x300, 0x03,
    0xff, 0x1ec3,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
PGL_crttable mode_1280x1024_75  =    // clock code = 0bh
{
    0x00, 0x00, 0x80, 0x00, 0x0800,
    0xd2, 0x9f, 0xa1, 0x12,
    0x0429, 0x03ff, 0x400, 0x03,
    0xff, 0x34bc,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

/* --------------------------------------------------------------------------
  PGL_getcrttable - return a pointer to a stored CRT table

  This function returns a pointer to a stored CRT table that can be used to
  set an accelerator mode with a specific vertical sync frequency. The
  majority of tables are VESA compliant. If the selected table is invalid,
  a NULL pointer will be returned.
-------------------------------------------------------------------------- */
PGL_crttable *PGL_getcrttable(int table_selection)
{
    PGL_crttable *tableptr;

    // default assignment
    tableptr = NULL;

    // get table selection
    switch(table_selection)
    {
        case CRT_640x480_60:   tableptr = &mode_640x480_60;   break;
        case CRT_640x480_72:   tableptr = &mode_640x480_72;   break;
        case CRT_640x480_75:   tableptr = &mode_640x480_75;   break;
        case CRT_800x600_56:   tableptr = &mode_800x600_56;   break;
        case CRT_800x600_60:   tableptr = &mode_800x600_60;   break;
        case CRT_800x600_72:   tableptr = &mode_800x600_72;   break;
        case CRT_800x600_75:   tableptr = &mode_800x600_75;   break;
        case CRT_1024x768_60:  tableptr = &mode_1024x768_60;  break;
        case CRT_1024x768_70:  tableptr = &mode_1024x768_70;  break;
        case CRT_1024x768_75:  tableptr = &mode_1024x768_75;  break;
        case CRT_1280x1024_75: tableptr = &mode_1280x1024_75; break;
    }

    return (tableptr);
}

