/*==========================================================================
* PGLGLOB.C - Copyright (c) 1993-94 ATI Technologies Inc. All rights reserved*
*                                                                          *
* PGL global internal variables are declared and allocated in this file.   *
* ======================================================================== */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>

#include "..\inc\pgl.h"
#include "..\inc\pglglob.h"

// internal structures
PGL_queryheader PGL_querydata = {0};
PGL_modeconfig  PGL_modecfg = {0};
PGL_attribute   PGL_attr = {0};
PGL_palette     save_palette[256] = {0};

// internal flags and save variables
int PGL_palSave = 0;
int PGL_modeSet = 0;
int PGL_savecurflag = 0;
unsigned long PGL_memBndry = 0;
unsigned int PGL_modeType = 0x03;

// default palette for 4 & 8 bpp modes
PGL_palette DefaultPalette[16] =
{
    {0, 0, 0},         // black
    {0, 0, 168},       // blue
    {0, 168, 0},       // green
    {0, 168, 168},     // cyan
    {168, 0, 0},       // red
    {168, 0, 168},     // magenta
    {168, 168, 0},     // brown
    {168, 168, 168},   // light gray
    {84, 84, 84},      // gray
    {0, 0, 255},       // light blue
    {0, 255, 0},       // light green
    {0, 255, 255},     // light cyan
    {255, 0, 0},       // light red
    {255, 0, 255},     // light magenta
    {255, 255, 0},     // yellow
    {255, 255, 255}    // white
};

// default generic color codes
PGL_genericcolors PGL_generic =
{
    // 4 & 8 bpp
    {
        BLACK,
        DARKBLUE8,
        DARKGREEN8,
        DARKCYAN8,
        DARKRED8,
        DARKMAGENTA8,
        BROWN8,
        LIGHTGRAY8,
        DARKGRAY8,
        LIGHTBLUE8,
        LIGHTGREEN8,
        LIGHTCYAN8,
        LIGHTRED8,
        LIGHTMAGENTA8,
        YELLOW8,
        WHITE8
    },
    // 15 bpp (16 bpp 555 weight)
    {
        BLACK,
        DARKBLUE15,
        DARKGREEN15,
        DARKCYAN15,
        DARKRED15,
        DARKMAGENTA15,
        BROWN15,
        LIGHTGRAY15,
        DARKGRAY15,
        LIGHTBLUE15,
        LIGHTGREEN15,
        LIGHTCYAN15,
        LIGHTRED15,
        LIGHTMAGENTA15,
        YELLOW15,
        WHITE15
    },
    // 16 bpp (16 bpp 565 weight)
    {
        BLACK,
        DARKBLUE16,
        DARKGREEN16,
        DARKCYAN16,
        DARKRED16,
        DARKMAGENTA16,
        BROWN16,
        LIGHTGRAY16,
        DARKGRAY16,
        LIGHTBLUE16,
        LIGHTGREEN16,
        LIGHTCYAN16,
        LIGHTRED16,
        LIGHTMAGENTA16,
        YELLOW16,
        WHITE16
    },
    // 24 bpp RGB weight
    {
        BLACK,
        DARKBLUE24_RGB,
        DARKGREEN24_RGB,
        DARKCYAN24_RGB,
        DARKRED24_RGB,
        DARKMAGENTA24_RGB,
        BROWN24_RGB,
        LIGHTGRAY24_RGB,
        DARKGRAY24_RGB,
        LIGHTBLUE24_RGB,
        LIGHTGREEN24_RGB,
        LIGHTCYAN24_RGB,
        LIGHTRED24_RGB,
        LIGHTMAGENTA24_RGB,
        YELLOW24_RGB,
        WHITE24_RGB
    },
    // 24 bpp BGR weight
    {
        BLACK,
        DARKBLUE24_BGR,
        DARKGREEN24_BGR,
        DARKCYAN24_BGR,
        DARKRED24_BGR,
        DARKMAGENTA24_BGR,
        BROWN24_BGR,
        LIGHTGRAY24_BGR,
        DARKGRAY24_BGR,
        LIGHTBLUE24_BGR,
        LIGHTGREEN24_BGR,
        LIGHTCYAN24_BGR,
        LIGHTRED24_BGR,
        LIGHTMAGENTA24_BGR,
        YELLOW24_BGR,
        WHITE24_BGR
    },
    // 32 bpp RGBa weight
    {
        BLACK,
        DARKBLUE32_RGBA,
        DARKGREEN32_RGBA,
        DARKCYAN32_RGBA,
        DARKRED32_RGBA,
        DARKMAGENTA32_RGBA,
        BROWN32_RGBA,
        LIGHTGRAY32_RGBA,
        DARKGRAY32_RGBA,
        LIGHTBLUE32_RGBA,
        LIGHTGREEN32_RGBA,
        LIGHTCYAN32_RGBA,
        LIGHTRED32_RGBA,
        LIGHTMAGENTA32_RGBA,
        YELLOW32_RGBA,
        WHITE32_RGBA
    },
    // 32 bpp aRGB weight
    {
        BLACK,
        DARKBLUE32_ARGB,
        DARKGREEN32_ARGB,
        DARKCYAN32_ARGB,
        DARKRED32_ARGB,
        DARKMAGENTA32_ARGB,
        BROWN32_ARGB,
        LIGHTGRAY32_ARGB,
        DARKGRAY32_ARGB,
        LIGHTBLUE32_ARGB,
        LIGHTGREEN32_ARGB,
        LIGHTCYAN32_ARGB,
        LIGHTRED32_ARGB,
        LIGHTMAGENTA32_ARGB,
        YELLOW32_ARGB,
        WHITE32_ARGB
    },
    // 32 bpp BGRa weight
    {
        BLACK,
        DARKBLUE32_BGRA,
        DARKGREEN32_BGRA,
        DARKCYAN32_BGRA,
        DARKRED32_BGRA,
        DARKMAGENTA32_BGRA,
        BROWN32_BGRA,
        LIGHTGRAY32_BGRA,
        DARKGRAY32_BGRA,
        LIGHTBLUE32_BGRA,
        LIGHTGREEN32_BGRA,
        LIGHTCYAN32_BGRA,
        LIGHTRED32_BGRA,
        LIGHTMAGENTA32_BGRA,
        YELLOW32_BGRA,
        WHITE32_BGRA
    },
    // 32 bpp aBGR weight
    {
        BLACK,
        DARKBLUE32_ABGR,
        DARKGREEN32_ABGR,
        DARKCYAN32_ABGR,
        DARKRED32_ABGR,
        DARKMAGENTA32_ABGR,
        BROWN32_ABGR,
        LIGHTGRAY32_ABGR,
        DARKGRAY32_ABGR,
        LIGHTBLUE32_ABGR,
        LIGHTGREEN32_ABGR,
        LIGHTCYAN32_ABGR,
        LIGHTRED32_ABGR,
        LIGHTMAGENTA32_ABGR,
        YELLOW32_ABGR,
        WHITE32_ABGR
    }
};

