/*==========================================================================
* SAVEMODE.C - Copyright (c) 1994 ATI Technologies Inc. All rights reserved*
*                                                                          *
* PGL functions to save and restore current text mode.                     *
* ======================================================================== */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>
#include <dos.h>

#include "..\inc\atim64.h"
#include "..\inc\pgl.h"
#include "..\inc\pglglob.h"

/* --------------------------------------------------------------------------
  pgl_getvideomode - retrieve current video mode
-------------------------------------------------------------------------- */
unsigned int pgl_getvideomode(void)
{
    union REGS regs;
    unsigned int curmode;

    // determine color or mono text mode
    int86(0x11, &regs, &regs);
    if (((regs.x.ax >> 4) & 3) == 3)
    {
        // mono text mode
        curmode = 7;
    }
    else
    {
        // color text mode

        // retrieve text mode
        regs.x.ax = 0x0f00;
        int86(0x10, &regs, &regs);
        regs.h.ah = 0;              // 25 line default

        // check for 43 line mode
        if (*((char far *)(0x00000484L)) == 0x2a)
        {
            regs.h.ah = 0x2a;
        }

        // check for 50 line mode
        if (*((char far *)(0x00000484L)) == 0x31)
        {
            regs.h.ah = 0x31;
        }

        curmode = regs.x.ax;
    }

    return (curmode);
}

/* --------------------------------------------------------------------------
  pgl_setvideomode - set the current video mode
-------------------------------------------------------------------------- */
void pgl_setvideomode(unsigned int mode)
{
    union REGS regs;

    // set text mode
    regs.x.ax = mode & 0x00ff;
	int86( 0x10, &regs, &regs );

    // set font type only if color text mode
    if ((PGL_modeType & 0x00ff) != 7)
    {
        // load 8x14 font for 43 line mode
        if ((PGL_modeType & 0xff00) == 0x2a00)
        {
            regs.x.ax = 0x1112;
            regs.x.bx = 0;
            int86( 0x10, &regs, &regs );
            regs.x.ax = 0x1102;
            regs.x.bx = 0;
            int86( 0x10, &regs, &regs );
        }

        // load 8x8 font for 50 line mode
        if ((PGL_modeType & 0xff00) == 0x3100)
        {
            regs.x.ax = 0x1112;
            regs.x.bx = 0;
            int86( 0x10, &regs, &regs );
            regs.x.ax = 0x1103;
            regs.x.bx = 0;
            int86( 0x10, &regs, &regs );
        }
    }
}

/* --------------------------------------------------------------------------
  pgl_savetextmode - save text mode for restoration by restore_text_mode()
-------------------------------------------------------------------------- */
void pgl_savetextmode(void)
{
    PGL_modeType = pgl_getvideomode();
}

/* --------------------------------------------------------------------------
  pgl_restoretextmode - restore text mode saved by save_text_mode()
-------------------------------------------------------------------------- */
void pgl_restoretextmode(void)
{
    pgl_setvideomode(PGL_modeType);
}

