	list	ON
	PL	104
	PL   60
	PW   132
;************************************************************************
;* FILE		: MOD1.ASM	UNIVERSAL				*
;* SUBJECT	: Power up and Idle loop 				*
;************************************************************************

; 3/1/91 - Release 1.0
;
	INCLUDE CONFIG.ASM
	INCLUDE RDEFINE.ASM

;========================================
;EXTERNAL DEFINITIONS
;========================================
;
;FROM MOD3.ASM
;
	EXTERNAL	DISCONNECT,CHECK_TST
	EXTERNAL	ANSWER,WR1_CNTL,MAN_ORG
	EXTERNAL	SET_IDL,CHK_PAT,SET_LCXR
	EXTERNAL	CHK070,ON_LOOP,DATS00		;133
	EXTERNAL	SPD_OUT,CHK_RET			;300
	EXTERNAL 	DISCONNECTM
;
;FROM MOD4.ASM
;
	EXTERNAL	C_ENERGY,B_ENERGY		;154
;
;FROM MOD5.ASM
;
	EXTERNAL	AT_MAIN,INIT_AT
	EXTERNAL	MSG_RING,MSG_OK,SND_RESULT
	EXTERNAL	WAIT_3MS,SYNC_DIAL,OFF_HOOK
	EXTERNAL	WAIT_E3MS,INI_CTS		;121
	EXTERNAL	UPDATE_IO,UPDAT_SPK
;
; FROM MOD6.ASM
;
	EXTERNAL	READ_NV,SAVENV
;		
;FROM MNP4.ASM
;
	IFTRUE		MICROCOM
	GLOBAL		I_MNPINIT,I_V42INIT,I_TXASYN16,I_RXASYN16
	GLOBAL		I_TXSYNTT,I_RXSYNTT,I_SNDREL,I_SETURMNP
	GLOBAL		I_SPDTX,I_SPDRX
;BBIS
	GLOBAL		I_ENCODE,I_DECODE,I_BTFLUSH
	GLOBAL		I_RMINIT
;
	EXTERNAL	SCTINT_1,FIXED2,FIXED3		;161
	EXTERNAL	LN_OUT,BK_NOW			;131
	EXTERNAL	BT_TX,BT_RX,BIS			;119
	ENDIF
;BBIS
	EXTERNAL	ENCODE,DECODE,BT_FLUSH,DICT_INIT
	EXTERNAL	MNP_INIT,V42_INIT,TX_ASYN16,RX_ASYN16
	EXTERNAL	TX_SYNTT,RX_SYNTT,SND_REL,SET_URMNP
	EXTERNAL	EC_MAIN
	EXTERNAL	MNP_IN
	EXTERNAL	SCRINT_1
	EXTERNAL	SPINT_1		;FOR V42
	EXTERNAL	SPINT		;FOR V42BIS
	EXTERNAL	V21_IN
;
;FROM	WMOD.ASM
	EXTERNAL	RD_STAT,INIT_MOD	
	
	IFFALSE	X2400
	EXTERNAL	RS_TPEQ,SET_NTD,SET_PDM,SET_SPDM
	ENDIF

	IFTRUE	FAX
;FROM	FAXPA.ASM
	EXTERNAL	FAX_ANS,FAXD_INIT
	ENDIF

;FROM MNP5.ASM
;	EXTERNAL	SEC1,SEC2,WAIT200,INIT_TIM,INI_T1

;FORM SPD
	EXTERNAL	SPD_TX,SPD_RX			;116

	IFTRUE	V.23
;FORM V23
	EXTERNAL	V23_TX,V23_RX
	ENDIF

;========================================
;Public Definitions
;========================================
	GLOBAL	EX_5,EX_TIMER5,EX_TIMER6,EX_TIMER7
	GLOBAL	PUT_DATA,S3,CTS_N1
	GLOBAL	T1_INT,INT_TIM0,HS_H
	GLOBAL	IDLE,PUT_CHAR,INIT_IO,PWR_ON
	GLOBAL	SET_SPEED,SET300,SET1200,SET2400,INIT_TIM
	GLOBAL	WARM0,WARM1,WARM_ST,WAIT200
	GLOBAL	CXR_OFF,CXR_ON
	GLOBAL	DSR_ON,DSR_OFF
	GLOBAL	HIS_ON,HIS_OFF
	GLOBAL	CTS_ON,CTS_OFF,CTS_ON1
	GLOBAL	SET_T1,SET_UR
;	GLOBAL	MNP_OUT
	GLOBAL	RX_P,TX_P,FULL
	GLOBAL	BK_RAM,RST_EC,SET_OUT
	
	IFFALSE	NSP
	GLOBAL	SPD_TXD_1,SPD_RXD_1				;116
	ENDIF

;	IFFALSE	X2400
	IFTRUE	V42ONLY
	GLOBAL	SPD_TXD,SPD_RXD					;116
	ENDIF
;	ENDIF

;
; MNP PROGRAM RE-ENTRY LOCATION
;
	IFFALSE	MICROCOM
	GLOBAL	SPD_OUTS
	ENDIF
	IFTRUE	MICROCOM
	GLOBAL	OUT_SCT,OUT_SCR,OUT_T0,OUT_T1,OUT_SP
	GLOBAL	PWR_ONS,MNP_OUT,CHK070S,DISCONNECTS
	GLOBAL	ON_LOOPS
	GLOBAL	SPD_OUTS,OUT_T2
	GLOBAL		IV42_NEGO
	EXTERNAL	V42_NEGO
;	EXTERNAL	SPD_TX,SPD_RX			;116D
	ENDIF

;MRCNT		EQU	2AH
;
;############################################################
;#                                                          #
;#                 INTERRUPT VECTORS                        #
;#                                                          #
;############################################################
;
	LIST	ON
	CODE

; -------------------------------------- MNP INTERRUPT VECTORS
	IFTRUE	MICROCOM	
;;=========================
;;POWER ON INTERRUPT VECTOR
;;=========================
;	ORG	0
PWR_ONS:	LJMP	PWR_ON
;;=========================
;;EXTERNAL INTERRUPT 0
;;=========================
;	ORG	3H
OUT_SCT:
	LJMP	SCTINT_N	;EC USED
;	LJMP	FIXED2		;EC USED
;	LJMP	SCTINT_1	;EC USED
;;=========================
;;TIMER 0 INTERRUPT VECTOR
;;=========================
;	ORG	0BH
OUT_T0:	
	LJMP	INT_TIM0	;General Purpose Timer Interrupt
;;=========================
;;EXTERNAL INTERRUPT 1
;;=========================
;	ORG	013H
OUT_SCR:
	LJMP	SCRINT_N
;	LJMP	SCRINT_1
;	LJMP	FIXED3		;161
;;=========================
;;TIMER 1 INTERRUPT VECTOR
;;=========================
;	ORG	1BH
OUT_T1:
	LJMP	T1_INT			;NOT USED
;;=========================
;;SERIAL INTERRUPT
;;=========================
;	ORG	0023H
OUT_SP:	LJMP	SP_INT			;Serial I/O Interrupt(EC USED)
	
OUT_T2:	LJMP	OUT_T2			;DUMMY 
	ENDIF


; -------------------------------------- NON-MNP INTERRUPT VECTORS
	IFFALSE	MICROCOM	
;;=========================
;;POWER ON INTERRUPT VECTOR
;;=========================
	ORG	0
PWR_ONS:
	LJMP	PWR_ON
;;=========================
;;EXTERNAL INTERRUPT 0
;;=========================
;
	ORG	3H
OUT_SCT:
	LJMP	SCTINT_N	;116 EC USED
;;=========================
;;TIMER 0 INTERRUPT VECTOR
;;=========================
	ORG	0BH
OUT_T0:	
	LJMP	INT_TIM0	;General Purpose Timer Interrupt
;;=========================
;;EXTERNAL INTERRUPT 1
;;=========================
	ORG	013H
OUT_SCR:
	LJMP	SCRINT_N	;116 EC USED
;;=========================
;;TIMER 1 INTERRUPT VECTOR
;;=========================
	ORG	1BH
OUT_T1:
	LJMP	T1_INT		;NOT USED
;;=========================
;;SERIAL INTERRUPT
;;=========================
	ORG	0023H
OUT_SP:	RETI

	ORG	002BH
OUT_T2:	RETI			;for 52
	ENDIF

;############################################################
;#                                                          #
;#                 VECTORS				    #
;#                                                          #
;############################################################

; -------------------------------------- MNP VECTORS
	IFTRUE	MICROCOM	
MNP_OUT:
	LJMP	FIXED1
;	LJMP	MNP_IN		;
MN000:	LJMP	MNP_IN		;
CHK070S:
	LJMP	B_CHK070
;	LJMP	CHK070		;
DISCONNECTS:
	LJMP	B_DIS
;	LJMP	DISCONNECTM	;
ON_LOOPS:	
	LJMP	BON_LOOP		;
SPD_OUTS:
	LJMP	SPD_OUT
V21_INS:
	LJMP	V21_IN
SPD_TXD:
	LJMP	SPD_TXD_1	;GET TXD FOR SPDCNV.ASM
SPD_RXD:
	LJMP	SPD_RXD_1	;GET RXD FOR SPDCNV.ASM	
I_TXSYNTT:
	LJMP	TX_SYNTT
I_RXSYNTT:
	LJMP	RX_SYNTT
I_TXASYN16:
	LJMP	TX_ASYN16
I_RXASYN16:
	LJMP	RX_ASYN16
I_SNDREL:
	LJMP	SND_REL
I_MNPINIT:
	LJMP	MNP_INIT
I_V42INIT:
	LJMP	V42_INIT
I_SETURMNP:
	LJMP	SET_URMNP

; -------------------------------------- V.42bis VECTORS
	IFTRUE	V42BIS
I_ENCODE:
	LJMP	ENCODE
I_DECODE:
	LJMP	DECODE
I_BTFLUSH:
	LJMP	BT_FLUSH
IV42_NEGO:
	LJMP	V42_NEGO
	ENDIF
	
; -------------------------------------- V.42 VECTORS
	IFTRUE	V42ONLY
I_ENCODE:
	LJMP	I_ENCODE
I_DECODE:
	LJMP	I_DECODE
I_BTFLUSH:
	LJMP	I_BTFLUSH
IV42_NEGO:
	LJMP	IV42_NEGO
	ENDIF

I_SPDTX:
	LJMP	SPD_TX
I_SPDRX:
	LJMP	SPD_RX	

; -------------------------------------- REMOTE ACCESS VECTORS
I_RMINIT:
	IFTRUE	REMOTE
	LJMP	RM_INIT
	ENDIF
	
	RET

RM_CHK:
	RET
	
	ENDIF


;############################################################
;#                                                          #
;#                 POWER ON AND IDLE LOOP                   #
;#                                                          #
;############################################################
PWR_ON:	MOV	IE,#00		;DISABLE ALL INTERRUPTS
	MOV	SP,#STACK	;INITIALIZE STACK

;------------------------------------------------------------
;	SRAM softswitch
;
	MOV	A,#SRAM		;SELECT OPTIONAL OUTPUT
	MOV	DPTR,#OPT_P
	MOVX	@DPTR,A
;------------------------------------------------------------

	LCALL	INIT_IO		;INITIALIZE I/O PINS

;------------------------------------------------------------
;INITIALIZE INTERNAL RAM
;
INIT_RAM:
	MOV	R0,#7FH
INITR1:	MOV	@R0,#00		;CLEAR LOCATION
	DJNZ	R0,INITR1
;02-21-89
	CLR	A
	MOV	DPTR,#BACK_RAM
	MOVX	@DPTR,A

	LCALL	INIT_TIM	;INITIALIZE TIMERS AND UART
	MOV	IE,#10000010B	;ENABLE GENERAL PURPOSE TIMER 0 INTERRUPT
	LCALL 	INIT_AT		;INITIALIZE "AT" DIALER VARIABLES
	
	MOV	R0,#5		;MOVE SPEED INFORMATION FROM NV RAM
	LCALL	READ_NV
	MOV	S23,A
	LCALL	CNV_SP
	LCALL	RST_EC		;001
	IFTRUE	FAX
	LCALL	FAXD_INIT	;6-01-90
	ENDIF
;901S
	MOV	BUFFER,S3
;	
;========================================
;WARM START LOCATION
;========================================
;
WARM_ST:
	CLR	M_READY		;MODEM READY LED
	CLR	PSW.5		;FOR ; MODE
	MOV	SP,#STACK	;CLEAN UP STACK
	LCALL	INIT_TIM	;INITIALIZE TIMERS AND UART
	MOV	IE,#10000010B	;ENABLE GENERAL PURPOSE TIMER 0 INTERRUPT
	LCALL	INIT_MOD	;INIT MODEM CHIP
	LCALL	UPDAT_SPK
WARM1:	CLR	A
	MOV	S1,A		;RESET RING IN COUNTER
	MOV	RI_TRANS,A	;RESET RING TRANSITION COUNTER
	MOV	RAM29H,A	;RESET TEST FLAGS
	MOV	RAM2EH,#07H	;RESET ONLINE FLAGS
	CLR	DTR_FLG
	JNB	DTR_L,WARM0
	SETB	DTR_FLG
	CLR	SYNC_DTR
WARM0:	CLR	REN		;DISABLE SERIAL RECEIVER

	IFTRUE	MICROCOM
	MOV	DPTR,#JS7	;144S
	MOVX	A,@DPTR
	JB	ACC.0,RNR	
	ENDIF

WARM2:	MOV	IE,#10000010B	;ENABLE GENERAL PURPOSE TIMER 0 INTERRUPT
RNR:	SETB	RI_IN		;144T
;	MOV	A,#25
;K_WAIT:
;	LCALL	WAIT200
;	DJNZ	ACC,K_WAIT
	MOV	DPTR,#BACK_RAM
	MOVX	A,@DPTR
	JZ	CNNT
	CALL	REC_RAM
CNNT:	CALL	INI_T1
	LCALL	INI_CTS			;121
	
	IFTRUE	MICROCOM		;144S
	JNB	DATA_BIT,NOT_V42M	;DONT CHECK FOR RING WHEN IN DATA MODE
	MOV	DPTR,#JS7
	MOVX	A,@DPTR
	JB	ACC.0,NOT_V42M	
	MOV	DPTR,#MNP_S		;020S CHECK V.42 MODE
	MOVX	A,@DPTR
	JNB	ACC.5,NOT_V42M		;020T
	LCALL	ONL_RNR			;TURN ON RNR AT ON LINE COMMAND MODE
NOT_V42M:				;144T
	ENDIF
;--------------------------------------- AUTO BREAK IN
	MOV	A,#5
	CJNE	A,U_ST,IDLE
	MOV	S23,#17H		;DEFAULT SPEED
	SETB	JP_004
	LCALL	SAVENV
	CLR	JP_004
	LCALL	SAVENV
	MOV	U_ST,#0
;
;============================================================
;IDLE MODE -  THIS LOOP CHECKS FOR RING IN AND TRYS TO AUTOBAUD
;  ON AN "AT" CHARACHTER SEQUENCE
;  WHEN ONLINE THIS LOOP WILL ALSO CHECK FOR A LOSS OF CARRIER
; DESTROYS:  ACC
;            TIMER 0 - RING IN DELAY (8 SECONDS)
; CALLS:  CHK_RING,FRAME_IT
; EXPECTS:
; EXITS: ANSWER,AT_MAIN,DISCONNECT
; TIMERS:  TIMER 0 - RING IN DELAY (8 SECONDS)
;============================================================
;
IDLE:
	IFFALSE	X2400		;001S
	LCALL	RS_TPEQ
	ENDIF			;001T
	JB	CXR_NORM,IDLE0	;003
	CLR	CXR_L		;003
IDLE0:	LCALL	UPDATE_IO
	JB	DATA_BIT,IDLE2	;DONT CHECK FOR RING WHEN IN DATA MODE
	LCALL	CHK_RING	;SEE IF RING IN ACTIVE
	JB	ASYN_2,IDLE1A	;IF AT&M2 OR AT&M3 IGNORE AT&D SETTING
	JB	IGNORE_DTR,IDLE2B
IDLE1A:	JB	DTR_L,IDLE2A	;DONT ANSWER IF DTR OFF
	SETB	DTR_HL		;DTR HIGH TO LOW TRANSITION FLAG
;
;DTR IS ON
;
IDLE2B:	JNB	PASS,IDLE2	;BRANCH IF NOT TIME TO ANSWER PHONE
	LCALL	CNV_SP		;REBOOT SPEED
;	ANL	RAM22H,#CFH
;	ANL	RAM2DH,#F0H
;	LCALL	R_SPD		;REBOOT SPEED
	LCALL	SET_OUT		;RESET T1 SPEED (SPEED)--> TH1,TL1
	CLR	RI

	IFTRUE	FAX
	MOV	DPTR,#OPT_FAX
	MOVX	A,@DPTR
	JB	ACC.1,ANS_MDM
	JNB	ACC.0,ANS_MDM
	LJMP	FAX_ANS
	ENDIF

ANS_MDM:
	LJMP	ANSWER		;GO TO ANSWER MODE ROUTINE
;
;DTR IS OFF
;
IDLE2A:	JNB	DTR_HL,IDLE2C	;BRANCH IF NOT HIGH TO LOW TRANSITION
	JNB	DTR_OP1,IDLE2C
	JNB	DTR_OP2,IDLE2C	;IF AT&D3 THEN RESET OPTIONS
	JB	ASYN_2,IDLE2C	;IF AT&M2 OR AT&M3 THEN DISREGARD AT&D3
	LCALL	INIT_AT	
	LCALL	UPDAT_SPK
IDLE2C:	SETB	DTR_FLG		;SET DTR LOW TO HIGH XSITION FLAG
	CLR	DTR_HL		;DTR OFF CLEAR HIGH TO LOW XSITION FLAG
;
IDLE2:
;	JNB	DUMB_L,IDLE3	;DONT CHECK FOR "AT" IF DUMB MODE
	LCALL	CTS_ON1
	LCALL	FRAME_IT	;TRY TO FRAME INCOMING DATA
	JNB	PASS,M_ID1	;BRANCH IF NO AT DETECTED
	CLR	GOT_A
	LJMP	AT_MAIN		;GO TO AT COMMAND ROUTINES
;M_ID1: 	JB	IP.3,B_IDLE
M_ID1:	JB	IP.3,IDLE3
	CLR	GOT_A
	LJMP	WARM0
B_IDLE:	LJMP	IDLE
IDLE3:	JNB	DATA_BIT,IDLE15
;
;========================================
;CHECK FOR LOSS OF CARRIER
;DURING ONLINE INTERACTIVE MODE
; ALSO CHECK FOR DTR LOSS
; ALSO CHECK FOR TEST TIMER WITH DLB
;========================================
;
IDLE4:	
	
	IFTRUE	V.23		;154S
	MOV	DPTR,#OPT_7
	MOVX	A,@DPTR
	CJNE	A,#3,Q23C
Q23C:	JNC	G_CP
	LCALL	B_ENERGY
	SJMP	CCD	
G_CP:
	ENDIF			;154T

	LCALL	C_ENERGY	;CHECK CARRIER STATUS
CCD:	JNC	IDLE5		;BRANCH IF ENERGY LOST
	CLR	LOST_IT
	LCALL	CXR_ON		;CLR	CXR_L
IDLE9:	JB	TEST_BIT,IDLE10
IDLE13:	LJMP	IDLE
IDLE5:	LCALL	CXR_OFF		;SETB	CXR_L CXR OFF TO EIA
	JB	LOST_IT,IDLE6
	MOV	A,#255
	CJNE	A,S10,IDLE7	;BRANCH IF CXR LOSS DISCONNECT ENABLED
	SJMP	IDLE9
IDLE7:	LCALL	SET_LCXR	;LOAS LOSS OF CXR TIMER
IDLE6:	JB	TIM_2F,IDLE9	;BRANCH IF NOT TIME TO DISCONNECT YET
	LJMP	DISCONNECT	;EXIT ONLINE MODE
;
;========================================
;MUST BE IN LDLB OR ALB ST
;========================================
;
IDLE10:	JNB	TXD_D,IDLE2	;CHECK FOR AUTOBAUD HERE
	LCALL	UPDATE_IO
	LCALL	CHK_PAT		;
	JNB	TXD_D,IDLE2	;CHECK FOR AUTOBAUD HERE
	LCALL	CHECK_TST
	JNC	IDLE2
IDLE12:
	MOV	DPTR,#MSG_OK
	LCALL	SND_RESULT
	LJMP	WARM0
;
;============================================================
;SYNC MODE CHECK FOR DTR CONNECT OR DIAL
;============================================================
	IFTRUE	INTERNAL

IDLE15:	SJMP	IDLE

	ENDIF

	IFFALSE	INTERNAL

IDLE15:	JNB	SYNC,IDLE13		;
	JNB	DTR_FLG,IDLE13		;BRANCH IF NO HIGH TO LOW TRANSITION
					;OF DTR
	JNB	ASYN_2,IDLE13		;BRANCH IF DTR DOES NOT CONTROL SYNC		
	JB	ASYN_1,IDLE17		;
;
;DTR CONTROL DIAL  (AT&M2)
;
IDLE16:	JB	DTR_L,IDLE13		;EXIT IF DTR OFF
	CLR	DTR_FLG
	SETB	SYNC_D			;SYNC DIALING
	LCALL	CTS_OFF			;CTS OFF UNTIL CONNECT
	LCALL	SET_OUT			;103
	MOV	TMOD,#21H		;103
	LJMP	SYNC_DIAL
;
;DTR CONTROL MANUAL ORIGINATE (AT&M3)
;
IDLE17:	JB	DTR_L,IDLE13		;EXIT IF DTR OFF
	CLR	DTR_FLG
;	SETB	SYNC_D			;112D NO CONNECT MESSAGES
	LCALL	OFF_HOOK	
	LCALL	CTS_OFF			;CTS OFF UNTIL CONNECT
	LCALL	SET_OUT			;112
	MOV	TMOD,#21H		;112
	LJMP	MAN_ORG
;
	ENDIF

	EJECT
;
;===================================================================
;	T1 INTERRUPT FOR 'AT' AUTO BAUD
;===================================================================
;
T1_INT:
	PUSH	ACC
	PUSH	PSW
	MOV	C,TXD_D
	MOV	TEMP_B,C
	JB	ST_B,R_SAMP
	JB	TXD_D,NOT_YET
	SETB	ST_B
	CLR	TR1
	MOV	A,TL1
	ADD	A,#0E0H
	MOV	TL1,A
	MOV	A,TH1
	ADDC	A,#0FFH
	MOV	TH1,A
	ANL	TMOD,#10111111B
	SETB	TR1
	MOV	COUNT,#09H
R_RET:
	POP	PSW
	POP	ACC
	RETI
NOT_YET:
	CLR	TR1
	MOV	RAM22H,#0H
	ORL	TMOD,#01000000B
	MOV	TL1,#0FFH
	MOV	TH1,#0FFH
	SETB	TR1
	SJMP	R_RET
CH_LWA:
	CJNE	A,#61H,NOT_YET
	LJMP	EXPECT
R_SAMP:
	DJNZ	COUNT,SAMP0
	JNB	TEMP_B,NOT_YET
	MOV	A,TEMP_A
	ANL	A,#7FH
	CJNE	A,#41H,CH_LWA
EXPECT:
	MOV	A,RAM22H
	LCALL	SET1
	SETB	GOT_A
	LCALL	L_ECH3			;018
	SJMP	R_RET

SET_OUT:
	MOV	DPTR,#SPEED
	MOVX	A,@DPTR
SET1:
	CLR	TR1
	CLR	ET1
	SETB	REN
	MOV	TMOD,#21H
	ANL	A,#07H
	JZ	G192
	ANL	PCON,#01111111B
	SJMP	BG192
G192:	ORL	PCON,#10000000B
BG192:
	ADD	A,#09H
	MOVC	A,@A+PC
	MOV	TH1,A
	MOV	TL1,A
	SETB	REN
	SETB	TR1
	RET
;
	DB	0FDH,0FDH,0FAH,0F4H,0E8H,0A0H,001H
;
SAMP0:
	MOV	A,COUNT
	CJNE	A,#08H,G_SAMP
	JB	TEMP_B,G_SAMP
	INC	RAM22H
	MOV	A,RAM22H
	ANL	A,#0FH
	CJNE	A,#7,CHANGE
	LJMP	NOT_YET
CHANGE:
	INC	COUNT
	CLR	TR1
;	LJMP	SEC1
	DJNZ	ACC,B4800
	MOV	A,#0C9H				;132
	SJMP	B99
B4800:	DJNZ	ACC,B2400
	MOV	A,#07CH
B99:	ADD	A,TL1
	MOV	TL1,A
	MOV	A,#0FFH
	SJMP	SAME1
B2400:	DJNZ	ACC,B1200
	MOV	A,#0EEH
	ADD	A,TL1
	MOV	TL1,A
	MOV	A,#0FEH
	SJMP	SAME1
B1200:	DJNZ	ACC,B300
	MOV	A,#0D0H
	ADD	A,TL1
	MOV	TL1,A
	MOV	A,#0FDH
	SJMP	SAME1
B300:	DJNZ	ACC,B110
	MOV	A,#092H
	ADD	A,TL1
	MOV	TL1,A
	MOV	A,#0F2H
	SJMP	SAME1
B110:	MOV	A,#00
	ADD	A,TL1
	MOV	TL1,A
	MOV	A,#0E0H
SAME1:	ADDC	A,TH1
	MOV	TH1,A
	SETB	TR1
	LJMP	R_RET
G_SAMP:
	MOV	A,RAM22H
	ANL	A,#0FH
	CLR	TR1
	JZ	C192
	DJNZ	ACC,C4800
C9600:	MOV	A,#0B2H			;132
	SJMP	CK96
C192:	MOV	A,#0DAH
CK96:	ADD	A,TL1
	MOV	TL1,A
	MOV	A,#0FFH
SAME2:
	ADDC	A,TH1
	MOV	TH1,A
	SETB	TR1
SPEC3A:
	MOV	C,TEMP_B
	MOV	A,TEMP_A
	RRC	A
	MOV	TEMP_A,A
S_RET:
	POP	PSW
	POP	ACC
	RETI
C4800: 	DJNZ	ACC,C2400
	MOV	A,#04FH
	SJMP	CK96
C2400:	DJNZ	ACC,C1200
	MOV	A,#095H				;132
	ADD	A,TL1
	MOV	TL1,A
	MOV	A,#0FEH
	SJMP	SAME2
C1200:	DJNZ	ACC,C300
	MOV	A,#015H
	ADD	A,TL1
	MOV	TL1,A
	MOV	A,#0FDH
	SJMP	SAME2
NOT_1:	LJMP	NOT_YET
C300:
	DJNZ	ACC,C110
	MOV	A,#17H
	ADD	A,TL1
	MOV	TL1,A
	MOV	A,#0F4H
	SJMP	SAME2
C110:	DJNZ	ACC,NOT_1
	MOV	A,#00
	ADD	A,TL1
	MOV	TL1,A
	MOV	A,#0DFH
	SJMP	SAME2
INI_T1:
	CLR	TR1
	CLR	REN
	CLR	RI
	MOV	RAM22H,#0H
	MOV	TMOD,#51H
	MOV	TH1,#0FFH
	MOV	TL1,#0FFH
	CLR	TF1
	SETB	IP.3
	SETB	TR1
	SETB	ET1
	RET
L_ECHO:	MOV	A,TEMP_A
L_COM:	JNB	COM_ECHO,L_RET
	MOV	SBUF,A
L_LOOP:	JNB	TI,L_LOOP
	CLR	TI
L_RET:	RET

L_ECH3:	MOV	A,TEMP_A		;018S
	JNB	COM_ECHO,L3_RET
	CLR	TI
	MOV	SBUF,A
L3_RET:	RET

L_ECH1:	MOV	A,TEMP_T
	SJMP	L_COM

L_ECH2:	MOV	A,TEMP_T
	JNB	COM_ECHO,L2_RET
LP_2:	JNB	TI,LP_2	
	CLR	TI
	MOV	SBUF,A
L2_RET:	RET				;018D
	
;=====================================================================
;FRAME_IT - THIS ROUTINE WILL TRY TO FRAME THE INCOMING DATA AND LOOK
;  FOR A VALID "AT".  IF A VALID "AT" IS RECEIVED THE UART BAUD RATE
;  WILL BE UPDATED AND STATUS BITS WILL BE SET FOR PARITY,
;  BIT COUNT AND SPEED.
;  VALID BAUD RATES ARE 110,300,1200 AND 2400 BPS
;
; DESTROYS: ACC,FRAME_A,FRAME_T,CHK_PARITY,SET_SPEED,INIT_TIM
;           TIMER 0
; CALLS:  BIT_TIME,ECHO,FRAME_A,FRAME_T,CHK_PARITY,SET_SPEED,INIT_TIM
; EXPECTS:  NOTHING
; RETURNS:  PASS = 0  -  NO "AT" DETECTED
;           PASS = 1  -  VALID "AT" DETECTED
; STACK - 6
;=====================================================================
;
FRAME_IT:
	CLR	PASS
;	CLR	EA		;144
FRM001:	JNB	GOT_A,FRM950
	CLR	IP.3
;	CLR	TI		;018D
;	JB	TXD_D,FRM950	;EXIT IF NO SPACE ON EIA TXD
;	LCALL	ECHO		;ECHO BIT
;	LCALL	BIT_TIME	;MEASURE BIT TIME AND SEE IF VALID
;	JNB	PASS,FRM800	;EXIT IF NOT VALID BIT TIME FOR 110,300 OR
;	CALL	L_ECHO          ;018D                      ;1200 BIT TIME
;	LCALL	FRAME_A		;LOOK FOR "A"
;	JNB	PASS,FRM800
	LCALL	FRAME_T		;LOOK FOR "T" OR "/"
	CALL	L_ECH2		;018
	JNB	PASS,FRM800
	LCALL	CHK_PARITY	;VALID "AT" DETECTED - NOW CALCULATE PARITY
	LCALL	SET_SPEED	;SETUP UART FOR CORRECT SPEED
;	CLR	RI		;CLEAR JUST IN CASE
	JNB	COM_ECHO,EC0	;018S
LP_21:	JNB	TI,LP_21
EC0:	CLR	TI		
	SETB	PASS		;SET "AT" VALID FLAG
FRM999:	SETB	REN
FRM950:
FRM900:	SETB	EA
	RET
FRM800:
	JNB	COM_ECHO,EC1
LP_211:	JNB	TI,LP_211
EC1:	CLR	TI		;018T
	RET

FRM801:	JNB	BIT_12,FRM802
	MOV	A,#3
	SJMP	FRM804
FRM802:	JNB	BIT_3,FRM803
	MOV	A,#10
	SJMP	FRM804
FRM803:	MOV	A,#28
FRM804:	CALL	WAIT_E3MS
	RET

FRMA20:
	SETB	PASS
	RET
FRMA99:
;	LCALL	WAIT_BIT	;
	CLR	PASS
	RET	
;	
;=====================================================================
;FRAME_T - FRAME THE "T" CHARACHTER - THIS ROUTINE WAITS FOR THE NEXT
;  CHARACHTER FROM THE DTE AND FRAMES IT BIT BY BIT.  IF A "T" OR "/"
;  CHARACHTER IS DETECTED THEN PASS IS RETURNED.
; DESTROYS - TIMER 0,ACC,COUNT
; CALLS - WAIT_H,WAIT_BIT
; EXPECTS - NOTHING
; RETURNS - PASS = 0  -  ILLEGAL CHAR
;           PASS = 1  -  "T" OR "/" DETECTED
;           AT_SLASH = 1 - "/" DETECTED
;           TEMP_T = "T" CHARACHTER WITH PARITY INTACT
; STACK - 4
;=====================================================================
;
FRAME_T:
FRMT01:
	IFTRUE	RING
	JB	RI_IN,FRMT00
	CLR	DATA_BIT
	LJMP	WARM_ST
FRMT00:
	ENDIF
	
	JNB	RI,FRMT01
	MOV	A,SBUF
	CLR	RI
 	CLR	AT_SLASH
	MOV	TEMP_T,ACC	;SAVE CHARACHTER FOR PARITY CHECK
	ANL	A,#7FH		;MASK OFF PARITY
	CJNE	A,#'T',FRMT10	;BRANCH IF NOT A
	SJMP	FRMA20
FRMT10:	CJNE	A,#'t',FRMT20	
	SJMP	FRMA20
FRMT20:	CJNE	A,#'/',E_A
	SETB	AT_SLASH
	SJMP	FRMA20
E_A:	CJNE	A,#'A',E_N
	MOV	TEMP_A,TEMP_T
	CALL	L_ECH2				;018
	SJMP	FRMT01		
E_N:	CJNE 	A,#'a',FRMA99
	MOV	TEMP_A,TEMP_T
	CALL	L_ECH2				;018
	SJMP	FRMT01

;
;=====================================================================
;CHK_PARITY - TAKES THE "A" IN TEMP_A AND THE "T" IN TEMP_T AND
;  CALCULATES THE PARITY AND SET THE PARITY BITS ACCORDINGLY
; DESTROYS -  NOTHING
; CALLS -  NOTHING
; EXPECTS - TEMP_A AND TEMP_T TO CONTAIN "AT" CHARACHTERS WITH PARITY
;           INTACT
; RETURNS - PAR_1 AND PAR_2 SET ACCORDING TO PARITY
;
; STACK - 0
;=====================================================================
;
CHK_PARITY:	
	ANL	S23,#11001111B	;CLR	PAR_1
				;CLR	PAR_2
	MOV	A,TEMP_A
	JB	ACC.7,CHK_P1	;
	MOV	A,TEMP_T
	JB	ACC.7,CHK_P3	;BRANCH IF NOT SPACE PARITY
	SETB	PAR_1		
	RET			;RETURN WITH SPACE PARITY
CHK_P1:	MOV	A,TEMP_T
	JNB	ACC.7,CHK_P2	;BRANCH IF NOT MARK PARITY
	ORL	S23,#00110000B	;SETB	PAR_1
				;SETB	PAR_2	RETURN WITH MARK PARITY
	RET		

CHK_P2:	MOV	A,TEMP_A	;A PARITY = 1, T PARITY = 0
	ANL	A,#7FH		;MASK OFF PARITY
	CJNE	A,#61H,CHK_P4	;IS IT A SMALL A
	RET			;EVEN PARITY - LOWER CASE AT

CHK_P3:	MOV	A,TEMP_A	;A PARITY = 0, T PARITY = 1
	ANL	A,#7FH
	CJNE	A,#61H,CHK_P6	;BRANCH IF EVEN PARITY UPPER CASE AT
CHK_P4:	SETB	PAR_2		;ODD PARITY - LOWER CASE AT
CHK_P6:	RET
;
;=====================================================================
;SET_SPEED - THIS ROUTINE WILL SET UP THE UART FOR THE APPROPRIATE SPEED
;  DEPENDING ON THE STATUS OF THE BIT_12, BIT_3 AND BIT_1 STATUS BITS
;  THE SPEED STATUS BITS IN THE S15 REGISTERS ARE ALSO UPDATED TO SHOW
;  THE PRESENT SPEED STATUS.
; DESTROYS -  BAUD RATE TIMER (TIMER 1)
; CALLS -  NOTHING
; EXPECTS - BIT_24 OR BIT_12 OR BIT_3 OR BIT_1 SET
; RETURNS - WITH UART SET FOR SELECTED BAUD RATE
;           S15 UPDATED WITH CORRECT SPEED STATUS
; STACK - 0
;=====================================================================
;
SET_SPEED:
	ANL	S23,#11110001B
	ANL	RAM2DH,#0F0H
	MOV	A,RAM22H
	ANL	A,#07H
R_SPD:	MOV	DPTR,#SPEED
	MOVX	@DPTR,A
	JNZ	C_96
	SETB	BIT_24		;19200 BPS
	SETB	BPS_1
	SETB	BPS_2
	ORL	PCON,#1000000B
C_96:	DJNZ	ACC,C_48
	ORL	S23,#00001010B
	SETB	BIT_96		;9600 BPS
	SETB	BIT_24
	JMP	C_SPEED
C_48:	DJNZ	ACC,C_24
	SETB	BPS_2
	SETB	BIT_48	     	;4800 BPS
	SETB	BIT_24
	JMP	C_SPEED
C_24:	DJNZ	ACC,C_12
	ORL	S23,#00000110B
	SETB	BIT_24		;2400 BPS
	JMP	C_SPEED
C_12:	DJNZ	ACC,C_30
	SETB	BPS_1
	SETB	BIT_12		;1200 BPS
	JMP	C_SPEED
C_30:
	SETB	BIT_3		;300 BPS
C_SPEED:
	RET
SET_UR:
	ANL	S23,#11111001B	;CLR	BPS_0
				;CLR	BPS_1
	JNB	BIT_24,SSPD09
SET2400:
	ORL	S23,#00000110B	;SET	BPS_0
				;SETB	BPS_1
	MOV	TL1,#BAUD_24
	MOV	TH1,#BAUD_24	
	MOV	A,#02
SS_P00:	MOV	DPTR,#SPEED
	MOVX	@DPTR,A
	RET

SSPD09:	JNB	BIT_12,SSPD10	;BRANCH IF NOT 1200BPS
SET1200:
	SETB	BPS_1
	MOV	TL1,#BAUD_12
	MOV	TH1,#BAUD_12
	MOV	A,#3
	SJMP	SS_P00

SSPD10:	JNB	BIT_3,SET110

SET300:
	MOV	TL1,#BAUD_3
	MOV	TH1,#BAUD_3
	MOV	A,#4
	SJMP	SS_P00

SET110:
	MOV	TL1,#BAUD_11
	MOV	TH1,#BAUD_11
	MOV	A,#5
	SJMP	SS_P00
;
;=====================================================================
;ECHO - ECHO DATA IF SO OPTIONED - BIT BY BIT
;  THIS ROUTINE READS THE TXD DATA FROM THE DTE AND WRITES IT TO THE
;  RXD DATA TO THE DTE.
; DESTROYS -  NOTHING
; CALLS -  NOTHING
; EXPECTS - NOTHING
; RETURNS - NOTHING
; I/O - READS TXD_D AND WRITES TO RXD_D
; STACK - 0
;=====================================================================
;
ECHO:	JNB	COM_ECHO,ECHOX	;EXIT IF NO ECHO
	MOV	C,TXD_D
	MOV	RXD_D,C
ECHOX:	RET
;
	EJECT
;=====================================================================
;INIT_IO - INITIALIZE THE I/O PORTS THE POWER ON DEFAULT
; DESTROYS -  NOTHING
; CALLS -  NOTHING
; EXPECTS - NOTHING
; RETURNS -  ALL I/O PORTS TO POWER ON DEFAULT
; STACK - 0
;=====================================================================
;
INIT_IO:	
	MOV	P1,#11011110B
;				;OH_L	BIT	P1.0	;300D
;				;NV_CS	BIT	P1.0
;				;RI_IN	BIT	P1.1	;
;				;CXR_L	BIT	P1.2	;
;				;RI_OUT	BIT	P1.3	;
;				;DTR_L	BIT	P1.4	;
;				;NV_CLK	BIT	P1.5
;				;DUMB_L	BIT	P1.5	;
;				;RTS_L	BIT	P1.6	;
;				;RSTTMS BIT	P1.7	;
;
	MOV	P3,#11111111B
;
;				;RXD_D	BIT	P3.0	;
;				;TXD_D	BIT	P3.1	;
;				;NV_CS	BIT	P3.2	;
;				;NV_CLK	BIT	P3.3	;
;				;NV_DI	BIT	P3.4	;
;				;NV_DO	BIT	P3.5	;
;				;W_BIT	BIT	P3.6	;
;				;R_BIT	BIT	P3.7	;
	RET
;
;
	EJECT
;============================================================
;PUT_CHAR - SEND CHARACHTER TO DTE AND APPEND CORRECT PARITY
;  ROUTINE WAITS FOR CHARACHTER TO BE SENT BEFORE RETURNING TO
;  CALLING PROGRAM
; DESTROYS: ACC,SBUF
; CALLS: NOTHING
; EXPECTS: CHAR IN ACC
; RETURNS: NOTHING
; STACK - 0
;============================================================
;
PUT_CHAR:
	ANL	A,#7FH
	JB	PAR_1,PUT001		;BRANCH IF NO PARITY
	MOV	C,P
	JNB	PAR_2,PUT002		;BRANCH IF EVEN PARITY
	CPL	C
PUT002:	MOV	ACC.7,C
	SJMP	PUT003
PUT001:	JNB	PAR_2,PUT003		;BRANCH IF SPACE PARITY
	SETB	ACC.7			;SET MARK PARITY
PUT_DATA:
PUT003:	MOV	SBUF,A			;OUTPUT CHARACHTER
PUT004:	JNB	TI,PUT004		;WAIT FOR CHARACHTER TO FINISH
	CLR	TI
	RET
;
;============================================================
;INT_TIM0 - TIMER INTERRUPT 0 INTERRUPT SERVICE ROUTINE
;  THIS TIMER INTERRUPT IS USED AS A GENERAL PURPOSE TIMER.  
;  THIS INTERRUPT CONTROLS UPTO 5 SEPERATE SOFT TIMERS AS FOLLOWS.
;  THIS INTERRUPT OCCURS EVERY 3.3MS
;  
;  SOFT TIMER 1 - 1 SECOND PER COUNT (8 BIT)
;             TIM_1 =  8 BIT COUNT
;             TIM_1P = PRESCALAR
;             TIM_1F = TIMER FLAG
;             TIM_1PF = TIMER PRESCALE FLAG
;  SOFT TIMER 2 - 100 MILLISECONDS PER COUNT (8 BIT)
;             TIM_2 = 8 BIT COUNT
;             TIM_2P = PRESCALAR
;             TIM_2F = TIMER FLAG
;  SOFT TIMER 3 - 20 MILLISECONDS PER COUNT (8 BIT)
;             TIM_3 = 8 BIT COUNT
;             TIM_3P = PRESCALAR
;             TIM_3F = TIMER FLAG
;  SOFT TIMER 4 - 3.3MS PER COUNT
;             TIM_4 = 8 BIT COUNT
;             TIM_4F = TIMER FLAG
;  SOFT TIMER 5 - 20MS PER COUNT
;             TIM_4 = 8 BIT COUNT
;             TIM_4P = PRESCALAR
;             TIM_4F = TIMER FLAG
;  SOFT TIMER 6 - 1 SECOND PER COUNT (8 BIT)
;             TIM_6 =  8 BIT COUNT
;             TIM_6P = PRESCALAR
;             TIM_6F = TIMER FLAG
;             TIM_6PF = TIMER PRESCALE FLAG
;  SOFT TIMER 7 - 10 MS PER COUNT
;             TIM_7 = 8 BIT COUNT
;             TIM_7P = PRESCALAR
;             TIM_7F = TIMER FLAG
;  SOFT TIMER 8 - 10 MS PER COUNT
;             TIM_8 = 8 BIT COUNT
;             TIM_8P = PRESCALAR
;             TIM_8F = TIMER FLAG
;  SOFT TIMER 9 - 3.3 MS PER COUNT
;             TIM_9 = 8 BIT COUNT
;             TIM_9F = TIMER FLAG
; STACK - 1
;============================================================
B_TIMAAA:
	LJMP	TIMAAA
;
INT_TIM0:
	PUSH	PSW
	PUSH	ACC
	PUSH	DPL
	PUSH	DPH

	IFTRUE	V.23
	JB	V23_SPD,V23TI
	ENDIF
	
	SETB	TTF1
	SJMP	TTIM
V23TI:	CLR	TF0		;RE-INITIALIZE TIMER
;	MOV	TL0,#<(-3041)	;3072 3.3 ms constant
;	MOV	TH0,#>(-3041)	;3.3 ms constant
TTIM:				;
	MOV	TL0,#<(-380)	; 380, 378
	MOV	TH0,#>(-380)
	JB	DATA_BIT,TTIM1
	LJMP	G_STA
	
TTIM1:
	IFTRUE	X2400	
	JNB	SPD_FLG,CHIP	;160S
	ENDIF
	
	IFFALSE	X2400
	JNB	SPD_FLG,G_STA
	ENDIF

	IFTRUE	V.23	
	JNB	V23_SPD,NCT_23
	JB	ORG_BIT,G_STA
	PUSH	DPL
	PUSH	DPH
	LCALL	V23_RX
	POP	DPH
	POP	DPL
	SJMP	G_STA
NCT_23:	
	JB	V21_SPD,V21_R
	ENDIF

CHIP:	MOV	DPTR,#OPT_7	;130S
	MOVX	A,@DPTR
	CJNE	A,#3,BCHIP	;130T
V21_R:	
	IFFALSE	NSP
	PUSH	DPL
	PUSH	DPH
	LCALL	V21_IN
	POP	DPH
	POP	DPL
	ENDIF
	
	SJMP	G_STA

BCHIP:	
	IFTRUE	X2400		;300S
	CJNE	A,#6,G_STA
	LCALL	CHK_RET
	ENDIF			;300T

G_STA:	DJNZ	TIM_BAS,B_TIMAAA
	MOV	TIM_BAS,#08H
TIM000:	JNB	TIM_1F,TIM010	;BRANCH IF TIMER NOT ENABLED
	DJNZ	TIM_1P,TIM010	;DECREMENT TIMER 1 PRESCALAR
	MOV	TIM_1P,#150	;RELOAD TIMER 1 PRESCALAR
	CPL	TIM_1PF		
	JNB	TIM_1PF,TIM010	;
	DJNZ	TIM_1,TIM010	;BUMP THE TIMER REG
	CLR	TIM_1F		;SET TIMER 1 FINISHED FLAG

TIM010:	JNB	TIM_2F,TIM020	;BRANCH IF TIMER NOT ENABLED
	DJNZ	TIM_2P,TIM020	;DECREMENT TIMER 2 PRESCALAR
	MOV	TIM_2P,#30	;RELOAD TIMER 2 PRESCALAR
	DJNZ	TIM_2,TIM020	;BUMP THE TIMER REG
	CLR	TIM_2F		;SET TIMER 2 FINISHED FLAG

TIM020:	JNB	TIM_3F,TIM030	;BRANCH IF TIMER NOT ENABLED
	DJNZ	TIM_3P,TIM030	;DECREMENT TIMER 3 PRESCALAR
	MOV	TIM_3P,#6	;RELOAD TIMER 3 PRESCALAR
	DJNZ	TIM_3,TIM030	;BUMP THE TIMER REG
	CLR	TIM_3F		;SET TIMER 3 FINISHED FLAG

TIM030:	JNB	TIM_4F,TIM040	;BRANCH IF TIMER NOT ENABLED
	DJNZ	TIM_4,TIM040	;BUMP THE TIMER REG
	CLR	TIM_4F		;SET TIMER 4 FINISHED FLAG

TIM040:	JNB	TIM_5F,TIM050	;BRANCH IF TIMER NOT ENABLED
	DJNZ	TIM_5P,TIM050	;DECREMENT TIMER 5 PRESCALAR
	MOV	TIM_5P,#6	;RELOAD TIMER 5 PRESCALAR
	DJNZ	TIM_5,TIM050	;BUMP THE TIMER REG
	CLR	TIM_5F		;SET TIMER 5 FINISHED FLAG

TIM050:	JNB	TIM_6F,TIM060	;BRANCH IF TIMER NOT ENABLED
	DJNZ	TIM_6P,TIM060	;DECREMENT TIMER 6 PRESCALAR
	MOV	TIM_6P,#150	;RELOAD TIMER 6 PRESCALAR
	CPL	TIM_6PF		
	JNB	TIM_6PF,TIM060	;
	JNB	TEST_BIT,TIM051
	CPL	M_READY		;COMPLEMENT THE MODEM READY BIT
TIM051:	DJNZ	TIM_6,TIM060	;BUMP THE TIMER REG
	CLR	TIM_6F		;SET TIMER 6 FINISHED FLAG

TIM060:	JNB	TIM_7F,TIM070	;BRANCH IF TIMER NOT ENABLED
	DJNZ	TIM_7P,TIM070	;DECREMENT TIMER 7 PRESCALAR
	MOV	TIM_7P,#3	;RELOAD TIMER 7 PRESCALAR
	DJNZ	TIM_7,TIM070	;BUMP THE TIMER REG
	CLR	TIM_7F		;SET TIMER 7 FINISHED FLAG

TIM070:	JNB	TIM_8F,TIM080	;BRANCH IF TIMER NOT ENABLED
	DJNZ	TIM_8P,TIM080	;DECREMENT TIMER 8 PRESCALAR
	MOV	TIM_8P,#3	;RELOAD TIMER 8 PRESCALAR
	DJNZ	TIM_8,TIM080	;BUMP THE TIMER REG
	CLR	TIM_8F		;SET TIMER 8 FINISHED FLAG

TIM080:	JNB	TIM_9F,TIM999	;BRANCH IF TIMER NOT ENABLED
	DJNZ	TIM_9,TIM999	;BUMP THE TIMER REG
	CLR	TIM_9F		;SET TIMER 9 FINISHED FLAG

TIM999: JNB	SPD_FLG,TIMAAA
	INC	BK_PRE
TIMAAA:	
	POP	DPH
	POP	DPL
	POP	ACC
	POP	PSW
	RETI
;
;============================================================
;CHK_RING - CHECK THE RING IN SIGNAL AND SEND OUT RING MESSAGE
; IF NEEDED.  S1 IS INCREMENTED EVERY RING AND CLEARED IF NO RING
; IS RECEIVED IN AN 8 SECOND PERIOD.  IF S0 = S1 THEN THE PASS
; FLAG IS SET TO TELL THE CALLING ROUTINE THAT IT IS TIME TO ANSWER.
;
; DESTROYS:  ACC, DPTR, SOFT TIMER 1, SOFT TIMER 4
; CALLS:  SET_8S,RING_MSG
; RETURNS:  PASS = 0 - NOT TIME TO ANSWER
;           PASS = 1 - TIME TO ANSWER
; STACK  - 8
;============================================================
;
CHK_RING:
	JB	RING_IP,CHKR10	;BRANCH IF RING IN PROGRESS
	JB	RI_IN,CHKR99	;BRANCH IF NO TRANSITION ON RING IN LINE
;
;====================
;START OF RING DETECTED
;====================
;
CHKR05:	MOV	TIM_4,#75	;START 250MS TIMER	
	SETB	TIM_4F		
	MOV	RI_TRANS,#00	;RESET RING IN TRANSITION COUNT
	SETB	RING_IP
	MOV	C,RI_IN
	MOV	RING_BIT,C	;SAVE PRESENT RING IN STATUS
	SJMP	CHKR99		;EXIT RING ROUTINE
;
;====================
;RING IN PROCESS
;====================
;
CHKR10:	JNB	TIM_4F,CHKR20	;BRANCH IF TIMER FINISHED
	JB	RI_IN,CHKR15	;BRANCH IF RING IN HIGH
;
;====================
;RING IN LOW - CHECK PREVIOUS RING IN STATUS
;====================
;
	JNB	RING_BIT,CHKR99	;BRANCH IF NO TRANSITION
	CLR	RING_BIT	;UPDATE RING BIT
	SJMP	CHKR17
;
;====================
;RING IN HIGH - CHECK PREVIOUS RING IN STATUS
;====================
;
CHKR15:	JB	RING_BIT,CHKR99	;BRANCH IF NO TRANSITION
	SETB	RING_BIT	;UPDATE RING BIT
CHKR17:	INC	RI_TRANS	;INCREMENT TRANSITION COUNT
	SJMP	CHKR99		;AND EXIT
;
;====================
;TIMER FINISHED - CHECK TRANSTION COUNT
;====================
;
CHKR20:	MOV	A,#LOW_RING
	CJNE	A,RI_TRANS,CHKR25	;COMPARE WITH LOW WINDOW
CHKR25:	JC	CHKR27			;BRANCH IF RI_TRANS > LOW_RING
	JB	RI_OUT,CHKR30
	SETB	RI_OUT
	SETB	AA_BIT
	LCALL	UPDATE_IO
	CLR	RING_IP
	LCALL	SET_8S			;RESTART 8 SECOND TIMER
	LCALL	RING_MSG		;SEND OUT RING MESSAGE AND CHECK S0
	RET
CHKR27:	MOV	A,#HIGH_RING
	CJNE	A,RI_TRANS,CHKR28
CHKR28:	JC	CHKR30			;BRANCH IF RI_TRANS > HIGH_RING
	CLR	RI_OUT			;TURN ON RING SIGNAL
	CLR	AA_BIT
	LCALL	UPDATE_IO
	SJMP	CHKR05			;GO RESTART TIMER
CHKR30:	CLR	RING_IP
	SETB	RI_OUT
	SETB	AA_BIT		
	LCALL	UPDATE_IO
;
CHKR99:	JNB	TIM_1F,CHKR90
CHKR98:	CLR	PASS
	RET
CHKR90:	MOV	S1,#00			;CLEAR RING IN COUNT
	SJMP	CHKR98
;
;========================================
;SET_8S - START 8 SECOND TIMER
;========================================
;
SET_8S:	MOV	TIM_1,#8	;8 SECOND TIMER
SETT1A:	MOV	TIM_1P,#150
	SETB	TIM_1PF
	SETB	TIM_1F
	RET
SET_T1:	MOV	TIM_1,A		;LOAD SECOND TIMER
	SJMP	SETT1A
;
;========================================
;RING_MSG - SEND OUT RING MESSAGE AND UPDATE S1 REGISTER
; DESTROYS - ACC,DPTR
; CALLS - SND_RESULT
; EXPECTS - NOTHING
; RETURNS - PASS = 1 = TIME TO ANSWER PHONE
;           PASS = 0 = DONT ANSWER PHONE YET
; STACK - 6
;========================================
;
RING_MSG:
	LCALL	SET_OUT
;	MOV	DPTR,#SPEED
;	MOVX	A,@DPTR
;	LCALL	SET1
	MOV	DPTR,#MSG_RING
	LCALL	SND_RESULT
	LCALL	INI_T1
	INC	S1			;INCREMENT RING COUNT
	MOV	A,S0
	JZ	RINGM1			;EXIT IF S0 = 0
	MOV	A,S1
	CJNE	A,S0,B_RING		;EXIT IF NOT TIME TO ANSWER
B_RING:	JC	RINGM1
	CLR	AA_BIT			;TIME TO ANSWER - TURN ON AA BIT
	SETB	PASS
	RET
RINGM1:	CLR	PASS
	RET
;
;============================================================
;INIT_TIM - INITIALIZE TIMER/COUNTERS FOR IDLE LOOP
;DESTROYS:  NOTHING
;EXPECTS:  NOTHING
;RETURNS:  TIMER 1 USED AS BAUD RATE TIMER
;          TIMER 0 LOWER USED AS GENERAL PURPOSE COUNTER WITH 3.3MS COUNT
;            TR0,INT0 AND TF0  T0 USED AS 1200HZ CLOCK INPUT (ENABLED)
;          TIMER 0 UPPER USED AS SAMPLE TIMER
;            TR1,INT1 AND TF1  (NOT ENABLED)
;STACK - 0
;============================================================
;
INIT_TIM:
	MOV	TMOD,#00100001B	;TIMER 0 - 16 BIT NON AUTORELOAD TIMER
				;TIMER 1 USED AS BAUD RATE TIMER 8 BIT AUTO
				;RELOAD
	MOV	SCON,#01010000B	;RECIEVE ENABLE
				;8 BIT UART, VARIABLE BAUD RATE
	MOV	TL0,#<(-3041)	;GENERAL PURPOSE TIMER
	MOV	TH0,#>(-3041)	;SAMPLE TIMER
	MOV	TCON,#01010000B	;SET TR0 = 1,TCON.4 FOR 3.3MS CLOCK
				;SET TR1 = 1,TCON.6 FOR BAUD RATE CLOCK
	SETB	ET0		;ENABLE 3.3MS TIMER INTERRUPT
	CLR	PX0		;147
	RET

;
;============================================================
;WAIT200 - 200US SOFTWARE DELAY
;DESTROYS:  NOTHING
;EXPECTS:  NOTHING
;RETURNS:  NOTHING
;STACK - 1
;============================================================
;
WAIT200:
	PUSH	ACC
	MOV	A,#100
WAIT21:
	DJNZ	ACC,WAIT21
	POP	ACC
	RET
;
;========================================
;SET OR CLEAR EIA SIGNALS
; DESTROYS - ACC,DPTR
; CALLS - UPDATE_IO
; EXPECTS - NOTHING
; RETURNS - NOTHING
; STACK - 2
;========================================
;
CXR_OFF:
	SETB	TRUE_CXR		;TURN OFF CXR LED
	JNB	CXR_NORM,CXR_F2
	SETB	CXR_L			;DCD OFF
CXR_F2:	LCALL	UPDATE_IO
CXR_F1:	RET
;
CXR_ON:
	CLR	CXR_L
	CLR	TRUE_CXR		;TURN CXR LED ON
	SJMP	CXR_F2
;
;--------------------------------------- DATA SET READY CONTROL (DSR)
;
DSR_OFF:
	JNB	DSR_NORM,CTS_F1
	SETB	DSR_L
	SJMP	CTS_F2
;
DSR_ON:	CLR	DSR_L
	SJMP	CTS_F2
;
;--------------------------------------- CLEAR TO SEND (CTS) CONTROL
;
CTS_OFF:
	JNB	SYNC,CTS_F1		;CTS ALWAYS ON IN ASYNC MODE
	JB	CTS_OPT,CTS_F1
	SETB	CTS_L
	SJMP	CTS_F2
;^^^
;CHECK \Q5,Q6 OPTION TO TURN OFF CTS
;
CTS_F1:	MOV	DPTR,#OPT_8		;CHECK \Q5,\Q6 TO TURN OFF CTS
	MOVX	A,@DPTR
	JNB	ACC.5,CTS_F3
	SETB	CTS_L
;
CTS_F2:	LCALL	UPDATE_IO
CTS_F3:	RET

CTS_ON1:
	JNB	DATA_BIT,CTS_ON		;IN DATA COMMAND MODE CTS ALWAYS ON
	SJMP	CTS_N1
CTS_ON:	
	MOV	DPTR,#OPT_8		;150S
	MOVX	A,@DPTR
	JB	ACC.5,CTS_F3		;150T
	MOV	DPTR,#OPT_0
	MOVX	A,@DPTR
	JNZ	CTS_F3
CTS_N1:	CLR	CTS_L
	SJMP	CTS_F2
;
;SPEED INDICATION (HS) SIGNAL CONTROL
;
HIS_ON:	JNB	HI_SPD2,HIS_OFF
HIS_N1:	CLR	HS_H			;HI SPEED STATUS
	SJMP	CTS_F2

HIS_OFF:SETB	HS_H
	SJMP	CTS_F2
;INIT_EC:
;	MOV	A,#01H		;DEFAULT IS ERROR CONTROLLER ON
;	MOV	DPTR,#OPT_0
;	MOVX	@DPTR,A
;	MOV	A,#2H		;DEFAULT IS RTS/CTS ERROR CONTROLLER
;	INC	DPTR
;	MOVX	@DPTR,A
;	RET
;
;02-21-89
BK_RAM:
	PUSH	REG_0	       	;COMMAND BUFFER BACKUP
	MOV	DPTR,#BACK_RAM
	MOV	A,#1H
	MOVX	@DPTR,A
	MOV	R0,#BUFFER
	MOV	B,#40D
BK_R:	INC	DPTR
	MOV	A,@R0
	MOVX	@DPTR,A
	INC	R0
	DJNZ	B,BK_R
	POP	REG_0
	RET
REC_RAM:
	CLR	SPD_FLG
	PUSH	REG_0	     		;COMMAND BUFFER RECOVERY
	MOV	DPTR,#BACK_RAM
	CLR	A
	MOVX	@DPTR,A
	MOV	R0,#BUFFER
	MOV	B,#40D
RV_R:	INC	DPTR
	MOVX	A,@DPTR
	MOV	@R0,A
	INC	R0
	DJNZ	B,RV_R
	POP	REG_0
	RET
RST_EC:
	MOV	DPTR,#MNP_S
	CLR	A
	MOVX	@DPTR,A
	MOV	DPTR,#MNP_S+5
	MOVX	@DPTR,A
	RET
CNV_SP:
	MOV	A,S23
	ANL	A,#00001110B
	ANL	RAM2DH,#0F0H
	ANL	RAM22H,#07H
	MOV	DPTR,#SPEED
	CJNE	ACC,#0CH,CNV_96
	SETB	BIT_24		;19200 BPS
	ORL	PCON,#80H
	CLR	A
	MOVX	@DPTR,A
	RET
CNV_96:	CJNE	ACC,#0AH,CNV_48
	SETB	BIT_96		;9600 BPS
	SETB	BIT_24
	MOV	A,#1
	MOVX	@DPTR,A
	RET
CNV_48:	CJNE	ACC,#08H,CNV_24
	SETB	BIT_48	     	;4800 BPS
	SETB	BIT_24
	MOV	A,#2H
	MOVX	@DPTR,A
	RET
CNV_24:	CJNE	ACC,#06H,CNV_12
	SETB	BIT_24		;2400 BPS
	MOV	A,#3H
	MOVX	@DPTR,A
	RET
CNV_12:	CJNE	ACC,#04H,CNV_30
	SETB	BIT_12		;1200 BPS
	MOV	A,#04H
	MOVX	@DPTR,A
	RET
CNV_30:
	MOV	A,#5H
	MOVX	@DPTR,A
	SETB	BIT_3		;300 BPS
	RET
;
;====================================================
; READ/WRITE TX AND RXD FOR SPDCNV.ASM
; C IS THE TXD OR RXD
;====================================================
;
SPD_TXD_1:
	IFTRUE	V.23			;125S
	JNB	V21_SPD,NTT
	MOV	DPTR,#XR23P1
	MOV	A,#9			;V23 FILTER
	MOV	ACC.2,C
	SJMP	TX1
	ENDIF
NTT:	MOV	DPTR,#TX_P		;300 GET ONE BIT DATA FROM CHIP SET
	MOV	A,#FULL
	JC	TX1
	MOV	A,#0
TX1:
	MOVX	@DPTR,A
	RET

SPD_RXD_1:
	IFTRUE	V.23
	JNB	V21_SPD,NMD
	MOV	DPTR,#XR23P0
	SJMP	R_C
	ENDIF
NMD:	MOV	DPTR,#RX_P		;300
R_C:	MOVX	A,@DPTR			;125T
	MOV	C,ACC.0
	RET


	IFTRUE	MICROCOM
BON_LOOP:
	MOV	IE,#82H			;155
	LCALL	REV_S4
	LJMP	ON_LOOP

B_CHK070:				;144S
	LCALL	REV_S4
	LCALL	RNR_ON			;SET UP RNR FRAME
	LJMP	CHK070
ONL_RNR:	
;	PUSH	ACC
;	PUSH	PSW
;	PUSH	DPL
;	PUSH	DPH
	MOV	DPTR,#JS7
	MOVX	A,@DPTR
	SETB	SPD_FLG			;166
	SETB	ACC.0			;RNRON
	MOVX	@DPTR,A
;	POP	DPH
;	POP	DPL
;	POP	PSW
;	POP	ACC
	CLR	A
	MOV	DPTR,#PRT_1
	MOVX	@DPTR,A
	MOV	A,#08H
	MOV	DPTR,#C_CNT
	MOVX	@DPTR,A
	SETB	TCON.0
	SETB	IE.0

	IFFALSE	X2400	
	LCALL	SET_NTD
	LCALL	SET_PDM
	LCALL	SET_SPDM
	ENDIF
	
	IFTRUE	X2400	
	MOV	A,#W_REG3		;ENABLE NTD/SPDM
	LCALL	RD_STAT
	ANL	A,#11001111B
	ORL	A,#00110000B
	MOV	B,#W_REG3
	LCALL	WR1_CNTL
	ENDIF

	RET
;
; SET UP FOR SEND OUT RNR DURING ON LINE COMMAND MODE
;
RNR_ON:
RNR_INIT:
	MOV	DPTR,#MNP_S+5		;020S CK V.42/MNP		
	MOVX	A,@DPTR
	JNB	ACC.3,NOT_V42MR
	MOV	DPTR,#9650H
	MOV	R0,#12D
RNR_CONTI:	
	MOV	A,R0
	MOVC	A,@A+PC
	CJNE	A,#0AAH,R_CNT
	SJMP	RNR_CONT
NOT_V42MR:	
	MOV	DPTR,#9650H
	MOV	R0,#12D+9
	SJMP	RNR_CONTI
FRM_RNR:
	DB	7EH,01H,05H,00H,00H,00H,7EH,7EH,0AAH
FRM_LA0:
	DB	7EH,03H,05H,00H,00H,00H,00H,7EH,0AAH
R_CNT:
	MOVX	@DPTR,A
	INC	DPTR
	INC	R0
	SJMP	RNR_CONTI
NOT_V42MF:
	MOV	DPTR,#9E47H	;GET SEQUENCE NUMBER
	MOVX	A,@DPTR
	MOV	DPTR,#9653H
	MOVX	@DPTR,A	
	SJMP	NSET_ORI
RNR_CONT:
	MOV	DPTR,#MNP_S+5	;CK V.42/MNP
	MOVX	A,@DPTR
	JNB	ACC.3,NOT_V42MF
	MOV	DPTR,#9E47H	;GET SEQUENCE NUMBER
	MOVX	A,@DPTR
	SETB	ACC.0		;SET FOR FINAL BIT
	MOV	DPTR,#9653H
	MOVX	@DPTR,A	
	MOV	DPTR,#9E21H	;CHECK ORI/ANS
	MOVX	A,@DPTR
	JNB	ACC.7,NSET_ORI
	MOV	A,#03		;SET 03 FOR 9651H
	MOV	DPTR,#9651H
	MOVX	@DPTR,A
NSET_ORI:
	MOV	CRCH_T,#0FFH
	MOV	CRCL_T,#0FFH
	MOV	B,#3
	MOV	DPTR,#MNP_S+5
	MOVX	A,@DPTR
	JB	ACC.3,V42MR
	INC	B
V42MR:
	MOV	DPTR,#CRCL_D
	MOV	A,#51H		;SET UP INITIAL ADDRESS FOR CRC CHECKING
	MOVX	@DPTR,A
GET_CRC:
	LCALL	GET_D
	LCALL	I_TXSYNTT
	DJNZ	B,GET_CRC
	MOV	DPTR,#MNP_S+5
	MOVX	A,@DPTR
	JB	ACC.3,V42MCRC
	MOV	DPTR,#9655H
	SJMP	CRC_COM
V42MCRC:	
	MOV	DPTR,#9654H
CRC_COM:	
	MOV	A,CRCH_T
	XRL	A,#0FFH
	MOVX	@DPTR,A
	INC	DPTR
	MOV	A,CRCL_T
	XRL	A,#0FFH
	MOVX	@DPTR,A	
	MOV	DPTR,#C_CNT
	MOV	A,#8
	MOVX	@DPTR,A		;SET C_CNT
	INC	DPTR
	MOV	A,#50H		;SET PRT_1
	MOVX	@DPTR,A
	INC	DPTR
	MOV	A,#7
	MOVX	@DPTR,A		;SET RNR_CNT
	RET
GET_D:
	MOV	DPTR,#CRCL_D
	MOVX	A,@DPTR
	MOV	DPL,A
	MOV	DPH,#96H
	MOVX	A,@DPTR
	PUSH	A		;KEEP ACC
	INC	DPL
	MOV	A,DPL
	MOV	DPTR,#CRCL_D	;STORE BACK FOR DATA MEMORY
	MOVX	@DPTR,A
	POP	A		;GET BACK ACC
	RET

RNR_INT:
;	PUSH	DPL
;	PUSH	DPH
;	PUSH	PSW
;	PUSH	ACC
	MOV	DPTR,#MK_CNT1	;CHECK 5 1'S
	MOVX	A,@DPTR
	CJNE	A,#5,NO_SACT
	SJMP	SND_SP
NO_SACT:
	MOV	DPTR,#PRT_1
	MOVX	A,@DPTR
	JZ	NO_INS
	MOV	DPTR,#MNP_S+5
	MOVX	A,@DPTR
	JB	ACC.3,V42_L
	MOV	DPTR,#PRT_1
	MOVX	A,@DPTR
	JZ	NO_INS
	CJNE	A,#7,CHK_INS
	SJMP	CHK_INS

V42_L:	MOV	DPTR,#PRT_1
	MOVX	A,@DPTR
	JZ	NO_INS
	CJNE	A,#6,CHK_INS
CHK_INS:	
	JNC	NO_INS	
	MOV	DPTR,#9650H
	ADD	A,DPL
	MOV	DPL,A
	MOVX	A,@DPTR
	RR	A
	MOVX	@DPTR,A
	RL	A
	ANL	A,#3
	MOV	DPTR,#TX_P
	MOVX	@DPTR,A
	MOV	C,ACC.0
	JNC	RST_MK
	MOV	DPTR,#MK_CNT1	;INCREMENT FOR MK_CNT
	MOVX	A,@DPTR
	INC	A
	MOVX	@DPTR,A
RNR_COM:	
	MOV	DPTR,#C_CNT	;SET BIT COUNT
	MOVX	A,@DPTR
	DEC	A
	MOVX	@DPTR,A
	JNZ	BK_EXTRA
	MOV	A,#8H
	MOVX	@DPTR,A
	MOV	DPTR,#PRT_1
	MOVX	A,@DPTR
	INC	A
;	ANL	A,#00000111B
	MOVX	@DPTR,A
BK_EXTRA:
;	POP	ACC
;	POP	PSW
;	POP	DPH
;	POP	DPL
	RET				;020T
RST_MK:
	MOV	DPTR,#MK_CNT1
	CLR	A
	MOVX	@DPTR,A
	SJMP	RNR_COM
;	
SND_SP:
	MOV	DPTR,#TX_P		;ZERO INSERTION
	CLR	A
	MOVX	@DPTR,A
	MOV	DPTR,#MK_CNT1
	MOVX	@DPTR,A
	SJMP	BK_EXTRA
;		
NO_INS:
	MOV	DPTR,#MK_CNT1
	CLR	A
	MOVX	@DPTR,A			;RESET MK_CNT
	MOV	DPTR,#9650H
	MOVX	A,@DPTR
	RR	A
	MOVX	@DPTR,A
	RL	A
	ANL	A,#3
	MOV	DPTR,#TX_P
	MOVX	@DPTR,A
	SJMP	RNR_COM			;144T
;902S
;FOR S86 REGISTER			
B_DIS:
	MOV	DPTR,#C_BUF+1		;014S
	MOVX	A,@DPTR
	CJNE	A,#0,NOT_EMNA
	LJMP	ON_LOOPS
NOT_EMNA:
	INC	DPTR
	MOVX	A,@DPTR
	CJNE	A,#0,NOT_EMNB
	LJMP	ON_LOOPS
NOT_EMNB:				;014T
	CLR	EA			;152
	MOV	DPTR,#STAT_1
	MOVX	A,@DPTR
	JNZ	MAY_ENG
	MOV	DPTR,#LN_RETX
	MOVX	A,@DPTR
	CJNE	A,#12D,CHK_NN1
CHK_NN0:
	MOV	DPTR,#S86	;12 RE_TRANSMIT
	MOV	A,#13
	MOVX	@DPTR,A
	SJMP	NO_STAT
;
CHK_NN1:
	MOV	DPTR,#RE_COUNT
	MOVX	A,@DPTR
	CJNE	A,#12D,CHK_NN2
	SJMP	CHK_NN0
CHK_NN2:
	MOV	DPTR,#RCV_BUF+1		;MNP
	MOVX	A,@DPTR
	CJNE	A,#2H,MAY_ENG
	MOV	DPTR,#S86	;NORMAL DISCONNECT
	MOV	A,#12
	MOVX	@DPTR,A
	SJMP	NO_STAT
;
MAY_ENG:
	CJNE	A,#3H,NO_STAT
	MOV	DPTR,#S86
	INC	A
	MOVX	@DPTR,A
NO_STAT:
	LCALL	REV_S4
;902T
	LJMP	DISCONNECTM
REV_S4:
	MOV	DPTR,#TEMP_S21
	MOVX	A,@DPTR
	MOV	S21,A
	MOV	DPTR,#TEMP_S10
	MOVX	A,@DPTR
	MOV	S10,A
	RET
;
B_ONLP:
	MOV	DPTR,#RCV_BUF+1	;MNP V.42 ?
	MOVX	A,@DPTR
	CJNE	A,#1,CHK_NN3
	MOV	DPTR,#S86	;NO ACCORD PROTOCOL
	MOV	A,#9
	MOVX	@DPTR,A
	LJMP	ON_LOOP
;
CHK_NN3:
	MOV	DPTR,#S86	;SUCCESS& NEGOTIATION FAIL
	MOV	A,#6		
	MOVX	@DPTR,A
	LJMP	ON_LOOP
	ENDIF

	IFFALSE	MICROCOM
SPD_OUTS:
	LJMP	SPD_OUT
	ENDIF	

SCTINT_N:			;116S ;163S
;	LCALL	CHK_P7
	JB	SPD_FLG,ON_SPD

	IFTRUE	MICROCOM
	LJMP	FIXED2
;	LJMP	SCTINT_1
	ENDIF	
	
	RETI

ON_SPD:	PUSH	ACC
	PUSH	PSW
	PUSH	DPL
	PUSH	DPH
	
	IFTRUE V.23
	JNB	V23_SPD,SCT_N
	LCALL	V23_TX
	SJMP	SCT_O
SCT_N:
	ENDIF
	
	IFTRUE	MICROCOM
	MOV	DPTR,#JS7
	MOVX	A,@DPTR
	JNB	ACC.0,N_PAT	;RNRON
	LCALL	RNR_INT
	SJMP	SCT_O
N_PAT:
	ENDIF
	
	IFFALSE	NSP
	LCALL	SPD_TX
	ENDIF

SCT_O:	POP	DPH
	POP	DPL
	POP	PSW
	POP	ACC
	RETI


SCRINT_N:
	IFFALSE	NSP
	JNB	SPD_FLG,SCR_O
	PUSH	ACC
	PUSH	PSW
	PUSH	DPL
	PUSH	DPH
	LCALL	SPD_RX
	SJMP	INT0R
SCR_O:
	IFTRUE	V42BIS
	LJMP	FIXED3
	LJMP	SCRINT_1
	ENDIF

	IFTRUE	V42ONLY
	LCALL	SCRINT_1
	JNB	V42_S,T_V42O
	JNB	RCV_FR,T_V42O
	SETB	EXTRA_B
	CLR	RCV_FR
T_V42O:	RET
	ENDIF

INT0R:	POP	DPH
	POP	DPL
	POP	PSW
	POP	ACC
	ENDIF
	
	RETI			;116T ;163T


	IFTRUE	MICROCOM	;148
FIXED1:					;105S
	IFFALSE	X2400
	LCALL	RS_TPEQ
	ENDIF

	MOV	DPTR,#JS3		;131S
	MOVX	A,@DPTR
	JNB	ACC.7,OKBK1
	ANL	A,#0FH
	CJNE	A,#2,BKC
BKC:	JC	OKBK
	JB	LN_OUT,OKBK
	LJMP	ABK_AT
OKBK:	MOV	TIMER4,#0		;131T
OKBK1:
	IFTRUE	V42BIS
	JNB	BIS,PAS			;119S
	JB	BT_TX,PAS
	JB	BT_RX,PAS
	SETB	BT_TX
	SETB	BT_RX
	LCALL	DICT_INIT
PAS:					;119S
	JB	RCV_FR,CONDAT		;161S
	CLR	DATA_G
	ENDIF
CONDAT:					;161T
	LCALL	DTR_CKK
	LCALL	ENG_CKK
	LCALL	ESC_CKK
	
	IFTRUE	V42ONLY
;=======================================
; 1/22/91, FIX FOR LN SEQUENCE #
;=======================================

	JNB	V42_S,CNT_RM
	JBC	EXTRA_B,CHK_RCV
	SJMP	CNT_RM
CHK_RCV:
	MOV	DPTR,#RCV_BUF+1
	MOVX	A,@DPTR
	ANL	A,#0EFH
	CJNE	A,#3H,B_RCV
	CLR	RCVCMD
	INC	DPTR
	MOVX	A,@DPTR		;ADDRESS
	JBC	ACC.5,FR_UIA	;BREAK ACK IF BIT 5 = 1
B_RCV:	SETB	RCV_FR
	LJMP	MNP_IN
FR_UIA:
	LCALL	SEQ_CHK
	JNB	ACC.0,CNT_RM
	LCALL	INC_SEQ
	LJMP	B_UIA
SEQ_CHK:
	MOV	C,ACC.7
	MOV	DPTR,#CFR_UI+2H	;MAKE SURE RIGHT SEQUENCE
	MOVX	A,@DPTR		;
	RL	A
	ADDC	A,#0H
	RET
INC_SEQ:
	MOV	DPTR,#CFR_UI+2H	;NEXT SEQ NUMBER
	MOVX	A,@DPTR		;
	ADD	A,#80H		;
	MOVX	@DPTR,A		;
	RET
	ENDIF


CNT_RM:	
	IFTRUE REMOTE
	LCALL	RM_CHK
	ENDIF

;=======================================
; 3/11/91, FIX MICROCOM V42 CONNECTION 
;=======================================
;
	MOV	DPTR,#F1ST_E
	MOVX	A,@DPTR
	JZ	NOT_EM
	MOV	DPTR,#C_BUF+2
	MOVX	A,@DPTR
	CJNE	A,#'M',NOT_EM
	MOV	A,#0AAH
	MOVX	@DPTR,A
	MOV	DPTR,#F1ST_E
	MOVX	A,@DPTR
	DEC	A
	MOVX	@DPTR,A
NOT_EM:	
;
;==============================================
; 4/8/91, SND BREAK REFER \K1,\K3,\K5
;==============================================
;
	JB	V42_S,V42_BRK
	MOV	DPTR,#CFR_LN+7H
	MOVX	A,@DPTR
	CJNE	A,#3,BK_EMERY
	SJMP	NO_EMERYBK
;==============================================
; 4/8/91, SND BREAK REFER \K1,\K3,\K5
;==============================================
;
V42_BRK:						;144S
	MOV	DPTR,#CFR_UI+3
	MOVX	A,@DPTR
	JB	ACC.6,BK_EMERY
	JB	ACC.7,BK_EMERY
	SJMP	NO_EMERYBK

BK_EMERY:
	MOV	A,DTR_PTR
	SETB	ACC.5
	SETB	ACC.6
	MOV	DPH,#88H
	MOV	DPL,A
	MOV	A,#1
	MOVX	A,@DPTR
	JZ	NO_EMERYBK
	CLR	A
	MOVX	@DPTR,A
	SETB	WAIT_LN
NO_EMERYBK:			;147
N_ACT:				;021S
	MOV	DPTR,#OPT_BK
	MOVX	A,@DPTR
	JZ	FIN_BK
	JB	BK_NOW,CLR_LN	;CHECK START TO PROCESS BREAK
	JB	LN_OUT,FIN_BK
	CLR	A
	MOVX	@DPTR,A
	LJMP	ABK_AT

ST_BK:	JB	LN_OUT,FIN_BK
	SETB	ACC.1		;OUT RNR
	MOVX	@DPTR,A
	MOV	TIMER4,#3	;LOWER TIMER4 TIMER
	SETB	R_ACK
	SETB	N_CRD
	SETB	N_CHK
FIN_BK:	LJMP	MNP_IN	

CLR_LN:	CLR	LN_OUT
	SJMP	FIN_BK		;021T

;	LJMP	MN000		;144T

SP_INT:				;131S
	JNB	RI,NRX
	PUSH	PSW		;RI
	PUSH	ACC
	PUSH	DPH
	PUSH	DPL
	MOV	DPTR,#JS3
	MOVX	A,@DPTR
	JNB	ACC.7,NBKC
	MOV	A,SBUF
	JNZ	N_BK
	JB	SCON.2,N_BK
;	JNB	BK_NOW,F_BK
F_BK:	MOVX	A,@DPTR
	INC	A
	SJMP	BK_OK

N_BK:	MOVX	A,@DPTR
	ANL	A,#F0H
BK_OK:	MOVX	@DPTR,A
NBKC:	POP	DPL
	POP	DPH
	POP	ACC
	POP	PSW
NRX:	
	IFTRUE	V42BIS
	LJMP	SPINT		;Serial I/O Interrupt(EC USED)
	ENDIF

	IFTRUE	V42ONLY
	LJMP	SPINT_1		;Serial I/O Interrupt(EC USED)
	ENDIF

	RETI
;	ENDIF			;131T

;	IFTRUE	V42BIS
;MMM
DTR_CKK:
	MOV	DPTR,#T_TIMER0	;UPDATE DUPLICATE TIMER0
	MOVX	A,@DPTR		;MAY BE REPLACE BY TIMER0 OF UART
	MOV	B,A		;TO CREAT S10 & S12 & S25
	MOV	A,TIMER0
	MOVX	@DPTR,A	   	;STORE PREVIOUS TIMER0
	XRL	A,B
	JB	ACC.5,DTR_TOUT	;TICKING ?
	RET
R_DTR:
	CLR	A
	MOVX	@DPTR,A
	RET
DTR_TOUT:
	MOV	DPTR,#TIME_S12
	MOVX	A,@DPTR
	INC	A
	JB	ACC.7,NO_INC
	MOVX	@DPTR,A
NO_INC:
	MOV	DPTR,#TIME_S10
	MOVX	A,@DPTR
	INC	A
	JB	ACC.7,NO_INC1
	MOVX	@DPTR,A
NO_INC1:
	MOV	DPTR,#TIME_S25	;
	JNB	P1.4,R_DTR	;DTR ON ?
	MOVX	A,@DPTR
	INC	A
	MOVX	@DPTR,A
	MOV	B,A
	MOV	DPTR,#S_S25
	MOVX	A,@DPTR
	CJNE	A,B,CHK_S25	;S25 TIMEOUT
CHK_S25:
	JC	B_S25
	RET
B_S25:
	MOV	DPTR,#TEMP_S21	;DTR OPTION ?
	MOVX	A,@DPTR
	JNB	ACC.4,CHK3
	JB	ACC.3,BINIT
	LJMP    8EH 		;DROP LINE
BINIT:	CLR	EA
	LJMP	0H		;GO TO INITIALZE
CHK3:	JNB	ACC.3,CONSE1	;IGNORE DTR
	POP	ACC
	POP	ACC
	LJMP	91H		;GO TO COMMAND MODE
CONSE1:
	RET
	
;
;MAKE SURE B REG HAS PREVIOUS TIMER0 VALUE
;
ENG_CKK:
	MOV	DPTR,#RX_P
	MOVX	A,@DPTR
	JB	ACC.2,RST_S10
	MOV	DPTR,#TEMP_S10
	MOVX	A,@DPTR
	MOV	B,A
	INC	A
	JZ	CONTSE
	MOV	DPTR,#TIME_S10
	MOVX	A,@DPTR
	CJNE	A,B,CHK_S10
CHK_S10:
	JC	CONTSE
	MOV	DPTR,#OPT_B
	MOVX	A,@DPTR
	JNB	ACC.0,GDBK_AT
	MOV	A,R_CRD
	JNZ	CONTSE
	MOV	DPTR,#P_CNT
	MOVX	A,@DPTR
	JNZ	RST_S10
	JNB	TI_FLAG,RST_S10	
GDBK_AT:
	POP	ACC
	POP	ACC
	LJMP	99H
RST_S10:
	CLR	A
	MOV	DPTR,#TIME_S10
	MOVX	@DPTR,A
CONTSE:
	RET
;
;========S12 WORK AROUND==========================
;
ESC_CKK:
	MOV	DPTR,#MESC_CNT
	MOVX	A,@DPTR
	JNZ	T_ESC
	MOV	TIMER4,#05H	;MAKE INSIDE ROM ALWAYS TIMEOUT
	CLR	ESC_BIT
	RET
T_ESC:
	MOV	A,TIMER4 	;DATA IN RESET TIMER4 =0,1
	MOV	TIMER4,#2H	;
	JZ	CNT_CHK
	DJNZ	A,B_NOCNG
CNT_CHK:
	MOV	DPTR,#S_S12
	MOVX	A,@DPTR
;	CLR	C
;	RRC	A
	MOV	B,A
	MOV	DPTR,#TIME_S12
	MOVX	A,@DPTR
	CJNE	A,B,CHK_TOUT
CHK_TOUT:
	JNC	S12_OUT		;S12 TIMEOUT ?
	CLR	A		;NOW RESET TIMER & ESC_CNT
	MOVX	@DPTR,A
	MOV	DPTR,#MESC_CNT
	MOVX	A,@DPTR
	CJNE	A,#3,CHK_1
	SETB	ESC_BIT
	RET
CHK_1:	CJNE	A,#1,NO_CNG
CHK_11:	CLR	A
	MOVX	@DPTR,A
	MOV	TIMER4,#05H	;BACK TO INITIAL
NO_CNG:
	RET
B_NOCNG:
	JB	ESC_BIT,CHK_RDY
	RET
S12_OUT:
	CLR	A
	MOVX	@DPTR,A		;RESET TIMER
	MOV	DPTR,#MESC_CNT
	MOVX	A,@DPTR
	CJNE	A,#1,CHK_11	;
	RET
;
CHK_RDY:
	MOV	DPTR,#S_S12
	MOVX	A,@DPTR
;	CLR	C		;TIMER ADJUSTMENT
;	RRC	A
	MOV	B,A
	MOV	DPTR,#TIME_S12
	MOVX	A,@DPTR
	CJNE	A,B,CHK_SOUT
CHK_SOUT:
	JNC	ESC_OUT		;S12 TIMEOUT ?
	RET
ESC_OUT:
	CLR	ESC_BIT
	MOV	TIMER4,#05
	RET
	ENDIF
	
	END
