	list	on
	pl	104
	pw	128
;************************************************************************
;* FILE		: MOD4.ASM UNIVERSAL					*
;* PROGRAM	: N/A							*
;* SUBJECT	: Call Progress						*
;************************************************************************

; 5/1/91	RELEASE 1.1
; 3/1/91	RELEASE 1.0
	
	LIST	OFF
	INCLUDE CONFIG.ASM
	INCLUDE RDEFINE.ASM
	LIST	ON
;
;========================================
;EXTERNAL DEFINITIONS
;========================================
;
;FROM MOD1.ASM
;
	EXTERNAL	INIT_MOD,SET_T1
;
;FROM MOD3.ASM
;
	EXTERNAL	WR0_CNTL,RD0_CNTL,SET_FSK,SET_T2
;
;FROM MOD5.ASM
;
	EXTERNAL	WAIT_3MS,SPEAK_ON,C_ENERGY

;FROM	WMOD.ASM
	EXTERNAL	SET_V22,UPDAT_SPK,SET_TMOD,TX_ON,TX_OFF
	
	IFTRUE	X2400
	EXTERNAL	WR1_CNTL,RD_STAT
	ENDIF

;
;FROM MOD10.ASM
;
	EXTERNAL	V21TRY
;

;	
;========================================
;Public Definitions
;========================================
	GLOBAL	CPM_MOD,CHK_DT,QUIET_A
	GLOBAL	CHK_DTW
;
	TITLE  Module 4 - Call Progress

;############################################################
;#                                                          #
;#                    DIALTONE DETECT                       #
;#                                                          #
;############################################################
;
	CODE
;
;============================================================
;CHK_DT - CHECK FOR DIALTONE - AFTER "D" COMMAND
;CHK_DTW - CHECK FOR DIALTONE - AFTER "W" COMMAND
; THIS ROUTINE WILL CHECK FOR DIALTONE.  IF ATX2 OR ATX4 IS SET
; THEN THIS ROUTINE WILL WAIT 5 SECONDS FOR 2 SECONDS OF DIALTONE
; IF A "W" MODIFIER IS SPECIFIED THIS ROUTINE WILL WAIT S7 SECONDS
; FOR THE SECOND DIALTONE
; DESTROYS: ACC,DPTR
;           TIMER 1
;           TIMER 2
; CALLS: SETCPM, C_ENERGY  
; EXPECTS:  NOTHING
; RETURNS:  ABORT1 = 1 IF USER ABORT
;           PASS = 1 IF DIALTONE DETECTED
; STACK - 10
;============================================================
;
CHK_DTW:
	MOV	A,S7
	SJMP	CHKDT0
;
CHK_DT:	MOV	A,#5		;WAIT 5 SECONDS FOR DIALTONE
CHKDT0:	CLR	ABORT1
	CLR	PASS
	CALL	SET_T1
	LCALL	SETCPM		;PUT XR2400 INTO CALL PROGRESS MODE
CHKDT2:	LCALL	C_ENERGY
	JNB	TIM_1F,CHKDT9	;BRANCH IF NO DIALTONE DETECTED WITHIN TIME
				;ALLOTED
	JBC	RI,CHKDTA	;BRANCH IF USER ABORT
	JC	CHKDT1		;BRANCH IF ENERGY IN CPM BAND DETECTED
	SJMP	CHKDT2
;
;====================
;VALIDATE DIALTONE
;====================
;
CHKDT1:	MOV	A,#20		;2 SECOND CONSTANT
	LCALL	SET_T2
CHKDT3:	LCALL	C_ENERGY	;CHECK FOR ENERGY
	JNB	TIM_2F,CHKDT4	;BRANCH IF 2 SEC OF DIALTONE DETECTED
	JBC	RI,CHKDTA	;BRANCH IF USER ABORT
	JNC	CHKDT2		;BRANCH IF ENERGY DISAPPEARS
	SJMP	CHKDT3	
;
CHKDT4:	SETB	PASS		;DIALTONE DETECTED
	SJMP	CHKDT9
;
CHKDTA:	SETB	ABORT1		;USER ABORT
CHKDT9:	LJMP	CLRCPM
;	RET			;DIALTONE NOT DETECTED

	IFTRUE FAX
;3-15-91 ENABLE CALLING TONE -- FOR FAX MODE
ENA_CNG:
	LCALL	SET_TMOD	;SET TONE TRANSMIT MODE
	MOV	B,#03		;WRITE ADDRS 3 = 1DH
	MOV	A,#1DH
	LCALL	WR0_CNTL
	MOV	B,#02		;WRITE ADDRS 2 = 55H
	MOV	A,#55H
	LCALL	WR0_CNTL
	LCALL	TX_ON		; TURN ON TRANSMITTER
	MOV	TIM_5,#25	;CONTINUOUS CALLING TONE FOR 500MS
	SETB	TIM_5F
E_CNG1:	JB	TIM_5F,E_CNG1
	LCALL	TX_OFF	
	MOV	TIM_5,#150	;SET UP 3.0 SECONS FOR CNG OFF TIME
	SETB	TIM_5F
	RET
	ENDIF
;
;============================================================
;CPM_MOD - CHECK FOR BUSY OR ANSWER TONE
; DESTROYS:  ACC,DPTR,R0,R1,R2,BUSY_CYCLES
;            TIMER 4
;            TIMER 2
;	     TIMER 3
; CALLS: SETCPM,SETORG,C_ENERGY,CPM_ON,CPM_OFF,WAIT_3MS  
; EXPECTS: TIMER 1 TO BE RUNNING WITH S7 TIME
;          BUSY_CHK = 1 IF BUSY TO BE CHECKED
; RETURNS:  ABORT = 1 IF USER ABORT OR S7 TIMEOUT
;           BUSYB = 1 IF BUSY TONE DETECTED
;           ANSWER_T = 1 IF ANSWER TONE DETECTED 
; STACK - 10
;============================================================
;
CPM_MOD:
	IFTRUE	FAX
	MOV	DPTR,#OPT_FAX	;3-15-91
	MOVX	A,@DPTR		;3-15-91
	JNB	ACC.0,NO_CNG	;3-15-91
	JB	TIM_5F,NO_CNG	;3-15
	LCALL	ENA_CNG		;3-15
NO_CNG:				;3-15
	ENDIF
	
	CLR	BUSYB
	CLR	ANSWER_T
	MOV	BUSY_CYCLES,#00
	JB	BUSY_CHK,CPM002
	LJMP	CPM100		;GO CHECK FOR ANSWER TONE ONLY
CPM002:	LCALL	SETCPM		;SETUP EXAR FOR CPM MODE
CPM005:	MOV	TIM_4,#100
	SETB	TIM_4F		;START 330MS TIMER
;
;Look for energy in call progress band
;
CPM010:	LCALL	C_ENERGY	;LOOK FOR ENERGY IN THAT BAND
	JBC	RI,CPM090	;BRANCH IF USER ABORT
	JNB	TIM_1F,CPM090	;BRANCH IF S7 TIMEOUT
	JNB	TIM_4F,CPM030	;BRANCH IF 250MS TIMER FINISHED
	JC	CPM020		;ENERGY SEEN
	SJMP	CPM010
;
;Energy in call progress band detected - Is it busy tone?
;
CPM020:	MOV	R1,#17		;340MS MINIMUM
	MOV	R2,#33		;650MS MAXIMUM
	LCALL	CPM_ON		;CHECK LENGTH OF ENERGY
	JB	ABORT,CPM090
	JNB	PASS,CPM030	;NOT A VALID BUSY, CHECK ANSWER TONE
	LCALL	CPM_OFF		;CHECK FOR OFF DELAY
	JB	ABORT,CPM090
	JNB	PASS,CPM030	;CHECK FOR ANSWER TONE
	INC	BUSY_CYCLES
	MOV	A,#4		;BUSY DELAY = 4 CYCLES
	CJNE	A,BUSY_CYCLES,CPM005
;
;====================	
;BUSY DETECTED
;====================	
;
	SETB	BUSYB		;SET BUSY STATUS FOR CALLER
	SJMP	CPM085
;	
;====================	
;LOOK FOR ANSWER TONE
;====================	
;
CPM030:	LCALL	SETORG		;LOOK FOR ANSWER TONE NOW
	MOV	A,#10		;WAIT 33MS
	LCALL	WAIT_3MS
	LCALL	C_ENERGY
;XXX	JNC	CPM_MOD		;GO BACK TO LOOK FOR BUSY
	JC	CPM31		;171S

	IFTRUE	V.23
	JB	BELL212,CPM_MOD	;BRANCH IF TIMEOUT
	MOV	DPTR,#JS5	;018S
	MOVX	A,@DPTR
	JNB	ACC.0,NB2
	LJMP	CPM085		;018T

NB2:	LCALL	V21TRY
	JNC	CPM_MOD
	LJMP	CPM085
	ENDIF

R_CPM:	SJMP	CPM_MOD		;GO BACK TO LOOK FOR BUSY
CPM31:				;171T

;====================
;VALIDATE ANSWER TONE
;====================
	MOV	A,S9		;CARRIER DETECT RESPONSE TIMER
	LCALL	SET_T2
CPM040:	LCALL	C_ENERGY
	JBC	RI,CPM090	;BRANCH IF USER ABORT
	JNC	R_CPM		;ENERGY DISAPPEARED, GO BACK TO CPM BAND
	JB	TIM_2F,CPM040
;====================
;VALID ANSWER TONE DETECTED
;====================
CPM083:	SETB	ANSWER_T
CPM085:	CLR	ABORT
	SJMP	CPM091
;
CPM090:	SETB	ABORT
CPM091:	LJMP	CLRCPM
;	RET	
;
;====================
;CHECK FOR ANSWER TONE ONLY
;====================
;
CPM100:
	MOV	A,#3		;171S
	LCALL	SET_T2
CPM100A:
	IFTRUE	FAX
	MOV	DPTR,#OPT_FAX	;3-15-91
	MOVX	A,@DPTR		;3-15-91
	JNB	ACC.0,NO_CNG0	;3-15-91
	JB	TIM_5F,NO_CNG0	;3-15
	LCALL	ENA_CNG		;3-15
NO_CNG0:			;3-15
	ENDIF

	LCALL	SETORG
	JBC	RI,CPM090	;BRANCH IF ABORT
	JNB	TIM_1F,CPM090	;BRANCH IF TIMEOUT
	JB	TIM_2F,CPM91	;BRANCH IF TIMEOUT

	IFTRUE	V.23
	JB	BELL212,CPM100	;BRANCH IF TIMEOUT
	LCALL	V21TRY
	JNC	CPM100
	LJMP	CPM085
	ENDIF

	SJMP	CPM100

CPM91:	LCALL	C_ENERGY
	JNC	CPM100A		;171T

CPM110:	MOV	A,S9		;CARRIER DETECT RESPONSE TIMER
	LCALL	SET_T2
CPM115:	LCALL	C_ENERGY
	JNB	TIM_2F,CPM083	;ANSWER TONE DETECTED
	JBC	RI,CPM090	;BRANCH IF USER ABORT
	JC	CPM115		;BRANCH IF ENERGY STILL PRESENT
	SJMP	CPM100
;
;============================================================
;QUIET_A - THIS ROUTINE WILL WAIT FOR 5 SECONDS OF QUIET AFTER
;  A MINIMUM OF 220 MS OF ENERGY IN CPM BAND
; DESTROYS:  ACC,DPTR,R0,R1,R2
;            TIMER 3
; CALLS: SETCPM,C_ENERGY,CPM_ON,CPM_OFF  
; EXPECTS:  TIMER 1 RUNNING WITH S7 TIME
; RETURNS:  ABORT = 1 USER ABORT OR S7 TIMEOUT
;           PASS = 1 QUIET ANSWER DETECTED
; STACK - 8
;============================================================
;
QUIET_A:
	CLR	PASS		;147
	CLR	ABORT		;147
	CLR	BUSYB		;147
	MOV	A,S7
	CALL	SET_T1
	LCALL	SETCPM		;SETUP CPM
QUITA1:	LCALL	C_ENERGY	;LOOK FOR ENERGY IN THAT BAND
	JNB	TIM_1F,QUITA3	;BRANCH IF S7 TIMEOUT
	JBC	RI,CPM090	;BRANCH IF USER ABORT
	JNC	QUITA1		;BRANCH IF ENERGY NOT SEEN
QUITA2:	MOV	R1,#11		;220MS MINIMUM
	MOV	R2,#255		;5.1 SECOND  MAXIMUM
	LCALL	CPM_ON		;CHECK LENGTH OF ENERGY
	JB	ABORT,CPM090
	JNB	PASS,QUITA1	;START ALL OVER AGAIN
;	LCALL	SETCPM
;	MOV	R1,#0
;	MOV	R2,#254
;	LCALL	CPM_OFF		;CHECK FOR 5 SECONDS OF SILENCE
;	JB	ABORT,CPM090
;	JNB	PASS,B_QUITA1	;START ALL OVER AGAIN IF NOT GREATER THAN 5.1
	LCALL	SET_6
A_QUITA2:				;SECONDS OF SPACE
	LCALL	CHK_BY
	JNB	TIM_6F,B_QUITA1
	JNB	TIM_1F,QUITA3
	JB	ABORT,CPM090
	JNB	PASS,B_QUITA1
	SJMP	A_QUITA2
B_QUITA1:
;====================
;QUIET ANSWER DETECTED
;====================
	SETB	PASS
	SJMP	QUITA4
;	RET
QUITA3:	CLR	PASS
	CLR	ABORT
QUITA4:	LJMP	CLRCPM
;	RET
;
	EJECT
;############################################################
;#                                                          #
;#                CALL PROGRESS SUBROUTINES                 #
;#                                                          #
;############################################################
;
;============================================================
;SETCPM - SET CALL PROGRESS MODE - PUT XR2400 INTO CALL PROGRESS MODE
; DESTROYS: ACC,DPTR
; REQUIRES:  NOTHING
; CALLS: NOTHING  
; EXPECTS: NOTHING
; STACK - 6
;============================================================
;
SETCPM:
	
	IFFALSE	X2400
	LCALL	SET_V22
	MOV	B,#07
	LCALL	RD0_CNTL
	SETB	ACC.7
	SETB	ACC.6
	CLR	ACC.1
	LCALL	WR0_CNTL
	RET

SETORG:	
	LCALL	SET_V22
	MOV	B,#07
	LCALL	RD0_CNTL
	CLR	ACC.7
	CLR	ACC.6
	CLR	ACC.1
	LCALL	WR0_CNTL
	RET	
	ENDIF

	IFTRUE	X2400
	MOV	A,#FSK_MOD
	MOV	B,#W_REG9
	LCALL	WR1_CNTL		;SET UP FOR CPM MODE (FSK)
	MOV	A,#W_REG4
	LCALL	RD_STAT
	ORL	A,#11000000B		;
					;ACC.6		;SET CPM MODE
					;ACC.7		;SELECT LOW BAND
SETC1:	MOV	B,#W_REG4
	LJMP	WR1_CNTL
;	RET
CRCPM0:	LCALL	INIT_MOD		;INITIALIZE MODEM
	LJMP	SPEAK_ON
;
SETORG:	
	MOV	A,#FSK_MOD
	MOV	B,#W_REG9
	LCALL	WR1_CNTL		;
	MOV	A,#W_REG4
	LCALL	RD_STAT
	SETB	ACC.6			;SET CPM MODE
	ANL	A,#01111101B
					;ACC.7	;SELECT HIGH BAND (ALB)
					;ACC.1	;SET ORIGINATE MODE
	MOV	B,#W_REG4
	LJMP	WR1_CNTL
;	RET
	ENDIF

CLRCPM:	
	LCALL	INIT_MOD		;INITIALIZE MODEM
	LCALL	UPDAT_SPK		;102
	JNB	SPEAK_1,CLRCP1
	JNB	SPEAK_2,CLRCP1
	RET
CLRCP1:	LJMP	SPEAK_ON	;& RET

;============================================================
;CPM_ON - MEASURE TIME THAT ENERGY IS ON IN CALL PROGRESS BAND
; DESTROYS: ACC,DPTR
; CALLS: NOTHING  
; TIMERS:  TIMER 3
; EXPECTS:  TIMER 1 RUNNING WITH S7 TIME
;           R1 = LOW MARGIN
;           R2 = HIGH MARGIN
; RETURNS:  PASS = 1 IF WITHIN MARGINS
;           ABORT = 1 IF USER ABORT OR S7 TIMEOUT
; STACK - 2
;============================================================
;
CPM_ON:
	CLR	PASS
	CLR	ABORT
	MOV	TIM_3,#255	;TIMER 3 = 5.1 SECONDS
	MOV	TIM_3P,#6	;20MS PRESCALAR
	SETB	TIM_3F		;START TIMER
CPMON1:	LCALL	C_ENERGY
	JNC	CPMON2		;BRANCH IF ENERGY DISAPPEARS
	JBC	RI,CPMON9	;BRANCH IF USER ABORT
	JNB	TIM_1F,CPMON9	;BRANCH IF S7 TIMEOUT
	JNB	TIM_3F,CPMON8	;BRANCH IF TIMER 3 TIMES OUT
	SJMP	CPMON1
CPMON2:	CLR	TIM_3F		;STOP TIMER
	MOV	A,#255
	CLR	C
	SUBB	A,TIM_3		;ACC = LENGTH OF TONE * 20MS
	CJNE	A,REG_1,CPMON3
CPMON3:	JC	CPMON8		;BRANCH IF TIME < MINIMUM
	CJNE	A,REG_2,CPMON4
CPMON4:	JNC	CPMON8		;BRANCH IF TIME > MAXIMUM
	SETB	PASS
	RET
CPMON9:	SETB	ABORT
CPMON8:	RET	
;
;============================================================
;CPM_OFF - MEASURE TIME THAT ENERGY IS OFF IN CALL PROGRESS BAND
; DESTROYS: ACC,DPTR
; CALLS: NOTHING  
; TIMERS:  TIMER 3
; EXPECTS:  TIMER 1 RUNNING WITH S7 TIME
;           R1 = LOW MARGIN
;           R2 = HIGH MARGIN
; RETURNS:  PASS = 1 IF WITHIN MARGINS
;           ABORT = 1 IF USER ABORT OR S7 TIMEOUT
; STACK - 2
;============================================================
;
CPM_OFF:
	CLR	PASS
	CLR	ABORT
	MOV	TIM_3,#255	;TIMER 3 = 5.1 SECONDS
	MOV	TIM_3P,#6	;20MS PRESCALAR
	SETB	TIM_3F		;START TIMER
CPMOF1:	LCALL	C_ENERGY
	JC	CPMON2		;BRANCH IF ENERGY APPEARS
	JBC	RI,CPMON9	;BRANCH IF USER ABORT
	JNB	TIM_1F,CPMON9	;BRANCH IF S7 TIMEOUT
	JNB	TIM_3F,CPMON8	;BRANCH IF TIMER 3 TIMES OUT
	SJMP	CPMOF1
;====================================================
CHK_BY:
	CLR	BUSYB
	CLR	ANSWER_T
	MOV	BUSY_CYCLES,#00
	LCALL	SETCPM		;SETUP EXAR FOR CPM MODE
CP005:	MOV	TIM_4,#100
	SETB	TIM_4F		;START 330MS TIMER
;
;Look for energy in call progress band
;
CP010:	LCALL	C_ENERGY	;LOOK FOR ENERGY IN THAT BAND
	JBC	RI,CP090	;BRANCH IF USER ABORT
	JNB	TIM_1F,CP092	;147 BRANCH IF S7 TIMEOUT
	JNB	TIM_4F,CP030	;BRANCH IF 250MS TIMER FINISHED
	JC	CP020		;ENERGY SEEN
	SJMP	CP010
;
;Energy in call progress band detected - Is it busy tone?
;
CP020: 
	MOV	R1,#17		;340MS MINIMUM
	MOV	R2,#33		;650MS MAXIMUM
	LCALL	CPM_ON		;CHECK LENGTH OF ENERGY
	LCALL	SET_6
	JB	ABORT,CP090
	JNB	PASS,CP030	;NOT A VALID BUSY, CHECK ANSWER TONE
	LCALL	CPM_OFF		;CHECK FOR OFF DELAY
	JB	ABORT,CP090
	JNB	PASS,CP030	;CHECK FOR ANSWER TONE
	INC	BUSY_CYCLES
	MOV	A,#4		;BUSY DELAY = 4 CYCLES
	CJNE	A,BUSY_CYCLES,CP020
;
;====================	
;BUSY DETECTED
;====================	
;
	SETB	BUSYB		;SET BUSY STATUS FOR CALLER
	SJMP	CP085
;	
;====================	
;LOOK FOR ANSWER TONE
;====================	
;
CP030:	LCALL	SETORG		;LOOK FOR ANSWER TONE NOW
	MOV	A,#10		;WAIT 33MS
	LCALL	WAIT_3MS
	LCALL	C_ENERGY
	JNC	CP091		;GO BACK TO LOOK FOR BUSY
;====================
;VALIDATE ANSWER TONE
;====================
	MOV	A,S9		;CARRIER DETECT RESPONSE TIMER
	LCALL	SET_T2
CP040:	LCALL	C_ENERGY
	JBC	RI,CP090	;BRANCH IF USER ABORT
	JNC	CP091		;ENERGY DISAPPEARED, GO BACK TO CPM BAND
	JB	TIM_2F,CP040
;====================
;VALID ANSWER TONE DETECTED
;====================
CP083:	SETB	ANSWER_T
CP085:	CLR	ABORT
	CLR	PASS
	RET
;
CP090:	SETB	ABORT
CP091:	SETB	PASS
CP092:	RET			;147
;
SET_6:
	MOV	TIM_6,#5
	MOV	TIM_6P,#150
	SETB	TIM_6F
	RET

	END
