	list	on
	pl	104
	pw	128
;************************************************************************
;* FILE		: MOD8.ASM UNIVERSAL					*
;* PROGRAM	: MICROCOM COMMANDS					*
;************************************************************************

; 3/1/91	RELEASE 1.0

	LIST	OFF
	INCLUDE CONFIG.ASM
	INCLUDE RDEFINE.ASM
	LIST	ON
;========================================
;GLOBAL DEFINITIONS
;========================================
;
	IFTRUE	MICROCOM
	GLOBAL		ATN_A,ATN_B,ATN_C,ATN_I
	GLOBAL		ATN_K,ATN_L,ATN_M			;116
	GLOBAL		ATN_O,ATN_S,ATN_T			;116
	GLOBAL		ATN_U,ATN_V,ATN_X,ATN_Y,ATN_Z
	GLOBAL 		ATP_A,ATP_C,ATP_U,ATM_P
	GLOBAL		ATP_D,ATP_V,ATN_F
	GLOBAL		ATM_C,ATM_D
	GLOBAL		ADDS_REG,EX_SREG
	ENDIF
	
	IFFALSE	NSP		;118S
	GLOBAL		ATN_N,ATN_J,ATN_G			;148 ;116
	ENDIF			;118D
	
	GLOBAL		CHK_NV,NO_NV,DISPLAY
	GLOBAL		ATXK0,ATXK3,ATXK4			;110
	GLOBAL		ATN_Q			;116

;
; FROM MOD3.ASM
;
	EXTERNAL	DATS00,DATA_MOD,GO_MNP
;
; FROM MOD5.ASM
	EXTERNAL	GET_PARAM,AT_000
	EXTERNAL	PUT_CHAR,UPDATE_IO		;150
	EXTERNAL	SND_MSG,S_CRLF
	EXTERNAL	SND_DIGITS
	EXTERNAL	GO_ONLINE
	EXTERNAL	AT_EQ3,AT_ERR		;002
;
; FROM MOD6.ASM
;
	EXTERNAL	READ_NV,TEL_ADD_S,NV_R,SD_CRLF
	EXTERNAL	WRT_NV,MSG_NCAR,SND_RESULT
;
; FROM WMOD.ASM
	EXTERNAL	RXTX_MKU,TX_BKU
	
	EJECT
	TITLE THE EXTENDED "AT" COMMAND FOR MICROCOM INSTRUCTION SET
;
;############################################################
;#                                                          #
;#             THE EXTENDED "AT" COMMAND MODULE             #
;#                                                          #
;############################################################
	CODE
	
	IFTRUE	MICROCOM
	INCLUDE	ADDSREG.ASM
;
;==================================================
;ATN_A - BLOCK SIZE TRANSMIT
;
;   \A0 : BLOCK SIZE = 64 BYTES
;   \A1 : BLOCK SIZE = 128 BYTES
;   \A2 : BLOCK SIZE = 192 BYTES
;   \A3 : BLOCK SIZE = 256 BYTES
;==================================================
;
ATN_A:	MOV	DPTR,#OPT_3
MICRO_MOD:
	LCALL	GET_PARAM	;GET NEXT PARAMETER
ATN_A1:	MOVX	@DPTR,A
T10:	LJMP	AT_000
;
MICRO_MOD1:
	LCALL	GET_PARAM
	CLR	C
	ADD	A,#F6H
	JC	T10
	ADD	A,#AH
	SJMP	ATN_A1
;
;==================================================
;ATN_B - BREAK SIZE TRANSMIT
;   N= 1 TO 9,
;   IN RELIABLE LINK BREAK ALWAYS 300MS
;==================================================
;
ATN_B:	MOV	DPTR,#OPT_4
	LCALL	GET_PARAM		;021S GET NEXT PARAMETER
	JNB	PASS,ATN_B2
	MOV	A,#3
ATN_B2:	MOVX	@DPTR,A
	JNB	DATA_BIT,N_ERR
	MOV	DPTR,#MNP_S
	MOVX	A,@DPTR
	JB	ACC.5,ATN_B3
	LCALL	TX_BKU
	MOV	B,#33
BKKK:	MOV	DPTR,#OPT_4
	MOVX	A,@DPTR
	MOV	TIM_9,A
	SETB	TIM_9F
BKING:	JB	TIM_9F,BKING
	DJNZ	B,BKKK
	LCALL	RXTX_MKU
	SJMP	ATN_B1

N_ERR:	MOV	DPTR,#MSG_NCAR
	LCALL	SND_RESULT
ATN_B1:	LJMP	AT_000
ATN_B3:	MOV	DPTR,#OPT_BK
	MOV	A,#1
	MOVX	@DPTR,A
	MOV	DPTR,#DBK_NOW
	MOVX	A,@DPTR
	SETB	ACC.7
	MOVX	@DPTR,A
	LJMP	GO_ONLINE

;==================================================
;ATN_C - SET AUTO-RELIABLE BUFFER
;==================================================
;
ATN_C:	
	LCALL	GET_PARAM		;146S
	ANL	A,#3
	RL	A
	RL	A
	MOV	B,A
	MOV	DPTR,#OPT_8
	MOVX	A,@DPTR
	ANL	A,#F3H
	ORL	A,B
	MOVX	@DPTR,A
	LJMP	AT_000			;146T
;
;==================================================		;148S
;ATN_F - 
;==================================================
;
ATN_F:	
	LCALL	DIS_PHONE
	LJMP	AT_000			;148T
	ENDIF				;106

	IFFALSE	NSP
;==================================================
;ATN_G - SET MODEM PORT FLOW CONTROL
;
;   \G0 : DISABLE MODEM PORT FLOW CONTROL
;   \G1 : ENABLE MODEM PORT FLOW CONTROL TO XON/XOFF
;==================================================
;
ATN_G:	MOV	DPTR,#OPT_2
	LCALL	GET_PARAM
	JB	PASS,ATN_G0
	CJNE	A,#1,ATN_G20
	MOVX	A,@DPTR
	SETB	ACC.2
	SJMP	ATN_G10
ATN_G0:	MOVX	A,@DPTR
	CLR	ACC.2
ATN_G10:
	MOVX	@DPTR,A	
ATN_G20:
	LJMP	AT_000
;
;==================================================
;ATN_I - INTERFACE PROTOCOL
;   PERFORMS NO FUNCTION
;
;==================================================
;
ATN_I:	LJMP	AT_000
;
;==================================================
;ATN_J - DISABLE BPS RATE ADJUST
;
;   \JO = DISABLE SERIAL PORT ADJUSTMENT, CLR BIT1
;   \J1 = ENABLE SERIAL PORT RATE ADJUSTMENT, SET BIT1
;   
;==================================================
;
ATN_J:	MOV	DPTR,#OPT_2
	LCALL	GET_PARAM
	JB	PASS,ATN_J0
	CJNE	A,#1,ATN_J20
	MOVX	A,@DPTR
	SETB	ACC.1
	SJMP	ATN_J10
ATN_J0:	MOVX	A,@DPTR
	CLR	ACC.1
ATN_J10:
	MOVX	@DPTR,A	
ATN_J20:
	LJMP	AT_000
	ENDIF
	
	IFTRUE	MICROCOM			;106
;==================================================
;ATN_K - BREAK TYPE CONTROL
;
;   \K0,\K1 :
;   \K2,\K3 :
;   \K4,\K5 :
;==================================================
;
ATN_K:	
	MOV	DPTR,#OPT_5
	LCALL	GET_PARAM
	CJNE	A,#1,ATN_K3
	MOVX	@DPTR,A
	MOV	DPTR,#S82
	MOV	A,#7H
	MOVX	@DPTR,A
	SJMP	ATN_K00
ATN_K3:	CJNE	A,#3,ATN_K5
SETN_K3:
	MOV	A,#2H
	MOVX	@DPTR,A
	MOV	DPTR,#S82
	MOV	A,#1H
	MOVX	@DPTR,A
	SJMP	ATN_K00
ATN_K5:
SETN_K5:
DEF_1:	MOV	A,#3H
	MOVX	@DPTR,A
	MOV	DPTR,#S82
	MOV	A,#128
	MOVX	@DPTR,A
SETN_K1:
ATN_K00:
	LJMP	AT_000

;==================================================
; ATN_L - BLOCK MNP LINK
;  \L0 = \L1
;
;==================================================
;
ATN_L:	LCALL	GET_PARAM	;GET NEXT PARAMETER
	JB	PASS,ATN_L1	;BRANCH IF NONE OR ZERO
ATN_L1:	LJMP	AT_000
;
;==================================================
;ATN_M - DISABLE/ENABLE MICROCOM SLOW DOWN OPTION
;
;   \M0 : DISABLE SLOW DOWN OPTION
;   \M1 : ENABLE SLOW DOWN OPTION
;==================================================
;
ATN_M:	MOV	DPTR,#OPT_2
	LCALL	GET_PARAM	;GET NEXT PARAMETER
	JB	PASS,ATN_M1	;BRANCH IF NONE OR ZERO
	CJNE	A,#1,CHK2	
	MOVX	A,@DPTR
	SETB	ACC.6
	SJMP	ATN_M2
CHK2:	CJNE	A,#2,CHK3
	MOVX	A,@DPTR
	CLR	ACC.5
	SJMP	ATN_M2
CHK3:	CJNE	A,#3,CHK4
	MOVX	A,@DPTR
	SETB	ACC.5
	SJMP	ATN_M2
CHK4:	CJNE	A,#4,CHK5
	MOVX	A,@DPTR
	CLR	ACC.4
	SJMP	ATN_M2
CHK5:	CJNE	A,#5,ATN_M1
	MOVX	A,@DPTR
	SETB	ACC.4
	SJMP	ATN_M2
ATN_M1:	MOVX	A,@DPTR
	CLR	ACC.6
ATN_M2:	MOVX	@DPTR,A
ATN_M4:	LJMP	AT_000	
;
	ENDIF			;106
	IFFALSE	NSP
;==================================================
;ATN_N - MNP MODE SELECTION
;
;   \N0 : NORMAL MODE
;   \N1 : DIRECT MODE
;   \N2 : MNP ONLY RELIABLE MODE
;   \N3 : MNP ONLY AUTO-RELIABLE
;   \N4 : V.42 ONLY RELIABLE MODE
;   \N5 : V.42 ONLY AUTORELIABLE
;   \N6 : V.42/MNP RELIABLE MODE
;   \N7 : V.42/MNP AUTORELIABLE MODE
;==================================================
;
ATN_N:	MOV	DPTR,#OPT_2	;SET V42/MNP
	MOVX	A,@DPTR		
	CLR	ACC.6
	MOVX	@DPTR,A
;
	MOV	DPTR,#OPT_8	;RESET V.42 ONLY
	MOVX	A,@DPTR
	CLR	ACC.6
	MOVX	@DPTR,A
;	
	MOV	DPTR,#OPT_0	;SET DPTR= OPT_0
	LCALL	GET_PARAM	;GET NEXT PARAMETER
	JB	PASS,ATN_N5	;BRANCH IF NONE OR ZERO
	CJNE	A,#01,ATN_N2
	DEC	A
SETN_N1:
	MOVX	@DPTR,A
	SJMP	ATN_N4
ATN_N2:	CJNE	A,#02,ATN_N6
	DEC	A		;\N2
SETN_N2:
	MOVX	@DPTR,A		;SET RELIABLE MODE
	MOV	DPTR,#OPT_2
	MOVX	A,@DPTR		;SET OPT_2.6
	SETB	ACC.6		;SET MNP MODE
	SJMP	ATN_N5
	
ATN_N0:	MOVX	@DPTR,A
ATN_N1:	LJMP	AT_000

ATN_N4:	MOV	DPTR,#OPT_2	;DISABLE SPEED CONVERSION
	MOVX	A,@DPTR
	CLR	ACC.0
	SJMP	ATN_N0
SETN_N0:
ATN_N5:	MOVX	@DPTR,A		
	MOV	DPTR,#OPT_2	;ENABLE SPEED CONVERSION
	MOVX	A,@DPTR
	SETB	ACC.0
	SJMP	ATN_N0
	
ATN_N6:	CJNE	A,#03,ATN_N7
	DEC	A		;\N3
SETN_N3:
	MOVX	@DPTR,A		;SET OPT_0
	MOV	DPTR,#OPT_2
	MOVX	A,@DPTR		;
	SETB	ACC.6		;SET OPT_2.6
	SJMP	ATN_N5
ATN_N7:	CJNE	A,#04,ATN_N8	;
SETN_N4:
	MOV	A,#1		;\N4, 
ATN_N7A:
	MOVX	@DPTR,A		;SET RELIABLE MODE	
	MOV	DPTR,#OPT_8
	MOVX	A,@DPTR		;001
	SETB	ACC.6		;SET V.42 ONLY
	SJMP	ATN_N5
ATN_N8:	CJNE	A,#05,ATN_N9
SETN_N5:
	MOV	A,#2		;\N5, AUTORELIABLE MODE
	SJMP	ATN_N7A
ATN_N9:	CJNE	A,#06,ATN_N10
SETN_N6:
	MOV	A,#1
	SJMP	ATN_N5
ATN_N10:
	CJNE	A,#07,ATN_N11
SETN_N7:
ATN_N11:
	MOV	A,#2		;\N7, AUTORELIABLE MODE
	SJMP	ATN_N5			
	ENDIF
	IFTRUE	MICROCOM			;106
;
;==================================================
;ATN_O - ORIGINATE RELIABLE LINK
;        INITIATE A RELIABLE LINK REGARDLESS OF WHETHER
;	 MODEM IN ORIGINATED OR ANSWER MODE.
;   \O :
;==================================================
;
ATN_O:
	JNB	DATA_BIT,ATN_O1
	MOV	DPTR,#MNP_S
	MOVX	A,@DPTR
	JB	ACC.5,ATN_O2
	MOV	DPTR,#OPT_6
	MOV	A,#10000001B
	MOVX	@DPTR,A
ATN_O3:	LJMP	GO_MNP		;GO TO MNP MODE
ATN_O1:	LJMP	AT_000		;NO ACTION
ATN_O2:	LJMP	GO_ONLINE	;GO BACK TO ON LINE MODE
;
	ENDIF

;==================================================
;ATN_Q - SERIAL PORT FLOW CONTROL
;
;   \QO : DISABLE FLOW CONTROL(WHEN MNP DISABLE)
;   \Q1 : BIDIRECTIONAL XON/XOFF FLOW CONTROL
;   \Q2 : UNIDIRECTIONAL HARDWARE BY CTS
;   \Q3 : BIDIRECTIONAL HARDWARE BY RTS/CTS
;   \Q4 : UNIDIRECTIONAL XON/XOFF FLOW CONTROL
;   \Q5 : \Q2, CTS OFF UNTIL CONNECTION
;   \Q6 : \Q3, CTS OFF UNTIL CONNECTION
;==================================================
;
ATN_Q:	MOV	DPTR,#OPT_8
	MOVX	A,@DPTR
	CLR	ACC.5
	MOVX	@DPTR,A
;	
	MOV	DPTR,#OPT_1
	LCALL	GET_PARAM	;GET NEXT PARAMETER
	JNB	PASS,ATN_Q6
ATXK0:	MOV	A,#6		;110 \Q0
	SJMP	ATN_Q9
ATN_Q6:	CJNE	A,#01,ATN_Q2	;\Q1
ATXK4:	MOV	A,#0		;110
ATN_Q0:	MOVX	@DPTR,A
	SJMP	ATN_Q1
ATN_Q2: CJNE	A,#02,ATN_Q3	;\Q2
ATN_Q8:	MOV	A,#5
	SJMP	ATN_Q9
ATN_Q3:	CJNE	A,#03,ATN_Q4	;\Q3
ATXK3:	MOV	A,#2		;110
	SJMP	ATN_Q9
ATN_Q4:	CJNE	A,#04,ATN_Q20	;\Q4
	MOV	A,#4
ATN_Q9:	MOVX	@DPTR,A		;150S
ATN_Q1:	LJMP	AT_000

ATN_Q20:
	CJNE	A,#05,ATN_Q22	;\Q5
	MOV	DPTR,#OPT_1
	MOV	A,#5
ATN_Q23:
	MOVX	@DPTR,A
	MOV	DPTR,#OPT_8
	MOVX	A,@DPTR
	SETB	ACC.5
	SJMP	ATN_Q9A
ATN_Q22:
	MOV	DPTR,#OPT_1	;\Q6
	MOV	A,#2
	SJMP	ATN_Q23	
ATN_Q9A:
	MOVX	@DPTR,A
	SETB	CTS_L
	LCALL	UPDATE_IO
	LJMP	AT_000		;150T	

	IFTRUE	MICROCOM
;==================================================
;ATN_S - AT&V COMMAND
;
;   \S :
;==================================================
;
ATN_S:
ATN_S1:	
	LCALL	DISPLAY
	LJMP	AT_000

;==================================================
;ATN_T - SET INACITIVITY TIMER
;   PERFORMS NO FUNCTION
;==================================================
;
ATN_T:	MOV	DPTR,#OPT_A
	LJMP	MICRO_MOD1
;
;==================================================
;ATN_U - ACCEPT RELIABLE LINK
;
;   \U  :
;   \U1 :
;==================================================
;
ATN_U:
	JNB	DATA_BIT,ATN_U1
	MOV	DPTR,#MNP_S
	MOVX	A,@DPTR
	JNZ	ATN_U2
	MOV	DPTR,#OPT_6
	MOV	A,#10000010B
	MOVX	@DPTR,A
ATN_U3:	LJMP	GO_MNP		;GO TO MNP MODE
ATN_U1:	LJMP	AT_000		;NO ACTION
ATN_U2:	LJMP	GO_ONLINE	;GO BACK TO ON LINE MODE
;
;==================================================
;ATN_V - MODIFIED RESULT CODE FORM
;
;   \V0 : STANDARD RESULT CODE - OPT_8.0 = 0
;   \V1 : RESULT CODE FOR MNP  - OPT_8.0 = 1
;==================================================
;
ATN_V:	MOV	DPTR,#OPT_8
	LCALL	GET_PARAM	;GET NEXT PARAMETER
	JB	PASS,ATN_V1	;BRANCH IF NONE OR ZERO
	CJNE	A,#1,ATN_V20
	MOVX	A,@DPTR
	SETB	ACC.0
	CLR	ACC.1
	SJMP	ATN_V2
ATN_V1:	MOVX	A,@DPTR
	CLR	ACC.0
	CLR	ACC.1
ATN_V2:	MOVX	@DPTR,A
ATN_V4:	LJMP	AT_000
ATN_V20:
	CJNE	A,#2,ATN_V30
	MOVX	A,@DPTR
	CLR	ACC.0
	SETB	ACC.1
	SJMP	ATN_V2
ATN_V30:
	MOVX	A,@DPTR
	SETB	ACC.0
	SETB	ACC.1
	SJMP	ATN_V2
;
;==================================================
;ATN_X - XON/XOFF USING PASS THROUGH
;
;   \X0 : NOT PASS THROUGH
;   \X1 : PASSTHROUGH
;==================================================
;
ATN_X:	MOV	DPTR,#OPT_1
	MOV	A,#3
	MOVX	@DPTR,A
	LCALL	GET_PARAM	;GET NEXT PARAMETER
	JNB	PASS,ATN_X1	;BRANCH IF NONE OR ZERO
	MOV	A,#0
	MOVX	@DPTR,A
ATN_X1:	LJMP	AT_000
;
;==================================================
;ATN_Y - SWITCH TO RELIABLE MODE
;
;   \Y  :
;==================================================
;
ATN_Y:
	JNB	DATA_BIT,ATN_Y1
	MOV	DPTR,#MNP_S
	MOVX	A,@DPTR
	JNZ	ATN_Y2
	MOV	DPTR,#OPT_6
	MOV	A,#10000000B
	MOVX	@DPTR,A
ATN_Y3:	LJMP	GO_MNP		;GO TO MNP MODE
ATN_Y1:	LJMP	AT_000		;NO ACTION
ATN_Y2:	LJMP	GO_ONLINE	;GO BACK TO ON LINE MODE

;==================================================
;ATN_Z - SWITCH TO NORMAL MODE
;
;   \Z  :
;==================================================
;
ATN_Z:
	JNB	DATA_BIT,ATN_X1
	MOV	DPTR,#Z_BUF
	MOV	A,#1
	MOVX	@DPTR,A
	LJMP	GO_ONLINE
;
;==================================================
; ATP_A - SET AUTO-RELIABLE FALLBACK CHARACTER
;  PERFORMS NO FUNCTION
;
;==================================================
;
ATP_A:	MOV	DPTR,#OPT_9
	LCALL	GET_PARAM	;GET NEXT PARAMETER
	CJNE	A,#22D,ST_IN
	LJMP	AT_ERR
ST_IN:	MOVX	@DPTR,A
	LJMP	AT_000

ATP_A1:	LJMP	MICRO_MOD
;
;==================================================
;ATP_C - DISABLE/ENABLE DATA COMPRESSION
;
;   %C0 : DISABLE DATA COMPRESSION
;   %C1 : ENABLE DATA COMPRESSION
;==================================================
;
ATP_C:	MOV	DPTR,#OPT_2
	LCALL	GET_PARAM	;GET NEXT PARAMETER
	JB	PASS,ATP_C1	;BRANCH IF NONE OR ZERO
SETP_C1:
	MOVX	A,@DPTR
	SETB	ACC.7
	SJMP	ATP_C2
SETP_C0:
ATP_C1:	MOVX	A,@DPTR
	CLR	ACC.7
ATP_C2:	MOVX	@DPTR,A
ATP_C4:	LJMP	AT_000	
;
;==================================================
;ATP_D - CLEAR RX_BUFFER THEN DISCONNECT
;  PARAMETER 0,1
;==================================================
;
ATP_D:	MOV	DPTR,#OPT_B
	LCALL	GET_PARAM	;GET NEXT PARAMETER
	JB	PASS,ATP_D1	;BRANCH IF NONE OR ZERO
SETP_D1:
	MOVX	A,@DPTR
	SETB	ACC.0
	SJMP	ATP_D2
SETP_D0:
ATP_D1:	MOVX	A,@DPTR
	CLR	ACC.0
ATP_D2:	MOVX	@DPTR,A
ATP_D4:	LJMP	AT_000	
;
;==================================================
; ATP_U - CLEAR SERIAL PORT SPEED
;  PERFORMS NO FUNCTION
;
;==================================================
;
ATP_U:	LJMP	AT_000
;
;==================================================
;ATP_V - ELIMINATE ODP IN V.42 MODE
;   OPT_8.6,7
;  PARAMETER 0,1,2,3
;	0 - 
;	1 - V.42 ONLY NEGOTIATION
;	2 - ELIMINATE ODP FOR V.42
;	3 - V.42 ONLY AND ELIMINATE ODP
;==================================================
;
ATP_V:	MOV	DPTR,#OPT_8
	LCALL	GET_PARAM	;GET NEXT PARAMETER
	JB	PASS,ATP_V1	;BRANCH IF NONE OR ZERO
	CJNE	A,#1,ATP_V7
	MOVX	A,@DPTR
	SETB	ACC.6
	CLR	ACC.7
	LJMP	ATN_V
ATP_V1:	MOVX	A,@DPTR
	CLR	ACC.6
	CLR	ACC.7
ATP_V2:	MOVX	@DPTR,A
ATP_V4:	LJMP	AT_000	
ATP_V7:	CJNE	A,#2,ATP_V8
	CLR	ACC.6
	SETB	ACC.7
	SJMP	ATP_V2
ATP_V8:	MOVX	A,@DPTR
	SETB	ACC.6
	SETB	ACC.7
	SJMP	ATP_V2	
;
;==================================================
;ATM_C - SET BTLZ MAXIMUM STRING CHAR.
;   
;==================================================
;
ATM_C:	MOV	DPTR,#OPT_C
	LJMP	MICRO_MOD
;
;==================================================
;ATM_D - SET BTLZ DICTIOANRY SIZE
; OPT_D - BIT5,4
;   -D0 = 0 , SET ENTRY = 512
;   -D1 = 1 , SET ENTRY = 1K
;   -D2 = 2 , SET ENTRY = 2K
;   -D3 = 3 , SET ENTRY = 4K
;==================================================
;
ATM_D:	MOV	DPTR,#OPT_D
	LCALL	GET_PARAM	;GET NEXT PARAMETER
	JB	PASS,ATM_D1	;BRANCH IF NONE OR ZERO
	CJNE	A,#1,ATM_D20
	MOVX	A,@DPTR
	SETB	ACC.4
	CLR	ACC.5
	SJMP	ATM_D2
ATM_D1:	MOVX	A,@DPTR
	CLR	ACC.4
	CLR	ACC.5
ATM_D2:	MOVX	@DPTR,A
ATM_D4:	LJMP	AT_000
ATM_D20:
	CJNE	A,#2,ATM_D30
	MOVX	A,@DPTR
	CLR	ACC.4
	SETB	ACC.5
	SJMP	ATM_D2
ATM_D30:
	MOVX	A,@DPTR
	SETB	ACC.4
	SETB	ACC.5
	SJMP	ATM_D2
;
;==================================================
;ATM_P - ENABLE/DISABLE PARITY CHECKING FOR FLOW CONTROL
;
;   -P0 : ENABLE PARITY CHECKING FOR FLOW CONTROL
;   -P1 : DISABLE PARITY CHECKING FOR FLOW CONTROL
;==================================================
;
ATM_P:	MOV	DPTR,#OPT_2
	LCALL	GET_PARAM	;GET NEXT PARAMETER
	JNB	PASS,ATM_P1	;BRANCH IF NONE OR ZERO
	MOVX	A,@DPTR
	SETB	ACC.3
;8-14-89	CLR	ACC.3
	SJMP	ATM_P2
ATM_P1:	MOVX	A,@DPTR
	CLR	ACC.3
;8-14-89	SETB	ACC.3
ATM_P2:	MOVX	@DPTR,A
ATM_P4:	LJMP	AT_000	
	ENDIF
;=====================================================
; CHECK NV RAM
; DESTROY	ACC,JP_004
; EXPECT	PASS = 0; NO NV RAM
;		       1; NV RAM OK
;=====================================================
;
CHK_NV:	PUSH	REG_5
	PUSH	REG_0
	MOV	R0,#HRST_P
	CLR	JP_004
	LCALL	READ_NV
	MOV	R5,A
	INC	A
	SETB	JP_004
	LCALL	WRT_NV
	CLR	JP_004
	LCALL	READ_NV
	DEC	A
	CJNE	A,REG_5,NONV
	SETB	JP_004
	LCALL	WRT_NV
	SETB	PASS
	SJMP	BKNV
NONV:	CLR	PASS
BKNV:	POP	REG_0
	POP	REG_5
	RET
;
; -------------------------------------- DISPLAY PROFILE AND TEL #
DISPLAY:
; -------------------------------------- DISPLAY ACTIVE PROFILE
	LCALL	S_CRLF
	MOV	DPTR,#ACTIVE
	LCALL	SND_MSG
	SETB	PSW.5
	CLR	JP_004	
	LCALL	DIS_1	
; -------------------------------------- CHECK IF NV RAM THERE
	LCALL	CHK_NV
	JB	PASS,PF0
	MOV	DPTR,#NO_NV
	LCALL	SND_MSG
	RET
; ---------------------------------------- DISPLAY STORED PROFILE 0
PF0:	
	LCALL	SD_CRLF
	LCALL	SD_CRLF
	MOV	DPTR,#STORED0
	LCALL	SND_MSG
	CLR	PSW.5	
	CLR	JP_004	
	LCALL	DIS_1
; ---------------------------------------- DISPLAY STORED PROFILE 1
	IFFALSE	ONEPF
	LCALL	SD_CRLF
	LCALL	SD_CRLF
	MOV	DPTR,#STORED1
	LCALL	SND_MSG
	CLR	PSW.5	
	SETB	JP_004
	LCALL	DIS_1
	CLR	JP_004
	ENDIF
; ------------------------- DISPLAY TELEPHONE NUMBER STORED IN NV RAM
DIS_PHONE:
	LCALL	SD_CRLF
	LCALL	SD_CRLF
	MOV	DPTR,#NUMBERS
	LCALL	SND_MSG
	LCALL	S_CRLF	
	MOV	DPTR,#PREFIX0
	LCALL	SND_MSG
	MOV	A,#'0'
	LCALL TEL_ADD_S
	MOV	B,#TEL_TAB
	SETB	JP_004	
	LCALL	NV_R

	MOV	A,#' '
TAB1:	LCALL	PUT_CHAR
	DJNZ	B,TAB1

	IFTRUE ONEPH
	LJMP	TAB3
	ENDIF

	MOV	DPTR,#PREFIX1
	LCALL	SND_MSG
	MOV	A,#'1'
	LCALL TEL_ADD_S
	MOV	B,#TEL_TAB	
	SETB	JP_004	
	LCALL	NV_R
	LCALL	SD_CRLF	
	
	MOV	DPTR,#PREFIX2
	LCALL	SND_MSG
	MOV	A,#'2'
	LCALL TEL_ADD_S
	MOV	B,#TEL_TAB
	SETB	JP_004	
	LCALL	NV_R
	
	MOV	A,#' '
TAB2:	LCALL	PUT_CHAR
	DJNZ	B,TAB2

	MOV	DPTR,#PREFIX3
	LCALL	SND_MSG
	MOV	A,#'3'
	LCALL TEL_ADD_S
	MOV	B,#TEL_TAB
	SETB	JP_004	
	LCALL	NV_R

	IFTRUE	FIVEPH
	MOV	DPTR,#PREFIX4
	LCALL	SND_MSG
	MOV	A,#'4'
	LCALL TEL_ADD_S
	MOV	B,#TEL_TAB
	SETB	JP_004		
	LCALL	NV_R
	ENDIF	
	
	CLR	JP_004
TAB3:	LCALL	SD_CRLF	
	RET	
;
;================================================
; DISPLAY S REG IN DECIMAL FORMAT:
; PUT NUMBER IN R2,
; PUT CONTEND OF REGISTER IN R3
;================================================
;
DISPLAY_SREG:
	MOV	A,R2
	LCALL	SND_2DIG
	LCALL	SND_COLON
	MOV	A,R3
	LCALL	SND_DIGITS
	RET
;
;================================================
; DISPLAY S REG IN HEX FORMAT:
; PUT NUMBER IN R2,
; PUT CONTEND OF REGISTER IN R3
;================================================
;
DISPLAY_SREGH:
	MOV	A,R2
	LCALL	SND_2DIG
	LCALL	SND_COLON
	MOV	A,R3
	LCALL	SND_HEX
	MOV	A,#'H'
	LCALL	PUT_CHAR
	RET	
	
SND_SP:
	MOV	A,#' '
	LCALL	PUT_CHAR
	RET

SND_SPAND:
	MOV	A,#' '
	LCALL	PUT_CHAR
	MOV	A,#'&'
	LCALL	PUT_CHAR
	RET

SND_SPPN:
	MOV	A,#' '
	LCALL	PUT_CHAR
	MOV	A,#'%'
	LCALL	PUT_CHAR
	RET	

SND_SPMN:
	MOV	A,#' '
	LCALL	PUT_CHAR
	MOV	A,#'-'
	LCALL	PUT_CHAR
	RET		
SND_SPBK:
	MOV	A,#' '
	LCALL	PUT_CHAR
	MOV	A,#'\'
	LCALL	PUT_CHAR
	RET	
	
SND_SPS:
	MOV	A,#' '
	LCALL	PUT_CHAR
SND_SPS1:
	MOV	A,#'S'
	LCALL	PUT_CHAR
	RET

SND_COLON:
	MOV	A,#':'
	LCALL	PUT_CHAR
	RET

DISPLAY_BIT:
	JNZ	DIS01
	SJMP	DIS00
DIS01:	MOV	A,#'1'
	SJMP	DIS03
DIS00:	MOV	A,#'0'
DIS03:	LCALL	PUT_CHAR
	RET

SND_2DIG:
	MOV	B,#10
	DIV	AB
	ADD	A,#'0'
	LCALL	PUT_CHAR
	MOV	A,B
	ADD	A,#'0'
	LJMP	PUT_CHAR	;TO RETURN
	
SND_HEX:
	PUSH	A
	SWAP	A
	LCALL	HEXASC
	LCALL	PUT_CHAR
	POP	A
	LCALL	HEXASC
	LCALL	PUT_CHAR
	RET
	
HEXASC:
	ANL	A,#0FH
	INC	A
	MOVC	A,@A+PC
	RET
ASCTBL:	DB	'0'
	DB	'1'
	DB	'2'
	DB	'3'
	DB	'4'
	DB	'5'
	DB	'6'
	DB	'7'
	DB	'8'
	DB	'9'
	DB	'A'
	DB	'B'
	DB	'C'
	DB	'D'
	DB	'E'
	DB	'F'
				
ACTIVE:	DB 	'ACTIVE PROFILE:',0FFH
STORED0:	DB	'STORED PROFILE 0:',0FFH
STORED1:	DB	'STORED PROFILE 1:',0FFH
NO_NV:		DB	0DH,0AH,'NO NV MEMORY',0FFH
PREFIX0:	DB	'0=',0FFH
PREFIX1:	DB	'1=',0FFH
PREFIX2:	DB	'2=',0FFH
PREFIX3:	DB	'3=',0FFH
PREFIX4:	DB	'4=',0FFH
NUMBERS:	DB	'TELEPHONE NUMBERS:',0FFH
FLOW_C:	DB	'ERROR CONTROL COMMANDS:',0FFH
HIT:	DB	'------------   HIT ANY KEY TO CONTINUE	----------',0FFH
;-------------------------------
DIS_1:
	LCALL	S_CRLF
	MOV	A,#'B'			;DISPLAY "B" COMMAND
	LCALL	PUT_CHAR
	MOV	A,S27
	JB	PSW.5,DIS_30
	MOV	R0,#8
	LCALL	READ_NV
DIS_30:	
	ANL	A,#01000000B
	LCALL	DISPLAY_BIT

	LCALL	SND_SP			;DISPLAY "E" COMMAND
	MOV	A,#'E'
	LCALL	PUT_CHAR
	MOV	A,S14
	JB	PSW.5,DIS_31
	MOV	R0,#1
	LCALL	READ_NV
DIS_31:	
	ANL	A,#00000010B
	LCALL	DISPLAY_BIT

	LCALL	SND_SP			;DISPLAY "L" COMMAND
	MOV	A,#'L'
	LCALL	PUT_CHAR
	MOV	A,S22
	JB	PSW.5,DIS_32
	MOV	R0,#4
	LCALL	READ_NV
DIS_32:	
	ANL	A,#00000011B
	ADD	A,#30H
	LCALL	PUT_CHAR

	LCALL	SND_SP			;DISPLAY "M" COMMAND
	MOV	A,#'M'
	LCALL	PUT_CHAR
	MOV	A,S22
	JB	PSW.5,DIS_33
	MOV	R0,#4
	LCALL	READ_NV
DIS_33:	
	ANL	A,#00001100B
	RR	A
	RR	A
	ADD	A,#30H
	LCALL	PUT_CHAR

	LCALL	SND_SP			;DISPLAY "Q" COMMAND
	MOV	A,#'Q'
	LCALL	PUT_CHAR
	MOV	A,S14
	JB	PSW.5,DIS_34
	MOV	R0,#1
	LCALL	READ_NV
DIS_34:	
	ANL	A,#00000100B
	LCALL	DISPLAY_BIT

	LCALL	SND_SP			;DISPLAY "V" COMMAND
	MOV	A,#'V'
	LCALL	PUT_CHAR
	MOV	A,S14
	JB	PSW.5,DIS_35
	MOV	R0,#1
	LCALL	READ_NV
DIS_35:	
	ANL	A,#00001000B
	LCALL	DISPLAY_BIT

	LCALL	SND_SP			;DISPLAY "X" COMMAND
	MOV	A,#'X'
	LCALL	PUT_CHAR
	MOV	A,S22
	JB	PSW.5,DIS_36
	MOV	R0,#4
	LCALL	READ_NV
DIS_36:	
	ANL	A,#01110000B
	RR	A
	RR	A
	RR	A
	RR	A
	JZ	DX_00
	SUBB	A,#3
DX_00:	ADD	A,#30H
	LCALL	PUT_CHAR

	LCALL	SND_SP			;DISPLAY "Y" COMMAND
	MOV	A,#'Y'
	LCALL	PUT_CHAR
	MOV	A,S21
	JB	PSW.5,DIS_37
	MOV	R0,#3
	LCALL	READ_NV
DIS_37:	
	ANL	A,#10000000B
	LCALL	DISPLAY_BIT

	LCALL	SND_SPAND		;DISPLAY "&C" COMMAND
	MOV	A,#'C'
	LCALL	PUT_CHAR
	MOV	A,S21
	JB	PSW.5,DIS_38
	MOV	R0,#3
	LCALL	READ_NV
DIS_38:	
	ANL	A,#00100000B
	LCALL	DISPLAY_BIT

	LCALL	SND_SPAND		;DISPLAY "&D" COMMAND
	MOV	A,#'D'
	LCALL	PUT_CHAR
	MOV	A,S21
	JB	PSW.5,DIS_39
	MOV	R0,#3
	LCALL	READ_NV
DIS_39:	
	ANL	A,#00011000B
	RR	A
	RR	A
	RR	A
	ADD	A,#30H
	LCALL	PUT_CHAR

	LCALL	SND_SPAND		;DISPLAY "&G" COMMAND
	MOV	A,#'G'
	LCALL	PUT_CHAR
	MOV	A,S23
	JB	PSW.5,DIS_40
	MOV	R0,#5
	LCALL	READ_NV
DIS_40:	
	ANL	A,#11000000B
	RR	A
	RR	A
	RR	A
	RR	A
	RR	A
	RR	A
	ADD	A,#30H
	LCALL	PUT_CHAR

	LCALL	SND_SPAND		;DISPLAY "&J" COMMAND
	MOV	A,#'J'
	LCALL	PUT_CHAR
	MOV	A,S21
	JB	PSW.5,DIS_41
	MOV	R0,#3
	LCALL	READ_NV
DIS_41:	
	ANL	A,#000000001B
	LCALL	DISPLAY_BIT

	LCALL	SND_SPAND		;DISPLAY "&L" COMMAND
	MOV	A,#'L'
	LCALL	PUT_CHAR
	MOV	A,S27
	JB	PSW.5,DIS_42
	MOV	R0,#8
	LCALL	READ_NV
DIS_42:	
	ANL	A,#00000100B
	LCALL	DISPLAY_BIT

	LCALL	SND_SPAND		;DISPLAY "&P" COMMAND
	MOV	A,#'P'
	LCALL	PUT_CHAR
	MOV	A,S22
	JB	PSW.5,DIS_43
	MOV	R0,#4
	LCALL	READ_NV
DIS_43:	
	ANL	A,#10000000B
	LCALL	DISPLAY_BIT

;	LCALL	SND_SPAND		;DISPLAY "&Q" COMMAND
;	MOV	A,#'Q'
;	LCALL	PUT_CHAR
;	MOV	A,S27
;	ANL	A,#00000011B
;	LCALL	DISPLAY_BIT

	LCALL	SND_SPAND		;DISPLAY "&R" COMMAND
	MOV	A,#'R'
	LCALL	PUT_CHAR
	MOV	A,S21
	JB	PSW.5,DIS_44
	MOV	R0,#3
	LCALL	READ_NV
DIS_44:	
	ANL	A,#00000100B
	LCALL	DISPLAY_BIT

	LCALL	SND_SPAND		;DISPLAY "&S" COMMAND
	MOV	A,#'S'
	LCALL	PUT_CHAR
	MOV	A,S21
	JB	PSW.5,DIS_45
	MOV	R0,#3
	LCALL	READ_NV
DIS_45:	
	ANL	A,#01000000B
	LCALL	DISPLAY_BIT

	LCALL	SND_SPAND		;DISPLAY "&X" COMMAND
	MOV	A,#'X'
	LCALL	PUT_CHAR
	MOV	A,S27
	JB	PSW.5,DIS_46
	MOV	R0,#8
	LCALL	READ_NV
DIS_46:	
	ANL	A,#00110000B
	RR 	A
	RR	A
	RR	A
	RR	A
	ADD	A,#30H
	LCALL	PUT_CHAR

	LCALL	SND_SPAND		;DISPLAY "&Y" COMMAND
	MOV	A,#'Y'
	LCALL	PUT_CHAR
	PUSH	REG_0
	MOV	R0,#HRST_P
	
	JB	JP_004,STILL
	LCALL	READ_NV
	SJMP	CONTU

STILL:
	CLR	JP_004
	LCALL	READ_NV
	SETB	JP_004
	
CONTU:
	ANL	A,#1
	ADD	A,#30H
	LCALL	PUT_CHAR
	POP	REG_0
;	LCALL	S_CRLF

;
;===================================================
; START TO DISPLAY S REGISTER
;==================================================
;	LCALL	S_CRLF
;	LCALL	SND_SPAND		
;	MOV	A,#'S'		;DISPLAY S0
;	LCALL	PUT_CHAR
	LCALL	SND_SPS
	MOV	R2,#0
	MOV	R3,S0
	JB	PSW.5,DIS_2
	MOV	R0,#0
	LCALL	READ_NV
	MOV	R3,A
DIS_2:	LCALL	DISPLAY_SREG	
	
	LCALL	SND_SPS		;DISPLAY S1
	MOV	R2,#1
	MOV	R3,S1
	LCALL	DISPLAY_SREG	
	LCALL	S_CRLF
	
	LCALL	SND_SPS1	;DISPLAY S2
	MOV	R2,#2
	MOV	R3,S2	
	LCALL	DISPLAY_SREG	
	
	LCALL	SND_SPS		;DISPLAY S3
	MOV	R2,#3
	MOV	R3,S3	
	LCALL	DISPLAY_SREG	
	
	LCALL	SND_SPS		;DISPLAY S4
	MOV	R2,#4
	MOV	R3,S4	
	LCALL	DISPLAY_SREG	
	
	LCALL	SND_SPS		;DISPLAY S5
	MOV	R2,#5
	MOV	R3,S5
	LCALL	DISPLAY_SREG	
			
	LCALL	SND_SPS		;DISPLAY S6
	MOV	R2,#6
	MOV	R3,S6
	LCALL	DISPLAY_SREG	
	
	LCALL	SND_SPS		;DISPLAY S7
	MOV	R2,#7
	MOV	R3,S7	
	LCALL	DISPLAY_SREG	
;	LCALL	S_CRLF
			
	LCALL	SND_SPS		;DISPLAY S8	
	MOV	R2,#8
	MOV	R3,S8	
	LCALL	DISPLAY_SREG	

	LCALL	SND_SPS		;DISPLAY S9
	MOV	R2,#9
	MOV	R3,S9
	LCALL	DISPLAY_SREG	

	LCALL	SND_SPS		;DISPLAY S10
	MOV	R2,#10
	MOV	R3,S10
	LCALL	DISPLAY_SREG		

	LCALL	SND_SPS		;DISPLAY S11
	MOV	R2,#11
	MOV	R3,S11
	LCALL	DISPLAY_SREG		
	LCALL	S_CRLF

	LCALL	SND_SPS1	;DISPLAY S12
	MOV	R2,#12
	MOV	R3,S12
	LCALL	DISPLAY_SREG		

	LCALL	SND_SPS		;DISPLAY S14
	MOV	R2,#14
	MOV	R3,S14
	JB	PSW.5,DIS_3
	INC	R0
	LCALL	READ_NV
	MOV	R3,A
DIS_3:	LCALL	DISPLAY_SREGH		

	LCALL	SND_SPS		;DISPLAY S16
	MOV	R2,#16
	MOV	R3,S16
	LCALL	DISPLAY_SREGH	

	LCALL	SND_SPS		;DISPLAY S18
	MOV	R2,#18
	MOV	R3,S18
	JB	PSW.5,DIS_4
	INC	R0
	LCALL	READ_NV
	MOV	R3,A
DIS_4:
	LCALL	DISPLAY_SREG			

;	LCALL	S_CRLF
;	MOV	A,#'S'
;	LCALL	PUT_CHAR	;DISPLAY S21

	LCALL	SND_SPS		
	MOV	R2,#21
	MOV	R3,S21
	JB	PSW.5,DIS_5
	INC	R0
	LCALL	READ_NV
	MOV	R3,A
DIS_5:
	LCALL	DISPLAY_SREGH	


	LCALL	SND_SPS		;DISPLAY S22
	MOV	R2,#22
	MOV	R3,S22
	JB	PSW.5,DIS_6
	INC	R0
	LCALL	READ_NV
	MOV	R3,A
DIS_6:
	LCALL	DISPLAY_SREGH	

	LCALL	SND_SPS		;DISPLAY S23
	MOV	R2,#23
	MOV	R3,S23
	JB	PSW.5,DIS_7
	INC	R0
	LCALL	READ_NV
	MOV	R3,A
DIS_7:
	LCALL	DISPLAY_SREGH			

	LCALL	SND_SPS		;DISPLAY S25
	MOV	R2,#25
	MOV	R3,S25
	JB	PSW.5,DIS_8
	INC	R0
	LCALL	READ_NV
	MOV	R3,A
DIS_8:
	LCALL	DISPLAY_SREG	

	LCALL	SND_SPS		;DISPLAY S26
	MOV	R2,#26
	MOV	R3,S26
	JB	PSW.5,DIS_9
	INC	R0
	LCALL	READ_NV
	MOV	R3,A
DIS_9:
	LCALL	DISPLAY_SREG			

	LCALL	SND_SPS		;DISPLAY S27
	MOV	R2,#27
	MOV	R3,S27
	JB	PSW.5,DIS_10
	INC	R0
	LCALL	READ_NV
	MOV	R3,A
DIS_10:
	LCALL	DISPLAY_SREGH		
	
	IFTRUE MICROCOM
;====================================================
; START TO DISPLAY MNP COMMANDS
;	
;LCALL	S_CRLF
;	MOV	DPTR,#FLOW_C
;	LCALL	SND_MSG
;	LCALL	S_CRLF
;	MOV	A,#'&'			;DISPLAY "&E0 - &E3"
;	LCALL	PUT_CHAR
;	MOV	A,#'E'
;	LCALL	PUT_CHAR
;	MOV	DPTR,#OPT_0
;	MOVX	A,@DPTR
;	CJNE	A,#4,EX_00
;	MOV	A,#3
;EX_00:	ADD	A,#30H
;	LCALL	PUT_CHAR
;	
;	LCALL	SND_SPAND		;DIAPLAY "&E4 - &E8"
;	MOV	A,#'E'
;	LCALL	PUT_CHAR
;	MOV	DPTR,#OPT_1
;	MOVX	A,@DPTR
;	ADD	A,#34H
;	LCALL	PUT_CHAR
;	
	LCALL	S_CRLF
	MOV	A,#'\'			;DISPLAY "\A" COMMAND
	LCALL	PUT_CHAR
	MOV	A,#'A'
	LCALL	PUT_CHAR
	MOV	DPTR,#OPT_3
	MOVX	A,@DPTR
	JB	PSW.5,DIS_11
	MOV	R0,#9
	LCALL	READ_NV
	RL	A
	RL	A
	RL	A
	ANL	A,#3
DIS_11:	
	ADD	A,#30H
	LCALL	PUT_CHAR

	LCALL	SND_SPBK		;DISPLAY "\B" COMMAND
	MOV	A,#'B'
	LCALL	PUT_CHAR
	MOV	DPTR,#OPT_4
	MOVX	A,@DPTR
	JB	PSW.5,DIS_12
	MOV	R0,#13
	LCALL	READ_NV
DIS_12:	
      	ADD	A,#30H
	LCALL	PUT_CHAR	

	LCALL	SND_SPBK		;DISPLAY "\G" COMMAND
	MOV	A,#'G'
	LCALL	PUT_CHAR
	MOV	DPTR,#OPT_2
	MOVX	A,@DPTR
	JB	PSW.5,DIS_13
	MOV	R0,#11
	LCALL	READ_NV
DIS_13:	
	JNB	ACC.2,GG_1
	MOV	A,#1
	SJMP	GG_10
GG_1:	CLR	A	
GG_10:	ADD	A,#30H
	LCALL	PUT_CHAR	

	LCALL	SND_SPBK		;DISPLAY "\J" COMMAND
	MOV	A,#'J'
	LCALL	PUT_CHAR
	MOV	DPTR,#OPT_2
	MOVX	A,@DPTR
	JB	PSW.5,DIS_14
	MOV	R0,#11
	LCALL	READ_NV
DIS_14:	
	JB	ACC.1,JJ_1
	CLR	A
	SJMP	JJ_10
JJ_1:	MOV	A,#1	
JJ_10:	ADD	A,#30H
	LCALL	PUT_CHAR		

	LCALL	SND_SPBK		;DISPLAY "\K" COMMAND
	MOV	A,#'K'
	LCALL	PUT_CHAR
	MOV	DPTR,#OPT_5
	MOVX	A,@DPTR
	JB	PSW.5,DIS_15
	MOV	R0,#9
	LCALL	READ_NV
	RR	A
	RR	A
	ANL	A,#7
DIS_15:				;133S
	SJMP	OBK
	PUSH	ACC	
	MOV	DPTR,#JS3
	MOVX	A,@DPTR
	JB	ACC.7,EVEN
	POP	ACC
OBK:	CJNE	A,#1,NKK_1
	SJMP	NKK_00
NKK_1:	CJNE	A,#2,NKK_2
	INC	ACC
	SJMP	NKK_00
NKK_2:	CJNE	A,#3,NKK_00
	ADD	A,#2	
NKK_00:	ADD	A,#30H
	LCALL	PUT_CHAR		
	SJMP	DIS16A

EVEN:	POP	ACC
	CJNE	A,#1,NKK_1A
	SJMP	NKK_00A
NKK_1A:	CJNE	A,#2,NKK_2A
	INC	ACC
	SJMP	NKK_00A
NKK_2A:	CJNE	A,#3,NKK_00A
	ADD	A,#2	
NKK_00A:
	DEC	A
	ADD	A,#30H
	LCALL	PUT_CHAR		
	
DIS16A:					;133T	
	LCALL	SND_SPBK		;DISPLAY "\M" COMMAND
	MOV	A,#'M'
	LCALL	PUT_CHAR
	MOV	DPTR,#OPT_2
	MOVX	A,@DPTR
	JB	PSW.5,DIS_16
	MOV	R0,#11
	LCALL	READ_NV
DIS_16:	
	JB	ACC.6,AAM_1
	CLR	A
	SJMP	AAM_10
AAM_1:	MOV	A,#1
AAM_10:	ADD	A,#30H
	LCALL	PUT_CHAR

	LCALL	SND_SPBK		;DISPLAY "\N" COMMAND
	MOV	A,#'N'
	LCALL	PUT_CHAR
	JB	PSW.5,ACT_N

	MOV	R0,#9
	LCALL	READ_NV
	ANL	A,#3
	JNZ	N_1
	MOV	R0,#11
	LCALL	READ_NV
	JB	ACC.0,N_2
	CLR	A
	INC	A			;"\N1"
	SJMP	N_10
N_2:	CLR	A			;"\N0"
	SJMP	N_10	
N_1:	CJNE	A,#1,N_5
	MOV	R0,#11
	LCALL	READ_NV
	JB	ACC.6,N_6
	MOV	R0,#15
	LCALL	READ_NV
	JB	ACC.6,N_8
	MOV	A,#6			;\N6
	SJMP	N_10
N_8:	MOV	A,#4			;\N4
	SJMP	N_10	
N_5:	
	MOV	R0,#11
	LCALL	READ_NV
	JB	ACC.6,N_7
	MOV	R0,#15
	LCALL	READ_NV
	JB	ACC.6,N_9
	MOV	A,#7			;\N7
	SJMP	N_10
N_9:	MOV	A,#5			;\N5
	SJMP	N_10	
N_6:	MOV	A,#2			;\N2
	SJMP	N_10	
N_7:	MOV	A,#3
N_10:	ADD	A,#30H
	LCALL	PUT_CHAR
	LJMP	DIS_17


ACT_N:	MOV	DPTR,#OPT_0
	MOVX	A,@DPTR
	JNZ	NN_1
	MOV	DPTR,#OPT_2
	MOVX	A,@DPTR
	JB	ACC.0,NN_2
	CLR	A
	INC	A			;"\N1"
	SJMP	NN_10
NN_2:	CLR	A			;"\N0"
	SJMP	NN_10	
NN_1:	CJNE	A,#1,NN_5
	MOV	DPTR,#OPT_2
	MOVX	A,@DPTR
	JB	ACC.6,NN_6
	MOV	DPTR,#OPT_8
	MOVX	A,@DPTR
	JB	ACC.6,NN_8
	MOV	A,#6			;\N6
	SJMP	NN_10
NN_8:	MOV	A,#4			;\N4
	SJMP	NN_10	
NN_5:	MOV	DPTR,#OPT_2
	MOVX	A,@DPTR
	JB	ACC.6,NN_7
	MOV	DPTR,#OPT_8
	MOVX	A,@DPTR
	JB	ACC.6,NN_9
	MOV	A,#7			;\N7
	SJMP	NN_10
NN_9:	MOV	A,#5			;\N5
	SJMP	NN_10	
NN_6:	MOV	A,#2			;\N2
	SJMP	NN_10	
NN_7:	MOV	A,#3
NN_10:	ADD	A,#30H
	LCALL	PUT_CHAR

DIS_17:
	LCALL	SND_SPBK		;DISPLAY "\Q" COMMAND
	MOV	A,#'Q'
	LCALL	PUT_CHAR
	MOV	DPTR,#OPT_1
	MOVX	A,@DPTR
	JB	PSW.5,DIS_18
	MOV	R0,#10
	LCALL	READ_NV
DIS_18:	
	JNZ	QQ_1
	INC	A			;"\Q1"- NORMAL
	SJMP	QQ_10
QQ_1:	CJNE	A,#2,QQ_2
	
	JB	PSW.5,QQ_8		;150S
	MOV	R0,#15
	LCALL	READ_NV
	SJMP	QQ_11
QQ_8:	MOV	DPTR,#OPT_8
	MOVX	A,@DPTR
QQ_11:	JNB	ACC.5,QQ_7
	MOV	A,#6			;"\Q6"	
	SJMP	QQ_10
QQ_7:	MOV	A,#3			;150T \Q3
	SJMP	QQ_10
QQ_2:	CJNE	A,#3,QQ_3
	MOV	A,#1			;"Q1" - PASS THROUGH
	SJMP	QQ_10
QQ_3:	CJNE	A,#4,QQ_4
	SJMP	QQ_10
QQ_4:	CJNE	A,#5,QQ_5
	JB	PSW.5,QQ_9		;150S
	MOV	R0,#15
	LCALL	READ_NV
	SJMP	QQ_12
QQ_9:	MOV	DPTR,#OPT_8
	MOVX	A,@DPTR
QQ_12:	JNB	ACC.5,QQ_6
	MOV	A,#5			;"\Q5"	
	SJMP	QQ_10
QQ_6:	MOV	A,#2			;"\Q2"	
	SJMP	QQ_10			;150T
QQ_5:	CJNE	A,#6,QQ_10		;"\Q0"
	CLR	A	
QQ_10:	ADD	A,#30H
	LCALL	PUT_CHAR

	LCALL	SND_SPBK		;DISPLAY "\T" COMMAND
	MOV	A,#'T'
	LCALL	PUT_CHAR
	MOV	DPTR,#OPT_A
	MOVX	A,@DPTR
;	LCALL	SND_DIGITS
	JB	PSW.5,DIS_71
	MOV	R0,#17
	LCALL	READ_NV
DIS_71:	
	ADD	A,#30H
	LCALL	PUT_CHAR	
	LCALL	SND_SPBK		;DISPLAY "\V" COMMAND
	MOV	A,#'V'
	LCALL	PUT_CHAR
	MOV	DPTR,#OPT_8
	MOVX	A,@DPTR
	JB	PSW.5,DIS_19
	MOV	R0,#15
	LCALL	READ_NV
DIS_19:	
	ANL	A,#03			;147
	ADD	A,#30H
	LCALL	PUT_CHAR
	LCALL	SND_SPBK		;DISPLAY "\X" COMMAND
	MOV	A,#'X'
	LCALL	PUT_CHAR
	MOV	DPTR,#OPT_1
	MOVX	A,@DPTR
	JB	PSW.5,DIS_20
	MOV	R0,#10
	LCALL	READ_NV
DIS_20:	
	CJNE	A,#3,NP_1
	MOV	A,#'1'
	SJMP	NP_2
NP_1:	MOV	A,#'0'
NP_2:	LCALL	PUT_CHAR		

	LCALL	SND_SPPN		;DISPLAY "%A" COMMAND
	MOV	A,#'A'
	LCALL	PUT_CHAR
	MOV	DPTR,#OPT_9
	MOVX	A,@DPTR
	JB	PSW.5,DIS_21
	MOV	R0,#16
	LCALL	READ_NV
DIS_21:	
	LCALL	SND_DIGITS
		
	LCALL	SND_SPPN		;DISPLAY "%C" COMMAND
	MOV	A,#'C'
	LCALL	PUT_CHAR
	MOV	DPTR,#OPT_2
	MOVX	A,@DPTR
	JB	PSW.5,DIS_22
	MOV	R0,#11
	LCALL	READ_NV
DIS_22:	
	JB	ACC.7,AAP_1
	CLR	A
	SJMP	AAP_10
AAP_1:	MOV	A,#1
AAP_10:	ADD	A,#30H
	LCALL	PUT_CHAR

	LCALL	SND_SPPN		;DISPLAY "%D" COMMAND
	MOV	A,#'D'
	LCALL	PUT_CHAR
	MOV	DPTR,#OPT_B
	MOVX	A,@DPTR
	JB	ACC.0,AAD_1
	MOV	A,#0
	SJMP	AAD_10
AAD_1:	MOV	A,#1
AAD_10:	ADD	A,#30H
	LCALL	PUT_CHAR

	SJMP	OMCT			;134
	LCALL	SND_SPPN		;DISPLAY "%V" COMMAND
	MOV	A,#'V'
	LCALL	PUT_CHAR
	MOV	DPTR,#OPT_8
	MOVX	A,@DPTR
	ANL	A,#0C0H
	SWAP	A
	RR	A
	RR	A
AAV_10:	ADD	A,#30H
	LCALL	PUT_CHAR
OMCT:						;134
	LCALL	SND_SPMN		;DISPLAY "-P" COMMAND
	MOV	A,#'P'
	LCALL	PUT_CHAR
	MOV	DPTR,#OPT_2
	MOVX	A,@DPTR
	JB	PSW.5,DIS_23
	MOV	R0,#11
	LCALL	READ_NV
DIS_23:	
	JNB	ACC.3,MAP_1		;148
	CLR	A	
	SJMP	MAP_10
MAP_1:	MOV	A,#1
MAP_10:	ADD	A,#30H
	LCALL	PUT_CHAR	
	LCALL	SND_SPMN		;DISPLAY "-C" COMMAND
	MOV	A,#'C'
	LCALL	PUT_CHAR
	MOV	DPTR,#OPT_C
	MOVX	A,@DPTR
	LCALL	SND_DIGITS

	LCALL	SND_SPMN		;DISPLAY "-D" COMMAND
	MOV	A,#'D'
	LCALL	PUT_CHAR
	MOV	DPTR,#OPT_D		;CHECK BIT4,5
	MOVX	A,@DPTR
	SWAP	A
	ANL	A,#00000011B
	ADD	A,#30H 
	LCALL	PUT_CHAR
	ENDIF
	
	RET

	
	END		
