;	INCLUDE	CONFIG.ASM
;	LIST  ON
;************************************************************************
;*									*
;* FILE		: RDEFINE.ASM	UNIVERSAL 				*
;*									*
;* ATTENTION 	: BE CAREFUL TO CHANGE ANY THING IN THIS MODULE.	*
;*									*
;************************************************************************

	TITLE GLOBAL MEMORY AND CONSTANT DEFINITIONS

;################################################################
;#								#
;#            INTERNAL BIT DEFINITIONS				#
;#								#
;################################################################

;================================================================
;		"AT" BIT MAPPED REGISTERS			
;================================================================

S14		EQU	21H	;S14
;
TTF1		REG	21H.0	;BIT 0 = 2400 retrain
COM_ECHO	REG	21H.1	;BIT 1 = COMMAND ECHO (ATE)
QUIET		REG	21H.2	;BIT 2 = RESULT CODE ENABLED (ATQ)
VERBOSE		REG	21H.3	;BIT 3 = TERSE/VERBOSE MODE  (ATV)
COM_DIS		REG	21H.4	;BIT 4 = DISABLE COMMAND RECOGNITION IF 1
PUL_DIAL	REG	21H.5	;BIT 5 = PULSE/TONE BIT
NP_GF		REG	21H.6	;BIT 6 = 
ORG_BIT		REG	21H.7	;BIT 7 = ANSWER/ORIGINATE BIT

;----------------------------------------------------------------
S16		EQU	23H	;S16
;
;ALB1_REQ		REG	23H.0	;ANALOG LOOPBACK
ALB_REQ		REG	23H.0	;ANALOG LOOPBACK
TST_F		REG	23H.1	;
DLOOP1_R	REG	23H.2	;LOCAL DIGITAL LOOPBACK
DLOOP2_R	REG	23H.3	;REMOTE DIGITAL LOOPBACK ON (RTRT)
IRT1_R		REG	23H.4	;IRT REQUESTED
IRT2_R		REG	23H.5	;IRT W/TEST REQUESTED
ALB1_REQ	REG	23H.6	;ANALOG LOOPBACK SELF TEST
TST_TF		REG	23H.7	;

;----------------------------------------------------------------
S21		EQU	24H	;S21
;
JACK_SEL	REG	24H.0	;AT&J COMMAND STATUS
NP_UF		REG	24H.1	;
CTS_OPT		REG	24H.2	;AT&R COMMAND STATUS
DTR_OP1		REG	24H.3	;DTR STATUS (LSB) AT&D COMMAND STATUS
DTR_OP2		REG	24H.4	;DTR STATUS (MSB)
CXR_NORM	REG	24H.5	;AT&C COMMAND STATUS (CXR)
DSR_NORM	REG	24H.6	;AT&S COMMAND STATUS (DSR)
LSD_ENB		REG	24H.7	;ATY COMMAND STATUS (LONG SPACE DISCONNECT)
;
;----------------------------------------------------------------
S22		EQU	25H	;S22
;
SPEAK_A		REG	25H.0	;SPEAKER VOLUME (LSB) ATL
SPEAK_B		REG	25H.1	;SPEAKER VOLUME (MSB)
SPEAK_1		REG	25H.2	;SPEAKER CONTROL (LSB) ATM
SPEAK_2		REG	25H.3	;SPEAKER CONTROL (MSB)
XBIT_0		REG	25H.4	;ATX BIT LSB
XBIT_1		REG	25H.5	;ATX BIT
XBIT_2		REG	25H.6	;ATX BIT MSB
PUL_RATIO	REG	25H.7	;PULSE RATIO  (0 = US)
;
;----------------------------------------------------------------
S23		EQU	26H	;S23
;
RTRT_ENB	REG	26H.0	;RTRT ENABLE
BPS_0		REG	26H.1	;COMMUNICATIONS RATE
BPS_1		REG	26H.2	;
BPS_2 		REG	26H.3	;FOR 9600
PAR_1		REG	26H.4	;PARITY OPTIONS
PAR_2		REG	26H.5	;
GAURD_1		REG	26H.6	;GAURD TONE OPTION
GAURD_2		REG	26H.7	;
;
;----------------------------------------------------------------
S27		EQU	27H	;S27
;
ASYN_1		REG	27H.0	;AT&M COMMAND STATUS
ASYN_2		REG	27H.1	;AT&M COMMAND STATUS
LEASED_L	REG	27H.2	;DIAL UP/LEASED LINE (&L)
V_SD		REG	27H.3	;
CLOCK_1		REG	27H.4	;DCE CK
CLOCK_2		REG	27H.5	;DTE CK
BELL212		REG	27H.6	;CCITT/BELL MODE (ATB)
COM_F		REG	27H.7	;

;================================================================
;		MISC STATUS BITS				
;================================================================

RAM20H		EQU	20H	;ONLINE FLAGS
;
RTS_LOSS	REG	20H.0	;
LOST_DTR	REG	20H.1	;DTR LOSS STATUS (FOR DTR DELAY)
SYNC		REG	20H.2	;SYNC MODE BIT
LL_BITF		REG	20H.3	;TEMP LEASED LINE BIT
GOOD_LL		REG	20H.4	;
BAD_LL		REG	20H.5	;
NOISE_BIT	REG	20H.6	;SET IF NOISE DURING CONNECT
SPD_FLG		REG	20H.7	;SPEED CONVERSION FLAG

;----------------------------------------------------------------
RAM28H		EQU	28H	;MISC "AT" STATUS BITS
;
TIM_1PF		REG	28H.0	;TIMER 1 PRESCALAR
TIM_6PF		REG	28H.1	;TIMER 6 PRESCALAR
FUL_DUP		REG	28H.2	;FULL DUPLEX BIT IN DATA MODE
SYNC_DTR	REG	28H.3	;SET IF SYNC MODE 1 TO DELAY DTR DETECT
RING_BIT	REG	28H.4	;STORAGE FOR RING STATUS
HOOK_BIT	REG	28H.5	;1 = OFFHOOK
SYNC_D		REG	28H.6	;SYNC DIAL STATUS (DO NOT SEND MESSAGES)
WAIT_HALF	REG	28H.7	;USED IN AUTOBAUD
;
;TEST MODE FLAGS  (DO NOT CHANGE)
;
;----------------------------------------------------------------
RAM29H		EQU	29H	
;
RDLB_ON		REG	29H.0	;
RTRT_ON		REG	29H.1	;999
LDLB_ON		REG	29H.2	;LDLB REQUEST
ALB_ON		REG	29H.3	;ALB ON FLAG
TEST_BIT	REG	29H.4	;TEST IN PROGRESS
ST_FLAG		REG	29H.5	;SELF TEST IN PROGRESS
V21_SPD		REG	29H.6	;
RDLB_REQ	REG	29H.7	;

ESC_BIT		EQU	4AH
;
;DATA COM BITS AND GENERAL PURPOSE BITS AND FLAGS
;
;----------------------------------------------------------------
RAM2AH		EQU	2AH	;THIS REGISTER HOLDS THE FLAGS
;
TIM_1F		REG	2AH.0	;TIMER 1 FLAG
TIM_2F		REG	2AH.1	;TIMER 2 FLAG
TIM_3F		REG	2AH.2	;TIMER 3 FLAG
TIM_4F		REG	2AH.3	;TIMER 4 FLAG
TIM_5F		REG	2AH.4	;TIMER 5 FLAG
TIM_6F		REG	2AH.5	;TIMER 6 FLAG
TIM_7F		REG	2AH.6	;TIMER 7 FLAG
TIM_8F		REG	2AH.7	;TIMER 8 FLAG
;
MRCNT		EQU	2AH	;COUNTER USING IN MNP ALB MODE
;
;
;DIALER STATUS BITS
;
;----------------------------------------------------------------
RAM2BH		EQU	2BH	
;
RING_IP		REG	2BH.0	;RING IN - IN PROCESS
ANSWER_T	REG	2BH.1	;ANSWER TONE DETECTED
BUSYB		REG	2BH.2	;BUSY DETECTED
BUSY_CHK	REG	2BH.3	;BUSY CHECK ENABLED
AUTODIAL	REG	2BH.4	;ANSWER TONE DETECTED
HI_SPD1		REG	2BH.5	;00-LOW SPEED
HI_SPD2		REG	2BH.6	;01 - 1200, 10 OR 11 = V.22BIS MOD
LD_L		REG	2BH.7	;* SPD LEASED LINE STATUS &L COMMAND
;RNRON		EQU	LD_L

;================================================================
;		ONLINE MODE BITS SHARED WITH DIALER BITS	
;================================================================
;
RAM2CH		EQU	2CH	;MISC ONLINE BITS
;
PRE_TIM		REG	2CH.0	;PRE-GAURD TIME MET
ABORT1		REG	2CH.1	;USED IN CHK_DT
LOST_IT		REG	2CH.2	;CARRIER LOST
EXT_LATCF	REG	2CH.3	;SET IF EXTERNAL MODEM LATCH AVALIABLE
IGNORE_DTR	REG	2CH.4	;
S_DIAL		REG	2CH.5	;SET IF STORED DIALING (CHARACHTERS ECHOED)
TIM_9F		REG	2CH.6	;
DTR_FLG		REG	2CH.7	;SET IF DTR HAS OFF TO ON TRANSITION
;
;----------------------------------------------------------------
RAM2DH		EQU	2DH	;MISC OFFLINE BITS
;
BIT_1		REG	2DH.0	;AUTO BAUD FLAGS
BIT_12		REG	2DH.1	;
BIT_3		REG	2DH.2	;
BIT_24		REG	2DH.3	;
AT_SLASH	REG	2DH.4	;HAYES "A/" DETECTED
PASS		REG	2DH.5	;
ABORT		REG	2DH.6	;
V23_SPD		REG	2DH.7	;999 SPEAKER OFF/ON
JP_004		EQU	AT_SLASH;
;
;----------------------------------------------------------------
RAM2EH		EQU	2EH	;MISC ONLINE BITS (DO NOT CHANGE)
;
S1_TBIT		REG	2EH.0	;USED IN S1 DETECT
S1_PBIT		REG	2EH.1	;USED IN S1 DETECT
DTR_HL		REG	2EH.2	;DTR HIGH TO LOW TRANSITION FLAG
LL_BIT2		REG	2EH.3	;LEASED LINE BIT 2 - SET WHEN IN 2400BPS LEASE
				;LINE MODE. CLEARED AFTER FIRST SUCESSFULL
				;RETRAIN REQUEST
CXRLST1		REG	2EH.4	;USED WHEN S10=255 FOR CXR LOSS
RETRAIN		REG	2EH.5	;RETRAIN REQUEST (ATO1, LOCAL ACTIVE)
DATA_BIT	REG	2EH.6	;DATA MODE FLAG
RET_BIT		REG	2EH.7	;RETRAIN (FAR END ACTIVE)

;----------------------------------------------------------------
RAM2FH		EQU	2FH	;8 BIT PORT IMAGE
	IFTRUE	SINGLE_CHIP
M_READY		REG	2FH.0	;MODEM READY LED  (PIN 21
AA_BIT		REG	2FH.1	;AUTO ANSWER LED  (PIN 22)
TRUE_CXR	REG	2FH.2	;TRUE CXR STATUS (PIN 23)
HS_H		REG	2FH.3	;HIGH SPEED STATUS  (PIN 24)
DSR_L		REG	2FH.4	;DATA SET READY (PIN 25)
CTS_L		REG	2FH.5	;CLEAR TO SEND  (PIN 26)
SPKR1A		REG	2FH.6	;SPEAKER VOLUME CONTROL (LOW)  (PIN 27)
SPKR2B		REG	2FH.7	;SPEAKER VOLUME CONTROL (HIGH) (PIN 28)
	ENDIF

;----------------------------------------------------------------
	IFTRUE	EXT_ROM
CTS_L		REG	2FH.0	;CLEAR TO SEND
DSR_L		REG	2FH.1	;DATA SET READY
HS_H		REG	2FH.2	;HIGH SPEED STATUS
AA_BIT		REG	2FH.3	;AUTO ANSWER LED
M_READY		REG	2FH.4	;MODEM READY LED
OH_L  		REG	2FH.5	;OFFHOOK CONTROL
TRUE_CXR	REG	2FH.6	;TRUE CXR STATUS
CXR_L 		REG	2FH.7	;CARRIER DETECT
;
;----------------------------------------------------------------
RAM22H		EQU	22H

				; BIT0,BIT1 SHARE SPEAKER VOLUME CONTROL
SPKR1A		REG	22H.0	;SPEAKER OUTPUT CONTROL
SPKR2B		REG	22H.1	;

				;LOW 3 BITS ARE FOR SPEED CHECKING
GOT_A		REG	22H.3	;GOT A FROM INTERRUPT ROUTINE
BIT_96		REG	22H.4	;9600BPS
BIT_48		REG	22H.5	;4800BPS
ST_B		REG	22H.6	;START BIT
TEMP_B		REG	22H.7	;BIT TO STORE INPUT DATA

TI_FLAG		EQU	14H

	ENDIF

;----------------------------------------------------------------
	IFTRUE	TAN
M_READY		REG	2FH.0	;MODEM READY LED
AA_BIT		REG	2FH.1	;AUTO ANSWER LED
HS_H		REG	2FH.2	;HIGH SPEED STATUS
DSR_L		REG	2FH.3	;DATA SET READY
CTS_L		REG	2FH.4	;CLEAR TO SEND
SPKR1A		REG	2FH.5	;SPEAKER VOLUME CONTROL (LOW)
SPKR2B		REG	2FH.6	;SPEAKER VOLUME CONTROL (HIGH)
TRUE_CXR	REG	2FH.7	;TRUE CXR STATUS
	ENDIF
;
;################################################################
;#								#
;#            I/O PORT DEFINITIONS				#
;#								#
;################################################################
;
;================================================================
; PORT 1 - 8051 port 1
;================================================================
;
NV_CS	REG	P1.0	;NON VOLITLE RAM CONTROLS
RI_IN	REG	P1.1	;RING IN FROM LINE
	IFFALSE	DOI
NV_DO	REG	P1.2	;NVRAM DATA OUT
	ENDIF
RI_OUT	REG	P1.3	;RING TO DTE
DTR_L	REG	P1.4	;DATA TERMINAL READY
NV_CLK	REG	P1.5	;NVRAM CLOCK INPUT
RTS_L	REG	P1.6	;REQUEST TO SEND
RSTTMS	REG	P1.7	;RESET TO TMS 320
;
;================================================================
; PORT 3 - 8051 port 3
;================================================================
;
TXD_D	REG	P3.0	;SERIAL INPUT
RXD_D	REG	P3.1	;SERIAL OUTPUT
SCT_ITP REG	P3.2	;TXCLK INTERRUPT
SCR_ITP REG	P3.3	;RXCLK INTERRUPT
NV_DI	REG	P3.4	;T0 NVRAM DATA INPUT
T1_ITP	REG	P3.5	;INTERRUPT FOR AUTO_BAUD
W_BIT	REG	P3.6	;WRITE STROBE
R_BIT	REG	P3.7	;READ STROBE
	IFTRUE	DOI
NV_DO	EQU	NV_DI
	ENDIF
;	
;================================================================
; External Port Definitions (8 BIT LATCH)
;================================================================
;
;CTS_L		REG	2FH.0	;CLEAR TO SEND
;DSR_L		REG	2FH.1	;DATA SET READY
;HS_H		REG	2FH.2	;HIGH SPEED STATUS
;AA_BIT		REG	2FH.3	;AUTO ANSWER LED
;M_READY	REG	2FH.4	;MODEM READY LED
;TRUE_CXR	REG	2FH.5	;TRUE CXR STATUS
;SPKR1A		REG	2FH.6	;SPEAKER VOLUME CONTROL (LOW)
;SPKR2B		REG	2FH.7	;SPEAKER VOLUME CONTROL (HIGH)
;
	IFTRUE	SRAM
LATCH		EQU	0400BH	;32K SRAM
	ENDIF
	IFFALSE	SRAM
LATCH		EQU	0F00BH	;8K SRAM	
	ENDIF

;================================================================
; XR2321
;================================================================
XR23P0	EQU	0028H
XR23P1	EQU	0029H

;################################################################
;#								#
;#            INTERNAL RAM DEFINITIONS				#
;#								#
;################################################################
;
REG_0		EQU	00H
REG_1		EQU	01H
REG_2		EQU	02H
REG_3		EQU	03H
;
REG_4		EQU	04H
ST_CNT		EQU	04H	;USED IN SELF TEST MODE
;
REG_5		EQU	05H
TEMP_T		EQU	05H	;USED IN AUTOBAUD
UNSM_CNT	EQU	05H	;FOR RTRT
;
REG_6		EQU	06H	
DOT_CNT		EQU	06H	;FOR IRT
;
REG_7		EQU	07H
ERR_CNT		EQU	07H	;ERROR COUNT FOR TEST MODES
XSITION		EQU	07H	;TRANSITION COUNT (ANSWER MODE ONLY)
;
	RSECT
;
	ORG	08H		
;
TIM_1:		DS	1			;TIMER 1 DOWN COUNTER
TIM_1P:		DS	1			;TIMER 1 PRESCALAR

TIM_2:		DS	1			;TIMER 2 DOWN COUNTER
TIM_2P:		DS	1			;TIMER 2 PRESCALAR

TIM_3:		DS	1			;TIMER 3 DOWN COUNTER
TIM_3P:		DS	1			;TIMER 3 PRESCALAR

TIM_4:		DS	1			;TIMER 4 DOWN COUNTER
STATUS:		DS	1			;C_DATA STATUS

TIM_5:		DS	1			;TIMER 5 DOWN COUNTER
TIM_5P:		DS	1			;TIMER 5 PRESCALAR

RI_TRANS:	DS	1			;RING IN TRANSITION COUNT
BUSY_CYCLES	EQU	RI_TRANS	;USED IN CALL PROGRESS ROUTINES
ESC_CNT		EQU	RI_TRANS	;USED IN ONLINE MODE ALSO
RET_CNT		EQU	RI_TRANS	;300 RETRAIN COUNTER
;
;================================================================
; "AT" S REGISTERS
;================================================================
;
	ORG	13H
;
S0:		DS	1
S1:		DS	1
S2:		DS	1
S3:		DS	1
S4:		DS	1
S5:		DS	1
S6:		DS	1
S7:		DS	1
S8:		DS	1
S9:		DS	1
S10:		DS	1
S11:		DS	1
S12:		DS	1

;----------------------------------------------------------------
;				;S14 AND S16 IN BIT RAM 20H-22H
	ORG	30H		;S REGISTERS
S13:		EQU	0	;NOT USED
S15:		EQU	0	;NOT USED
S17:		EQU	0	;NOT USED
S18:		DS	1	;TEST TIMER
S19:		EQU	0	;NOT USED
S20:		EQU	0	;NOT USED
S24:		EQU	0	;NOT USED
S25:		DS	1	;DELAY TO DTR
S26:		DS	1	;RTS TO CTS DELAY
TIM_6:		DS	1	;TIMER 6 DOWN COUNTER
TIM_6P:		DS	1	;TIMER 6 PRESCALAR
TIM_7:		DS	1	;TIMER 7 DOWN COUNTER
TIM_7P:		DS	1	;TIMER 7 PRESCALAR
TIM_8:		DS	1	;TIMER 8 DOWN COUNTER
TIM_8P:		DS	1	;TIMER 8 PRESCALAR
TIM_9:		DS	1	;TIMER 9 DOWN COUNTER
U_ST		DS	1	;UNIVERSAL STATE INDICATOR
TEMP_A		DS	1	;USED IN AUTOBAUD
COUNT		EQU	TIM_7P	;USED IN AUTOBAUD SEQUENCD

;----------------------------------------------------------------
	ORG	3CH
POINTER:	DS	1	;100
BUFFER:		DS	40	;100 KEYBOARD BUFFER
FR1:		DS	1	;JCM TEMP STORAGE
TIM_BAS:	DS	1
BK_AGC:		DS	1
S1_CNT:		DS	1	;300 **** 2400
BK_PRE		EQU	51H	;BREAK PRE_SCALE IN SPDCNV.ASM
BK_TMR		EQU	52H	;BREAK TIMER IN SPDCNV.ASM
S_STORE:	EQU	BK_AGC	;ATSn=?
S1_TEMP:	EQU	FR1	;S1 BIT COUNTER		**** 2400

	
	IFFALSE	M32
	ORG	(7FH-17H+1)
STACK:		DS	23	;23=17H SHOULD BE ENOUGH
	ENDIF


	IFTRUE	M32
STACK:		EQU	0C0H	;SHOULD BE ENOUGH
	ENDIF

 	EJECT
;################################################################
;#								#
;#                  GLOBAL CONSTANTS				#
;#								#
;################################################################
;
;================================================================
;These are the baud rate constants for a 11.059Mhz crystal
;================================================================
;CALCULATED WITH THE FOLLOWING
;COUNT = XTAL FREQ / (384 * BAUDRATE)
;
BAUD_11		EQU	<(-255)		;110 BAUD WILL ACTUALLY BE HIGH BY
;					;2 PERCENT
BAUD_3		EQU	<(-96)		;
BAUD_12		EQU	<(-24)		;
BAUD_24		EQU	<(-12)		;
;

;================================================================
;3.3 MS TIMER CONSTANT FOR 11.059MHZ CLOCK
;================================================================
;
SYSTEM_T	EQU	-3072	
;
;================================================================
;AUTO BAUD CONSTANTS
; CALCULATED FOR A CLOCK SPEED OF 11.059 MHZ
; OR A TIMER CLOCK PERIOD OF 1+085 US
;================================================================
;
B2400_L		EQU	320		;FROM 340 9/10
B2400_M1	EQU	344		;FROM 354 10/11
B2400_H		EQU	403		;
B4800_M		EQU	111		;FROM 175 9/10
					;FROM 160 9/10
;
B1200_L		EQU	680		;FROM 729 4/28
B1200_M		EQU	748		;FROM 768 4/28
B1200_H		EQU	806		;
B2400_M		EQU	354		;FROM 384 4/28
;
B300_L		EQU	2917
B300_M		EQU	3071	
B300_H		EQU	3224
B600_M		EQU	1535
;
B110_L		EQU	7959
B110_M		EQU	8378
B110_H		EQU	8796
B220_M		EQU	4189

;**********************************************
;	SPECIAL DEFINITION FOR MNP
;**********************************************
;
;--------------------------------------- BIT
V42_S		EQU	3BH
;BIS		EQU	3DH
;BT_TX		EQU	42H
;BT_RX		EQU	45H
DATA_G		EQU	4FH		;161  V.42BIS
MS1_BIT		EQU	62H
MS1_PBIT	EQU	63H
MS1_TBIT	EQU	64H
TRF1		EQU	65H		;

;--------------------------------------- BYTE
DCE_S1		EQU	2H
EXTEND		EQU	6H
CRCH_T		EQU	8H
CRCL_T		EQU	9H
RCV_FR		EQU	09H
DCE_TB		EQU	0CH


N_CRD		EQU	10H
TIMER2		EQU	12H
R_ACK		EQU	13H
TIMER4		EQU	14H
TIMER0		EQU	10H
TIME0		EQU	13H

EXTRA_B		EQU	2EH

DCETPL		EQU	33H
DCETPH		EQU	34H
RCVPOLL		EQU	3FH

DTR_PTR		EQU	42H
R_CRD		EQU	45H
SND_O_S		EQU	47H
OUT_BUF		EQU	4BH
N_CHK		EQU	4FH

TX_STA		EQU	52H
SYN_7E		EQU	54H
MK_CNT		EQU	59H

IN_T1		EQU	6BH
BIT_CNT		EQU	6BH
TX_CNT		EQU	6CH
WAIT_LN		EQU	6EH

MS1_TEMP	EQU	7DH
MS1_CNT		EQU	7EH
TIN_T1		EQU	7FH

BUF		EQU	96H

AT_STACK	EQU	0C0H


;================================================================
; MNP CONSTANTS
;================================================================

RCVCMD	EQU	43H
B_LEN	EQU	0FFH


;================================================================
; VECTORS ( DON'T CHANGE )
;================================================================

BK_AT	EQU	008EH
ABK_AT	EQU	0091H
B_UIA	EQU	1A4EH	;ENTRY POINT TO INTERNAL ROM
CFR_LN	EQU	802DH	;ADDRESS FOR LN IN MNP MODE
EC_B	EQU	9EFFH
AT_BE	EQU	9FFFH

;================================================================
; GENERAL CONSTANTS
;================================================================
NULL		EQU	00H
SPACE		EQU	20H
CR		EQU	0DH	;CARRIAGE RETURN
LF		EQU	0AH	;LINE FEED
STAR		EQU	42
FULL		EQU	0FFH

HIGH_RING	EQU 	250	;RING TRANSITION WINDOWS
LOW_RING	EQU 	8
MAX_LINE	EQU	40	;MAXIMUM LINE LENGTH
MAX_S		EQU	28	;MAXIMUM S REGISTERS + 1
S1_A		EQU	40	;ANSWER S1 1.1 33

	IFTRUE	X2400		;138 300S
TX_P		EQU	3
RX_P		EQU	3
USMK_C		EQU	240
DOT_T		EQU	2
SQH_T		EQU	1
S1_NB		EQU	20
	ENDIF
	
	IFFALSE	X2400
TX_P		EQU	1
RX_P		EQU	8
USMK_C		EQU	160
DOT_T		EQU	2
SQH_T		EQU	100
	ENDIF			;138 300T

;================================================================
; JCM CONSTANTS
;================================================================
EP_ID		EQU	014	;VERSION ID : 0 - 127
C_STB1		EQU	1	;CHIP STABILITY CONST
C_STB2		EQU	3	;CHIP STABILITY CONST
C_STB3		EQU	1	;CHIP STABILITY CONST
C_STB4		EQU	2	;CHIP STABILITY CONST
	
	IFTRUE	S1_H	;124S
S1_STB		EQU	26	;S1 STABILITY CONST * TIM_4
	ENDIF
	
	IFFALSE	S1_H
S1_STB		EQU	29	;S1 STABILITY CONST * TIM_4
	ENDIF			;124T

;################################################################
;#								#
;#            	XR2900 CONTROL WORDS				#
;#								#
;################################################################

FSPD		EQU	9400H	;PUT IN R4 FOR FAX SPEED SELECTION
DEBUG_F		EQU	9401H	;DEBUG MODE FLAG 
SET_MPS		EQU	9402H	;MPS NUMBER
FAX_SPD		EQU	9403H	;FAX REQUEST CONNECT SPEED
OPT_FAX		EQU	9404H	;FAX MODE CONTROL REGISTER
DEBUG_S		EQU	9405H	;DEBUG MODE FOR SEND DATA

;################################################################
;#								#
;#            XR2400 CONTROL WORDS				#
;#								#
;################################################################
;
W_REG0		EQU	60H	;CONTROL REGISTER 0
W_REG1		EQU	61H	;CONTROL REGISTER 1
W_REG2		EQU	62H	;CONTROL REGISTER 2
W_REG3		EQU	63H	;CONTROL REGISTER 3
W_REG4		EQU	64H	;CONTROL REGISTER 4
W_REG5		EQU	65H	;CONTROL REGISTER 5
W_REG6		EQU	66H	;CONTROL REGISTER 6
R_REG7		EQU	67H	;STATUS REGISTER 7
W_REG9		EQU	69H	;CONTROL REGISTER 9
W_REGF		EQU	6FH	;CONTROL REGISTER F
;
;REGISTER 9 CONSTANTS
;
IDL_MOD		EQU	00H	;IDLE MODE
FSK_MOD		EQU	01H	;FSK MODE
PSK_MOD		EQU	02H	;PSK MODE
DTMF_MOD	EQU	03H	;TONE DIAL MODE
CALL_MOD	EQU	04H	;CALL PROGRESS FILTER

LOW_ORG1	EQU	0A4H	;103 ORG MODE CONTROL 1
LOW_ORG2	EQU	01H	;103 ORG MODE CONTROL 2

;################################################################
;#								#
;#		SRAM CONTROL REGISTERS				#
;#								#
;################################################################

RCV_BUF		EQU	803AH
MRCVP2		EQU	803BH	;FOR FALL BACK TO NORMAL MODE

PTR_1		EQU	9602H

CFR_UI		EQU	9813H
C_BUF		EQU	9A00H

	
	ORG	9D09H
MISC_REG	EQU	9DH	;MISC REGISTERS
OPT_0		DS	1	;ERROR CONTROL OPTION
OPT_1		DS	1	;FLOW CONTROL OPTION
OPT_2		DS	1	;9D0BH
OPT_3		DS	1	;9D0CH
OPT_4		DS	1	;9D0DH
OPT_5		DS	1	;9D0EH
OPT_8		DS	1	;9D0FH
OPT_9		DS	1	;9D10H
OPT_A		DS	1	;9D11H
OPT_6		DS	1	;9D12H
OPT_7		DS	1	;9D13H
PASS_B		DS	1	;DTE PASSING BYTE
SPEED		DS	1	;DTE SPEED
Z_BUF		DS	1	;"\Z"
F1		DS	1	;"\Z"
F2		DS	1	;"\Z"
F3		DS	1	;"\Z"
MESC_CNT	DS	1	;9D1AH
KEYS		DS	1	;"\Z"
BACK_RAM	DS	1	;9D1CH KEYBUFF BKUP
KEY_BFF		DS	40	;KEYBUFF
B_TAL		DS	1	;122T 9D45H FREE
STAT_1		EQU	9D1BH

	
	
	ORG	9D50H	
OPT_P		EQU	9D50H	;OPTIONAL OUTPUT PORT
OPT_B		EQU	9D51H
OPT_C		EQU	9D52H
OPT_D		EQU	9D53H
CB_BUFF		EQU	9D5AH
CB_BUF1		EQU	9D5BH
;
;------------------------------- RNR ON LINE COMMAND
;
CRCL_D		EQU	9D65H
C_CNT		EQU	9D68H
PRT_1		EQU	9D66H
RNR_CNT		EQU	9D69H
MK_CNT1		EQU	9D6AH
;

LN_RETX		EQU	9D75H
RE_COUNT	EQU	9D76H
P_CNT		EQU	9D79H
;TEMP_S4	EQU	9D7BH	;122D
;TEMP_S3	EQU	9D7CH	;122T

	ORG	9DA0H		;002S JCM registers
JS0		DS	1	;131	
JS1		DS	1	;RX EQ 
JS2		DS	1	;TX EQ
JS3		DS	1	;131 BREAK CONTROL
JS4		DS	1	;DATA STABILITY
JS5		DS	1	;125 CONNECTION
JS6		DS	1	;134 ATW
JS7		DS	1	;144
JS8		DS	1	;144
JS9		DS	1	;162	
JS10		DS	1	
JS11		DS	1	
JS12		DS	1	
JS13		DS	1	
JS14		DS	1	
JS15		DS	1	
JS16		DS	1	
JS17		DS	1	
JS18		DS	1	
JS19		DS	1	
JS20		DS	1	
JS21		DS	1	
JS22		DS	1	
JS23		DS	1	
JS24		DS	1	
JS25		DS	1	
JS26		DS	1	
JS27		DS	1	
JS28		DS	1	
JS29		DS	1	
JS30		DS	1	;Temp
JS31		DS	1	;9DBFH

EXTRA_1		EQU	JS6	;134
F1ST_E		EQU	JS8	;144
OPT_BK		EQU	JS10

	ORG	9DC0H	
MISC_RL	EQU	C0H		;143
S36		DS	1		
S37		DS	1		
S40		DS	1		
S41		DS	1		
S46		DS	1		
S48		DS	1		
S82		DS	1		
S86		DS	1		
S90		DS	1		
S91		DS	1	;002T 9DC9H	


MEXTRA_1	DS	1	;BIT 0,1 for atw
				;bit 7 for at&s2
T_TIMER0	DS	1
TIME_S25	DS	1
TEMP_S21	DS	1
EX_TIMER5	DS	1
EX_TIMER6	DS	1
EX_5		DS	1
EX_TIMER7	DS	1
OPT_NQ		DS	1
TIME_S12	DS	1
TIME_S10	DS	1
TEMP_S10	DS	1


EC_RAM		EQU	9E00H
MNP_S		EQU	9E22H	;MNP LINK INDICATOR
				;MNP_S BIT 5 FOR MNP LINK INDICATOR
DBK_NOW		EQU	9E25H

SAV_RAM		EQU	9F00H
S_S2		EQU	9F15H
S_S3		EQU	9F16H
S_S12		EQU	9F1FH
S_S25		EQU	9F31H

;################################################################
;#								#
;#            HARDWARE INTERNAL BIT DEFINITIONS			#
;#								#
;################################################################
;
TF1	REG	TCON.7
TR1	REG	TCON.6
TF0	REG	TCON.5
TR0	REG	TCON.4
IE1	REG	TCON.3
IT1	REG	TCON.2
IE0	REG	TCON.1
IT0	REG	TCON.0
;
SM0	REG	SCON.7
SM1	REG	SCON.6
SM2	REG	SCON.5
REN	REG	SCON.4
TB8	REG	SCON.3
RB8	REG	SCON.2
TI	REG	SCON.1
RI	REG	SCON.0
;
EA	REG	IE.7
ET2	REG	IE.5
ES	REG	IE.4
ET1	REG	IE.3
EX1	REG	IE.2
ET0	REG	IE.1
EX0	REG	IE.0

P	REG	PSW.0

B0	EQU	F0H
B1	EQU	F1H
B2	EQU	F2H
B3	EQU	F3H
B4	EQU	F4H
B5	EQU	F5H
B6	EQU	F6H
B7	EQU	F7H

;################################################################
;#								#
;#            EEPROM ADDRESS DEFINITIONS			#
;#								#
;################################################################
	
MAX_NV_ADD	EQU	63		;MAX EEPROM ADDRESS	
MAX_COD		EQU	32		;MAX DECODING
HRST_P		EQU	18		;&Y PARAMETER POINTER
TEL_TAB		EQU	39		;TABLE FOR DISPLAY TEL #
MAX_TEL_DIG	EQU	TEL_TAB-3	;DIGITS FOR EACH TEL #

	IFTRUE FOURPH
MAX_ADD	EQU	11			;ADDRESS LENGTH FOR EACH TEL #
TADD0	EQU	(63-4*MAX_ADD)		;TEL ADDRESS POINTER 0
TADD1	EQU	(63-3*MAX_ADD)		;TEL ADDRESS POINTER 1
TADD2	EQU	(63-2*MAX_ADD)		;TEL ADDRESS POINTER 2
TADD3	EQU	(63-1*MAX_ADD)		;TEL ADDRESS POINTER 3
	ENDIF
	IFTRUE FIVEPH
MAX_ADD	EQU	9			;ADDRESS LENGTH FOR EACH TEL #
TADD0	EQU	(63-5*MAX_ADD)		;TEL ADDRESS POINTER 0
TADD1	EQU	(63-4*MAX_ADD)		;TEL ADDRESS POINTER 1
TADD2	EQU	(63-3*MAX_ADD)		;TEL ADDRESS POINTER 2
TADD3	EQU	(63-2*MAX_ADD)		;TEL ADDRESS POINTER 3
TADD4	EQU	(63-1*MAX_ADD)		;TEL ADDRESS POINTER 4
	ENDIF
	IFTRUE ONEPH
MAX_ADD		EQU	12		;ADDRESS LENGTH FOR EACH TEL #
TADD0		EQU	21		;TEL #0
TADD1		EQU	21		;TEL #1
TADD2		EQU	21		;TEL #2
TADD3		EQU	21		;TEL #3
	ENDIF
	IFTRUE REMOTE
MAX_RM_ADD	EQU	13		;ADDRESS LENGTH FOR REMOTE ID
					;MAX_LENGTH = MAX_RM_ADD * 2
RM_IDA		EQU	(63-MAX_RM_ADD+1)
					;REMOTE ID#,  51 
RM_RNV		EQU	19		;REMOTE STATE PARAMETER
RM_RSNV		EQU	20		;REMOTE IDENTIFIER
	ENDIF
	END
