# $Log: pregasm.awk $
# Revision 1.2  1993/09/15  18:28:42  Mike_Lottridge
# enhance handling of inversions for labels
#

function process_inv( ){
  
  # count "!"
  # if odd # of "!" found, change "=" to "!="
  # if even # of "!", strip all of them out

  num_excl=split($0,dum,"!")-1;
  if ( (num_excl%2)==0)gsub("!",""); #even number of inversions
  else {                             #odd number of inversions
     gsub("!",""); # remove all "!"
     gsub("=","!=");
  }
}

BEGIN {
  cmt_re="^[ ]*\".*";   # reg expression for comment line
}

$0 ~ /.*=.*/ && $1 !~ cmt_re { process_inv(); # fix up any inversions 
}

{
  if ((NF == 3) && ($1 !~ cmt_re) && ($2 ~ /[Pp][Ii][Nn]/)) { 
     # this is a symbolic pin assignment of the form <name> pin <pin number>
     if($1 ~ /\!.*/)symbol[substr($1,2)]="!pin" $3;
     else symbol[$1]="pin " $3;
  
  }
  else if (($1 !~ cmt_re) && (($2 ~ /=|!=/)||($3 ~ /=|!=/))) {
     if ($1 in symbol) $1 = symbol[$1];   
     if ($3 in symbol) $3 = symbol[$3];
     if ($4 in symbol) $4 = symbol[$4];
     process_inv(); # process any new inversions that may have appeared
     print $0;
  }
  else print $0;


}
