;16 BIT BY 16 BIT DIVISION
;THIS ROUTINE PERFORMS THE BINARY DIVIDE OPERATION 
;ON A DIVIDEND AND DIVISOR (Y,Z). THE DIVIDEND IS   
;LOCATED IN MEMORY LOCATIONS 2 AND 3. DIVISOR IS
;LOCATED IN MEMORY LOCATIONS 0 AND 1. Q=Y/Z.
;THE MEMORY ASSIGNMENTS ARE AS FOLLOWS:
;
;	M(5)	M(4)	M(3)	M(2)	    
;	 0	 0	 Y	 Y	  
;      ------------------------------            
;	M(1)	M(0)
;	 Z	 Z
;WHEN THE ROUTINE IS THROUGH THE QUOTIENT WILL BE 
;WHERE THE DIVIDEND Y WAS AND THE REMAINDER WILL
;BE LOCATED IN MEMORY LOCATONS 4 AND 5. DIVISION 
;BY ZERO WILL RESULT IN THE QUOTIENT BEING ALL 1'S
;AND THE REMAINDER BEING THE Y ARGUMENT.
;
;
; EDITTED MAY 11, 1994 - REVISED FOR NEW ASSEMBLER (ASMCOP v4.2) 
;

	.TITLE  BCDDIV
	.CHIP	ANYCOP
        .SECT   MAIN,ROM,INPAGE

	CNTR=0FF
DIV:	LD	CNTR,#010	;INITIALIZE CNTR
	LD	B,#004		;FOR 16 COUNTS
	LD	[B+],#000	;PUT 0 IN M(5,4)
	LD	[B] ,#000
	LD	X,#004
LSHFT:	LD	B,#002		;LEFT SHIFT
	RC			;M(5,4,3,2)
LUP:	LD	A,[B]
	ADC	A,[B]
	X	A,[B+]
	IFBNE	#006
	JP	LUP
	IFC
	JP	SUBT
TSUBT:	LD	B,#000		;SUBTRACT AND TEST
	SC			;SUBTRACT Z FROM M(5,4)
	LD	A,[X+]
	SUBC	A,[B]
	LD	B,#001
	LD	A,[X-]
	SUBC	A,[B]
	IFNC
	JP	TEST
SUBT:	LD	B,#000		;SUBTRACT Z FROM M(5,4)
	LD	A,[X]
	SUBC	A,[B]
	X	A,[X+]
	LD	B,#001
	LD	A,[X]
	SUBC	A,[B]
	X	A,[X-]
	LD	B,#002
	SBIT	0,[B]
TEST:	DRSZ	CNTR		;DECREMENT CNTR
	JP 	LSHFT		;CNTR IS NOT 0
	RET

	.END
	