;
; WHITE NOISE COP800.
;
; TIE SERIAL INPUT (SI) PIN TO SERIAL OUTPUT (SO) PIN.
; OUTPUT IS ON THE SERIAL OUTPUT (SO) PIN.  
; NO INTERRUPT IS USED.	
; USE 20MHz XTAL, 1us INSTR CYCLE FOR THIS DEMO.
;
; WRITTEN BY: JERRY LEVENTER
; DATE:       OCTOBER 4, 1989
;
; EDITTED MAY 11, 1994 - REVISED FOR NEW ASSEMBLER (ASMCOP v4.2) 
;

	.TITLE NOISE8
	.CHIP	820
	.SECT  MAIN,ROM,INPAGE
;
	PORTGC	=   0D5 	; PORT G CONFIGURATION
	SIOR	=   0E9		; SERIAL SHIFT REGISTER	
	TMRLO	=   0EA 	; TIMER LOW BYTE
	TMRHI	=   0EB 	; TIMER HIGH BYTE
	TAULO	=   0EC 	; TIMER REGISTER LOW BYTE
	TAUHI	=   0ED 	; TIMER REGISTER HIGH BYTE
	CNTRL	=   0EE 	; CONTROL REGISTER
	PSW	=   0EF 	; PSW REGISTER
	BUSY	=   2		; BUSY BIT
;
; ****	SPECIAL REGISTERS AND CONSTANTS  ****
;	
	RNGVAL	=   002		; RANDOM NUMBER LOCATION
	LUPREG	=   0FF		; EXTRACTION RATE REGISTER
	FLAG	=   000		; RANDOM NUMBER BYTE FLAG
	COUNT	=   4		; EXTRACTION RATE CONSTANT
	NSLO	=   0FF		; TIMER VALUES
	NSHI	=   0FF
;
; ******************************
; ****  BEGIN PROGRAM HERE  ****
; ******************************
;
	LD	SP,#02F 	 ; DEFAULT INITIALIZATION OF SP
NOISE:	LD	PORTGC,#030	; SO AND SK AS OUTPUTS
	LD	CNTRL,#08B	; SK = DIV BY 8, TIMER RELOAD 
	SC			; INIT STAGE 1
	LD	B,#RNGVAL	; POINT TO RANDOM # LOCATION
	LD	[B+],#0FF	; INIT RING VAL TO ONE'S
	LD	[B],#0FF	; B POINTS TO UPPER BYTE 
	LD	TMRLO,#NSLO	; SET SUBROUTINE TIMEOUT 
	LD	TMRHI,#NSHI
	LD	TAULO,#NSLO
	LD	TAUHI,#NSHI
START:				; PLACE # IN SIOR AND
	X	A,SIOR		; START SHIFTING BITS
	SBIT	BUSY,PSW	; ONTO SERIAL OUTPUT PIN	
	LD	LUPREG,#004	; RESTORE EXTRACTION COUNT
;---------------------------------------------------------------
;    RING COUNTER (17 STAGE)
;    THIS IS A SEVENTEEN STAGE RING COUNTER (LINEAR
;    FEEDBACK SHIFT REGISTER) WITH THE RRC COMMAND.
;    THE COUNTER'S 14th AND 17th STAGES THROUGH AN             
;    EXCLUSIVE-OR SERVE AS THE FEEDBACK FUNCTION. 
;    THIS 14,17 RING COUNTER BREAKS DOWN INTO         
;    1 CYCLE OF [(2 ** 17) - 1] COUNTS.  SINCE THE EXCLUSIVE OR
;    OCCURS AFTER THE ROTATE, IT IS THE 15th AND CARRY
;    STAGES THAT ARE XOR'D (BIT 2 AND CARRY).
;
;			    STAGE
;			-------------
;    BEFORE ROTATE:	14   	17
;    AFTER ROTATE:	15	CARRY   
;
;    CARRY BIT = STAGE ONE
;    LOW ORDER BIT = STAGE 17 
;--------------------------------------------------------------     
;    
RING:	LD 	A,[B]		; GET RANDOM #
	RRC	A		; ROTATE UPPER BYTE	
	X	A,[B-]
	LD	A,[B]
	RRC	A		; ROTATE LOWER BYTE
	X	A,[B]
	LD	A,#004		; PERFORM XOR
	AND	A,[B]
	IFEQ	A,#000
	JP	LUPTST
	IFC
	JP	RC
	SC
	JP	LUPTST
RC:	RC
LUPTST:	LD	A,[B+]		; POINT TO UPPER BYTE
	DRSZ	LUPREG 		; EXTRACT THIS NUMBER ?
	JP	RING		; NO, KEEP ROTATING
	JMP	START		; YES 
	.END

