/*FILE: test10a.c
 *
 *DESCRIPTION:
 * This is a demonstration of how to perform asynchronous block memory
 * transfers between cooperating programs running on the ARM and on the PC.
 *
 *COMPILER:  Norcroft ARM C 1.31 Feb 17 1987
 *
 */


#include <stdio>
#include <ctype>

/* Compiler feature: norcrosys is a system header file but it cannot be found
 * using <>.  (Compiled under old ARM C compiler hence adfs file name) */
#include "$.arm.clib.h.nonansi.norcrosy"



/* Define TRUE and FALSE here.  */
typedef short	BOOL;		/* Short is 16 bits which is an int on the pc
							 * MWC compiler. */
#define TRUE	(BOOL)1
#define FALSE	(BOOL)0



main()
    {
	struct
		{
		BOOL					data_available;
		BOOL					work_done;
#   	define BUFF_LEN 		256
		char					string[BUFF_LEN];
		}	comms_area;

	unsigned int			int_buff[1];
#   define DONTCARE_INT 	0
	int						i;


	/* Initialise comms_area */
	comms_area.data_available = FALSE;
	comms_area.work_done = FALSE;
	for (i=0; i<BUFF_LEN; i++)	comms_area.string[i] = '\0';


    /* Send the address of the buffer (4 bytes) to PC. */

	/* An int is 32 bits and can hold a pointer. */
	int_buff[0] = (unsigned int)(&comms_area);
    _osfile(0, "PCMEM:", DONTCARE_INT, DONTCARE_INT, 
			(unsigned int)(int_buff), 
			(unsigned int)(int_buff) + 4);


	/* Poll,  waiting until the PC has finished sending the string. */
	while ( comms_area.data_available != TRUE ) /* Do nothing */;
	comms_area.data_available = FALSE;	/* Acknowledge */


    /* Change string to upper case. */
    for (i = 0; ( (comms_area.string[i] != '\0') && (i < BUFF_LEN) ); i++)
            comms_area.string[i] = toupper(comms_area.string[i]);


	/* Indicate that the work has been done. */
	comms_area.work_done = TRUE;


	/* Wait until the PC has read the converted string before exiting. */
	while ( comms_area.work_done == TRUE ) /* Do nothing */;
    }
