	title	"Debugger Constants"
	psect	code
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
; constants, data, and other trivia..
;
; normally at the end of rom
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

hextbl:	dcs	"0123456789abcdef"
vermsg:	dcs	"\r\nWings Dbgr 1.0\0"
prompt:	dcs	"\r\n*\0"
nulmsg:	dcs	"{null}\0"
offmsg:	dcs	"------ \0"
regmsg:	dcs	"\n\r    <pc>  <ac>  <ix>   "
	dcs	"<iy>  <dp> <sp> <ps>  "
	dcs	"<b0>   <b1>   <b2>   <b3>"
	dcs	"   <ss>\n\r   \0"
bpserr:	dcs	"\r\nCan't set bp there\r\n\0"
unkbkp: dcs	" Unknown brk\r\n\0"
	eject
;
;	the help message
;
hlpmsg:	dcs	"\n\r"
	dcs	" s       single step  "
	dcs	" p  continue from bkpt  "
	dcs	" g   load pc and jmp\n\r"
	dcs	" h    print help msg  "
	dcs	" /           open word  "
	dcs	" \         open byte\r\n"
	dcs	" ^         open prev  "
	dcs	" lf          open next  "
	dcs	" r      display regs\r\n\n"
	dcs	" ;b      reset bkpts  "
	dcs	" <adr>;b    set bkpt 0\n\r"
	dcs	" ;nb    reset bkpt n  "
	dcs	" <adr>;nb    set bpt n\r\n\n"
	dcs	" <val>;a      ld acc  "
	dcs	" <val>;x    ld index x  "
	dcs	" <val>;y  ld index y\n\r"
	dcs	" <val>;s  ld stk ptr  "
	dcs	" <val>;p    ld pgm ctr  "
	dcs	" <val>;z  ld dir reg\n\r"
	dcs	" <val>;d  ld dat bnk  "
	dcs	" <val>;k    ld pgm bnk  "
	dcs	" <val>;f      ld psw\n\r"
	dcs	" <adr>;r    reset regs\0"

;		  pc ac  ix  iy dp sp  ps
regfmt: dcs	"%la %x %la %la %x %x  %b  \0"
opnwfmt:	dcs	"%la %x \0"
opnbfmt:	dcs	"%la %b \0"
addfmt:	dcs	" %la  \0"

	end
