	title	"Debugger Ram"
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
;	Debugger read/write data
;
;	Note:
;	The debugger sets the direct page register to
;	point to this data, so it should be page aligned
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

	psect	dirpg
;
;	breakpoint table
;	4 user breakpoints
;
;	breakpoint 5 is for single stepping
;
;	each entry is a 24 bit address
;	(longword aligned)
;
bkptbl:	struct	quad	; bp0
	struct	quad	; bp1
	struct	quad	; bp2
	struct	quad	; bp3
	struct	quad	; sstep bkpt (bp4)
;
;	breakpoint counts
;	number of times to execute a proceed or
;	single step (1-65536)
;
bkpcnt:	struct	word	; bp0
	struct	word	; bp1
	struct	word	; bp2
	struct	word	; bp3
	struct	word	; sstep
;
;	breakpoint values
;	this is where we store the byte replaced by
;	the brk instruction
;
bkpval:	struct	byte	; bp0
	struct	byte	; bp1
	struct	byte	; bp2
	struct	byte	; bp3
	struct	byte	; sstep
;
;	The context of the process being debugged is
;	saved here.
;	Regs are on word boundaries to make loading
;	unloading easier in 16 bit mode
;
spc:	struct	word	; saved pgm counter
spb:	struct	word	; saved pgm bank reg
sac:	struct	word	; saved accumulator
six:	struct	word	; saved ix
siy:	struct	word	; saved iy
sdp:	struct	word	; saved direct page reg
ssp:	struct	word	; saved stack pointer
sps:	struct	word	; saved processor status
sdb:	struct	word	; saved data bank reg

;
daccum:	struct	quad	; digit accumulator
digcnt:	struct	word	; number of valid digits in daccum

curadr:	struct	quad	; currently open adr
onebyt:	struct	byte	; 1=byte adr 0=word adr

bptnum:	struct	word	; ff = use next bp, 0-4 = bp #

dbgsp:	struct	word	; saved value of the dbg sp
dbgdpr:	struct	word	; saved value of the dbg dpr
dbgpbk:	struct	word	; saved value of the dbgr pgm/data bank regs.
dirlen:	ends		; total length of ram used
