	title	"Opcode Disassembly Tables"
	psect	code
;
;	65816 opcode length / name table
;
;	00 = implied		1 byte
;	01 = a			1 byte
;	02 = <dir		2 bytes
;	03 = <dir,x		2 bytes
;	04 = <dir,y		2 bytes
;	05 = (<dir)		2 bytes
;	06 = (<dir),y		2 bytes
;	07 = (<dir,x)		2 bytes
;	08 = [<dir]		2 bytes
;	09 = [<dir],y		2 bytes
;	10 = offset,s		2 bytes
;	11 = (offset,s),y	2 bytes
;	12 = abs		3 bytes
;	13 = abs,x		3 bytes
;	14 = abs,y		3 bytes
;	15 = (abs)		3 bytes
;	16 = (abs,x)		3 bytes
;	17 = rel8		2 bytes
;	18 = rel16		3 bytes
;	19 = >dbr,adr		4 bytes
;	20 = >dbr,adr,x		4 bytes
;	21 = #imm		2 bytes
;	22 = #imm or ##imm	2(3) bytes based on M
;	23 = #imm or ##imm	2(3) bytes based on X
;	24 = >src,>dst		3 bytes
;

;
;	table of operand lengths
;
opclen::
		dcb	1	; implied
		dcb	1	; accumulator
		dcb	2	; <dir
		dcb	2	; <dir,x
		dcb	2	; <dir,y
		dcb	2	; (<dir)
		dcb	2	; (<dir),y
		dcb	2	; (<dir,x)
		dcb	2	; [<dir]
		dcb	2	; [<dir],y
		dcb	2	; offset,s
		dcb	2	; (offset,s),y
		dcb	3	; abs
		dcb	3	; abs,x
		dcb	3	; abs,y
		dcb	3	; (abs)
		dcb	3	; (abs,x)
		dcb	2	; rel8
		dcb	3	; rel16
		dcb	4	; >dbr,adr
		dcb	4	; >dbr,adr,x
		dcb	2	; #imm
		dcb	0x82	; #imm based on M
		dcb	0xc2	; #imm based on X
		dcb	3	; >src,>dst

;
;	operand type table
;
opctyp::

$impl	equ	0
$accum	equ	1
$dp	equ	2
$dpix	equ	3
$dpiy	equ	4
$dpin	equ	5
$dpiniy	equ	6
$dpixin	equ	7
$dpinl	equ	8
$dpiliy	equ	9
$skr	equ	10
$skriiy	equ	11
$abs	equ	12
$absix	equ	13
$absiy	equ	14
$absin	equ	15
$absixi	equ	16
$rel8	equ	17
$rel16	equ	18
$absl	equ	19
$abslix	equ	20
$immed2	equ	21
$accimm	equ	22
$idximm	equ	23
$blkm	equ	24


;
; indices for all of the opcode names
;

$adc_nm		equ	0
$and_nm		equ	1
$asl_nm		equ	2
$bcc_nm		equ	3
$bcs_nm		equ	4
$beq_nm		equ	5
$bit_nm		equ	6
$bmi_nm		equ	7
$bne_nm		equ	8
$bpl_nm		equ	9
$bra_nm		equ	10
$brk_nm		equ	11
$brl_nm		equ	12
$bvc_nm		equ	13
$bvs_nm		equ	14
$clc_nm		equ	15
$cld_nm		equ	16
$cli_nm		equ	17
$clv_nm		equ	18
$cmp_nm		equ	19
$cop_nm		equ	20
$cpx_nm		equ	21
$cpy_nm		equ	22
$dec_nm		equ	23
$dex_nm		equ	24
$dey_nm		equ	25
$eor_nm		equ	26
$inc_nm		equ	27
$inx_nm		equ	28
$iny_nm		equ	29
$jml_nm		equ	30
$jmp_nm		equ	31
$jsl_nm		equ	32
$jsr_nm		equ	33
$lda_nm		equ	34
$ldx_nm		equ	35
$ldy_nm		equ	36
$lsl_nm		equ	37
$lsr_nm		equ	38
$mvn_nm		equ	39
$mvp_nm		equ	40
$nop_nm		equ	41
$ora_nm		equ	42
$pea_nm		equ	43
$pei_nm		equ	44
$per_nm		equ	45
$pha_nm		equ	46
$phb_nm		equ	47
$phd_nm		equ	48
$phk_nm		equ	49
$php_nm		equ	50
$phx_nm		equ	51
$phy_nm		equ	52
$pla_nm		equ	53
$plb_nm		equ	54
$pld_nm		equ	55
$plp_nm		equ	56
$plx_nm		equ	57
$ply_nm		equ	58
$rep_nm		equ	59
$rol_nm		equ	60
$ror_nm		equ	61
$rti_nm		equ	62
$rtl_nm		equ	63
$rts_nm		equ	64
$sbc_nm		equ	65
$sec_nm		equ	66
$sed_nm		equ	67
$sei_nm		equ	68
$sep_nm		equ	69
$sta_nm		equ	70
$stp_nm		equ	71
$stx_nm		equ	72
$sty_nm		equ	73
$stz_nm		equ	74
$tax_nm		equ	75
$tay_nm		equ	76
$tcd_nm		equ	77
$tcs_nm		equ	78
$tdc_nm		equ	79
$trb_nm		equ	80
$tsb_nm		equ	81
$tsc_nm		equ	82
$tsx_nm		equ	83
$txa_nm		equ	84
$txs_nm		equ	85
$txy_nm		equ	86
$tya_nm		equ	87
$tyx_nm		equ	88
$wai_nm		equ	89
$xba_nm		equ	90
$xce_nm		equ	91
$wdm_nm		equ	92

	dcb	$impl		; 00 = brk
	dcb	$brk_nm

	dcb	$dpixin		; 01 = ora (<dir,x)
	dcb	$ora_nm

	dcb	$impl		; 02 = cop
	dcb	$cop_nm

	dcb	$skr		; 03 = ora offset,s
	dcb	$ora_nm

	dcb	$dp		; 04 = tsb <dir
	dcb	$tsb_nm

	dcb	$dp		; 05 = ora <dir
	dcb	$ora_nm

	dcb	$dp		; 06 = asl <dir
	dcb	$asl_nm

	dcb	$dpinl		; 07 = ora [<dir]
	dcb	$ora_nm

	dcb	$impl		; 08 = php
	dcb	$php_nm

	dcb	$accimm		; 09 = ora #imm (##imm)
	dcb	$ora_nm

	dcb	$accum		; 0a = asl a
	dcb	$asl_nm

	dcb	$impl		; 0b = phd
	dcb	$phd_nm

	dcb	$abs		; 0c = tsb abs
	dcb	$tsb_nm

	dcb	$abs		; 0d = ora abs
	dcb	$ora_nm

	dcb	$abs		; 0e = asl abs
	dcb	$asl_nm

	dcb	$absl		; 0f = ora >dbr,adr
	dcb	$ora_nm

	dcb	$rel8		; 10 = bpl rel8
	dcb	$bpl_nm

	dcb	$dpiniy		; 11 = ora (<dir),y
	dcb	$ora_nm

	dcb	$dpin		; 12 = ora (<dir)
	dcb	$ora_nm

	dcb	$skriiy		; 13 = ora (offset,s),y
	dcb	$ora_nm

	dcb	$dp		; 14 = trb <dir
	dcb	$trb_nm

	dcb	$dpix		; 15 = ora <dir,x
	dcb	$ora_nm

	dcb	$dpix		; 16 = asl <dir,x
	dcb	$asl_nm

	dcb	$dpiliy		; 17 = ora [<dir],y
	dcb	$ora_nm

	dcb	$impl		; 18 = clc
	dcb	$clc_nm

	dcb	$absiy		; 19 = ora abs,y
	dcb	$ora_nm

	dcb	$accum		; 1a = inc a
	dcb	$inc_nm

	dcb	$impl		; 1b = tcs
	dcb	$tcs_nm

	dcb	$abs		; 1c = trb abs
	dcs	$trb_nm

	dcb	$absix		; 1d = ora abs,x
	dcb	$ora_nm

	dcb	$absix		; 1e = asl abs,x
	dcb	$asl_nm

	dcb	$abslix		; 1f = ora >pbr,abs,x
	dcb	$ora_nm

	dcb	$abs		; 20 = jsr abs
	dcb	$jsr_nm

	dcb	$dpixin		; 21 = and (<dir,x)
	dcb	$and_nm

	dcb	$absl		; 22 = jsl >pbr,abs
	dcb	$jsl_nm

	dcb	$skr		; 23 = and offset,s
	dcb	$and_nm

	dcb	$dp		; 24 = bit <dir
	dcb	$bit_nm

	dcb	$dp		; 25 = and <dir
	dcb	$and_nm

	dcb	$dp		; 26 = rol <dir
	dcb	$rol_nm

	dcb	$dpinl		; 27 = and [<dir]
	dcb	$and_nm

	dcb	$impl		; 28 = plp
	dcb	$plp_nm

	dcb	$accimm		; 29 = and #imm (##imm)
	dcb	$and_nm

	dcb	$accum		; 2a = rol a
	dcb	$rol_nm

	dcb	$impl		; 2b = pld
	dcb	$pld_nm

	dcb	$abs		; 2c = bit abs
	dcb	$bit_nm

	dcb	$abs		; 2d = and abs
	dcb	$and_nm

	dcb	$abs		; 2e = rol abs
	dcb	$rol_nm

	dcb	$absl		; 2f = and >dbr,abs
	dcb	$and_nm

	dcb	$rel8		; 30 = bmi rel8
	dcb	$bmi_nm

	dcb	$dpiniy		; 31 = and (<dir),y
	dcb	$and_nm

	dcb	$dpin		; 32 = and (<dir)
	dcb	$and_nm

	dcb	$skriiy		; 33 = and (offset,s),y
	dcb	$and_nm

	dcb	$dpix		; 34 = bit <dir,x
	dcb	$bit_nm

	dcb	$dpix		; 35 = and <dir,x
	dcb	$and_nm

	dcb	$dpix		; 36 = rol <dir,x
	dcb	$rol_nm

	dcb	$dpiliy		; 37 = and [<dir],y
	dcb	$and_nm

	dcb	$impl		; 38 = sec
	dcb	$sec_nm

	dcb	$absiy		; 39 = and abs,y
	dcb	$and_nm

	dcb	$accum		; 3a = dec a
	dcb	$dec_nm

	dcb	$impl		; 3b = tsc
	dcb	$tsc_nm

	dcb	$absix		; 3c = bit abs,x
	dcb	$bit_nm

	dcb	$absix		; 3d = and abs,x
	dcb	$and_nm

	dcb	$absix		; 3e = rol abs,x
	dcb	$rol_nm

	dcb	$absix		; 3f = and >dbr,adr,x
	dcb	$and_nm

	dcb	$impl		; 40 = rti
	dcb	$rti_nm

	dcb	$dpixin		; 41 = eor (<dir,x)
	dcb	$eor_nm

	dcb	$impl		; 42 = <wdm reserved>
	dcb	$wdm_nm

	dcb	$skr		; 43 = eor offset,s
	dcb	$eor_nm

	dcb	$blkm		; 44 = mvp >src,>dst
	dcb	$mvp_nm

	dcb	$dp		; 45 = eor <dir
	dcb	$eor_nm

	dcb	$dp		; 46 = lsl <dir
	dcb	$lsl_nm

	dcb	$dpinl		; 47 = eor [<dir]
	dcb	$eor_nm

	dcb	$impl		; 48 = pha
	dcb	$pha_nm

	dcb	$accimm		; 49 = eor #imm (##imm)
	dcb	$eor_nm

	dcb	$accum		; 4a = lsr a
	dcb	$lsr_nm

	dcb	$impl		; 4b = phk
	dcb	$phk_nm

	dcb	$abs		; 4c = jmp abs
	dcb	$jmp_nm

	dcb	$abs		; 4d = eor abs
	dcb	$eor_nm

	dcb	$abs		; 4e = lsr abs
	dcb	$lsr_nm

	dcb	$absl		; 4f = eor >dbr,adr
	dcb	$eor_nm

	dcb	$rel8		; 50 = bvc rel8
	dcb	$bvc_nm

	dcb	$dpiniy		; 51 = eor (<dir),y
	dcb	$eor_nm

	dcb	$dpin		; 52 = eor (<dir)
	dcb	$eor_nm

	dcb	$skriiy		; 53 = eor (offset,s),y
	dcb	$eor_nm

	dcb	$blkm		; 54 = mvn >src,>dst
	dcb	$mvn_nm

	dcb	$dpix		; 55 = eor <dir,x
	dcb	$eor_nm

	dcb	$dpix		; 56 = lsl <dir,x
	dcb	$lsl_nm

	dcb	$dpiliy		; 57 = eor [<dir],y
	dcb	$eor_nm

	dcb	$impl		; 58 = cli
	dcb	$cli_nm

	dcb	$absiy		; 59 = eor abs,y
	dcb	$eor_nm

	dcb	$impl		; 5a = phy
	dcb	$phy_nm

	dcb	$impl		; 5b = tcd
	dcb	$tcd_nm

	dcb	$absl		; 5c = jmp >pbr,abs
	dcb	$jmp_nm

	dcb	$absix		; 5d = eor abs,x
	dcb	$eor_nm

	dcb	$absix		; 5e = lsr abs,x
	dcb	$lsr_nm

	dcb	$absix		; 5f = eor >dbr,adr,x
	dcb	$eor_nm

	dcb	$impl		; 60 = rts
	dcb	$rts_nm

	dcb	$dpixin		; 61 = adc (<dir,x)
	dcb	$adc_nm

	dcb	$rel16		; 62 = per rel16
	dcb	$per_nm

	dcb	$skr		; 63 = adc offset,s
	dcb	$adc_nm

	dcb	$dp		; 64 = stz <dir
	dcb	$stz_nm

	dcb	$dp		; 65 = adc <dir
	dcb	$adc_nm

	dcb	$dp		; 66 = ror <dir
	dcb	$ror_nm

	dcb	$dpinl		; 67 = adc [<dir]
	dcb	$adc_nm

	dcb	$impl		; 68 = pla
	dcb	$pla_nm

	dcb	$accimm		; 69 = adc #imm (##imm)
	dcb	$adc_nm

	dcb	$accum		; 6a = ror a
	dcb	$ror_nm

	dcb	$impl		; 6b = rtl
	dcb	$rtl_nm

	dcb	$absin		; 6c = jmp (abs)
	dcb	$jmp_nm

	dcb	$abs		; 6d = adc abs
	dcb	$adc_nm

	dcb	$abs		; 6e = ror abs
	dcb	$ror_nm

	dcb	$absl		; 6f = adc >dbr,adr
	dcb	$adc_nm

	dcb	$rel8		; 70 = bvs rel8
	dcb	$bvs_nm

	dcb	$dpiniy		; 71 = adc (<dir),y
	dcb	$adc_nm

	dcb	$dpin		; 72 = adc (<dir)
	dcb	$adc_nm

	dcb	$skriiy		; 73 = adc (offset,s),y
	dcb	$adc_nm

	dcb	$dpix		; 74 = stz <dir,x
	dcb	$stz_nm

	dcb	$dpix		; 75 = adc <dir,x
	dcb	$adc_nm

	dcb	$dpix		; 76 = ror <dir,x
	dcb	$ror_nm

	dcb	$dpiniy		; 77 = adc [<dir],y
	dcb	$adc_nm

	dcb	$impl		; 78 = sei
	dcb	$sei_nm

	dcb	$absiy		; 79 = adc abs,y
	dcb	$adc_nm

	dcb	$impl		; 7a = ply
	dcb	$ply_nm

	dcb	$impl		; 7b = tdc
	dcb	$tdc_nm

	dcb	$absixi		; 7c = jmp (abs,x)
	dcb	$jmp_nm

	dcb	$absix		; 7d = adc abs,x
	dcb	$adc_nm

	dcb	$absix		; 7e = ror abs,x
	dcb	$ror_nm

	dcb	$abslix		; 7f = adc >dbr,adr,x
	dcb	$adc_nm

	dcb	$rel8		; 80 = bra rel8
	dcb	$bra_nm

	dcb	$dpixin		; 81 = sta (<dir,x)
	dcb	$sta_nm

	dcb	$rel16		; 82 = brl rel16
	dcb	$brl_nm

	dcb	$skr		; 83 = sta offset,s
	dcb	$sta_nm

	dcb	$dp		; 84 = sty <dir
	dcb	$sty_nm

	dcb	$dp		; 85 = sta <dir
	dcb	$sta_nm

	dcb	$dp		; 86 = stx <dir
	dcb	$stx_nm

	dcb	$dpinl		; 87 = sta [<dir]
	dcb	$sta_nm

	dcb	$impl		; 88 = dey
	dcb	$dey_nm

	dcb	$accimm		; 89 = bit #imm (##imm)
	dcb	$bit_nm

	dcb	$impl		; 8a = txa
	dcb	$txa_nm

	dcb	$impl		; 8b = phb
	dcb	$phb_nm

	dcb	$abs		; 8c = sty abs
	dcb	$sty_nm

	dcb	$abs		; 8d = sta abs
	dcb	$sta_nm

	dcb	$abs		; 8e = stx abs
	dcb	$stx_nm

	dcb	$absl		; 8f = sta >dbr,adr
	dcb	$sta_nm

	dcb	$rel8		; 90 = bcc rel8
	dcb	$bcc_nm

	dcb	$dpiniy		; 91 = sta (<dir),y
	dcb	$sta_nm

	dcb	$dpin		; 92 = sta (<dir)
	dcb	$sta_nm

	dcb	$skriiy		; 93 = sta (offset,s),y
	dcb	$sta_nm

	dcb	$dpix		; 94 = sty <dir,x
	dcb	$sty_nm

	dcb	$dpix		; 95 = sta <dir,x
	dcb	$sta_nm

	dcb	$dpiy		; 96 = stx <dir,y
	dcb	$stx_nm

	dcb	$dpiliy		; 97 = sta [<dir],y
	dcb	$sta_nm

	dcb	$impl		; 98 = tya
	dcb	$tya_nm

	dcb	$absiy		; 99 = sta abs,y
	dcb	$sta_nm

	dcb	$impl		; 9a = txs
	dcb	$txs_nm

	dcb	$impl		; 9b = txy
	dcb	$txy_nm

	dcb	$abs		; 9c = stz abs
	dcb	$stz_nm

	dcb	$absix		; 9d = sta abs,x
	dcb	$sta_nm

	dcb	$absix		; 9e = stz abs,x
	dcb	$stz_nm

	dcb	$abslix		; 9f = sta >dbr,adr,x
	dcb	$sta_nm

	dcb	$idximm		; a0 = ldy #imm (##imm)
	dcb	$ldy_nm

	dcb	$dpixin		; a1 = lda (<dir,x)
	dcb	$lda_nm

	dcb	$idximm		; a2 = ldx #imm (##imm)
	dcb	$ldx_nm

	dcb	$skr		; a3 = lda offset,s
	dcb	$lda_nm

	dcb	$dp		; a4 = ldy <dir
	dcb	$ldy_nm

	dcb	$dp		; a5 = lda <dir
	dcb	$lda_nm

	dcb	$dp		; a6 = ldx <dir
	dcb	$ldx_nm

	dcb	$dpinl		; a7 = lda [<dir]
	dcb	$lda_nm

	dcb	$impl		; a8 = tay
	dcb	$tay_nm

	dcb	$accimm		; a9 = lda #imm (##imm)
	dcb	$lda_nm

	dcb	$impl		; aa = tax
	dcb	$tax_nm

	dcb	$impl		; ab = plb
	dcb	$plb_nm

	dcb	$abs		; ac = ldy abs
	dcb	$ldy_nm

	dcb	$abs		; ad = lda abs
	dcb	$lda_nm

	dcb	$abs		; ae = ldx abs
	dcb	$ldx_nm

	dcb	$absl		; af = lda >dbr,adr
	dcb	$lda_nm

	dcb	$rel8		; b0 = bcs rel8
	dcb	$bcs_nm

	dcb	$dpiniy		; b1 = lda (<dir),y
	dcb	$lda_nm

	dcb	$dpin		; b2 = lda (<dir)
	dcb	$lda_nm

	dcb	$skriiy		; b3 = lda (offset,s),y
	dcb	$lda_nm

	dcb	$dpix		; b4 = ldy <dir,x
	dcb	$ldy_nm

	dcb	$dpix		; b5 = lda <dir,x
	dcb	$lda_nm

	dcb	$dpiy		; b6 = ldx <dir,y
	dcb	$ldx_nm

	dcb	$dpiliy		; b7 = lda [<dir],y
	dcb	$lda_nm

	dcb	$impl		; b8 = clv
	dcb	$clv_nm

	dcb	$absiy		; b9 = lda abs,y
	dcb	$lda_nm

	dcb	$impl		; ba = tsx
	dcb	$tsx_nm

	dcb	$impl		; bb = tyx
	dcb	$tyx_nm

	dcb	$absix		; bc = ldy abs,x
	dcb	$ldy_nm

	dcb	$absix		; bd = lda abs,x
	dcb	$lda_nm

	dcb	$absiy		; be = ldx abs,y
	dcb	$ldx_nm

	dcb	$abslix		; bf = lda >dbr,adr,x
	dcb	$lda_nm

	dcb	$idximm		; c0 = cpy #imm (##imm)
	dcb	$cpy_nm

	dcb	$dpixin		; c1 = cmp (<dir,x)
	dcb	$cmp_nm

	dcb	$immed2		; c2 = rep #imm
	dcb	$rep_nm

	dcb	$dpix		; c3 = cmp <dir,x
	dcb	$cmp_nm

	dcb	$dp		; c4 = cpy <dir
	dcb	$cpy_nm

	dcb	$dp		; c5 = cmp <dir
	dcb	$cmp_nm

	dcb	$dp		; c6 = dec <dir
	dcb	$dec_nm

	dcb	$dpinl		; c7 = cmp [<dir]
	dcb	$cmp_nm

	dcb	$impl		; c8 = iny
	dcb	$iny_nm

	dcb	$accimm		; c9 = cmp #imm (##imm)
	dcb	$cmp_nm

	dcb	$impl		; ca = dex
	dcb	$dex_nm

	dcb	$impl		; cb = wai
	dcb	$wai_nm

	dcb	$abs		; cc = cpy abs
	dcb	$cpy_nm

	dcb	$abs		; cd = cmp abs
	dcb	$cmp_nm

	dcb	$abs		; ce = dec abs
	dcb	$dec_nm

	dcb	$absl		; cf = cmp >dbr,adr
	dcb	$cmp_nm

	dcb	$rel8		; d0 = bne rel8
	dcb	$bne_nm

	dcb	$dpiniy		; d1 = cmp (<dir),y
	dcb	$cmp_nm

	dcb	$dpin		; d2 = cmp (<dir)
	dcb	$cmp_nm

	dcb	$skriiy		; d3 = cmp (offset,s),y
	dcb	$cmp_nm

	dcb	$dp		; d4 = pei <dir
	dcb	$pei_nm

	dcb	$dpix		; d5 = cmp <dir,x
	dcb	$cmp_nm

	dcb	$dpix		; d6 = dec <dir,x
	dcb	$dec_nm

	dcb	$dpiliy		; d7 = cmp [<dir],y
	dcb	$cmp_nm

	dcb	$impl		; d8 = cld
	dcb	$cld_nm

	dcb	$absiy		; d9 = cmp abs,y
	dcb	$cmp_nm

	dcb	$impl		; da = phx
	dcb	$phx_nm

	dcb	$impl		; db = stp
	dcb	$stp_nm

	dcb	$absin		; dc = jml (abs)
	dcb	$jml_nm

	dcb	$absix		; dd = cmp abs,x
	dcb	$cmp_nm

	dcb	$absix		; de = dec abs,x
	dcb	$dec_nm

	dcb	$abslix		; df = cmp >dbr,adr,x
	dcb	$cmp_nm

	dcb	$idximm		; e0 = cpx #imm (##imm)
	dcb	$cpx_nm

	dcb	$dpixin		; e1 = sbc (<dir,x)
	dcb	$sbc_nm

	dcb	$immed2		; e2 = sep #imm
	dcb	$sep_nm

	dcb	$skr		; e3 = sbc offset,s
	dcb	$sbc_nm

	dcb	$dp		; e4 = cpx <dir
	dcb	$cpx_nm

	dcb	$dp		; e5 = sbc <dir
	dcb	$sbc_nm

	dcb	$dp		; e6 = inc <dir
	dcb	$inc_nm

	dcb	$dpinl		; e7 = sbc [<dir]
	dcb	$sbc_nm

	dcb	$impl		; e8 = inx
	dcb	$inx_nm

	dcb	$accimm		; e9 = sbc #imm (##imm)
	dcb	$sbc_nm

	dcb	$impl		; ea = nop
	dcb	$nop_nm

	dcb	$impl		; eb = xba
	dcb	$xba_nm

	dcb	$abs		; ec = cpx abs
	dcb	$cpx_nm

	dcb	$abs		; ed = sbc abs
	dcb	$sbc_nm

	dcb	$abs		; ee = inc abs
	dcb	$inc_nm

	dcb	$absl		; ef = sbc >dbr,adr
	dcb	$sbc_nm

	dcb	$rel8		; f0 = beq rel8
	dcb	$beq_nm

	dcb	$dpiniy		; f1 = sbc (<dir),y
	dcb	$sbc_nm

	dcb	$dpin		; f2 = sbc (<dir)
	dcb	$sbc_nm

	dcb	$skriiy		; f3 = sbc (offset,s),y
	dcb	$sbc_nm

	dcb	$abs		; f4 = pea abs
	dcb	$pea_nm

	dcb	$dpix		; f5 = sbc <dir,x
	dcb	$sbc_nm

	dcb	$dpix		; f6 = inc <dir,x
	dcb	$inc_nm

	dcb	$dpiliy		; f7 = sbc [<dir],y
	dcb	$sbc_nm

	dcb	$impl		; f8 = sed
	dcb	$sed_nm

	dcb	$absiy		; f9 = sbc abs,y
	dcb	$sbc_nm

	dcb	$impl		; fa = plx
	dcb	$plx_nm

	dcb	$impl		; fb = xce
	dcb	$xce_nm

	dcb	$absixi		; fc = jsr (abs,x)
	dcb	$jsr_nm

	dcb	$absix		; fd = sbc abs,x
	dcb	$sbc_nm

	dcb	$absix		; fe = inc abs,x
	dcb	$inc_nm

	dcb	$abslix		; ff = sbc >dbr,adr,x
	dcb	$sbc_nm


;
;	alpha names for the opcodes
;
opcnam::

	dcs	"adc\0"		; 0
	dcs	"and\0"		; 1
	dcs	"asl\0"		; 2
	dcs	"bcc\0"		; 3
	dcs	"bcs\0"		; 4
	dcs	"beq\0"		; 5
	dcs	"bit\0"		; 6
	dcs	"bmi\0"		; 7
	dcs	"bne\0"		; 8
	dcs	"bpl\0"		; 9
	dcs	"bra\0"		; 10
	dcs	"brk\0"		; 11
	dcs	"brl\0"		; 12
	dcs	"bvc\0"		; 13
	dcs	"bvs\0"		; 14
	dcs	"clc\0"		; 15
	dcs	"cld\0"		; 16
	dcs	"cli\0"		; 17
	dcs	"clv\0"		; 18
	dcs	"cmp\0"		; 19
	dcs	"cop\0"		; 20
	dcs	"cpx\0"		; 21
	dcs	"cpy\0"		; 22
	dcs	"dec\0"		; 23
	dcs	"dex\0"		; 24
	dcs	"dey\0"		; 25
	dcs	"eor\0"		; 26
	dcs	"inc\0"		; 27
	dcs	"inx\0"		; 28
	dcs	"iny\0"		; 29
	dcs	"jml\0"		; 30
	dcs	"jmp\0"		; 31
	dcs	"jsl\0"		; 32
	dcs	"jsr\0"		; 33
	dcs	"lda\0"		; 34
	dcs	"ldx\0"		; 35
	dcs	"ldy\0"		; 36
	dcs	"lsl\0"		; 37
	dcs	"lsr\0"		; 38
	dcs	"mvn\0"		; 39
	dcs	"mvp\0"		; 40
	dcs	"nop\0"		; 41
	dcs	"ora\0"		; 42
	dcs	"pea\0"		; 43
	dcs	"pei\0"		; 44
	dcs	"per\0"		; 45
	dcs	"pha\0"		; 46
	dcs	"phb\0"		; 47
	dcs	"phd\0"		; 48
	dcs	"phk\0"		; 49
	dcs	"php\0"		; 50
	dcs	"phx\0"		; 51
	dcs	"phy\0"		; 52
	dcs	"pla\0"		; 53
	dcs	"plb\0"		; 54
	dcs	"pld\0"		; 55
	dcs	"plp\0"		; 56
	dcs	"plx\0"		; 57
	dcs	"ply\0"		; 58
	dcs	"rep\0"		; 59
	dcs	"rol\0"		; 60
	dcs	"ror\0"		; 61
	dcs	"rti\0"		; 62
	dcs	"rtl\0"		; 63
	dcs	"rts\0"		; 64
	dcs	"sbc\0"		; 65
	dcs	"sec\0"		; 66
	dcs	"sed\0"		; 67
	dcs	"sei\0"		; 68
	dcs	"sep\0"		; 69
	dcs	"sta\0"		; 70
	dcs	"stp\0"		; 71
	dcs	"stx\0"		; 72
	dcs	"sty\0"		; 73
	dcs	"stz\0"		; 74
	dcs	"tax\0"		; 75
	dcs	"tay\0"		; 76
	dcs	"tcd\0"		; 77
	dcs	"tcs\0"		; 78
	dcs	"tdc\0"		; 79
	dcs	"trb\0"		; 80
	dcs	"tsb\0"		; 81
	dcs	"tsc\0"		; 82
	dcs	"tsx\0"		; 83
	dcs	"txa\0"		; 84
	dcs	"txs\0"		; 85
	dcs	"txy\0"		; 86
	dcs	"tya\0"		; 87
	dcs	"tyx\0"		; 88
	dcs	"wai\0"		; 89
	dcs	"xba\0"		; 90
	dcs	"xce\0"		; 91
	dcs	"wdm\0"		; 92

	title	"65816 Disassembler"
;
;	disassemble the instruction pointed
;	to by the currently open address
;

	title	"65816 Disassembler"
;
;	Disassemble the instruction pointed
;	to by the currently open address.
;	In the case of #imm or ##imm instructions
;	the disassembly may be incorrect, since
;	the psw when the instruction is executed
;	isn't known (except when single stepping).
;

dasm:
	php			; preserve caller's status
	rep	#0x30		; 16 bit memory/idx
	pei	<curadr		; preserve this for debugger
	lda	[<curadr]	; get opcode	
	and	##0xff		; save only the opcode
;
;	check for bsr/brl pseudo instruction
;	bsr == per 01 00 bra <byte> <next instruction>
;	bsl == per 02 00 brl <word> <next instruction>
;
	cmp	##0x62		; per?
	beq	$per		; yup
	brl	$ckrest

$per:
	ldx	##80		; load bra opcode - assume bsr
	ldy	##1		; point to per offset
	lda	[<curadr],y	; get offset
	cmp	##1		; per 1 ?
	beq	$1		; per 1, bsr if next op is bra
	ldx	##0x82		; load x with brl opcode - bsl
	cmp	##2		; per 2 ?
	beq	$1		; per 2, bsl if next op is brl
	brl	$per2		; not bsr/bsl - go check rest

$1:	iny			; point to next opcode
	iny
	txa			; get bra/brl in acc
	eor	[<curadr],y	; see if next op is = acc
	and	##0xff		; only care about low byte
	bne	$per2		; not bsr/brl, go check rest
	
;
;	this is really a bsr or bsl, depending on x reg (bra/brl)
;
	clc			; point curadr to branch offset
	lda	<curadr		; for further processing
	adc	##4
	sta	<curadr

	cpx	##80		; bra ?
	bne	$2

	per	bsrfmt		; output "bsr "
	bsl	putstr
	brl	$rel8		; go output branch address
$2
	per	bslfmt
	bsl	putstr		; output "bsl "
	brl	$rel16		; finish up by outputting bra addr.

$per2:
	lda	##0x62		;restore opcode
;
;	check the rest of the possibilites
;

$ckrest:
	asl	a
	tay
	per	opctyp
	lda	(1,s),y		; get entry for this opcode
	plx			; pop off the base adr

	pha			; save copy for later
	xba			; get type index
	and	##0xff
	asl	a
	asl	a		; mult * 4
	per	opcnam
	clc
	adc	1,s		; calculate adr of name
	plx			; pop opcnam
	pha			; push adr onto stack
	bsl	putstr		; output the opcode
	bsl	putsp

	inc	<curadr		; point pc past opcode

	pla			; get the opcode
	and	##0xff		; mask off high byte

	cmp	##0
	bne	$acc		; implied?
	brl	$999		; output crlf, return to debugger

$acc:	cmp	##1		; a?
	bne	$rest
	lda	##'a'
	bsl	putchr
	brl	$999		; output crlf, return to debugger

;
;	opctype 2 - 16 are very easy, only the printf format
;	varies.  see if we're lucky
;
$rest:	cmp	##17
	blt	$lucky
	brl	$17

$lucky

;
;	make an index into the format offsets table
;	from the opcode type in a (2..16)
;
	dec	a
	dec	a
	asl	a
	tay			; save format offset index

	lda	[<curadr]	; get byte/word to print
	pha
	pea	##2		; push arg byte count for printf

;
;	make a pointer to our format string.
;	$forms + $fmtabl[i] is the address of
;	the i'th string in $forms
;
	per	$forms		; push address of format string pool
	per	$fmtabl		; push format offsets table addr
	lda	(1,s),y		; get offset for our format
	clc			; add string offset to pool addr
	adc	3,s		; now a points to format string

	ply			; clean stack
	ply

	pha			; push pointer to string for printf
	brl	$998		; go printf etc.



$17:	cmp	##17		; rel8
	bne	$18
$rel8:	lda	[<curadr]	; get offset
	and	##0xff		; sign extend offset
	bit	##0x80
	beq	$17a
	ora	##0xff00
$17a	
	dec	a		; compute addr to branch to 
	bra	$18a		; and output it

$18:	cmp	##18		; rel16?
	bne	$19
$rel16:	lda	[<curadr]	; get offset
$18a:
	clc
	adc	<curadr		; add to pc+1
	inc	a		; add 2 more for (ahem)
	inc	a		; good measure

	bsl	wtox		; output addr branched to
	brl	$999		; output crlf, return to debugger

$19:	cmp	##19		; >dbr,adr
	bne	$20

	ldy	##2		; get offset of dbr
	lda	[<curadr],y	; get dbr
	pha			; push it for printf
	lda	[<curadr]	; get adr 
	pha			; push it for printf

	pea	##4		; push arg byte count
	per	$19fmt		; push pointer to format
	brl	$998		; go printf etc.


$20:	cmp	##20		; >dbr,adr,x
	bne	$21
	ldy	##2		; get offset of dbr
	lda	[<curadr],y	; get dbr
	pha			; push it for printf
	lda	[<curadr]	; get adr 
	pha			; push it for printf
	pea	##4		; push arg byte count
	per	$20fmt		; push pointer to format
	brl	$998		; go printf etc


$21:	cmp	##24		; some kind of imm? (21 22 23)
	bge	$24

	tax			; save op type	
	lda	[<curadr]	; get immediate byte or word
	pha			; push it for printf
	pea	##2		; push arg byte count
;
;	now figure out (sort of) whether its byte or word
;	and push pointer to appropriate format
;
	cpx	##21		; plain # imm ?
	beq	$21b

	lda	##0x20		; assume optype = 22 (mem)
	cpx	##22
	beq	$21a
	lsr	a		; wrong, its 23 (idx)
$21a:	bit	<sps		; test m or x in saved psw.
	bne	$21b		; branch if set, imm byte.

	per	$21fmt2		; 2 byte imm format
	brl	$998		; go printf

$21b:	per	$21fmt1		; 1 byte imm format
	brl	$998		; go printf


$24:	lda	[<curadr]	; >bank,>bank
	pha			; push first bank for printf
	xba			; get 2nd bank
	pha			; push it for printf
	pea	##4		; push arg byte count
	per	$24fmt		; push format
;	bra	$998		; go printf etc


$998
	bsl	printf
$999
	bsl	crlf
	rep	#0x20
	pla			; restore original value 
	sta	<curadr		; of <curadr
	plp
	rts

$fmtabl
	dcw	$2fmt-$2fmt
	dcw	$3fmt-$2fmt
	dcw	$4fmt-$2fmt
	dcw	$5fmt-$2fmt
	dcw	$6fmt-$2fmt
	dcw	$7fmt-$2fmt
	dcw	$8fmt-$2fmt
	dcw	$9fmt-$2fmt
	dcw	$10fmt-$2fmt
	dcw	$11fmt-$2fmt
	dcw	$12fmt-$2fmt
	dcw	$13fmt-$2fmt
	dcw	$14fmt-$2fmt
	dcw	$15fmt-$2fmt
	dcw	$16fmt-$2fmt

$forms
$2fmt	dcs	"<%b\0"
$3fmt	dcs	"<%b,x\0"
$4fmt	dcs	"<%b,y\0"
$5fmt	dcs	"(<%b)\0"
$6fmt	dcs	"(<%b),y\0"
$7fmt	dcs	"(<%b,x)\0"
$8fmt	dcs	"[<%b]\0"
$9fmt	dcs	"[<%b],y\0"
$10fmt	dcs	"%b,s\0"
$11fmt	dcs	"(%b,s),y\0"
$12fmt	dcs	"%x\0"
$13fmt	dcs	"%x,x\0"
$14fmt	dcs	"%x,y\0"
$15fmt	dcs	"(%x)\0"
$16fmt	dcs	"(%x,x)\0"

$19fmt	dcs	">l%a\0"
$20fmt	dcs	">l%a,x\0"
$21fmt1	dcs	"#%b\0"
$21fmt2	dcs	"##%x\0"
$24fmt	dcs	">%b,>%b\0"

bsrfmt:	dcs	"bsr \0"	; bsr printf fmt
bslfmt:	dcs	"bsl \0"	; bsl printf fmt

	end
;
;	printf(fmt,arg1,..argn)
;	Args are 1 or 2 words long.
;	This is similar to the C version, but
;	currently the available formats are
;
;	%b : print hex value of (arg & 0xff)
;	%c : print ASCII value (char) (arg & 0xff)
;
;	%x : print hex value of arg (4 hex digits)
;	%lx : print hex value of longword arg (8 hex digits)
;
;	%s : print (null terminated) string pointed to by arg
;	     (string is in the current data bank)
;	%ls : like %s, but arg is a long address (bank address
;	     in second MSB).
;
;	%la : print hex value of long address 
;	     (6 hex digits, equivalent to %b%x)
;		
; 	 The most significant byte is ignored by %la, %ls.
;
;	Arguments are removed from the stack before return.
;	acc is trashed.
;
;	call sequence :
;
;	push	arg1
;	...
;	push	argn
;
;	pea	##nbytes; push arg byte count (bytes in arg1..argn).
;	per	format	; push pointer to (null terminated)format string
;	bsl	printf
;
;
;	The stack frame/direct page during printf looks like
;
;	sp+	arg1	
;		...
;	sp+18	argn
;	sp+16	arg byte count
;	sp+14	fmt pointer
;	sp+12	return addr
;	sp+11	callers psw (byte)
;	sp+9	callers direct page
;	sp+7	callers x reg
;	sp+5	callers y reg	
;	sp+3	exit stack value (with psw, ret addr)
;	sp+1	direct index of current arg

upsw	equ	11	; callers psw.
uret	equ	12	; callers ret addr.
exstk	equ	3	; exit stack pointer.
argidx	equ	1	; argidx is abs address of current arg.
nbytes	equ	16	; nbytes = number arg bytes.
fmtstr	equ	14	; (<fmtstr),y points to format string char.


;
;	printf exit routine, here for easy reference to above.
;

done	rep	#0x30

;
;	move psw and return addr to 'return' stack area.
;	note - when <dir,x bug gets fixed, change 
;	1,x and 2,x to <1,x and <2,x below
;
	ldx	<exstk		; get exit stack pointer
	lda	<upsw		; psw
	sta	1,x
	lda	<uret		; ret addr
	sta	2,x
;	
;	restore callers registers and clean up stack.
;	when <dir,x bug gets fixed, delete txa, replace with
;	tsc
;	clc
;	adc	<exstk

	txa			; save new sp.

	ply			; junk.
	ply			; junk.
	ply			; restore callers y
	plx			; ditto x
	pld			; restore callers direct page.
	tcs			; point stack to return stuff
	plp
	rts


printf	php			; save callers psw
	phd			; and direct page
	rep	#0x30		; set 16 bit m/x
	phx			; save callers x, y
	phy
	
	pha			; reserve 4 more bytes of stack.
	pha
	tsc			; use stack frame for direct page.
	tcd

;
;	set <argidx = absolute address of first arg.
; 	(args are accessed with 0,x because <0,x 
;	doesn't work in this rev of the processor.
;	when the real processor comes along, change all
;	0,x to <0,x and  replace the following 5 lines of code with
;	clc
;	lda	##nbytes
;	adc	<nbytes
;	sta	<argidx
;

	clc
	tdc			; get frame address
	adc	##nbytes	; add frame offset of last arg
	adc	<nbytes		; add # arg bytes
	sta	<argidx		; save abs addr of first arg

;
;	set exstk = abs addr of highest 4 bytes of the frame.
;	the exit routine will move psw, return addr up there,
;	load s from exstk, and do plp, rts.
;

	dec	a
	dec	a		; stack value to do plp, rts from
	sta	<exstk		; after cleaning up args on exit.

	sep	#0x20		; 8 bit mem, 16 bit idx.
	ldy	##0		; init pointer to fmt chars.

loop
	lda	(<fmtstr),y	; get char from fmt string.
	beq	done		; done if terminator.
	iny			; point to next char.
	cmp	#'%'		; format spec ?
	beq	format		; yes, go doit.

	bsl	putchr		; display char in acc.
	bra	loop		; do some more.

;
;	here after % in format string.  if next char is
;	s,c,b,x, or l then format current arg, else
;	just display the char.
;	

format
	lda	(<fmtstr),y	; get format specifier.	
	beq	done
	iny

	cmp	#'l'		; %l ?
	beq	$1		; branch if no.
	brl	fmt
$1	brl	lngfmt

;
;	Here after processing valid %something.
;	This is the normal exit from fmt and lngfmt.

fmtend
	ldx	<argidx		; make pointer to next arg
	dex
	dex
	stx	<argidx
	ply			; get pointer to next fmt char
	sep	#0x20		; ensure 8 bit mem for loop
	brl	loop		; do next format char

;
;	Here from fmt or lngfmt because of %junk.
;	Just print the junk.
;

junk
	bsl	putchr		; display char in acc.
	ply			; get pointer to next fmt char.
	brl	loop		; do some more.

;
;	Here to do %<not l>.  Jump to appropriate routine,
;	which will exit via fmtend (above).
;

fmt
	phy			; save ptr to next fmt char.
	ldx	<argidx		; point x at current arg

	cmp	#'x'
	beq	pword
	cmp	#'s'
	beq	pstring
	cmp	#'c'
	beq	pchar
	cmp	#'b'
	beq	pbyte
	brl	junk

;
;	Here on %s - print string in data bank
;

pstring
	ldy	0,x		; get pointer to string
	phy			; push pointer to string
	bsl	putstr		; print string
	brl	fmtend		; get ready for next whatever.

;
;	%c - print char 
;

pchar
	lda	0,x
	bsl	putchr
	brl	fmtend

;
;	%x - print hex word
;

pword	rep	#0x20		; need 16 bit m for this
	lda	0,x		; get the word
	bsl	wtox		; display it
	brl	fmtend

;
;	%b - print hex byte
;

pbyte	lda	0,x		; get the byte
	bsl	btox		; display it
	brl	fmtend

;
;	Here on %l<something:
;

lngfmt
	lda	(<fmtstr),y	; get fmt spec.
	bne	$1
	brl	done
$1
	iny			; point to next format char
	phy			; save pointer.
	ldx	<argidx		; point x at current arg (hi word)

	cmp	#'x'
	beq	plword
	cmp	#'s'
	beq	plstrn
	cmp	#'a'
	beq	pladdr
	brl	junk		; invalid %l, just output acc.
;
;	%lx - print long hex word
;

plword	rep	#0x20		; need 16 bit m for this
	lda	0,x		; get high word
	bsl	wtox		; display high word

	dex			; point x at low word of arg
	dex
	stx	<argidx		; update argidx
	brl	pword		; go display low word.

;
;	Here  on %la - print <bank><addr> 
;

pladdr
	rep	#0x20		; need 16 bit m
	lda	0,x		; get bank value
	bsl	btox		; print it (1 byte)

	dex			; point x to next arg (addr)
	dex
	stx	<argidx

	lda	0,x		; get addr
	bsl	wtox		; print it
	brl	fmtend
;
;	Here on %ls - print string in specified bank
;

plstrn
	phb			; save current dbr
	lda	0,x		; get specified bank
	pha			; copy to dbr
	plb

	dex			; point to next arg (string addr)
	dex
	stx	<argidx

	ldy	0,x		; get string addr
	phy			; push for putstr
	bsl	putstr		; print the string

	plb			; restore callers dbr
	brl	fmtend		; clean up

	end
