

;	These routines init and exercise the 4
;	INS8250s (ACEs)	used in the 1280.

;	ACE offsets (in decreasing interrupt priority level):

ACEBNK equ 0xf8			; Data bank containing ACEs.
aceadd equ 0			; address of first ACE.
acepad equ aceadd+0		; Mouse/pad ACE.
acekbd equ aceadd+0x30		; Keyboard ACE.
acehst equ aceadd+0x20		; Host ACE.
aceaux equ aceadd+0x10		; Aux ACE.

;	ACE register offsets :

;	(These 2 accessible if bit 7 of LCR = 1)
DDL equ 0			; Divisor Latch register (2 bytes)
DLL equ DDL			; Divisor Latch Low byte.
DLH equ DLL+2			; Divisor Latch High byte.

;	(These 3 accessible if bit 7 of LCR = 0)
RBR equ 0			; Receiver Buffer Reg. (read data).
THR equ 0			; Transmitter Holding Reg. (write data).
IER equ 2			; Interrupt Enable Reg.

;	(Regardless of LCR bit 7).
IIR equ 4			; Interrupt Ident. Reg.(read only).
LCR equ 6			; Line Control Register.
MCR equ 8			; Modem Control Reg. 
LSR equ 10			; Line Status Register.
MSR equ 12			; Modem Status Reg.
SCR equ 14			; Scratch reg.
	
;
; ACE test routines.  These routines simply poll the ACEs,
; echoing input.  Each ACE is set up for 9600 baud, no modem
; controls, no parity, interrupts disabled.  If the ACE
; indicates an error, an error message is output by the ACE.
;


start:
	sei			; disable interrupts
	clc
	xce			; set native mode
	rep	#0x30		; 16 bit m/x

	lda	##0x6fff	; set stack pointer to
	tcs			; 6fff (end of User RAM, 4k
				; reserved for firmware use)

	pea	##ACEBNK	; set data bank register to the bank
	plb			; where the ACEs are.
	tcs			; re-init stack pointer (we just
				; pushed 2 bytes and pulled only 1).

	bsl	aceini		; call ACE initialization subroutine
	bsl	scratch		; read/write the ACE scratch registers

;
; Now for the real test. Forever echo ACEs input to it's output.
; 

test:
$loop:
	pea	##acepad	; push address of mouse ACE
	bsr	poll		; go do the needful
	pla			; remove ACE address

	pea	##acehst	; push address of host ACE
	bsr	poll		; go do the needful
	pla			; remove ACE address

	pea	##aceaux	; push address of aux ACE
	bsr	poll		; go do the needful
	pla			; remove ACE address

	pea	##acekbd	; push address of keyboard ACE
	bsr	poll		; go do the needful
	pla			; remove ACE address

	bra	$loop		; again and again ...

;
; This routine does the actual test for the ACE whose 
; address is on the stack.  During execution the 
; stack looks like
; sp + 5	addr hi		high byte of ACE address
; sp + 4	addr lo		low byte  "
; sp + 3	ret hi		hi byte of return address
; sp + 2	ret lo		low byte "
; sp + 1	psw		poll saves callers psw here
; sp --->	???

poll:
	php			; save callers m/x mode
	sep	#0x30		; set 8 bit m/x
;
; Inspect the line status register
; for data ready or error.  If data ready
; echo it.  If error, copy line status
; into scratch register.
;
	ldy	#LSR		; get line status index
	lda	(4,s),y		; read line status register
	bit	#1		; data ready ?
	bne	$echo		; branch if yes
	bit	#16+8+4+2	; any error bits set ?
	beq	$done		; branch if no
;
; An error was posted in the LSR, copy
; line status to scratch register and return
;

	ldy	#SCR		; get scratch register index
	sta	(4,s),y		; put line status in scratch reg
	bra	$done		; clean up and return
;
; Here if data ready - read the data, then
; wait (hopefully not tooo long) for transmitter
; holding register empty and echo the data.
;

$echo:
	ldy	#RBR		; get receiver buffer index
	lda	(4,s),y		; read the data
	tax			; save it for echoing
	ldy	#LSR		; get line status index
$1:	lda	(4,s),y		; read line status
	bit	#32		; transmit holder empty ?
	beq	$1		; branch if no, keep trying
	ldy	#THR		; get transmitter buffer index
	txa			; get the data they sent us
	sta	(4,s),y		; send it back for repair or something

$done:
	plp			; restore callers m/x mode
	rts			; and return

	
;
; Just for grins, read/write the scratch
; register in each ACE a bunch of times.
; If nothing appears to be happening later, this
; will show if the chips are being accessed.
;

scratch:
	php
	sep	#0x30		; set 8 bit m/x
	lda	#1
	ldx	#0
$loop:
	sta	acepad+SCR
	lda	acepad+SCR
	sta	acehst+SCR
	lda	acehst+SCR
	sta	aceaux+SCR
	lda	aceaux+SCR
	sta	acekbd+SCR
	lda	acekbd+SCR

	dex
	bne	$loop
	asl	a
	bne	$loop
	
	plp
	rts

;
; This subroutine initializes the ACEs
;

aceini:
	php			; save current m/x mode
	phb			; save dbr
	phk			; set our dbr = pbr
	plb

	sep	#0x30		; set 8 bit m/x

	per	$inidat		; push address of init data table
	per	$inireg		; push address of register list
	ldy	#0		; init index into tables
$loop:
	lda	(1,s),y		; get an ACE register index
	tax			; put index in x register
	lda	(3,s),y		; get initial value for the ACE reg
;
; initialize the register in each ACE
;
	sta	>ACEBNK,acepad,x	
	sta	>ACEBNK,acehst,x
	sta	>ACEBNK,aceaux,x
	sta	>ACEBNK,acekbd,x
	iny			; point to next value/register
	cpy	#$inireg-$inidat ; end of list ?
	bne	$loop		; branch if no, do the next one

	rep	#0x30		; set 16 bit m/x for stack cleanup
	pla			; remove table addresses from stack
	pla	

	plb			; restore callers dbr
	plp			; restore callers m/x mode
	rts

;
; inidat[i] goes in ACE register inireg[i] to init the ACEs.
;

$inidat:
	dcb	128		; LCR to select DDL
	dcb	12		; DLL for 9600 baud
	dcb	0		; DLH for 9600 baud
	dcb	4+2		; LCR to deselect DDL, set data format
	dcb	0		; IER to disable interrupts
	dcb	8		; MCR to activate !OUT2, which
				; enables ACE output.
$inireg:
	dcb	LCR
	dcb	DLL
	dcb	DLH
	dcb	LCR
	dcb	IER
	dcb	MCR
;
; here on reset.  this next instruction must reside at
; absolute address fffffd.
;
rst:	brl	start

	end
	
