;	Centronics i/o routines

; Pulse the Cnetronics data strobe, verify timing needed

dstrob:
	php
	sep	#0x20

	lda	#2		; set it
	tsb	PtrCtl

	lda	#2		; clear strobe bit first
	trb	PtrCtl

	plp
	rts	

; Send contents of accumulator to Centronics interface.  Return
; with carry flag set if unsuccessful because printer was busy or
; fault occurred.

cnout:
	php
	rep	#0x30
	pha
	phx
	phy
	sep	#0x20

	sta	PtrPrt		; put data in output port

	bit	PtrCtl		; check for fault, it was active low
	bvs	$errxit		; but R. inverted it, so now we check for
				; high
	lda	PtrCtl		; check for busy, active high
	and	#8		; on bit 3
	bne	$errxit

	bsl	dstrob		; strobe it!

$wait:	bit	PtrCtl		; check for fault
	bvs	$errxit		; br if so
	lda	PtrCtl		; check for busy now
	and	#8		; wait for BUSY to go away
	bne	$wait	

	rep	#0x30
	ply
	plx
	pla
	plp
	clc
	rtl

$errxit				; here when any fault condition
	rep	#0x30		; occured, set carry to signal
	ply
	plx
	pla
	plp
	sec
	rtl

	end
