;
; Vertical blank interrupt handler.
; This version increments Vcount
; so the rest of the world knows a
; vertical occurred, and updates the
; keyboard leds or beeps (beep has
; higher priority).
;

vblint:
	lda	##0x0800	; disable vertical int
	trb	Iemask		; to prevent reentrance.
	inc	Vcount		; inc vertical counter.
;
; if keyboard transmitter empty, and 
; beep or LED change requested, do it.
; 
	sep	#0x20
	rep	#0x10
	sta	Clrvb		; turn off vertical irq.
	cli			; enable other interrupts.

	lda	Blink
	bne	$blink	
$2
	lda	>ACE,0x3a	; kbd THR empty ?
	bit	#32
	beq	$exit		; br if no, go home
	lda	#2		; get beep request flag bit.
	trb	Beeper		; test and clear beep request flag
	beq	$1		; br if no beep needed, check leds.
	ora	Beeper		; yes, issue beep command to kbd.
	sta	>ACE,0x30
	bra	$exit		; go home
$1:
	lda	Leds		; get new led setting.
	cmp	OldLed		; same as previous ?
	beq	$exit		; yes, don't make kbd busy for nothing.
	sta	>ACE,0x30	; update kbd leds.
	sta	OldLed		; save current led setting.
$exit:
	sep	#0x20
	lda	#0x8
	tsb	Iemask+1	; reenable vertical interrupt.

	jmp	Irqdon		; jump to irq exit.

$blink:				; here to blink colors
	sep	#0x30
	ldx	#0
$b1	
	lda	Bltab,x		; check for counter ticker
	bne	$b2		; br if time to do
$b3	txa
	clc
	adc	#7		; move to next entry
	cmp	#56		; check for end of table
	bcs	$2		; br if done
	tax
	bra	$b1	
$b2
	bpl	$on		; br to do ontime
	inc	Bltab,x		; inc offtime ticker
	bne	$b3
				; here to set ontime(next cycle)
	ldy	Bltab+3,x	; color index
	lda	Bltab+1,x	; get ontime ready
	sta	Bltab,x		; and put in ticker
	lda	Redclt,y
$f1	bit 	Dpdone
	bvc	$f1
	sty	Rbcltn		; dac lu addr register
	sta	Rbcltr
	lda	Grnclt,y
	sta	Rbcltg
	lda	Bluclt,y
	sta	Rbcltb
	bra	$b3
$on
	dec	Bltab,x		; and dec ontime ticker
	bne	$b3		; br if not done with this cycle
$setup
	lda	Bltab+2,x	; get offtime ready
	sta	Bltab,x		; ticker for next cycle

	ldy	Bltab+3,x
	lda	Bltab+4,x	; next red for next cycle
$s1:	bit	Dpdone
	bvc	$s1

	sty	Rbcltn		; hard color table addr
	sta	Rbcltr
	lda	Bltab+5,x
	sta	Rbcltg
	lda	Bltab+6,x
	sta	Rbcltb
	brl	$b3	

; old version for hardware problem
;
;
;;
;vblint:
;	lda	##0x0800	; disable vertical int
;	trb	Iemask		; to prevent reentrance.
;	cli			; enable other interrupts.
;	inc	Vcount		; inc vertical counter.
;;
;; if keyboard transmitter empty, and 
;; beep or LED change requested, do it.
;; 
;	sep	#0x20
;	lda	>ACE,0x3a	; kbd THR empty ?
;	bit	#32
;	beq	$exit		; br if no, done.
;	lda	#2		; get beep request flag bit.
;	trb	Beeper		; test and clear beep request flag
;	beq	$1		; br if no beep needed, check leds.
;	ora	Beeper		; yes, issue beep command to kbd.
;	sta	>ACE,0x30
;	bra	$exit		; and exit.
;$1:
;	lda	Leds		; get new led setting.
;	cmp	OldLed		; same as previous ?
;	beq	$exit		; yes, don't make kbd busy for nothing.
;	sta	>ACE,0x30	; update kbd leds.
;	sta	OldLed		; save current led setting.
;$exit:
;;
;; normally we'd reenable here but because of
;; hardware bug let idle loops do it.
;;
;;	lda	#0x8
;;	tsb	Iemask+1	; reenable vertical interrupt.
;
;	jmp	Irqdon		; jump to irq exit.
;


vblend:
	end
