	title	"Opcode Disassembly Tables"
	psect	code
;
;	65816 opcode length / name table
;
;	00 = implied		1 byte
;	01 = a			1 byte
;	02 = <dir		2 bytes
;	03 = <dir,x		2 bytes
;	04 = <dir,y		2 bytes
;	05 = (<dir)		2 bytes
;	06 = (<dir),y		2 bytes
;	07 = (<dir,x)		2 bytes
;	08 = [<dir]		2 bytes
;	09 = [<dir],y		2 bytes
;	10 = offset,s		2 bytes
;	11 = (offset,s),y	2 bytes
;	12 = abs		3 bytes
;	13 = abs,x		3 bytes
;	14 = abs,y		3 bytes
;	15 = (abs)		3 bytes
;	16 = (abs,x)		3 bytes
;	17 = rel8		2 bytes
;	18 = rel16		3 bytes
;	19 = >dbr,adr		4 bytes
;	20 = >dbr,adr,x		4 bytes
;	21 = #imm		2 bytes
;	22 = #imm or ##imm	2(3) bytes based on M
;	23 = #imm or ##imm	2(3) bytes based on X
;	24 = >src,>dst		3 bytes
;

;
;	table of operand lengths and other info
;	bits 0-2 are length (1..4).  if we ever need
;	another bit in here, we could code length-1
;	in bits 0,1
;	
;	bit 5 set flags branch/jump/return instructions
;	if bit 5 is set, bit 6 is set for branches, clear
;	for jump/return (distinguishes between pc relative
;	and absolute jumps).
;	bit 7 set flags imm depending on X (in psw)
;	bit 8 set flags imm depending on M (in psw)
;

$isMimm equ 0x80
$isXimm equ 0x40
$isrel  equ 0x20
$isnupc equ 0x10

opclen::
		dcb	1	; implied
		dcb	1	; accumulator
		dcb	2	; <dir
		dcb	2	; <dir,x
		dcb	2	; <dir,y
		dcb	2	; (<dir)
		dcb	2	; (<dir),y
		dcb	2	; (<dir,x)
		dcb	2	; [<dir]
		dcb	2	; [<dir],y
		dcb	2	; offset,s
		dcb	2	; (offset,s),y
		dcb	3	; abs
		dcb	3	; abs,x
		dcb	3	; abs,y
		dcb	3	; (abs)
		dcb	3	; (abs,x)
		dcb	2	; rel8
		dcb	3	; rel16
		dcb	4	; >dbr,adr
		dcb	4	; >dbr,adr,x
		dcb	2	; #imm
		dcb	0x82	; #imm based on M
		dcb	0x42	; #imm based on X
		dcb	3	; >src,>dst

;
;	operand type table
;
opctyp::

$impl	equ	0
$accum	equ	1
$dp	equ	2
$dpix	equ	3
$dpiy	equ	4
$dpin	equ	5
$dpiniy	equ	6
$dpixin	equ	7
$dpinl	equ	8
$dpiliy	equ	9
$skr	equ	10
$skriiy	equ	11
$abs	equ	12
$absix	equ	13
$absiy	equ	14
$absin	equ	15
$abixi	equ	16
$rel8	equ	17
$rel16	equ	18
$absl	equ	19
$abslix	equ	20
$immed2	equ	21
$accimm	equ	22
$idximm	equ	23
$blkm	equ	24


;
; indices for all of the opcode names
;

$adc_nm		equ	0
$and_nm		equ	1
$asl_nm		equ	2
$bcc_nm		equ	3
$bcs_nm		equ	4
$beq_nm		equ	5
$bit_nm		equ	6
$bmi_nm		equ	7
$bne_nm		equ	8
$bpl_nm		equ	9
$bra_nm		equ	10
$brk_nm		equ	11
$brl_nm		equ	12
$bvc_nm		equ	13
$bvs_nm		equ	14
$clc_nm		equ	15
$cld_nm		equ	16
$cli_nm		equ	17
$clv_nm		equ	18
$cmp_nm		equ	19
$cop_nm		equ	20
$cpx_nm		equ	21
$cpy_nm		equ	22
$dec_nm		equ	23
$dex_nm		equ	24
$dey_nm		equ	25
$eor_nm		equ	26
$inc_nm		equ	27
$inx_nm		equ	28
$iny_nm		equ	29
$jml_nm		equ	30
$jmp_nm		equ	31
$jsl_nm		equ	32
$jsr_nm		equ	33
$lda_nm		equ	34
$ldx_nm		equ	35
$ldy_nm		equ	36
$lsl_nm		equ	37
$lsr_nm		equ	38
$mvn_nm		equ	39
$mvp_nm		equ	40
$nop_nm		equ	41
$ora_nm		equ	42
$pea_nm		equ	43
$pei_nm		equ	44
$per_nm		equ	45
$pha_nm		equ	46
$phb_nm		equ	47
$phd_nm		equ	48
$phk_nm		equ	49
$php_nm		equ	50
$phx_nm		equ	51
$phy_nm		equ	52
$pla_nm		equ	53
$plb_nm		equ	54
$pld_nm		equ	55
$plp_nm		equ	56
$plx_nm		equ	57
$ply_nm		equ	58
$rep_nm		equ	59
$rol_nm		equ	60
$ror_nm		equ	61
$rti_nm		equ	62
$rtl_nm		equ	63
$rts_nm		equ	64
$sbc_nm		equ	65
$sec_nm		equ	66
$sed_nm		equ	67
$sei_nm		equ	68
$sep_nm		equ	69
$sta_nm		equ	70
$stp_nm		equ	71
$stx_nm		equ	72
$sty_nm		equ	73
$stz_nm		equ	74
$tax_nm		equ	75
$tay_nm		equ	76
$tcd_nm		equ	77
$tcs_nm		equ	78
$tdc_nm		equ	79
$trb_nm		equ	80
$tsb_nm		equ	81
$tsc_nm		equ	82
$tsx_nm		equ	83
$txa_nm		equ	84
$txs_nm		equ	85
$txy_nm		equ	86
$tya_nm		equ	87
$tyx_nm		equ	88
$wai_nm		equ	89
$xba_nm		equ	90
$xce_nm		equ	91
$wdm_nm		equ	92

	dcb	$impl		; 00 = brk
	dcb	$brk_nm

	dcb	$dpixin		; 01 = ora (<dir,x)
	dcb	$ora_nm

	dcb	$impl		; 02 = cop
	dcb	$cop_nm

	dcb	$skr		; 03 = ora offset,s
	dcb	$ora_nm

	dcb	$dp		; 04 = tsb <dir
	dcb	$tsb_nm

	dcb	$dp		; 05 = ora <dir
	dcb	$ora_nm

	dcb	$dp		; 06 = asl <dir
	dcb	$asl_nm

	dcb	$dpinl		; 07 = ora [<dir]
	dcb	$ora_nm

	dcb	$impl		; 08 = php
	dcb	$php_nm

	dcb	$accimm; 09 = ora #imm (##imm)
	dcb	$ora_nm

	dcb	$accum		; 0a = asl a
	dcb	$asl_nm

	dcb	$impl		; 0b = phd
	dcb	$phd_nm

	dcb	$abs		; 0c = tsb abs
	dcb	$tsb_nm

	dcb	$abs		; 0d = ora abs
	dcb	$ora_nm

	dcb	$abs		; 0e = asl abs
	dcb	$asl_nm

	dcb	$absl		; 0f = ora >dbr,adr
	dcb	$ora_nm

	dcb	$rel8		; 10 = bpl rel8
	dcb	$bpl_nm

	dcb	$dpiniy		; 11 = ora (<dir),y
	dcb	$ora_nm

	dcb	$dpin		; 12 = ora (<dir)
	dcb	$ora_nm

	dcb	$skriiy		; 13 = ora (offset,s),y
	dcb	$ora_nm

	dcb	$dp		; 14 = trb <dir
	dcb	$trb_nm

	dcb	$dpix		; 15 = ora <dir,x
	dcb	$ora_nm

	dcb	$dpix		; 16 = asl <dir,x
	dcb	$asl_nm

	dcb	$dpiliy		; 17 = ora [<dir],y
	dcb	$ora_nm

	dcb	$impl		; 18 = clc
	dcb	$clc_nm

	dcb	$absiy		; 19 = ora abs,y
	dcb	$ora_nm

	dcb	$accum		; 1a = inc a
	dcb	$inc_nm

	dcb	$impl		; 1b = tcs
	dcb	$tcs_nm

	dcb	$abs		; 1c = trb abs
	dcs	$trb_nm

	dcb	$absix		; 1d = ora abs,x
	dcb	$ora_nm

	dcb	$absix		; 1e = asl abs,x
	dcb	$asl_nm

	dcb	$abslix		; 1f = ora >pbr,abs,x
	dcb	$ora_nm

	dcb	$abs		; 20 = jsr abs
	dcb	$jsr_nm

	dcb	$dpixin		; 21 = and (<dir,x)
	dcb	$and_nm

	dcb	$absl		; 22 = jsl >pbr,abs
	dcb	$jsl_nm

	dcb	$skr		; 23 = and offset,s
	dcb	$and_nm

	dcb	$dp		; 24 = bit <dir
	dcb	$bit_nm

	dcb	$dp		; 25 = and <dir
	dcb	$and_nm

	dcb	$dp		; 26 = rol <dir
	dcb	$rol_nm

	dcb	$dpinl		; 27 = and [<dir]
	dcb	$and_nm

	dcb	$impl		; 28 = plp
	dcb	$plp_nm

	dcb	$accimm		; 29 = and #imm (##imm)
	dcb	$and_nm

	dcb	$accum		; 2a = rol a
	dcb	$rol_nm

	dcb	$impl		; 2b = pld
	dcb	$pld_nm

	dcb	$abs		; 2c = bit abs
	dcb	$bit_nm

	dcb	$abs		; 2d = and abs
	dcb	$and_nm

	dcb	$abs		; 2e = rol abs
	dcb	$rol_nm

	dcb	$absl		; 2f = and >dbr,abs
	dcb	$and_nm

	dcb	$rel8		; 30 = bmi rel8
	dcb	$bmi_nm

	dcb	$dpiniy		; 31 = and (<dir),y
	dcb	$and_nm

	dcb	$dpin		; 32 = and (<dir)
	dcb	$and_nm

	dcb	$skriiy		; 33 = and (offset,s),y
	dcb	$and_nm

	dcb	$dpix		; 34 = bit <dir,x
	dcb	$bit_nm

	dcb	$dpix		; 35 = and <dir,x
	dcb	$and_nm

	dcb	$dpix		; 36 = rol <dir,x
	dcb	$rol_nm

	dcb	$dpiliy		; 37 = and [<dir],y
	dcb	$and_nm

	dcb	$impl		; 38 = sec
	dcb	$sec_nm

	dcb	$absiy		; 39 = and abs,y
	dcb	$and_nm

	dcb	$accum		; 3a = dec a
	dcb	$dec_nm

	dcb	$impl		; 3b = tsc
	dcb	$tsc_nm

	dcb	$absix		; 3c = bit abs,x
	dcb	$bit_nm

	dcb	$absix		; 3d = and abs,x
	dcb	$and_nm

	dcb	$absix		; 3e = rol abs,x
	dcb	$rol_nm

	dcb	$absix		; 3f = and >dbr,adr,x
	dcb	$and_nm

	dcb	$impl		; 40 = rti
	dcb	$rti_nm

	dcb	$dpixin		; 41 = eor (<dir,x)
	dcb	$eor_nm

	dcb	$impl		; 42 = <wdm reserved>
	dcb	$wdm_nm

	dcb	$skr		; 43 = eor offset,s
	dcb	$eor_nm

	dcb	$blkm		; 44 = mvp >src,>dst
	dcb	$mvp_nm

	dcb	$dp		; 45 = eor <dir
	dcb	$eor_nm

	dcb	$dp		; 46 = lsl <dir
	dcb	$lsl_nm

	dcb	$dpinl		; 47 = eor [<dir]
	dcb	$eor_nm

	dcb	$impl		; 48 = pha
	dcb	$pha_nm

	dcb	$accimm		; 49 = eor #imm (##imm)
	dcb	$eor_nm

	dcb	$accum		; 4a = lsr a
	dcb	$lsr_nm

	dcb	$impl		; 4b = phk
	dcb	$phk_nm

	dcb	$abs		; 4c = jmp abs
	dcb	$jmp_nm

	dcb	$abs		; 4d = eor abs
	dcb	$eor_nm

	dcb	$abs		; 4e = lsr abs
	dcb	$lsr_nm

	dcb	$absl		; 4f = eor >dbr,adr
	dcb	$eor_nm

	dcb	$rel8		; 50 = bvc rel8
	dcb	$bvc_nm

	dcb	$dpiniy		; 51 = eor (<dir),y
	dcb	$eor_nm

	dcb	$dpin		; 52 = eor (<dir)
	dcb	$eor_nm

	dcb	$skriiy		; 53 = eor (offset,s),y
	dcb	$eor_nm

	dcb	$blkm		; 54 = mvn >src,>dst
	dcb	$mvn_nm

	dcb	$dpix		; 55 = eor <dir,x
	dcb	$eor_nm

	dcb	$dpix		; 56 = lsl <dir,x
	dcb	$lsl_nm

	dcb	$dpiliy		; 57 = eor [<dir],y
	dcb	$eor_nm

	dcb	$impl		; 58 = cli
	dcb	$cli_nm

	dcb	$absiy		; 59 = eor abs,y
	dcb	$eor_nm

	dcb	$impl		; 5a = phy
	dcb	$phy_nm

	dcb	$impl		; 5b = tcd
	dcb	$tcd_nm

	dcb	$absl		; 5c = jmp >pbr,abs
	dcb	$jmp_nm

	dcb	$absix		; 5d = eor abs,x
	dcb	$eor_nm

	dcb	$absix		; 5e = lsr abs,x
	dcb	$lsr_nm

	dcb	$abslix		; 5f = eor >dbr,adr,x
	dcb	$eor_nm

	dcb	$impl		; 60 = rts
	dcb	$rts_nm

	dcb	$dpixin		; 61 = adc (<dir,x)
	dcb	$adc_nm

	dcb	$rel16		; 62 = per rel16
	dcb	$per_nm

	dcb	$skr		; 63 = adc offset,s
	dcb	$adc_nm

	dcb	$dp		; 64 = stz <dir
	dcb	$stz_nm

	dcb	$dp		; 65 = adc <dir
	dcb	$adc_nm

	dcb	$dp		; 66 = ror <dir
	dcb	$ror_nm

	dcb	$dpinl		; 67 = adc [<dir]
	dcb	$adc_nm

	dcb	$impl		; 68 = pla
	dcb	$pla_nm

	dcb	$accimm		; 69 = adc #imm (##imm)
	dcb	$adc_nm

	dcb	$accum		; 6a = ror a
	dcb	$ror_nm

	dcb	$impl		; 6b = rtl
	dcb	$rtl_nm

	dcb	$absin		; 6c = jmp (abs)
	dcb	$jmp_nm

	dcb	$abs		; 6d = adc abs
	dcb	$adc_nm

	dcb	$abs		; 6e = ror abs
	dcb	$ror_nm

	dcb	$absl		; 6f = adc >dbr,adr
	dcb	$adc_nm

	dcb	$rel8		; 70 = bvs rel8
	dcb	$bvs_nm

	dcb	$dpiniy		; 71 = adc (<dir),y
	dcb	$adc_nm

	dcb	$dpin		; 72 = adc (<dir)
	dcb	$adc_nm

	dcb	$skriiy		; 73 = adc (offset,s),y
	dcb	$adc_nm

	dcb	$dpix		; 74 = stz <dir,x
	dcb	$stz_nm

	dcb	$dpix		; 75 = adc <dir,x
	dcb	$adc_nm

	dcb	$dpix		; 76 = ror <dir,x
	dcb	$ror_nm

	dcb	$dpiniy		; 77 = adc [<dir],y
	dcb	$adc_nm

	dcb	$impl		; 78 = sei
	dcb	$sei_nm

	dcb	$absiy		; 79 = adc abs,y
	dcb	$adc_nm

	dcb	$impl		; 7a = ply
	dcb	$ply_nm

	dcb	$impl		; 7b = tdc
	dcb	$tdc_nm

	dcb	$abixi		; 7c = jmp (abs,x)
	dcb	$jmp_nm

	dcb	$absix		; 7d = adc abs,x
	dcb	$adc_nm

	dcb	$absix		; 7e = ror abs,x
	dcb	$ror_nm

	dcb	$abslix		; 7f = adc >dbr,adr,x
	dcb	$adc_nm

	dcb	$rel8		; 80 = bra rel8
	dcb	$bra_nm

	dcb	$dpixin		; 81 = sta (<dir,x)
	dcb	$sta_nm

	dcb	$rel16		; 82 = brl rel16
	dcb	$brl_nm

	dcb	$skr		; 83 = sta offset,s
	dcb	$sta_nm

	dcb	$dp		; 84 = sty <dir
	dcb	$sty_nm

	dcb	$dp		; 85 = sta <dir
	dcb	$sta_nm

	dcb	$dp		; 86 = stx <dir
	dcb	$stx_nm

	dcb	$dpinl		; 87 = sta [<dir]
	dcb	$sta_nm

	dcb	$impl		; 88 = dey
	dcb	$dey_nm

	dcb	$accimm		; 89 = bit #imm (##imm)
	dcb	$bit_nm

	dcb	$impl		; 8a = txa
	dcb	$txa_nm

	dcb	$impl		; 8b = phb
	dcb	$phb_nm

	dcb	$abs		; 8c = sty abs
	dcb	$sty_nm

	dcb	$abs		; 8d = sta abs
	dcb	$sta_nm

	dcb	$abs		; 8e = stx abs
	dcb	$stx_nm

	dcb	$absl		; 8f = sta >dbr,adr
	dcb	$sta_nm

	dcb	$rel8		; 90 = bcc rel8
	dcb	$bcc_nm

	dcb	$dpiniy		; 91 = sta (<dir),y
	dcb	$sta_nm

	dcb	$dpin		; 92 = sta (<dir)
	dcb	$sta_nm

	dcb	$skriiy		; 93 = sta (offset,s),y
	dcb	$sta_nm

	dcb	$dpix		; 94 = sty <dir,x
	dcb	$sty_nm

	dcb	$dpix		; 95 = sta <dir,x
	dcb	$sta_nm

	dcb	$dpiy		; 96 = stx <dir,y
	dcb	$stx_nm

	dcb	$dpiliy		; 97 = sta [<dir],y
	dcb	$sta_nm

	dcb	$impl		; 98 = tya
	dcb	$tya_nm

	dcb	$absiy		; 99 = sta abs,y
	dcb	$sta_nm

	dcb	$impl		; 9a = txs
	dcb	$txs_nm

	dcb	$impl		; 9b = txy
	dcb	$txy_nm

	dcb	$abs		; 9c = stz abs
	dcb	$stz_nm

	dcb	$absix		; 9d = sta abs,x
	dcb	$sta_nm

	dcb	$absix		; 9e = stz abs,x
	dcb	$stz_nm

	dcb	$abslix		; 9f = sta >dbr,adr,x
	dcb	$sta_nm

	dcb	$idximm		; a0 = ldy #imm (##imm)
	dcb	$ldy_nm

	dcb	$dpixin		; a1 = lda (<dir,x)
	dcb	$lda_nm

	dcb	$idximm		; a2 = ldx #imm (##imm)
	dcb	$ldx_nm

	dcb	$skr		; a3 = lda offset,s
	dcb	$lda_nm

	dcb	$dp		; a4 = ldy <dir
	dcb	$ldy_nm

	dcb	$dp		; a5 = lda <dir
	dcb	$lda_nm

	dcb	$dp		; a6 = ldx <dir
	dcb	$ldx_nm

	dcb	$dpinl		; a7 = lda [<dir]
	dcb	$lda_nm

	dcb	$impl		; a8 = tay
	dcb	$tay_nm

	dcb	$accimm		; a9 = lda #imm (##imm)
	dcb	$lda_nm

	dcb	$impl		; aa = tax
	dcb	$tax_nm

	dcb	$impl		; ab = plb
	dcb	$plb_nm

	dcb	$abs		; ac = ldy abs
	dcb	$ldy_nm

	dcb	$abs		; ad = lda abs
	dcb	$lda_nm

	dcb	$abs		; ae = ldx abs
	dcb	$ldx_nm

	dcb	$absl		; af = lda >dbr,adr
	dcb	$lda_nm

	dcb	$rel8		; b0 = bcs rel8
	dcb	$bcs_nm

	dcb	$dpiniy		; b1 = lda (<dir),y
	dcb	$lda_nm

	dcb	$dpin		; b2 = lda (<dir)
	dcb	$lda_nm

	dcb	$skriiy		; b3 = lda (offset,s),y
	dcb	$lda_nm

	dcb	$dpix		; b4 = ldy <dir,x
	dcb	$ldy_nm

	dcb	$dpix		; b5 = lda <dir,x
	dcb	$lda_nm

	dcb	$dpiy		; b6 = ldx <dir,y
	dcb	$ldx_nm

	dcb	$dpiliy		; b7 = lda [<dir],y
	dcb	$lda_nm

	dcb	$impl		; b8 = clv
	dcb	$clv_nm

	dcb	$absiy		; b9 = lda abs,y
	dcb	$lda_nm

	dcb	$impl		; ba = tsx
	dcb	$tsx_nm

	dcb	$impl		; bb = tyx
	dcb	$tyx_nm

	dcb	$absix		; bc = ldy abs,x
	dcb	$ldy_nm

	dcb	$absix		; bd = lda abs,x
	dcb	$lda_nm

	dcb	$absiy		; be = ldx abs,y
	dcb	$ldx_nm

	dcb	$abslix		; bf = lda >dbr,adr,x
	dcb	$lda_nm

	dcb	$idximm		; c0 = cpy #imm (##imm)
	dcb	$cpy_nm

	dcb	$dpixin		; c1 = cmp (<dir,x)
	dcb	$cmp_nm

	dcb	$immed2		; c2 = rep #imm
	dcb	$rep_nm

	dcb	$dpix		; c3 = cmp <dir,x
	dcb	$cmp_nm

	dcb	$dp		; c4 = cpy <dir
	dcb	$cpy_nm

	dcb	$dp		; c5 = cmp <dir
	dcb	$cmp_nm

	dcb	$dp		; c6 = dec <dir
	dcb	$dec_nm

	dcb	$dpinl		; c7 = cmp [<dir]
	dcb	$cmp_nm

	dcb	$impl		; c8 = iny
	dcb	$iny_nm

	dcb	$accimm		; c9 = cmp #imm (##imm)
	dcb	$cmp_nm

	dcb	$impl		; ca = dex
	dcb	$dex_nm

	dcb	$impl		; cb = wai
	dcb	$wai_nm

	dcb	$abs		; cc = cpy abs
	dcb	$cpy_nm

	dcb	$abs		; cd = cmp abs
	dcb	$cmp_nm

	dcb	$abs		; ce = dec abs
	dcb	$dec_nm

	dcb	$absl		; cf = cmp >dbr,adr
	dcb	$cmp_nm

	dcb	$rel8		; d0 = bne rel8
	dcb	$bne_nm

	dcb	$dpiniy		; d1 = cmp (<dir),y
	dcb	$cmp_nm

	dcb	$dpin		; d2 = cmp (<dir)
	dcb	$cmp_nm

	dcb	$skriiy		; d3 = cmp (offset,s),y
	dcb	$cmp_nm

	dcb	$dp		; d4 = pei <dir
	dcb	$pei_nm

	dcb	$dpix		; d5 = cmp <dir,x
	dcb	$cmp_nm

	dcb	$dpix		; d6 = dec <dir,x
	dcb	$dec_nm

	dcb	$dpiliy		; d7 = cmp [<dir],y
	dcb	$cmp_nm

	dcb	$impl		; d8 = cld
	dcb	$cld_nm

	dcb	$absiy		; d9 = cmp abs,y
	dcb	$cmp_nm

	dcb	$impl		; da = phx
	dcb	$phx_nm

	dcb	$impl		; db = stp
	dcb	$stp_nm

	dcb	$absin		; dc = jml (abs)
	dcb	$jml_nm

	dcb	$absix		; dd = cmp abs,x
	dcb	$cmp_nm

	dcb	$absix		; de = dec abs,x
	dcb	$dec_nm

	dcb	$abslix		; df = cmp >dbr,adr,x
	dcb	$cmp_nm

	dcb	$idximm		; e0 = cpx #imm (##imm)
	dcb	$cpx_nm

	dcb	$dpixin		; e1 = sbc (<dir,x)
	dcb	$sbc_nm

	dcb	$immed2		; e2 = sep #imm
	dcb	$sep_nm

	dcb	$skr		; e3 = sbc offset,s
	dcb	$sbc_nm

	dcb	$dp		; e4 = cpx <dir
	dcb	$cpx_nm

	dcb	$dp		; e5 = sbc <dir
	dcb	$sbc_nm

	dcb	$dp		; e6 = inc <dir
	dcb	$inc_nm

	dcb	$dpinl		; e7 = sbc [<dir]
	dcb	$sbc_nm

	dcb	$impl		; e8 = inx
	dcb	$inx_nm

	dcb	$accimm		; e9 = sbc #imm (##imm)
	dcb	$sbc_nm

	dcb	$impl		; ea = nop
	dcb	$nop_nm

	dcb	$impl		; eb = xba
	dcb	$xba_nm

	dcb	$abs		; ec = cpx abs
	dcb	$cpx_nm

	dcb	$abs		; ed = sbc abs
	dcb	$sbc_nm

	dcb	$abs		; ee = inc abs
	dcb	$inc_nm

	dcb	$absl		; ef = sbc >dbr,adr
	dcb	$sbc_nm

	dcb	$rel8		; f0 = beq rel8
	dcb	$beq_nm

	dcb	$dpiniy		; f1 = sbc (<dir),y
	dcb	$sbc_nm

	dcb	$dpin		; f2 = sbc (<dir)
	dcb	$sbc_nm

	dcb	$skriiy		; f3 = sbc (offset,s),y
	dcb	$sbc_nm

	dcb	$abs		; f4 = pea abs
	dcb	$pea_nm

	dcb	$dpix		; f5 = sbc <dir,x
	dcb	$sbc_nm

	dcb	$dpix		; f6 = inc <dir,x
	dcb	$inc_nm

	dcb	$dpiliy		; f7 = sbc [<dir],y
	dcb	$sbc_nm

	dcb	$impl		; f8 = sed
	dcb	$sed_nm

	dcb	$absiy		; f9 = sbc abs,y
	dcb	$sbc_nm

	dcb	$impl		; fa = plx
	dcb	$plx_nm

	dcb	$impl		; fb = xce
	dcb	$xce_nm

	dcb	$abixi		; fc = jsr (abs,x)
	dcb	$jsr_nm

	dcb	$absix		; fd = sbc abs,x
	dcb	$sbc_nm

	dcb	$absix		; fe = inc abs,x
	dcb	$inc_nm

	dcb	$abslix		; ff = sbc >dbr,adr,x
	dcb	$sbc_nm


;
;	alpha names for the opcodes
;
opcnam::

	dcs	"adc\0"		; 0
	dcs	"and\0"		; 1
	dcs	"asl\0"		; 2
	dcs	"bcc\0"		; 3
	dcs	"bcs\0"		; 4
	dcs	"beq\0"		; 5
	dcs	"bit\0"		; 6
	dcs	"bmi\0"		; 7
	dcs	"bne\0"		; 8
	dcs	"bpl\0"		; 9
	dcs	"bra\0"		; 10
	dcs	"brk\0"		; 11
	dcs	"brl\0"		; 12
	dcs	"bvc\0"		; 13
	dcs	"bvs\0"		; 14
	dcs	"clc\0"		; 15
	dcs	"cld\0"		; 16
	dcs	"cli\0"		; 17
	dcs	"clv\0"		; 18
	dcs	"cmp\0"		; 19
	dcs	"cop\0"		; 20
	dcs	"cpx\0"		; 21
	dcs	"cpy\0"		; 22
	dcs	"dec\0"		; 23
	dcs	"dex\0"		; 24
	dcs	"dey\0"		; 25
	dcs	"eor\0"		; 26
	dcs	"inc\0"		; 27
	dcs	"inx\0"		; 28
	dcs	"iny\0"		; 29
	dcs	"jml\0"		; 30
	dcs	"jmp\0"		; 31
	dcs	"jsl\0"		; 32
	dcs	"jsr\0"		; 33
	dcs	"lda\0"		; 34
	dcs	"ldx\0"		; 35
	dcs	"ldy\0"		; 36
	dcs	"lsl\0"		; 37
	dcs	"lsr\0"		; 38
	dcs	"mvn\0"		; 39
	dcs	"mvp\0"		; 40
	dcs	"nop\0"		; 41
	dcs	"ora\0"		; 42
	dcs	"pea\0"		; 43
	dcs	"pei\0"		; 44
	dcs	"per\0"		; 45
	dcs	"pha\0"		; 46
	dcs	"phb\0"		; 47
	dcs	"phd\0"		; 48
	dcs	"phk\0"		; 49
	dcs	"php\0"		; 50
	dcs	"phx\0"		; 51
	dcs	"phy\0"		; 52
	dcs	"pla\0"		; 53
	dcs	"plb\0"		; 54
	dcs	"pld\0"		; 55
	dcs	"plp\0"		; 56
	dcs	"plx\0"		; 57
	dcs	"ply\0"		; 58
	dcs	"rep\0"		; 59
	dcs	"rol\0"		; 60
	dcs	"ror\0"		; 61
	dcs	"rti\0"		; 62
	dcs	"rtl\0"		; 63
	dcs	"rts\0"		; 64
	dcs	"sbc\0"		; 65
	dcs	"sec\0"		; 66
	dcs	"sed\0"		; 67
	dcs	"sei\0"		; 68
	dcs	"sep\0"		; 69
	dcs	"sta\0"		; 70
	dcs	"stp\0"		; 71
	dcs	"stx\0"		; 72
	dcs	"sty\0"		; 73
	dcs	"stz\0"		; 74
	dcs	"tax\0"		; 75
	dcs	"tay\0"		; 76
	dcs	"tcd\0"		; 77
	dcs	"tcs\0"		; 78
	dcs	"tdc\0"		; 79
	dcs	"trb\0"		; 80
	dcs	"tsb\0"		; 81
	dcs	"tsc\0"		; 82
	dcs	"tsx\0"		; 83
	dcs	"txa\0"		; 84
	dcs	"txs\0"		; 85
	dcs	"txy\0"		; 86
	dcs	"tya\0"		; 87
	dcs	"tyx\0"		; 88
	dcs	"wai\0"		; 89
	dcs	"xba\0"		; 90
	dcs	"xce\0"		; 91
	dcs	"wdm\0"		; 92

	title	"65816 Disassembler"
