/*	Graphics terminal subroutines with DMA for AED's 767.
*****************************************************************
*								*
*	All rights reserved:	VENTURCOM INC.	1982,83		*
*								*
*	This source listing is supplied in accordance with	*
*	the Software Agreement you have with VenturCom and	*
*	the Western Electric Company.				*
*								*
*****************************************************************/

#include <stdio.h>

/*	It turns out that it's not a good idea to send
	"any reasonable output" via command DMA.  One problem
	is that if some of the output contains time consuming
	commands like IFL the terminals' input buffer can
	overflow. There are other problems.
	
	The ifdef DMA code can (should) probably be removed.
	The scd routine can be used for command DMA, but it's
	up to the user to supply "reasonable output".
*/
	
	

/* #define	DMA	1	/* all reasonable output goes via command dma */
			/* otherwise by byte per interrupt transfer */
#define	NUMINT	2	/* size of transfer to try command dma instead */
			/* of bytes out */
#ifndef	DMA
#define	AEDOUTDEV	"/dev/aedbytes"
#define	AEDOUTFD	aed6fd
#define	AEDOUTOP	aed6op
#endif
#ifdef	DMA
#define	AEDOUTDEV	"/dev/aedwrcmd"
#define	AEDOUTFD	aed5fd
#define	AEDOUTOP	aed5op
#endif


/*	There are 2 new entries to aedsubs - dmaraster and aoidma.
	Both are called from TAP - see TAP functions rda,wda,rrd,wrd.
	dmaraster and aoidma are similar to ibyte,obyte in that they
	mostly just open a file if not open if possible and then
	issue read or write, as the case may be.  They're different
	in that one arg is a read/write flag.  All these functions
	are so similar that I'm toying with the idea of consolidating
	them into one function with args device number and read/write
	flag in addition to the usual buf,count.
*/
 
		
#define AOIDMADEV	"/dev/aedimaoi"	
static int aed3op = 0;
static int aed3fd;
#define IMADMADEV	"/dev/aedimage"
static int aed1op = 0;
static int aed1fd;


static char	aeddbfl = 0;
static	int	aed5op = 0;
static	int	aed5fd;
static	int	aed6op = 0;
static	int	aed6fd;

/*	aed_dummy is used as a one byte buffer	*/
/*	to read/write the first byte when the users */
/*	buffer is on an odd address.		*/
	
static int 	aed_dummy;



obyte(aedbfr,i) char *aedbfr; unsigned i;
{
	register char *pntr;
	register j;
	if(aed6op == 0){
		if((aed6fd = open("/dev/aedbytes",2)) < 1){
	fprintf(stderr,"open err (aedsubs-ordcmd:/dev/aedbytes)\n");
			exit(1);
		}
		aed6op++;
	}
#ifdef	DMA
	if(AEDOUTOP == 0){
		if((AEDOUTFD = open(AEDOUTDEV,2)) < 1){
			fprintf(stderr,"open err (aedsubs-obyte:");
			fprintf(stderr,AEDOUTDEV);
			fprintf(stderr,")\n");
			exit(1);
		}
		AEDOUTOP++;
	}
#endif
	if(i==0){
		printf("aed- zero byte count\n");
		return (-1);
	}
	if(aedbfr&1){
/*
fprintf(stderr,"warning-odd address buf (aedsubs-obyte)\n");
*/
		aed_dummy = *aedbfr++;
		if((j = write(aed6fd,&aed_dummy,1) != 1)){
			fprintf("write error %d\n",j);
			exit(1);
		}
		if(--i == 0)
			return;
	}
/* end of fix	*/

#ifdef	DMA
	if(i >= NUMINT){
		pntr = aedbfr + i;
		if(pntr&1){
			i++;
			*pntr = 0;
		}
		if((j = write(AEDOUTFD,aedbfr,i)) != i){
			fprintf(stderr,"write err %d (aedsubs-obyte:",j);
			fprintf(stderr,AEDOUTDEV);
			fprintf(stderr,")\n");
			exit(1);
		}	
		if(aeddbfl){
			pntr = aedbfr;
			for (j=0;j<i;j++)fprintf(stdout,"d%o\n",*pntr++);
		}
	}else 
#endif
	{	
		if((j = write(aed6fd,aedbfr,i)) != i){
fprintf(stderr,"write err %d (aedsubs-obyte:/dev/aedbytes)\n",j);
			exit(1);
		}
		if(aeddbfl){
			pntr = aedbfr;
			for (j=0;j<i;j++)fprintf(stdout,"b%o\n",*pntr++);
		}
	}
}
aoidma(aedbfr,i,rw)
char *aedbfr;
unsigned i;
/* int fd;		 1 = /dev/aedimage, 3 = /dev/aedimaoi	*/
char rw;		/*	0=read, else write	*/
{
	int j;
	if(aedbfr &01){
		fprintf(stderr,"aoidma - odd address\n");
		exit(1);
	}
	if(i == 0){
		fprintf(stderr,"aoidma - zero word count\n");
		exit(1);
	}
	if(aed3op == 0){
		if((aed3fd = open(AOIDMADEV,2)) <0){
			fprintf(stderr,"open failed on DMAOUT\n");
			exit(1);
		} 
		aed3op++;
	}
	switch(rw){
	case 0:	/* read aoi	*/
		if(( j = read(aed3fd,aedbfr,i)) != i){
			fprintf(stderr,"aoidmain - read error\n");
			exit(1);
		}
		break;

	default: /* write aoi	*/
		if(( j = write(aed3fd,aedbfr,i)) != i){
			fprintf(stderr,"aoidmaout - write error\n");
			exit(1);
		}
		break;

	}	/* end of read/write switch	*/
}

dmaraster(aedbfr,i,rw)
char *aedbfr;
unsigned i;
char rw;	/* 0= read, else write	*/
{
	int j;

	if(aedbfr & 1){
		fprintf(stderr,"raster - odd address\n");
		exit(1);
	}
	if(i == 0){
		fprintf(stderr,"dmaraster - zero word count\n");
		exit(1);
	}
	if(aed1op == 0){
		if((aed1fd = open(IMADMADEV,2)) < 0 ){
			fprintf(stderr,"open /image failed\n");
			exit(1);
		}
		aed1op++;
	}
	switch(rw){
	case 0:	/* read	*/
		if(( j=read(aed1fd,aedbfr,i)) != i){
			fprintf(stderr,"read raster failed %d %d\n",i,j);
			exit(1);
		}
		break;
	default: /* write	*/
		if((j=write(aed1fd,aedbfr,i)) != i){
			fprintf(stderr,"write raster failed %d %d\n",i,j);
			exit(1);
		}
		break;

	}	/* end of rw switch	*/
}
ordcmd(aedbfr,i) char *aedbfr; unsigned i;
{
	register char *pntr;
	register j;

	if(aed6op == 0){
		if((aed6fd = open("/dev/aedbytes",2)) < 1){
	fprintf(stderr,"open err (aedsubs-ordcmd:/dev/aedbytes)\n");
			exit(1);
		}
		aed6op++;
	}
	if(i == 0){
		fprintf(stderr,"ordcmd - zero byte count\n");
		exit(1);
	}

/* odd address fix 10/5/83 	--- roy	*/
	if(aedbfr&1){
		aed_dummy = *aedbfr++;
		if((j = write(aed6fd,&aed_dummy,1) != 1)){
			fprintf(stderr,"ordcmd write error %d\n",j);
			exit(1);
		}
		if(--i == 0)
			return;
	}
/* end of odd address fix	*/
	if((j = write(aed6fd,aedbfr,i)) != i){
fprintf(stderr,"write err %d (aedsubs-ordcmd:/dev/aedbytes)\n",j);
		exit(1);
	}
}
ibyte(aedbfr,n) char *aedbfr; unsigned n;
{
	char *pntr;
	register j;

	if(aeddbfl)fprintf(stdout,"ibyte(%o,%d);\n",aedbfr,n);

	if(aed6op == 0){
		if((aed6fd = open("/dev/aedbytes",2)) < 1){
	fprintf(stderr,"open error (aedsubs-ibyte:/dev/aedbytes)\n");
			exit(1);
		}
		aed6op++;

	}
	if(n == 0){
		fprintf(stderr,"ibyte - zero byte count\n");
		exit(1);
	}

	if(aedbfr&1){
/*
fprintf(stderr,"odd address buf (aedsubs-ibyte)\n");
*/
/* odd address fix -- roy 10/5/83 */
/*
user buffer is on odd address, so read first byte into
an even addressed temp, copy it to user buf, inc user pointer,
dec user count, read rest in usual way.
*/
		if((j = read(aed6fd,&aed_dummy,1)) != 1){
			fprintf(stderr," read error %d\n",j);
			exit(1);
		}
		*aedbfr++ = aed_dummy;
		if(--n == 0)
			return; 
	}
/* end of fix	*/

	if((j = read(aed6fd,aedbfr,n)) != n){
		fprintf(stderr,"read err %d (aedsubs-ibyte:/dev/aedbytes)\n",j);
		exit(1);
	}
	if(aeddbfl){
		pntr = aedbfr;
		for (j=0;j<n;j++)fprintf(stdout,"i%o\n",*pntr++);
	}
}
scd(aedbfr,i) char *aedbfr; unsigned i;

{
	register j;
	register char *pntr;
	if(aeddbfl)fprintf(stdout,"scd(%o,%d);\n",aedbfr,i);
	if(aed5op == 0){
		if((aed5fd = open("/dev/aedwrcmd",1)) < 1){
			fprintf(stderr,"open err (aedsubs:/dev/aedwrcmd)\n");
			exit(1);
		}
		aed5op++;
	}
	if(aedbfr&1){
		fprintf(stderr,"odd address buf (aedsubs-scd)\n");
		exit(1);
	}
	if(i == 0){
		fprintf(stderr,"scd - zero byte count\n");
		exit(1);
	}
	i <<= 1;
	if((j = write(aed5fd,aedbfr,i)) != i){
		fprintf(stderr,"write err %d (aedsubs-scd:/dev/aedwrcmd)\n",j);
		exit(1);
	}
	if(aeddbfl){
		pntr = aedbfr;
		for (j=0;j<i;j++)fprintf(stdout,"d%o\n",*pntr++);
	}
}
aeddebug(arg){
	if(arg) arg = 1;
	if(arg != aeddbfl){	
		if(arg)printf("aed debug printing on:\n");		
		else printf("aed debug printing off.\n");
		aeddbfl = arg;
	}
}
