#include "tcp.h"

esc()	/*  ESC - Enter interpreter mode.  */
{
	aedbf[0] = ESC;
	ordcmd(aedbf, 1);
}

xxx()	/* exit interpeter, enter text mode	*/
	/* recommend you use alf(), since xxx() */
	/* unfortunately causes a CR to be 	*/
	/* performed in single char mnemonic mode */

{
	aedbf[0] = XXX;
	obyte(aedbf,1);
}

/*	a frequent source of difficulty is omitting
	sif('P') after the original tapint().  tapint should
	probably do it, but then where would those people
	who actually want serial be ?
*/ 

sif(type)	/* select interface for returning */
int type;	/* data to host			*/
{
	switch(type){

	case	'S': /* return data via serial interface	*/
	case	'P': /*     "   "	parallel "		*/
	case	'M': /* return keystrokes over serial,other	*/
		     /* over parallel				*/	
	case	'D': /* display (don't send) returned data	*/
		
		 aedbf[0] = SIF;
		 aedbf[1] = type;
		 obyte(aedbf,2);
		 return;		

	default:
		printf(" sif ** invalid arg ** %c\n", type);
		printf(" use one of S P M D\n");
		exit(0);
	}
}

ers()		/* erase  screen */
{
	aedbf[0] = ERS;
	obyte(aedbf, 1);
}

blg(arg)				/* enable/disable blue line grid */
int arg;
{
	aedbf[0] = XTD;
	aedbf[1] = BLG;
	aedbf[2] = arg ? 1 : 0;
	obyte(aedbf,3);
}

ffd()			/* form feed */
{
	aedbf[0]= FFD;
	obyte(aedbf,1);
}

opt(opt1,value)			/* set programmable option switch */
int  opt1,value;
{

	if( (opt1 >= 0) && (opt1 < 8) ){
		aedbf[0] = OPT;
		aedbf[1] = opt1;
		aedbf[2] = (value ? 1 : 0);
		obyte(aedbf,3);
		}
	else{
		printf(" opt ** invalid arg %d\n",opt1);
		printf(" option must be in 0..7\n");
		exit(0);
	}
}
rst()				/* reset the terminal */
{
	aedbf[0]=RST;
	obyte(aedbf,1);
	sleep(-60);		/* wait a second	*/
}

scr()		/* send carriage return */
{
	aedbf[0] = SCR;
	ordcmd(aedbf,1);
}

sbr(main,aux)			/* set baud rate */
int main,aux;
{
	if(  ( ((main < 8) && (main >= 0)) || (main == '.') )
	   &&
	     ( ((aux < 8) &&  (aux >= 0))  || (aux == '.' ) )  ){	
		aedbf[0] = SBR;
		aedbf[1] = main;
		aedbf[2] = aux;
		obyte(aedbf,3);
		}
	else{
		printf(" sbr ** invalid arg(s) %d %d\n", main, aux);
		printf(" args must be in 0..7\n");
		exit(0);
	}
}

/*	wait delay/60 seconds before sending 	*/
/*	serial data to host.			*/

std(delay)	/* set turnaround delay */
int delay;
{
	aedbf[0] = STD;
	aedbf[1] = delay;
	obyte(aedbf,2);
}

/*	set Tektronix window size to 9 bits	*/
/*	if wsize = 0, 10 bits if n != 0.	*/

stw(wsize)
int wsize;
{
	aedbf[0]= XTD;
	aedbf[1]= STW;
	aedbf[2]= ( wsize ? 1 : 0);
	obyte(aedbf,3);
}

mar(xleft,xright)	/* set margin */
int xleft,xright;
{
	aedbf[0] = XTD;
	aedbf[1] = MAR;
	aedbf[2] = xleft.hibyte;
	aedbf[3] = xleft.lobyte;
	aedbf[4] = xright.hibyte;
	aedbf[5] = xright.lobyte;
	obyte(aedbf,6);
}

/*	display terminal status			*/
/*	shows version #, CAP, current color	*/
/*	on the display monitor.			*/
/*	available on AED1024 only		*/

aed()
{
	aedbf[0] = XTD;
	aedbf[1] = AED;
	obyte(aedbf,2);
}

