

#include <stdio.h>

/*	sign bit of a 12 bit int */
#define SIGN12 0x800


main(argc,argv)
int argc;
char **argv;
{
	int x,y;
	x = 1279;


	for(y=0;y<1024;y++)
		doit(x,y);
}

doit(dx,dy)	/* simulate Bresenhams algorithm using
		12bit and 16 bit arithmetic
		*/
int dx,dy;
{
	int i, ycount12,ycount16;

	int d12, i112, i212;	/* 12 bit variables */
	int d16, i116, i216;	/* 16 bit variables */

	d12 = (2 * dy - dx)>>1;	/* init for 12 bits */
	i112 = dy;
	i212 = (dy - dx);

	d16 = 2*dy - dx;	/* init for 16 bits */
	i116 = 2*dy;
	i216 = 2*(dy - dx);

	ycount12 = 0;
	ycount16 = 0;
	
	for(i=0;i<dx;i++){

		if(d12 & SIGN12)	/* (d12 < 0) ? */
			d12 += i112;	/* yes, move in x */
		else{
			d12 += i212;	/* no, move in y */
			ycount12++;
		}

		if(d16 < 0)		/* as above, 16 bit vars */
			d16 += i116;
		else{
			d16 += i216;
			ycount16++;
		}
		
		/* see if both moved same way */

		if(ycount12 != ycount16){
			printf("not same vector %d %d\n",dx,dy);
			return;	/* failed, do next vector */
		}
	}
}

