;
; Preliminary cursor drawing routines.
; Some Cware capabilities not yet implemented here
; are blinking cursor, and Caesar cursor functions.
;

cinit:
	php
	rep	#0x20
	lda	##640
	sta	<cx
	asl	a
	sta	<windx
	lda	##512
	sta	<cy
	asl	a
	sta	<windy
	lda	##0x800
	sta	<tbsizx
	sta	<dtmsx
	lda	##1700
	sta	<tbsizy
	sta	<dtmsy

	lda	##16*4
	sta	<jdxdy
	lda	##256*4
	sta	<joyx
	sta	<joyy

	lda	##-1
	sta	<cugrid
	sep	#0x20
	lda	#2
	sta	<curcol
	lda	#'+'
	sta	<cutype
	bsl	setpat	
$err:	plp
	rts	

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; set up cursor pattern for	;
; X or + shaped cursor.		;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

setpat:
	php
	sep	#0x20
	rep	#0x10
	phx
	phy
	lda	<cutype
	cmp	#'+'
;;;;;;;	bne	$defcur		; setup for default X shape.
	rep	#0x20		; 
	sep	#0x10
	ldy	#30
	lda	##0x8001
$xloop:	sta	(<curpat),y
	dey
	dey
	bpl	$xloop
	ldy	#14
	lda	##0x7ffe
	sta	(<curpat),y
	iny
	iny
	sta	(<curpat),y
	bra	$done	
$defcur:
$done:	rep	#0x30
	ply
	plx
	plp
	rts
				

;
; This subroutine is called from the
; graphics idle loop to update the cursor
; position and display the cursor.
; Also sends tablet coords if required.
;

curs:
	php
	rep	#0x10
	phx
	phy
	sep	#0x20
	lda	#16		; pad vs kbd bit.
	bit	<curson		; local cursor enabled?
	bmi	$1		; br if yes (kbd,mouse,tablet etc).
	bvc	$no		; br if cursor not drawn.
	bsl	rcurs
$no	
	lda	#32		; need to redraw host cursor ?
	bit	<curson
	beq	$done		; br if no, not enabled.
	ldx	<cx		; go draw host cursor.
	ldy	<cy
	jsl	>0,Dcurs
$done:
	rep	#0x30
	ply
	plx
	plp
	rts
$1:		

;;;	lda	<cudfmt
	bne	$tab		; br if mouse/tablet.
	lda	<vflag		; check for gin mode
	and	#2
	beq	$joy		; br if gin not on
	brl	$cgin

$tab:
;
; get cursor device coordinates.
;
	bsl	tabxy
	bcc	$2		; br if new data available.
	bit	<curson		; cursor already drawn ?
	bvs	$11		; br if yes, we're done.
	ldx	<cx		; go draw in same position.
	ldy	<cy
	jsl	>0,Dcurs	
$11:	brl	$done
$2:
	sta	<tbstat		; save tablet status.
	bsl	maptab		; map device to window coords.
	bcc	$3		; br if it's inside window.
	lda	#16
	tsb	<tbstat
	bra	$31
$3:	jsl	>0,Dcurs
$31:
;
; if we're in etc mode and pen status
; changed send status and coords.
;
	bit	<curdev		; are we allowed unsolicited reports ?
	bpl	$ret		; br if no, don't send until asked.
	bsl	sndtab	
$ret:	brl	$done

;
; here for cursor keys cursor.
;

$joy:
	rep	#0x20
;
; set cx = 5/8 joyx, cy = 1/2 joyy.
; obviously this is a windowless kludge.
;
	clc
	lda	<joyx
	asl	a
	asl	a
	adc	<joyx
	sta	<temp
	lsr	<temp
	lsr	<temp
	lsr	<temp
	ldx	<temp

	lda	<joyy
	sta	<temp
	lsr	<temp
	ldy	<temp

	jsl	>0,Dcurs
	brl	$done	

$cgin:				; check keystroke,dcur & sndhst
	lda	<rdykey
	bne	$l1
	jsl	>0,ChkKbd
	bcs	$joy		; if no key, then just upd cursor
$l1	jsl	>0,SndHst	; else send it
	stz	<rdykey
	jsl	>0,Tekc
	brl	$done


;
; This routine sends unsolicited tablet
; position reports at cursor update time.
;

sndtab:
	php
	rep	#0x10
	sep	#0x20

	lda	<tbstat		; did pen status change ?
	cmp	<oldtab	
	beq	$done		; br if no, no report.
	sta	<oldtab		; yes, save new status.
	bit	<curdev		; are we to report both pen up and down ?
	bvs	$sendit		; br if yes, report.
	bit	#15		; no, only on down.  is it down ?
	beq	$done		; br if no, no report.
$sendit
	lda	<tbname
	jsl	>0,Send
	lda	<tbstat
	jsl	>0,Sendb
	rep	#0x30
	ldx	<cx
	ldy	<cy
	lda	<tbstat
	bit	##16
	beq	$1
	ldx	<tbrawx
	ldy	<tbrawy
$1:
	txa
	jsl	>0,Sendw
	tya
	jsl	>0,Sendw
;
; optionally send cr
;
	sep	#0x20
	lda	<tekpri
	bit	#16
	beq	$done
	lda	#13
	jsl	>0,Send
$done
	plp
	rts



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Draw cursor subroutine.  Enter with the	;
; window relative cursor position in x,y	;
; registers.  After drawing cursor, x and	;
; y are stored in <cx, <cy.			;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

dcurs:
	php
	rep	#0x30
	phx
	phy
;
; round cursor coords as specified by scp command
;
	txa
	and	<cugrid
	tax
	tya
	and	<cugrid
	tay

	bit	<curson-1	; cursor drawn ?
	bvc	$draw		; no, go draw it.
	cpx	<cx		; yes, if it hasn't moved
	bne	$ers		;   then we're done.
	cpy	<cy
	bne	$ers
	brl	$done1		; cursor already drawn and didn't move.
$ers:	bsl	rcurs		; cursor moved, erase old one.
$draw:
	sep	#0x20
	lda	#64		; set cursor drawn flag.
	tsb	<curson
	stx	<cx		; save new cursor position.
	sty	<cy
	
	rep	#0x20
$f1	bit	Dpdone-1
	bvc	$f1
	stx	Rbx		; screen coords
	sty	Rby

	lda	DaFlag
	sta	<temp3
	and	##255-4
	sta	DaFlag

	sep	#0x20
	lda	<cutype
	cmp	#'L'
	bne	$1
	lda	#0xff
	bsl	lcu
	brl	$done

$1:	bit	Dpdone		; wait dpu done.
	bvc	$1
	lda	#7
	trb	Capctl		; x major up.
	lda	#0xff		; draw cursor in all planes.
	sta	Rbwmsk

	rep	#0x20
	sec
	txa
	sbc	##7
	sta	<temp1
	sec
	tya
	sbc	##7
	sta	<temp2
	sta	Rby

	sep	#0x30
	ldy	#0
$l0:
	rep	#0x20
	lda	<temp1
	sta	Rbx
	
	sep	#0x20
	ldx	#16
$l1:
	lda	Vmimaj
	sta	(<curbuf),y
	iny
	dex
	bne	$l1

	bit	Vmimin
	cpy	#0
	bne	$l0

	rep	#0x20
	lda	<temp2
	sta	Rby
				; save physical cap so we know where
	sta	<temp		; on the screen cursor is being drawn.

	ldx	#16
$loop:
	rep	#0x20
	lda	<temp1
	sta	Rbx
	sep	#0x20

	lda	(<curpat),y
	iny
	sta	Rbstip

	lda	<curcol

	sta	Stpmaj
	sta	Stpmaj
	sta	Stpmaj
	sta	Stpmaj
	sta	Stpmaj
	sta	Stpmaj
	sta	Stpmaj
	sta	Stpmaj

	lda	(<curpat),y
	iny
	sta	Rbstip
	lda	<curcol

	sta	Stpmaj
	sta	Stpmaj
	sta	Stpmaj
	sta	Stpmaj
	sta	Stpmaj
	sta	Stpmaj
	sta	Stpmaj
	sta	Stpmaj

	bit	Vmimin
	dex
	bne	$loop
	
	lda	<wmask
	sta	Rbwmsk

	rep	#0x30
	lda	<temp		; get cursor y position.
	cmp	##0x320		; in top half of screen ?
	bcc	$done		; br if no.

	lda	##vbmask
$w111:	bit	Vbflag
	beq	$w111
$done:
	lda	<temp3
	sta	DaFlag
$done1:	ply
	plx
	plp
	rtl

lcu:				; here to draw full screen cursor
	bit	Dpdone
	bvc	lcu
	sta	DaColr
	lda	<cuwmsk
	sta	Rbwmsk

	rep	#0x20
	lda	<cy		
	sta	Rby
	sta	0xfe02

	stz	Rbx
	lda	##1279
	sta	0xfe00
	sta	DaDva

	lda	<cx
$2	bit	Dpdone-1
	bvc	$2
	sta	Rbx		
	sta	0xfe00

	stz	Rby
	lda	##1023
	sta	0xfe02
	sta	DaDva

	sep	#0x20
	lda	<wmask
$w0	bit	Dpdone
	bvc	$w0
	sta	Rbwmsk
	lda	<color
	sta	DaColr
	rts

rcurs:
	php
	sep	#0x20
	bit	<curson
	bvs	$1
	plp
	rts
$1:
	rep	#0x30
	pha
	phx
	phy

	lda	DaFlag
	sta	<temp3
	and	##255-4		; disable clipping
	sta	DaFlag

;	lda	<winox		; make virtual = physical, so we draw at
;$f3	bit	Dpdone-1
;	bvc	$f3
;	sta	Xorg		; screen coords
;	lda	<winoy
;	sta	Yorg
;	lda	##1280
;	sta	<windx
;	lda	##1024
;	sta	<windy

	lda	<cutype
	and	##0xff
	cmp	##'L'
	bne	$p1

	sep	#0x30
	lda	#0
	bsl	lcu

	lda	#64
	trb	<curson
	brl	$done

$p1	sec
	lda	<cx
	sbc	##7
	sta	<temp1
	sec
	lda	<cy
	sbc	##7	

$w1:	bit	Dpdone-1		; wait for dpu done.
	bvc	$w1	

	sta	Rby

	sep	#0x30
	lda	#64
	trb	<curson
	lda	#0xff
	sta	Rbwmsk
	lda	#7
	trb	Capctl

	ldy	#0

	lda	#vbmask
$w2:	bit	Vbflag
	bne	$w2
$w3:	bit	Vbflag
	beq	$w3

$l0:
	rep	#0x20
	lda	<temp1
	sta	Rbx
	sep	#0x20
	ldx	#16
$l1:
	lda	(<curbuf),y
	sta	Vmimaj
	iny
	dex
	bne	$l1
	bit	Vmimin
	cpy	#0
	bne	$l0
$done:
	lda	<wmask
	sta	Rbwmsk
	rep	#0x30

	lda	##32
	bit	<curson
	bne	$done1

	lda	<cx
	sta	Rbx
	lda	Xcap
	sta	<xpos
	lda	<cy
	sta	Rby
	lda	Ycap
	sta	<ypos
$done1:
	lda	<temp3
	sta	DaFlag
	ply
	plx
	pla
	plp
	rts

crsend:
	end
