;
; Colorware compatible encoding scheme routines.
; Entries :
;		Getb	- returns byte in accumulator (high byte = 0).
;		Getw	- returns 16 bit word in acc.
;		Gdxdy	- returns 2 16 bit signed numbers in x, y.
;		Gcoor	- returns coordinate pair in x,y.
;		Sendb	- sends acc low byte (unsigned).
;		Sendw	- sends 16 bit unsigned value in acc.
;		Scoor	- sends coord pair in x,y registers.
;
; Note - only the 8 bit binary coordinate encoding scheme
;	 can fully support 11 bits of x, and signed x,y.
;

getb:
	php
	sep	#0x20
	lda	<otype
	bne	$m
	plp
	jmp	>0,Get
$m:
	cmp	#'M'
	bne	$h
	jsl	>0,Get
	asl	a
	asl	a
	asl	a
	asl	a
	pha
	jsl	>0,Get
	xba
	lda	#0
	xba
	and	#0xf
	ora	1,s
	sta	1,s
	pla
	plp
	rtl


$h:
	cmp	#'H'
	bne	$d
	rep	#0x30
	phx
	phy
	sep	#0x30
$1:	jsl	>0,Get
	bsl	xtob
	bcs	$1
	asl	a
	asl	a
	asl	a
	asl	a
	pha
	jsl	>0,Get
	bsl	xtob
	ora	1,s	
	sta	1,s
	pla
	rep	#0x30
	and	##0xff
	ply
	plx
	plp
	rtl

$d:
	cmp	#'D'
	bne	$7
	rep	#0x20
	bsl	decin
	and	##0xff
	plp
	rtl
$7:
	rep	#0x20
	jsl	>0,Get
	and	##0x7f
	plp
	rtl

	
getw:
	php
	sep	#0x20
	lda	<otype
	bne	$hm
	jsl	>0,Get		; get high byte
	sta	<iotemp		; save it.
	jsl	>0,Get		; get low byte.
	xba			; move it to acc high byte.
	lda	<iotemp		; get high byte.
	xba
	plp
	rtl			; thats it.
$hm:
	cmp	#'M'
	beq	$h0
	cmp	#'H'
	bne	$d
$h0	jsl	>0,Getb		; get high byte.
	pha
	jsl	>0,Getb		; low byte.
	xba
	pla			
	xba
	plp
	rtl		

$d:
	cmp	#'D'
	bne	$7
	bsl	decin
	plp
	rtl

$7:
	jsl	>0,Get		; get high byte.
	and	#0x7f
	sta	<iotemp
	jsl	>0,Get		; get low byte.
	asl	a
	lsr	<iotemp
	ror	a
	xba
	lda	<iotemp
	xba
	plp
	rtl


gdxdy:
	php
	rep	#0x30
	pha
	sep	#0x20
	lda	<otype
	bne	$hm
	rep	#0x20
	jsl	>0,Get	
	and	##0xff
	bit	##0x80
	beq	$1
	ora	##0xff00
$1:
	tax
	jsl	>0,Get
	and	##0xff
	bit	##0x80
	beq	$2
	ora	##0xff00
$2:
	tay
	pla
	plp
	rtl

$hm:
	cmp	#'M'
	beq	$h0
	cmp	#'H'
	bne	$d
$h0:	rep	#0x30
	jsl	>0,Getb
	bit	##0x80
	beq	$h1
	ora	##0xff00
$h1:	tax
	jsl	>0,Getb
	bit	##0x80
	beq	$h2
	ora	##0xff00
$h2:	tay
	pla
	plp
	rtl

$d:	cmp	#'D'
	bne	$7
	rep	#0x30
	bsl	decin
	tax

	bsl	decin
	tay
	pla
	plp
	rtl

$7:
	rep	#0x20
	jsl	>0,Get
	and	##0x7f
	bit	##0x40
	beq	$71
	ora	##0xff80
$71:	tax
	jsl	>0,Get
	and	##0x7f
	bit	##0x40
	beq	$72
	ora	##0xff80
$72:	tay
	pla
	plp
	rtl

	
gcoor:
	php
	rep	#0x20
	pha
	sep	#0x30
	lda	<ctype
	bne	$m

	jsl	>0,Get		; get high x,y bits.
	tax			; save it.
	and	#15		; get y bits.
	sta	<iotemp+3	; save y high byte.
	txa			; get x bits.
	lsr	a		; move em down.
	lsr	a
	lsr	a
	lsr	a

	sta	<iotemp+1	; save x high byte.
	jsl	>0,Get		; get x low byte.
	sta	<iotemp		; now <iotemp is x coord.

	jsl	>0,Get
	sta	<iotemp+2	; save low byte y.
$done:
	rep	#0x30
	ldx	<iotemp
	ldy	<iotemp+2
	pla
	plp
	rtl			; dots all folks.


$m:
	cmp	#'M'
	bne	$h
$m1:	jsl	>0,Get
	sec
	sbc	#0x30
	cmp	#0x10
	bcs	$m1

	tax
	and	#0x3
	sta	<iotemp+3		; y bits 8,9.
	txa
	lsr	a
	lsr	a
	and	#0x3			; x bits 8,9.
	sta	<iotemp+1

	jsl	>0,Get			; x bits 4,5,6,7.
	asl	a
	asl	a
	asl	a
	asl	a
	sta	<iotemp

	jsl	>0,Get			; x bits 0,1,2,3.
	and	#0xf
	tsb	<iotemp

	jsl	>0,Get			; y bits 4,5,6,7.
	asl	a
	asl	a
	asl	a
	asl	a
	sta	<iotemp+2

	jsl	>0,Get			; y bits 0,1,2,3.
	and	#0xf
	tsb	<iotemp+2

	brl	$done

$h:
	cmp	#'H'
	bne	$d
$h1:	jsl	>0,Get
	bsl	xtob
	bcs	$h1

	tax
	and	#0x3
	sta	<iotemp+3		; y bits 8,9.
	txa
	lsr	a
	lsr	a
	and	#0x3			; x bits 8,9.
	sta	<iotemp+1

	jsl	>0,Get			; x bits 4,5,6,7.
	bsl	xtob
	asl	a
	asl	a
	asl	a
	asl	a
	sta	<iotemp

	jsl	>0,Get			; x bits 0,1,2,3.
	bsl	xtob
	and	#0xf
	tsb	<iotemp

	jsl	>0,Get			; y bits 4,5,6,7.
	bsl	xtob
	asl	a
	asl	a
	asl	a
	asl	a
	sta	<iotemp+2

	jsl	>0,Get			; y bits 0,1,2,3.
	bsl	xtob
	and	#0xf
	tsb	<iotemp+2

	brl	$done

$d:
	cmp	#'D'
	bne	$7
	rep	#0x30
	bsl	decin
	tax
	bsl	decin
	tay
	pla
	plp
	rtl

$7:
	jsl	>0,Get		; get x9..7x10y9..7
	tax			; save it.
	and	#7		; get y bits.
	sta	<iotemp+3	; store where they belong.
	txa			; get x bits.
	lsr	a		; shift out y bits.
	lsr	a
	lsr	a

	lsr	a		; x10 to carry.
	bcc	$71
	ora	#8
$71:
	sta	<iotemp+1	; store where they belong.
	jsl	>0,Get		; get low byte of x.
	asl	a
	lsr	<iotemp+1
	ror	a
	sta	<iotemp
	jsl	>0,Get		; low byte of y.
	asl	a
	lsr	<iotemp+3
	ror	a
	sta	<iotemp+2
	brl	$done


sendb:
	php
	rep	#0x20
	pha
	sep	#0x20
	lda	<rtype
	bne	$m
	rep	#0x20
	pla
	plp
	jmp	>0,Send

$m:
	cmp	#'M'
	bne	$h
	rep	#0x30
	phx
	phy
	sep	#0x30
	lda	5,s
	lsr	a
	lsr	a
	lsr	a
	lsr	a
	ora	#'0'
	jsl	>0,Send
	lda	5,s
	and	#0xf
	ora	#'0'
	jsl	>0,Send
	rep	#0x30
	ply
	plx
	pla
	plp
	rtl

$h:
	cmp	#'H'
	bne	$d
	rep	#0x30
	phx
	phy
	sep	#0x30
	lda	5,s
	bsl	btox		; convert low acc to 2 hex dig.
	xba			; get ms digit in low acc.
	jsl	>0,Send		; send it.
	xba			; get ls digit.
	jsl	>0,Send		; send it.
	rep	#0x30
	ply
	plx
	pla
	plp
	rtl

$d:
	cmp	#'D'
	bne	$7
	rep	#0x20
	lda	1,s
	and	##0xff
	bsl	decout
	lda	##0xd
	jsl	>0,Send
	pla
	plp
	rtl
$7:
	lda	1,s
	and	#0x7f
	jsl	>0,Send
	rep	#0x20
	pla
	plp
	rtl

sendw:
	php
	rep	#0x20
	pha
	sep	#0x20
	lda	<rtype
	bne	$hm

	rep	#0x20
	pla
	xba	
	jsl	>0,Send		; send high byte
	xba
	plp
	jmp	>0,Send		; send low byte

$hm:
	cmp	#'D'
	beq	$d
	cmp	#'7'
	beq	$7
	rep	#0x20
	pla
	xba			; get high byte.
	jsl	>0,Sendb	; (preserves acc).
	xba
	plp
	jmp	>0,Sendb
	

$d:
	rep	#0x20
	pla
	bsl	decout
	lda	##0xd
	jsl	>0,Send
	plp
	rtl
$7:
	rep	#0x20
	lda	1,s
	asl	a		; bit 7 to high byte.
	xba			; swap high,low bytes.
	jsl	>0,Send		; send high byte.
	xba
	lsr	a
	and	##0x7f
	jsl	>0,Send
	pla
	plp
	rtl

scoor:
	php
	rep	#0x30
	pha
	phx
	phy

	sep	#0x20
	lda	<ctype
	bne	$m

	lda	3+1,s		; high byte x.
	asl	a
	asl	a
	asl	a
	asl	a
	sta	<iotemp
	lda	1+1,s		; high byte y.
	and	#0xf
	ora	<iotemp
	jsl	>0,Send
	lda	3,s		; low byte x.
	jsl	>0,Send
	lda	1,s		; low byte y.
	jsl	>0,Send
$done:
	rep	#0x30
	ply
	plx
	pla
	plp
	rtl

$m
	cmp	#'M'
	bne	$h
	sep	#0x30
	lda	4,s		; x high byte.
	asl	a
	asl	a
	and	#0xc
	ora	2,s		; y high byte.
	ora	#0x30		; make modified hex.
	jsl	>0,Send

	lda	3,s		; x low byte.
	lsr	a		; high nibble.
	lsr	a
	lsr	a
	lsr	a
	ora	#0x30
	jsl	>0,Send

	lda	3,s		; x low low nibble.
	and	#0xf
	ora	#0x30
	jsl	>0,Send

	lda	1,s		; y low high nibble.
	lsr	a
	lsr	a
	lsr	a
	lsr	a
	ora	#0x30
	jsl	>0,Send

	lda	1,s		; y low low nibble.
	and	#0xf
	ora	#0x30
	jsl	>0,Send

	brl	$cropt		; if opt(2,1) send cr.

$h
	cmp	#'H'
	bne	$d
	sep	#0x30
	lda	4,s		; x high byte.
	asl	a
	asl	a
	and	#0xc
	ora	2,s		; y high byte.
	bsl	btox
	jsl	>0,Send
	lda	3,s		; x low byte.
	bsl	btox
	xba
	jsl	>0,Send
	xba
	jsl	>0,Send
	lda	1,s		; y low byte.
	bsl	btox
	xba
	jsl	>0,Send
	xba
	jsl	>0,Send
$cropt
	sep	#0x20
	lda	<tekpri
	bit	#2
	bne	$cr1
	lda	#13
	jsl	>0,Send
$cr1
	brl	$done

$d:
	cmp	#'D'
	bne	$7
	rep	#0x30
	txa
	bsl	decout
	lda	##0x0d
	jsl	>0,Send
	tya
	bsl	decout
	lda	##0x0d
	jsl	>0,Send
	brl	$done
;
; modified for 11 bits of x.
; x10 goes where y10 should.
;

$7:
	rep	#0x30
	stx	<iotemp
	sty	<iotemp+2
;
; copy x10 to y10.
;
	lda	##1024
	and	<iotemp
	tsb	<iotemp+2

	asl	<iotemp+2
	txa
	lsr	a
	lsr	a
	lsr	a
	sep	#0x30
	and	#0x70
	ora	<iotemp+3
	jsl	>0,Send

	txa
	and	#0x7f
	jsl	>0,Send

	tya
	and	#0x7f
	jsl	>0,Send
	brl	$done

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Local routine to convert incoming	;
; decimal digits string to binary.	;
; Returns unsigned value in acc, with	;
; minus flag set if string preceeded 	;
; by '-'.				;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

decin:

;
; local temps etc.
;
$temp	equ	edtemp
$result	equ	edtemp+2

	rep	#128		; assume positive value.
	php
	rep	#0x20
	stz	<$temp
	stz	<$result
	sep	#0x20		; 8 bit mem.

$1:
	jsl	>0,Get
	cmp	#'-'		; minus sign ?
	bne	$2		; br if no.
	lda	1,s		; get callers psw.
	eor	#128		; toggle callers minus flag.
	sta	1,s
	bra	$1		; gobble til decimal digit comes.
$2:
	sec			; test for decimal digit.
	sbc	#'0'
	cmp	#10
	bcs	$1		; br if not decimal digit.
	sta	<$result	; save partial result.
	bra	$nxt		; get rest of digits.

$isdec	rep	#0x21		; 16 bit mem, clear carry.
	asl	<$result	; mult partial times 2.
	lda	<$result
	asl	a		; partial times 4.
	asl	a		; partial times 8.
	adc	<$result	; get partial times 10
	adc	<$temp		; add value current digit.
	sta	<$result	; save new partial result.
$nxt:
	jsl	>0,Get
	sep	#0x21		; 8 bit mem, set carry.
	sbc	#'0'
	sta	<$temp		; save value of (possible) digit.
	cmp	#10		
	bcc	$isdec		; br if yes, update partial result.
	rep	#0x20
	lda	<$result
	plp
	bmi	$neg
	rts
$neg	php
	rep	#0x20
	eor	##-1
	inc	a
	plp
	rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Local routine to send the (unsigned)	;
; value in acc in decimal format.	;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

decout:
	php
	rep	#0x30
	pha
	phx
	phy
;
; point iotemp at table of powers of ten
;
	per	$tens
	plx
	stx	<edtemp
	phk
	phk
	plx
	stx	<edtemp+2

	ldy	##-2
;
; inc y until 10**y > acc.
;
$1:
	iny
	iny
	cmp	[<edtemp],y	; acc >= ten**y ?
	bcc	$4		; br if less.
	bne	$1		; loop if greater.
	iny
	iny
	bra	$4	
; 
; while(--y > 0)	(while acc >= 10)
; 	x = '0'
; 	while(acc >= 10**y)
;		acc -= 10**y
;		x++
;	output(x)
; output(acc + '0')
;
$2:
	sbc	[<edtemp],y	; subtract 10**y.
	inx			; inc coefficient of 10**y.
$22:	cmp	[<edtemp],y	; acc >= 10**y ?
	bcs	$2		; br if yes.
$3:
	pha			; save val being converted.
	txa			; get decimal digit.
	jsl	>0,Send
	pla			; recover val to convert.
$4:
	ldx	##'0'		; init coefficient of 10**y.
	dey			; down to onesies ?
	dey
	beq	$done
	bpl	$22		; br if no.
$done:
	ora	##'0'		; convert acc to decimal digit.
	jsl	>0,Send
	
	ply
	plx
	pla
	plp
	rts

$tens:	dcw	0
	dcw	10
	dcw	100
	dcw	1000
	dcw	10000
	dcw	-1



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Local routine to convert low byte of 	;
; acc to 2 hex digits, most significant	;
; digit in b.				;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

btox:
	php
	sep	#0x20
	pha			; save byte to convert.
	lsr	a		; get high nibble.
	lsr	a
	lsr	a
	lsr	a
	ora	#'0'		; add 0x30
	cmp	#'9'+1		; > '9 ?
	bcc	$1		; br if no.
	adc	#6		; add 7 (6+carry) to get 'A..'F'.
$1:	xba			; save hex digit in b.
	pla			; get byte to convert.
	and	#0xf		; convert low nibble.
	ora	#'0'
	cmp	#'9'+1
	bcc	$2
	adc	#6		; add 7 to get A..F.
$2:	plp
	rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Local routine to convert hex digit in	;
; acc to binary if poss. Return original;
; char w carry set if not hex.		;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

xtob:
	clc
	php
	sep	#0x31		; 8 bit m,x, set carry.
	tax
	sbc	#'0'
	cmp	#10
	bcc	$done		; br if decimal digit.
	txa			; get original char.
	ora	#0x20		; convert upper to lower case.
	sbc	#'a'		; carry still set.
	cmp	#6
	bcc	$1		; br if hex.
	txa			; not hex, restore original char.
	plp
	sec
	rts
$1:	adc	#10		; carry still clear
$done:
	plp
	rts
encend:
	end
