;
; Simple graphics routines.
; All routines assume interpreter
; direct page and dbr = 0.
;
; Entries :
;		INQ	- return status to host.
;		MOV	- move cap to (x,y).
;		MVR	- move cap relative (dx,dy).
;		RCP	- read cap.
;		WPX	- write pixel at cap.
;		RPX	- read pixel at cap.
;		SEC	- set current color.
;		SBC	- set background color.
;		SWM	- set write mask.
;		SRM	- set read mask.
;		OWR	- select/deselect overlay plane for read/write.
;		ODS	- make overlay plane visible/invisible.
;		OCL	- select overlay plane color.
;		CLP	- enable/disable clipping.
;		SPF	- select stipple pattern.
;		DSP	- define stipple pattern.
;		SLS	- set line style.
;		WMP	- write multiple pixels.
;		ERW	- erase window.
;		ERS	- erase screen.
;		RCT	- read color table.
;		SCT	- set color table.
;		SIF
;		SEN
;		OPT
;		SBL	- set blink



;
; INQ - return status to host.  Host sends a byte
; requesting certain information about the terminal.
; Terminal responds with 1 or more words, depending on
; the request.  If the request is not understood by the
; terminal, terminal responds with -1.
; Currently understood parameters :
; 0 - return firmware rev.
;

inq:
	php
	rep	#0x20
	jsl	>0,Getb
	cmp	##0
	bne	$1
	lda	##101		; rev 1.01
	brl	$done
$1
$what:	lda	##-1
$done:	jsl	>0,Sendw
	plp
	rtl

;
; MOV - Move CAP to x,y.
;
mov:
	php
	rep	#0x10
	jsl	>0,Gcoor
	stx	<xpos
	sty	<ypos
	plp
	rtl
;
; MVR - Move CAP relative dx, dy.
;
mvr:
	php
	rep	#0x30

	jsl	>0,Gdxdy
	txa
	clc
	adc	<xpos
	sta	<xpos

	tya
	clc
	adc	<ypos
	sta	<ypos

	plp
	rtl
;
; RCP - Send CAP to host.
;
rcp:
	php
	rep	#0x10
	ldx	<xpos
	ldy	<ypos
	jsl	>0,Scoor
	plp
	rtl
;
; RPX - Send pixel value at CAP to host.
;
rpx:
	php
	rep	#0x20

$1:	bit	Dpdone-1		; wait dpu done.
	bvc	$1

	lda	<xpos
	sta	Xcap
	lda	<ypos
	sta	Ycap
	sep	#0x20
	lda	Vm
	jsl	>0,Sendb
	plp
	rtl
;
; WPX - Write pixel value from host at CAP.
;
wpx:
	php
	rep	#0x20

$1:	bit	Dpdone-1		; wait dpu done.
	bvc	$1

	lda	<xpos
	sta	Xcap
	lda	<ypos
	sta	Ycap
	sep	#0x20
	jsl	>0,Getb
	sta	Vm
	plp
	rtl
;
; SEC - Set current color.
;

sec:
	php
	sep	#0x20
	jsl	>0,Getb	
	sta	<color

$1:	bit	Dpdone		; wait dpu not busy
	bvc	$1

	sta	DaColr
	plp
	rtl
;
; SBC - Set background color.
;

sbc:
	php
	sep	#0x20
	jsl	>0,Getb	
	sta	<bcolor

$1:	bit	Dpdone		; wait dpu done.
	bvc	$1

	sta	DaBclr
	plp
	rtl
;
; SWM - Set write mask.
;
swm:
	php
	sep	#0x20
	jsl	>0,Getb
	sta	<wmask

$1:	bit	Dpdone			; wait dpu done.
	bvc	$1

	sta	Rbwmsk
	plp
	rtl
;
; SRM - Set read mask.
;
srm:
	php
	sep	#0x20
	jsl	>0,Getb
	sta	<rmask

$1:	bit	Dpdone		; wait dpu done.
	bvc	$1

	lda	#vbmask
$2:	bit	Vbflag
	beq	$2

	lda	<rmask
	sta	Rbrmsk
;
; get 3 more bogus read masks for compatibility.
;
	jsl	>0,Getb
	jsl	>0,Getb
	jsl	>0,Getb

	plp
	rtl
;
; Set overlay plane color.
;
ocl:
	php
	sep	#0x20
	jsl	>0,Getb
	sta	<ocolor
$1:	bit	Dpdone			; wait for dpu done
	bvc	$1

	lda	#vbmask
$2:	bit	Vbflag
	beq	$2

	lda	<ocolor
	sta	Rbovcl
	plp
	rtl
;
; Enable/disable overlay plane reads and writes.
;
owr:
	php
	sep	#0x20
	jsl	>0,Getb
$1:	bit	Dpdone			; wait for dpu done.
	bvc	$1
	cmp	#0
	beq	$2
	lda	#0x20
	tsb	Capctl
	bra	$done
$2:	lda	#0x20
	trb	Capctl
$done:
	plp
	rtl
;
; Display/hide overlay plane.
;
ods:
	php
	sep	#0x20
	jsl	>0,Getb
	pha

$1:	bit	Dpdone		; wait for dpu done.
	bvc	$1

	lda	#vbmask
$2:	bit	Vbflag
	beq	$2

	pla
	beq	$3
	lda	#0x10
	tsb	Capctl
	bra	$done
$3:	lda	#0x10
	trb	Capctl
$done:
	plp
	rtl

;
; SLS - Set pattern for dashed lines.
; Note - Colorware supports a 'scale factor'
; for dashed lines, 1280 doesn't.
;
sls:
	php
	sep	#0x20
	jsl	>0,Getb
	sta	<lstyle		; line style.
	jsl	>0,Getb		; scale factor (pitch it).
	plp
	rtl	

;
; SPF - select stipple pattern for filled rectangles.
;
spf:
	php
	rep	#0x20
	jsl	>0,Getb
	and	##0x1f
	cmp	##17
	bcs	$done
	sta	<stpnum
$done:	plp
	rtl
;
; DSP - define stipple pattern.
; Note - stipple patterns are stored "backwards".
;

dsp:
	php
	rep	#0x30
	jsl	>0,Getb
	and	##0x1f
	cmp	##17
	bcs	$hosed
	dec	a
	bmi	$hosed
	asl	a
	asl	a
	asl	a
	adc	<stpbuf
	adc	##7
	tax
	ldy	##8
	sep	#0x20
$loop:
	jsl	>0,Getb
	sta	0,x
	dex
	dey
	bne	$loop
	plp
	rtl
$hosed:
	ldy	##8
	jsl	>0,Getb
	dey
	bne	$hosed
	plp
	rtl
;
; WMP - Write multiple pixels.
; 
wmp:
	php
	rep	#0x30
$loop:
	jsl	>0,Gdxdy
	txa
	bne	$1
	tya
	beq	$done
	txa
$1:
	clc
	adc	<xpos
	sta	<xpos
	sta	Xcap
	tya
	clc
	adc	<ypos
	sta	<ypos
	sta	Ycap
	sep	#0x20
	lda	<color
	sta	Vm
	rep	#0x20
	bra	$loop
$done:
	plp
	rtl
;
; WIP - Write incremental plotter mode.
; Write pixel at CAP, then advance CAP.
;
wip:
	php
	rep	#0x30

	jsl	>0,Getw
	sta	<temp

$wait:	bit	Dpdone-1
	bvc	$wait

	lda	<xpos		; set CAP.
	sta	Xcap
	lda	<ypos
	sta	Ycap

	sep	#0x30
	lda	<temp		; convert count to 8 bit looper.
	beq	$1
	inc	<temp+1
$1:
	lda	Capctl		; get ctl reg.
	and	#127-7		; save non-cap bits.
	sta	<temp1

	phk
	pla
	sta	<temp3+2
	per	$wipctl		; table for decoding direc bits.
	pla
	sta	<temp3
	pla
	sta	<temp3+1
$loop:
	jsl	>0,Getb
	sta	<temp2		; save for later.
	lsr	a		; get first direction code.
	lsr	a
	lsr	a
	bsr	$wipwrt		; go write pixel and adv cap.
	beq	$done		; br if no more pixels to do.
$2:
	lda	<temp2		; get direction codes.
	bsr	$wipwrt		; go write pixel and adv cap.
	bne	$loop		; br if more pixels to do.
$done:
	rep	#0x30

	lda	Xcap		; update firmware cap
	sta	<xpos		; from hardware cap.
	lda	Ycap
	sta	<ypos

	plp
	rtl


$wipwrt:
	and	#7		; get direction code.
	asl	a		; convert to index.
	tay			; point to record for this direc.
	lda	[<temp3],y	; get cap ctl bits for direc.
	ora	<temp1		; or in with real bits.
	sta	Capctl		; set cap inc direction etc.
	iny			; point to index of vm reg.
	lda	[<temp3],y	; get index.
	tax			; put in x for indexing.
	lda	<color		; get color to write.
;
; for some reason this instruction
; doesn't work (hardware problem), so fake it.
;	sta	Vm,x		; write pixel and advance.

	cpx	#2
	bne	$w1
	sta	Vmimaj
	bra	$w4
$w1:	cpx	#4
	bne	$w2
	sta	Vmimin
	bra	$w4
$w2:	sta	Vmimm
$w4:
	dec	<temp		; dec pixel count, return
	bne	$3		; with z flag set if done.
	dec	<temp+1
$3:	rts

;
; CAP ctl bits for WIP.  x is always major,
; hence the references to xdn etc.
;

$wipctl:

$xdn	equ	2
$ydn	equ	1

$ix	equ	2
$ixy	equ	4
$iy	equ	6

	dcb	0
	dcb	$ix

	dcb	0
	dcb	$ixy

	dcb	0
	dcb	$iy

	dcb	$xdn
	dcb	$ixy

	dcb	$xdn
	dcb	$ix

	dcb	$xdn+$ydn
	dcb	$ixy

	dcb	$ydn
	dcb	$iy

	dcb	$ydn
	dcb	$ixy


;
; Erase window.
;

erw:
	php
	sep	#0x20

	lda	#vbmask
$2:	bit	Vbflag
	beq	$2

	sta	DaErw
	plp
	rtl

;
; erase screen
;
ers:	jmp	>0,Erase


;
; A copy of the color table is kept in 3
; RAM arrays, 1 for each of red, green, blue.
; Actual color table updates are done by a
; kernel routine which makes sure the update
; is not done during screen refresh.

;
; RCT - Read color table.
; 

rct:
	php
	sep	#0x30
	jsl	>0,Getb
	tay
	jsl	>0,Getb
	tax

$loop:
	lda	Redclt,y
	jsl	>0,Sendb
	lda	Grnclt,y
	jsl	>0,Sendb
	lda	Bluclt,y
	jsl	>0,Sendb
	iny			; bump to next color.
	dex			; more colors ?
	bne	$loop
$done:
	plp
	rtl
	

;
; SCT	- Set color table.
;
sct:
	php
	sep	#0x30

	jsl	>0,Getb		; get first color.
	pha			; save for later
	tay			; and for now.
	jsl	>0,Getb		; get # colors to set up.
	pha			; save for later
	tax			; and for now.

$loop:
	jsl	>0,Getb
	sta	Redclt,y
	jsl	>0,Getb
	sta	Grnclt,y
	jsl	>0,Getb
	sta	Bluclt,y
	iny
	dex
	bne	$loop

	plx			; color count.
	ply			; first color
	jsl	>0,SetClt	; do the actual update.

	plp
	rtl


sif:
	php
	sep	#0x20
	jsl	>0,Get
	cmp	#'S'
	bne	$1
	lda	#0
	bra	$done
$1:	cmp	#'P'
	bne	$2
	lda	#128
	bra	$done
$2:	cmp	#'M'
	bne	$3
	lda	#128+64
	bra	$done
$3:	cmp	#'D'
	bne	$err
	lda	#64
$done:	sta	<sifval
$err:	plp
	rtl
	
sen:
	jsl	>0,Get
	jsl	>0,Get
g:
	php
	sep	#0x30
	jsl	>0,Get
	cmp	#'1'
	bne	$1
	stz	<ftype
	bra	$2
$1:	cmp	#'3'
	bne	$2
	lda	#0xff
	sta	<ftype
$2:
	ldx	#otype
	bsr	$doit
	ldx	#rtype
	bsr	$doit
	ldx	#ctype
	bsr	$doit

	jsl	>0,Get
	cmp	#'N'
	beq	$5
	cmp	#'M'
	beq	$5
	cmp	#'8'
	beq	$5
	cmp	#'7'
	beq	$5
	plp
	rtl
$5:	sta	<ptype
	plp
	rtl

$doit:
	jsl	>0,Get
	cmp	#'8'
	beq	$deflt
	cmp	#'D'
	beq	$ok
	cmp	#'H'
	beq	$ok
	cmp	#'M'
	beq	$ok
	cmp	#'7'
	beq	$ok
	rts
$deflt:
	lda	#0
$ok
	sta	<0,x
	rts

opt:
	php
	sep	#0x30
	jsl	>0,Getb
	tax
	jsl	>0,Getb
	sta	<temp
	lda	#64		; assume opt(6,?).
	cpx	#6		; tek override.
	beq	$1
	lda	#2		; assume opt(2,?).
	cpx	#2		; cr after gin data or rcp.
	beq	$1
	lda	#16		; assume opt(4,?).
	cpx	#4		; cr after tablet coords (etc or rtp).
	beq	$1
	lda	#4		; assume opt(3,?)
	cpx	#3		; 5x6 font after first gs
	beq	$1
	bra	$done
$1	ldy	<temp
	beq	$off
	tsb	<tekpri
	plp
	rtl
$off:	trb	<tekpri
$done:	plp
	rtl


sbl:				; set blink color
	php
	sep	#0x30
	
	jsl	>0,Getb		; get color
	tay
	ldx	#0
$1				; see if color already set up
	tya
	cmp	Bltab+3,x
	beq	$f2

	txa
	clc
	adc	#7		; next index value
	tax
	cmp	#56		; max table entry number
	bcc	$1
	ldx	#0		; color not blinked yet, so look for
$2				; a free one
	lda	Bltab,x
	beq	$f2		; found a free one
	txa
	clc
	adc	#7
	tax
	cmp	#56
	bcc	$2
	ldx	#0		; full, reuse first entry
	stz	Bltab		; make sure counter is 0
$f2
	stz	Bltab+1,x	; cancel ontime of that entry to stop
$3				; blinking
	lda	Bltab,x		; wait for current color to be done
	bne	$3

	tya
	sta	Bltab+3,x	; color to be blinked

	jsl	>0,Getb		; red for offtime
	sta	Bltab+4,x
	jsl	>0,Getb		; green
	sta	Bltab+5,x
	jsl	>0,Getb		; blue
	sta	Bltab+6,x	
	jsl	>0,Getb		; ontime
	sta	Bltab+1,x	
	jsl	>0,Getb		; offtime
	eor	#-1		; make it negative
	inc	a	
	sta	Bltab+2,x
	beq	$done1		; color not to be blinked if offtime=0

	inc	Blink		; increase number of blinking color
	lda	Bltab+1,x	; start ontime counter
	sta	Bltab,x
$done
	plp
	rtl
$done1
	dec	Blink		; one less color to blink
	bra	$done


	end
