
;
; Entries :
;		dtm	- set dtmx, dtmy, dtmsx, dtmsy.
;			- (default 0,0,880,680 hex).
;		etp	- turn on/off tablet driven cursor, and
;			- send data only on command (rtp).
;		rtp	- send tablet status and cursor position.
;		etc	- turn on/off tablet driven cursor
;			- and do an rtp whenever cursor is
;			- drawn (but see stp).
;		stp	- bit 1 set means Kurta or mouse,
;			- else GTCO (decimal format).
;			- bit 0 set means send data only on
;			- pen status change (etc).
;		sgt	- select graphics tablt.  will select 
;			  corresponding cudfmt.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; DTM (x,y,sx,sy) - define tablet mapping.		;
; This command establishes the tablet			;
; area to be mapped to the current window.		;
; x,y are the coords of the lower left corner		;
; of the tablet area, sx and sy are the dimensions	;
; of the tablet area in an encoded form.  The		;
; actual size of the tablet area is 65536/sx, 65536/sy.	;
; If the tab coords are not in this area, they are not	;
; scaled, and bit ?? of the tablet status is set.	;
; Note - if sx or sy is 0, dtm sets the corresponding	;
; size to the remainder of the tablet.			;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

dtm:
	php
	rep	#0x30
;
; get origin of tablet area.
;
	jsl	>0,Getw
	sta	<dtmx
	jsl	>0,Getw
	sta	<dtmy
;
; get sx,sy, compute and save x,y sizes.
;
	jsl	>0,Getb		; get sx.
	tax			; save it.
	jsl	>0,Getb		; get sy.
$1:	bit	Dpdone-1	; wait for dpu done.
	bvc	$1
;
; divide 2**16 by sy to get y size.
;
	cmp	##0
	bne	$11
	sec
	lda	<tbsizy
	sbc	<dtmy
	sta	<dtmsy
	bra	$dox
$11:
	sta	0xfe04		; store divisor sy.
	lda	##0x10		; high nibble of dividend
	sta	0xfe00		; goes in pr0.
	stz	0xfe02		; low 3 nibbles in pr1.
	sta	DaDiv		; divide.

$20:	bit	Dpdone-1
	bvc	$20

	lda	0xfe00		; get quotient.
	sta	<dtmsy		; save y size.
;
; divide 2**16 by sx to get x size.
;
$dox:
	txa
	bne	$22
	sec
	lda	<tbsizx
	sbc	<dtmx
	sta	<dtmsx
	bra	$done
$22:
	sta	0xfe04		; store divisor sx.
	lda	##0x10		; high nibble of dividend
	sta	0xfe00		; goes in pr0.
	stz	0xfe02		; low 3 nibbles in pr1.
	sta	DaDiv		; divide.

$30:	bit	Dpdone-1
	bvc	$30

	lda	0xfe00		; get quotient.
	sta	<dtmsx		; save y size.
$done:
	plp
	rtl


etc:
	php
	sep	#0x20
	lda	#128
	tsb	<curdev
	bra	etp1

etp:
	php
	sep	#0x20
	lda	#128
	trb	<curdev
	
etp1:
	jsl	>0,Get
	sta	<tbname
	cmp	#0
	beq	$1
	lda	#128+16
	tsb	<curson
	lda	#ledcur
	tsb	Leds
	plp
	rtl
$1	lda	#128+16
	trb	<curson
	lda	#ledcur
	trb	Leds
	plp
	rtl
;
;stp - 	bit 0 = etc sends on pen down only.
;	bit 1 = packed binary data format.
;
stp:
	php
	sep	#0x20
	jsl	>0,Getb
	lsr	a
	pha
	lda	#64
	bcc	$1
	tsb	<curdev
	bra	$2
$1:	trb	<curdev
$2:	pla
	lsr	a
	lda	#'D'
	bcc	$ok
	lda	#'1'
$ok:	sta	<cudfmt

	plp
	rtl

; status byte = 0 + pen status if inside window, x,y window relative
;              32 +  "     "      outside   "    x,y screen coords
;              32+16+ "    "         "      " & dtm window, x,y absolute

rtp:
	php
	rep	#0x10
	sep	#0x20
	lda	<tbname
	jsl	>0,Send
	rep	#0x30
	ldx	<cx
	ldy	<cy

	bsl	winmap		; map to window coords, & set status
	bcc	$l1
	lda	##32
	tsb	<tbstat

$l1	lda	<tbstat
	bit	##16
	beq	$1
	ldx	<tbrawx
	ldy	<tbrawy
$1:
	sep	#0x20
	lda	<tbstat
	jsl	>0,Sendb

	rep	#0x20
	txa
	jsl	>0,Sendw
	tya
	jsl	>0,Sendw
;
; optionally send cr
;
	sep	#0x20
	lda	<tekpri
	bit	#16
	beq	$done
	lda	#13
	jsl	>0,Send
$done
	plp
	rtl

; map coords in x,y to window relative coords if inside, carry set if 
; outside window

winmap:
	sec			; default
	php
	rep	#0x30
	phy			; preserve
	phx	

	txa
	sec
	sbc	<winox		; where is it compare to window corner?
	bcc	$outside	; br if <
	sta	<temp
	tya
	sec
	sbc	<winoy
	bcc	$outside
	sta	<temp1

;	sec
;	sbc	<windy		; compare to upper corner
;;	bcs	$outside
;	lda	<temp
;	sec
;	sbc	<windx
;	bcs	$outside

	cmp	<windy
	bcs	$outside
	lda	<temp
	cmp	<windx
	bcs	$outside

	clc
	lda	<temp		; virtual = physical - window corner - 
	adc	<worgx		; window origin
	tax

	clc
	lda	<temp1
	adc	<worgy
	tay

	pla
	pla
	plp
	clc
	rts		
	
$outside
	plx
	ply
	plp
	rts

sgt:				; select graphics tablet
	php
	sep	#0x30

	jsl	>0,Getb

	ldy	#'1'		; packed binary format
	ldx	#'K'		; 0 - Kurta
	cmp	#0
	beq	$found	

	ldx	#'M'
	cmp	#3		; 3 - Summa Mouse
	beq	$found

	ldx	#'L'
	cmp	#5		; 5 - LogicMouse
	beq	$found

	ldy	#'D'		; ASCII decimal
	ldx	#'S'	
	cmp	#1		; 1 - summagraphics bit pad 1
	beq	$found
	
	ldx	#'G'
	cmp	#2		; 2 - GTCO
	beq	$found

	ldx	#'S'		; default - Summagraphics bit pad 1
$found
	stx	<bptype
	sty	<cudfmt

	plp
	rtl

	end
