;	4014 Tek emulation.  This is the Colorware compatible version

;	vflag: 128 - not in vector mode
;	        64 - point plot
;		64+8 - special point plot
;		2  - gin mode
;	        1  - drawing undark vector
;	        0  - drawing dark vector


teki:				; tek interpreter
	php
	rep	#0x30
	pha
	phx
	phy
	sep	#0x30

	bit	<tekpri		; does tek has priority from EEprom?
	bpl	teki2		; br if not
	bvs	teki2		; opt command select AED over tek

	cmp	#'8'		; give 'em 12x16 for '8' & '9'
	bcc	$1
	cmp	#';'+1
	bcs	$1
	bsl	csize
	lda	#0
	brl	done
$1
	cmp	#'?'		; substitute for rubout
	bne	$10
	ldx	<vflag		; are we in graph mode?
	beq	done		; if so, go home
	lda	#127
	brl	tekil
$10
	cmp	#96		; 96-116 for line style
	bcc	teki2
	cmp	#117
	bcs	teki2
	brl	teklin
teki2
	cmp	#040		; if space go home
	bcs	done
	cmp	#26		; esc sub - GIN
	beq	gin
	cmp	#28		; esc FS - point plot
	beq	pplot
	cmp	#5		; esc enq - 
	beq	enq
	cmp	#12		; esc ff - goto alpha
	beq	teka2
	cmp	#29		; esc GS - graph mode
	bne	$1
	brl	graph
$1	cmp	#30		; esc RS - incremental plot
	bne	done
	brl	iplot
done
	sta	5,s
	lda	#0
	sta	6,s	
	rep	#0x30
	ply
	plx
	pla
	plp
	rtl

gin:				; gin mode
	lda	#2
	sta	<vflag		; exit graph mode
	bsl	tekgin		; go display crosshair cursor
	lda	#0
;	brl	tekil
	brl	done		; should goto alpha mode

pplot:				; special point plot mode
	lda	#64+8
	tsb	<vflag
	brl	cg1
;	bra	tekil

enq:
	bsl	escenq
	lda	#0
;	brl	tekil
	brl	done

teka2:
	ldx	#128
	stx	<vflag
	stz	<lstyle
	brl	teka1
;	brl	done

tekil:
	tax
	lda	#128
	tsb	<vflag
;	stz	<temp
	rep	#0x20
	tsc
	clc
	adc	##10
	tcs
	sep	#0x20
	
	txa
;	lda	<temp
	jmp	>0,Alpha	; jump to alpha mode	

csize:				; set char size
	cmp	#'8'
	beq	$1
	cmp	#'9'
	bne	$2
$1
	lda	#12
	sta	<csx
	lda	#16
	sta	<csy
	lda	#14
	sta	<cwidth
	lda	#24
	sta	<chight
	lda	#24-16
	sta	<fudge
	lda	#3
	sta	<desc
	stz	<chrsiz		; might need to set DaCtl
	rep	#0x20
	stz	<fntptr
	sep	#0x20
	lda	#ROM
	sta	<fntbnk
	bra	$done
$2
	lda	#7
	sta	<csx
	lda	#9
	sta	<csy
	lda	#10
	sta	<cwidth
	lda	#16
	sta	<chight
	lda	#16-9
	sta	<fudge
	lda	#3
	sta	<desc
	stz	<chrsiz		; might need to set DaCtl
	rep	#0x20
	lda	##0xbc0
	sta	<fntptr
	sep	#0x20
	lda	#ROM
	sta	<fntbnk
$done
	lda	#0
;	lda	#27
	rts

texit:				; here if opcode not handled in graph mode
	ldx	#128		; so return to interpreter idle, and will
	stx	<vflag		; branch to alpha idle if applicable
	brl	done

graph:				; graph mode
	stz	<vflag		; init flag

cg1:	stz	<bflag		; init data byte order flag
	ldx	<vflag
	cpx	#64+9		; if we were doing spp, then reset for next
	bne	$1
	dec	<vflag
$1	lda	<tekpri		; see if we need to set to smaller font
	and	#4
	bne	gc		; br if 7x9 already		
	lda	#';'
	bsl	csize		; else set it and set flag
	lda	#4
	tsb	<tekpri	
gc:
	jsl	>0,Get
	
	cmp	#29		; here for a "mini" graph idle loop
	beq	graph
	cmp	#13		; cr
	beq	texit		; 
	cmp	#31		; us
	beq	texit		
	cmp	#30		; rs - goto incremental plot
	bne	$1
	brl	iplot
$1	cmp	#26		; sub
	beq	texit
	cmp	#12		; ff
	beq	texit
	cmp	#28		; fs - goto point plot
	bne	$3
	brl	pplot
$3	cmp	#27		; if it's esc, find out next char
	bne	$10
;	beq	gc
	brl	done
$10
	ldx	<vflag
	cpx	#64+8		; check for special point plot
	bne	$6
	inc	<vflag
	bra	gc

$6	tay			; temp
	and	#0x60
	beq	gc		; invalid data byte
	cmp	#0x60		; 5,6 = 11?
	beq	$loy
	cmp	#0x40		; 5,6 = 10?
	beq	$lox
	
	tya			; here if flag bits = 01, either hi y or x
	and	#0x1f		; keep only lower 5 bits
	ldy	<bflag		; bflag = 0 for hi y next, 
	bne	$hix		;         1     hi x  "
	sta	<hiy
	bra	gc
$hix:
	sta	<hix
	bra	gc
$loy:
	tya
	and	#0x1f		; keep only lower 5 bits
	sta	<loy
	inc	<bflag		; signal to get hi x next
	bra	gc
$lox:
	tya
	and	#0x1f		; keep only lower 5 bits
	sta	<tekx

	lda	<hiy
	lsr	a
	lsr	a
	lsr	a
	sta	<teky+1
	
	lda	<hiy
	asl	a
	asl	a
	asl	a
	asl	a
	asl	a
	ora	<loy
	sta	<teky

	lda	<hix
	lsr	a
	lsr	a
	lsr	a
	sta	<tekx+1
	
	lda	<hix
	asl	a
	asl	a
	asl	a
	asl	a
	asl	a
	ora	<tekx
	sta	<tekx

	rep	#0x20
	ldx	<vflag
	beq	upd		; br if drawing dark vector
	bit	<vflag-1
	bvs	pt		; br if doing point plot
$l1	bit	Dpdone-1
	bvc	$l1
	lda	<tekx
	sta	0xfe00
	lda	<teky
	sta	0xfe02
	lda	<xpos
	sta	Xcap
	lda	<ypos
	sta	Ycap

	sep	#0x20
	lda	<lstyle
	beq	$w1
	sta	Rbstip
	lda	#1
	tsb	DaCtl
	bra	$w2
$w1	inc	a
	trb	DaCtl
$w2	sta	DaDva
	rep	#0x20

upd:	lda	<tekx
	sta	<xpos
	lda	<teky
	sta	<ypos
	sep	#0x20
	ldx	<vflag
	bne	$4
	inc	<vflag		; make next vector undark if this one is
$4	brl	cg1
pt:				; point plot, write at end of vector
	bit	Dpdone-1
	bvc	pt
	lda	<tekx
	sta	Xcap
	lda	<teky
	sta	Ycap
	sep	#0x20
	lda	<color
	sta	Vm		
	bra	upd

iplot:				; incremental plot
	stz	<temp
$l1	bit	Dpdone
	bvc	$l1
iplot2:
	jsl	>0,Get
	
	cmp	#31		; us
	beq	$exit		; 
	cmp	#13		; cr
	beq	$exit
	cmp	#27		; esc
	bne	iplot1
	jsl	>0,Get		; get next char of esc sequence
	cmp	#12		; esc ff
	beq	$exit		
	cmp	#26		; esc sub
	bne	$exit
	brl	gin

$exit:	brl	done

iplot1:
	rep	#0x20
	and	##0xff
	ror	a
	bcc	$1
	inc	<xpos
$1	ror	a
	bcc	$2
	dec	<xpos
$2	ror	a
	bcc	$3
	inc	<ypos
$3	ror	a
	bcc	$4	
	dec	<ypos
$4	ror	a
	bcc	$5
	ldx	#1
	stx	<temp
$5	ror	a
	bcc	$6
	stz	<temp	
$6
	lda	<temp
	and	##0xff
	bne	$7		; don't draw if "beam off"
	sep	#0x20
	brl	iplot2
$7	lda	<xpos
	sta	Xcap
	lda	<ypos
	sta	Ycap
	sep	#0x20
	lda	<color			
	sta	Vm		; write the pixel
	brl	iplot2

teka:	
	php
	rep	#0x30
	pha
	phx
	phy

teka1:
	sep	#0x30
	cmp	#29		; gs
	bne	$1
	brl	graph
$1	cmp	#30		; rs
	bne	$2
	brl	iplot
$2	cmp	#28		; fs
	bne	$3
	lda	#64
	tsb	<vflag
	brl	cg1
$3	brl	done		; may be esc or alpha char to get written

teklin:
	and	#7
	tay
	rep	#0x20
	per	$pats
	pla
	sta	<temp
	phb
	phk
	plb
	sep	#0x20
	lda	(<temp),y
	sta	<lstyle
	plb
	lda	#0
;	lda	#27
	brl	done

$pats:	dcb	255
	dcb	128
	dcb	228
	dcb	240
	dcb	240
	dcb	255
	dcb	255
	dcb	255

escenq:				; send coords and forced exit to alpha
	lda	#40		; "status byte"
	jsl	>0,SndHst

	bit	<vflag		; find out if we're in graph mode
	bpl	$l1		; br if yes to send + cursor coord
	jsl	>0,Tekc

	lda	#128
	trb	<curson
	tsb	<acflag
	sta	<vflag
	rts
				; here to send beam addr
$l1	pei	<xpos
	bsl	sendtk
	pla			; clean trash on stack
	pla

	pei	<ypos		; see above, same format
	bsl	sendtk
	pla			; clean trash on stack
	pla
	brl	ensdtk

tekc:				; send + cursor coords and go home
	php
	sep	#0x30
	pei	<cx
	bsl	sendtk
	pla			; clean trash on stack
	pla

	pei	<cy
	bsl	sendtk
	pla			; clean trash on stack
	pla
	bsl	ensdtk
	plp
	rtl

sendtk:
	lda	3,s		; get low byte
	asl	a		; bit 7 in carry
	and	#0xc0		; save only bits 6,5
	sta	<temp

	lda	4,s		; get high byte
	and	#3		; only need low 2 bits
	ora	<temp		; acc= 6 5 x x x x 9 8
	rol	a		;      5 x x x x 9 8 7
	rol	a		;      x x x x 9 8 7 6
	rol	a		;      x x x 9 8 7 6 5
	bsl	sendt		; send high byte
	
	lda	3,s
	and	#0x1f
	bsl	sendt
	rts	

ensdtk:
	lda	<tekpri
	and	#2
	bne	$l1
	lda	#13		; cr
	jsl	>0,SndHst
$l1
	bsl	bypass		; bypass echoed data from host

	lda	#2
	trb	<vflag
	rts

sendt:
	and	#0x1f
	ora	#0x40		; needs bit 7,6 = 0,1
	jsl	>0,SndHst
	rts

bypass:				; tek bypass condition, "waste" echoed
	php			; data from host, erase cursor and exit
	rep	#0x30		; to alpha mode
	pha
	phx
	phy	
	sep	#0x30
$1
	jsl	>0,GetHst
	bcs	$1

$l2	cmp	#27		; esc?
	bne	$2
$3	jsl	>0,GetHst
	bcs	$3

	cmp	#12		; ff?
	beq	$5
	cmp	#15		; si
	beq	$done
	cmp	#23		; etb
	beq	$done

$2	cmp	#31		; us
	beq	$done
	cmp	#13		; cr
	beq	$5
	cmp	#7		; bell
	beq	$5
	cmp	#10		; lf
	bne	$1		; br if not any of the above exit cond.
				; probably one of the bypassed chars
$5
	jsl	>0,Dchar
$done
	lda	#128		; turn off cursor and led
	trb	<curson
	lda	#ledcur
	trb	Leds
	rep	#0x30
	ply
	plx
	pla
	plp
	rts

tekgin:				; here to display tek crosshair cursor,
	php
	rep	#0x30
	pha
	phx
	phy
	sep	#0x30

	lda	#128
;	tsb	<vflag
	tsb	<curson
	lda	#ledcur
	tsb	Leds

	rep	#0x30
	ply
	plx
	pla
	plp
	rts

tekend:
	end
