;
; Draw Hilberts curve of order n.
;

hcur:

$h	equ	254
$n	equ	252
$i	equ	250
$hd2	equ	248

	php
	rep	#0x30
	sta	<$n

	stz	<$i
	lda	##1024
	sta	<$h
	sta	<$hd2
	lsr	<$hd2
	lda	##640
	sta	<xpos
	lda	##512
	sta	<ypos

;	phk
;	bsl	getb
	lda	<$n
	and	##0xf
	beq	$done
	cmp	##11
	bcs	$done
	sta	<$n

$loop:
	inc	<$i

	lda	<$hd2
	sta	<$h
	lsr	<$hd2

	clc
	lda	<xpos
	adc	<$hd2
	sta	<xpos
	clc
	lda	<ypos
	adc	<$hd2
	sta	<ypos
	
	lda	<$i
	cmp	<$n
	bne	$loop

	lda	<xpos
	sta	Xcap
	lda	<ypos
	sta	Ycap

	sep	#0x20
	lda	#7
	trb	Capctl


	ldx	<$h
	bsl	$ha
$done	plp
	rtl
$ha:
	lda	<$i
	bne	$a1
	rts
$a1:
	dec	<$i

	bsl	$hd

	lda	#7
	trb	Capctl

	lda	#2		; x major down.
	tsb	Capctl
	stx	0xfe00
	lda	DaWnp

	bsl	$ha
	lda	#7
	trb	Capctl
	lda	#6		; y major down.
	tsb	Capctl
	stx	0xfe00
	lda	0xfed4

	bsl	$ha

	lda	#7
	trb	Capctl
	stx	0xfe00
	lda	0xfed4

	bsl	$hb

	inc	<$i
	rts


$hb:
	lda	<$i
	bne	$b1
	rts
$b1:
	dec	<$i

	bsl	$hc

	lda	#7
	trb	Capctl
	lda	#4		; y major up.
	tsb	Capctl
	stx	0xfe00
	lda	0xfed4

	bsl	$hb
	lda	#7
	trb	Capctl
	stx	0xfe00
	lda	0xfed4

	bsl	$hb

	lda	#7
	trb	Capctl
	lda	#6		; y major down.
	tsb	Capctl
	stx	0xfe00
	lda	0xfed4

	bsl	$ha

	inc	<$i
	rts


$hc:
	lda	<$i
	bne	$c1
	rts
$c1:
	dec	<$i

	bsl	$hb

	lda	#7
	trb	Capctl
	stx	0xfe00
	lda	0xfed4

	bsl	$hc
	lda	#7
	trb	Capctl
	lda	#4		; y major down.
	tsb	Capctl
	stx	0xfe00
	lda	0xfed4

	bsl	$hc

	lda	#7
	trb	Capctl
	lda	#2		; x major down.
	tsb	Capctl
	stx	0xfe00
	lda	0xfed4

	bsl	$hd

	inc	<$i
	rts


$hd:
	lda	<$i
	bne	$d1
	rts
$d1:
	dec	<$i

	bsl	$ha

	lda	#7
	trb	Capctl
	lda	#6		; y major down.
	tsb	Capctl
	stx	0xfe00
	lda	0xfed4

	bsl	$hd
	lda	#7
	trb	Capctl
	lda	#2		; x major down.
	tsb	Capctl
	stx	0xfe00
	lda	0xfed4

	bsl	$hd

	lda	#7
	trb	Capctl
	lda	#4		; y major up.
	tsb	Capctl
	stx	0xfe00
	lda	0xfed4

	bsl	$hc

	inc	<$i
	rts

	end
