;
; video memory test.
; fill with 0,ff,aa,55 and verify.
; if error at x,y output
;	x,y,
; 	BSEL = x % 10
;	LB   = y & 1
;	CADDR= x/10 + ((y&2)<<6)
;	RADDR= y >> 2
;
;
	psect	1
byte	equ	1
word	equ	2

color	struct	byte
xdiv10	struct	byte
xmod10	struct	byte
temp	struct	word
tcolor	struct 	byte

strt:
	rep	#0x30

;
; Get 20 bytes from stack for direct page.
;
	tsc
	sec
	sbc	##20
	tcs
	inc	a
	tcd

	sep	#0x20
	lda	#0
	pha
	plb

	lda	#0
	sta	<color
	lda	#0x8f
	sta	<tcolor
$1:
	bsl	test
	inc	<color
	bne	$1

	rep	#0x20
	tsc
	clc
	adc	##20
	tcs

	nop
	nop
	brk

; Video memory test routine.
; Write all pixels with <color,
; read back and compare.
; Set x,y caps = 0.
; Set da color = test color.
; Set x = major direction,
; major, minor counters to up.
;
test:
	lda	DaRst		; reset refresh buffer.	
	lda	#0xff
	sta	Rbwmsk		; set read mask to ff.
;	nop
	sta	Rbrmsk		; set write mask to ff.
;	nop

	lda	<color		; define test color.
	sta	Rbcltn
	lda	<tcolor
	eor	#-1
	sta	<tcolor
	sta	Rbcltg

	
	ldx	##0
	stx	Rbx
	stx	Rby
	lda	#4
	sta	Rbctl	; no overlay, 1024 lines, usual increments.
;
; Set all pixels = <color
;
	lda	<color		; test color.
	ldy	##0		; first line to write.
$1:
	sty	Rbx
	ldx	##128		; number pixels/8
$2:
	sta	Vmimaj
	eor	#-1
	sta	Vmimaj
	eor	#-1
	sta	Vmimaj
	eor	#-1
	sta	Vmimaj
	eor	#-1
	sta	Vmimaj
	eor	#-1
	sta	Vmimaj
	eor	#-1
	sta	Vmimaj
	eor	#-1
	sta	Vmimaj
	eor	#-1
	dex
	bne	$2
	stx	Rby
	iny
	cpy	##1280		; done all the lines ?
	bcc	$1		; loop if no.

;
; Now read all the pixels back, compare
; with value written.  Output error message
; if compare fails.
;
	ldy	##-1
	stz	<xmod10
	dec	<xmod10
	stz	<xdiv10
nxtlin:
	ldx	##0
	stx	Rby
	iny
	cpy	##1280
	bcs	done
	sty	Rbx

	inc	<xmod10		; inc x mod 10.
	lda	<xmod10		; up to next mult of 10 ?
	cmp	#10
	bcc	nxtpix		; br if no.
	inc	<xdiv10		; yes, inc x/10 counter and
	stz	<xmod10		; reset x mod 10 counter.

nxtpix
	lda	Vmimaj
	cmp	<color
	beq	$1
	bsl	error
$1:	
	inx			; inc column counter.
;	bit	Vmimaj		; advance cap to next pixel.

	lda	Vmimaj
	eor	#-1
	cmp	<color
	beq	$11
	bsl	error
$11:	
	inx			; inc column counter.
	cpx	##1024		; end of line ?
	bcs	nxtlin		; br if yes, set up for next.
;	bit	Vmimaj		; advance cap to next pixel.
	bra	nxtpix		; and so on..

done:	rts

;
; Routine to give diagnostic info
; on pixel compare error.  Output
; value expected, value read,
; BSEL	(x mod 10),
; LB	(y mod 2),
; RADDR	(y/4), and
; CADDR	(x/10 + 64*(y&2)).
;

error:
	php
	rep	#0x30
	pha			;7,s
	phx			;5,s
	phy			;3,s
	per	$str0 		;1,s pointer to output buffer.
	sep	#0x30

;
; Output x cap.
;
	ldx	#$xp	; index where 2 hex digits go.
	lda	3+1,s	; high byte of x
	bsl	putbuf
	ldx	#$xp+2
	lda	3,s	; low byte x
	bsl	putbuf
;
; Output y cap.
;
	ldx	#$yp	; index where 2 hex digits go.
	lda	5+1,s	; high byte of y
	bsl	putbuf
	ldx	#$yp+2
	lda	5,s	; low byte y
	bsl	putbuf

	pla
	pla
	per	$str1

;
; set <temp = -1 if y is odd.
;
	lda	5,s
	lsr	a		; set carry if odd y.
	lda	#0xff
	bcs	$999
	lda	#0
$999:	sta	<temp
;
; Output color written.  If (y&1), wrote
; <color ^ 0xff, else <color.
;
	ldx	#$col
	lda	<color
	bit	<temp
	bpl	$1000
	eor	#0xff
$1000	bsl	putbuf
;
; Output color read
;
	ldx	#$read
	lda	7,s	; saved value of acc.
	bit	<temp
	bpl	$1001
	eor	#0xff
$1001	bsl	putbuf
;
; Output BS = x mod 10
;
	ldx	#$bs
	lda	<xmod10
	bsl	putbuf
;
; Output LB = bit 0 of y
;
	ldx	#$lb
	lda	5,s	; saved low y byte.
	and	#1
	bsl	putbuf
	
;
; Output RA = y/4
;
	rep	#0x20
	lda	5,s	; saved y high byte
	sta	<temp
	lsr	<temp
	lsr	<temp
	sep	#0x20
	lda	<temp
	ldx	#$ra
	bsl	putbuf
;
; Output CA = x/10 + (128 if (y & 2) else 0).
;
	ldx	#$ca
	lda	#2
	and	5,s	;saved low y byte
	beq	$1
	lda	#128
$1:
	clc
	adc	<xdiv10
	bsl	putbuf

	pla		; clean up stack.
	pla

	per	$str0		; push string address.
	bsl	putstr		; output string.
	pla			; remove addr.
	pla
	
	rep	#0x30
	ply
	plx
	pla
	plp
	rts
;
; indices into the report strings.
;
$xp	equ	6
$yp	equ	11
$col	equ	7
$read	equ	15
$bs	equ	21
$lb	equ	27
$ra	equ	33
$ca	equ	39

$str0:
	dcs	"X,Y = xxxx,xxxx"
$str1:
	dcs	" Wrote xx Read xx"
	dcs	" BS=xx LB=xx RA=xx"
	dcs	" CA=xx\r\n\0"
;
; Convert acc to 2 ASCII hex digits
; and put them at (?,s),x.  All 
; registers nuked.
;

putbuf:
	php
	sep	#0x30
	pha

	per	$hextab		; addr hex table.

	lsr	a		; get high nibble.
	lsr	a
	lsr	a
	lsr	a
	tay			; to y for indexing.
	lda	(1,s),y		; get corresponding hex digit.
	txy			; get index to save digit at.
	sta	(7,s),y		; save digit.
	iny			; make index to next digit pos.
	tyx			; save index
	lda	3,s		; get original acc.
	and	#0xf		; get low nibble.
	tay			; index into hex table.
	lda	(1,s),y		; get hex digit.
	txy			; get index where to put digit.
	sta	(7,s),y		; put it.
	pla			; clean up stack.
	pla
	pla

	plp
	rts
$hextab:
	dcs	"0123456789abcdef"

;
; Output a null terminated string to the aux port.
; String address is on stack.
;

putstr:
	php
	sep	#0x30
	ldy	#0
$loop:
	lda	(4,s),y
	beq	$done
	tax
	
$1:	lda	>0xf8,0x1a
	bit	#32
	beq	$1
	txa
	sta	>0xf8,0x10
	iny
	bra	$loop
$done:
	plp
	rts	
	
	end
