;
;	printf(fmt,arg1,..argn)
;	fmt points to the format string (in current data bank).
;	Args are 1 or 2 words long.
;	This is similar to the C version, but
;	currently the available formats are
;
;	%b : print hex value of (arg & 0xff)
;	%c : print ASCII value (char) (arg & 0xff)
;
;	%x : print hex value of arg (4 hex digits)
;	%lx : print hex value of longword arg (8 hex digits)
;
;	%s : print (null terminated) string pointed to by arg
;	     (string is in the current data bank)
;	%ls : like %s, but arg is a long address (bank address
;	     in second MSB).
;
;	%la : print hex value of long address 
;	     (6 hex digits, equivalent to %b%x)
;		
; 	 The most significant byte is ignored by %la, %ls.
;
;	Arguments are removed from the stack before return.
;	X,Y registers preserved, acc is trashed.
;
;	call sequence :
;
;	push	arg1
;	...
;	push	argn
;
;	pea	##nbytes; push arg byte count (bytes in arg1..argn).
;	per	format	; push pointer to (null terminated)format string
;	bsl	printf
;
;
;	The stack frame/direct page during printf looks like
;
;	sp+	arg1	
;		...
;	sp+18	argn
;	sp+16	arg byte count
;	sp+14	fmt pointer
;	sp+12	return addr
;	sp+11	callers psw (byte)
;	sp+9	callers direct page
;	sp+7	callers x reg
;	sp+5	callers y reg	
;	sp+3	exit stack value (with psw, ret addr)
;	sp+1	direct index of current arg

upsw	equ	11	; callers psw.
uret	equ	12	; callers ret addr.
exstk	equ	3	; exit stack pointer.
argidx	equ	1	; argidx is abs address of current arg.
nbytes	equ	16	; nbytes = number arg bytes.
fmtstr	equ	14	; (<fmtstr),y points to format string char.


;
;	printf exit routine, here for easy reference to above.
;

pfexit	rep	#0x30

;
;	move psw and return addr to 'return' stack area.
;	note - when <dir,x bug gets fixed, change 
;	>0,1,x and >0,2,x to <1,x and <2,x below
;
	ldx	<exstk		; get exit stack pointer
	lda	<upsw		; psw
	sta	>0,1,x
	lda	<uret		; ret addr
	sta	>0,2,x
;	
;	restore callers registers and clean up stack.
;	when <dir,x bug gets fixed, delete txa, replace with
;	tsc
;	clc
;	adc	<exstk

	txa			; save new sp.

	ply			; junk.
	ply			; junk.
	ply			; restore callers y
	plx			; ditto x
	pld			; restore callers direct page.
	tcs			; point stack to return stuff
	plp
	rts


printf	php			; save callers psw
	phd			; and direct page
	rep	#0x30		; set 16 bit m/x
	phx			; save callers x, y
	phy
	
	pha			; reserve 4 more bytes of stack.
	pha
	tsc			; use stack frame for direct page.
	tcd

;
;	set <argidx = absolute address of first arg.
; 	(args are accessed with >0,0,x because <0,x 
;	doesn't work in this rev of the processor.
;	when the real processor comes along, change all
;	>0,0,x to <0,x and  replace the following 5 lines of code with
;	clc
;	lda	##nbytes
;	adc	<nbytes
;	sta	<argidx
;

	clc
	tdc			; get frame address
	adc	##nbytes	; add frame offset of last arg
	adc	<nbytes		; add # arg bytes
	sta	<argidx		; save abs addr of first arg

;
;	set exstk = abs addr of highest 4 bytes of the frame.
;	the exit routine will move psw, return addr up there,
;	load s from exstk, and do plp, rts.
;

	dec	a
	dec	a		; stack value to do plp, rts from
	sta	<exstk		; after cleaning up args on exit.

	sep	#0x20		; 8 bit mem, 16 bit idx.
	ldy	##0		; init pointer to fmt chars.

loop
	lda	(<fmtstr),y	; get char from fmt string.
	beq	pfexit		; done if terminator.
	iny			; point to next char.
	cmp	#'%'		; format spec ?
	beq	format		; yes, go doit.

	bsl	putchr		; display char in acc.
	bra	loop		; do some more.

;
;	here after % in format string.  if next char is
;	s,c,b,x, or l then format current arg, else
;	just display the char.
;	

format
	lda	(<fmtstr),y	; get format specifier.	
	beq	pfexit
	iny

	cmp	#'l'		; %l ?
	beq	$1		; branch if no.
	brl	fmt
$1	brl	lngfmt

;
;	Here after processing valid %something.
;	This is the normal exit from fmt and lngfmt.

fmtend
	ldx	<argidx		; make pointer to next arg
	dex
	dex
	stx	<argidx
	ply			; get pointer to next fmt char
	sep	#0x20		; ensure 8 bit mem for loop
	brl	loop		; do next format char

;
;	Here from fmt or lngfmt because of %junk.
;	Just print the junk.
;

junk
	bsl	putchr		; display char in acc.
	ply			; get pointer to next fmt char.
	brl	loop		; do some more.

;
;	Here to do %<not l>.  Jump to appropriate routine,
;	which will exit via fmtend (above).
;

fmt
	phy			; save ptr to next fmt char.
	ldx	<argidx		; point x at current arg

	cmp	#'x'
	beq	pword
	cmp	#'s'
	beq	pstring
	cmp	#'c'
	beq	pchar
	cmp	#'b'
	beq	pbyte
	brl	junk

;
;	Here on %s - print string in data bank
;

pstring
	rep	#0x20
	lda	>0,0,x		; get pointer to string
	pha			; push pointer to string
	bsl	putstr		; print string
	brl	fmtend		; get ready for next whatever.

;
;	%c - print char 
;

pchar
	lda	>0,0,x
	bsl	putchr
	brl	fmtend

;
;	%x - print hex word
;

pword	rep	#0x20		; need 16 bit m for this
	lda	>0,0,x		; get the word
	bsl	wtox		; display it
	brl	fmtend

;
;	%b - print hex byte
;

pbyte	lda	>0,0,x		; get the byte
	bsl	btox		; display it
	brl	fmtend

;
;	Here on %l<something:
;

lngfmt
	lda	(<fmtstr),y	; get fmt spec.
	bne	$1
	brl	pfexit
$1
	iny			; point to next format char
	phy			; save pointer.
	ldx	<argidx		; point x at current arg (hi word)

	cmp	#'x'
	beq	plword
	cmp	#'s'
	beq	plstrn
	cmp	#'a'
	beq	pladdr
	brl	junk		; invalid %l, just output acc.
;
;	%lx - print long hex word
;

plword	rep	#0x20		; need 16 bit m for this
	lda	>0,0,x		; get high word
	bsl	wtox		; display high word

	dex			; point x at low word of arg
	dex
	stx	<argidx		; update argidx
	brl	pword		; go display low word.

;
;	Here  on %la - print <bank><addr> 
;

pladdr
	rep	#0x20		; need 16 bit m
	lda	>0,0,x		; get bank value
	bsl	btox		; print it (1 byte)

	dex			; point x to next arg (addr)
	dex
	stx	<argidx

	lda	>0,0,x		; get addr
	bsl	wtox		; print it
	brl	fmtend
;
;	Here on %ls - print string in specified bank
;

plstrn
	phb			; save current dbr
	lda	>0,0,x		; get specified bank
	pha			; copy to dbr
	plb

	dex			; point to next arg (string addr)
	dex
	stx	<argidx

	rep	#0x20
	lda	>0,0,x		; get string addr
	pha			; push for putstr
	bsl	putstr		; print the string

	plb			; restore callers dbr
	brl	fmtend		; clean up

	end
