
;	entries : set802 - Sets E,M,X = 0.
;			   Routines that use 16 bit modes should
;			   call this routine first.
;
;		  set8bit - Sets E,M,X = 1, returns.  802 graphics
;			    routines jmp here to return to the
;			    interpreter.
;
;		  
	
	asect	7
	org	0x2700		; last page of RAM.
	
trnint
nmint
rcvint
ACIAC
ACIAP
BLINT
AXINT
AUXC
INT
NMINT
RESET
;	This entry calls the 6502 firmware interrupt handler.

savirq
	rep	#0x30		; MUST use 16 bit here.
	pha			; Save 'real' state.
	phx
	phy
	phb			; data bank register.
	phd			; direct register.

	pea	rti802		; The 6502 RTI will land us at rti802.
	php			; This gets popped in 6502 mode
				; when DISMIS does RTI.
	
	
	sep	#0x30		; Enter 6502 mode, jump to service
	sec			; routine.
	xce
	jmp	INT


;	This entry calls the 6502 firmware NMI handler.

savnmi
	rep	#0x30
	pha			; Save 'real' state :
	phx			; acc, x, y
	phy			
	phb			; data bank register.
	phd			; direct register.

	pea	rti802		; 802 rti routine.
	php			; This gets popped in 6502 mode
				; when DISMIS does RTI.
	sep	#0x30		; Enter 6502 mode, jump to service
	sec			; routine.
	xce
	jmp	NMINT

;	General 'return to 802 code from interrupt' routine.

rti802:
	clc			; Set 802 mode in case returning
	xce			; from 6502 int. handler.

	rep	#0x30
	pld			; direct register
	plb			; data bank register
	ply			; y, x, acc.
	plx
	pla
	rti
	
set802:
	sei
	clc
	xce
	sep	#0x30
	cli
	rts		



;	Jump here to return to 6502 firmware.

set8bit:
	sei
	rep	#0x30
	lda	##0			; set direct register.
	tcd
	sep	#0x30			; set 8 bit mode.
	sec
	xce				; set emulation mode.
	cli
	rts

freset
	sei
	rep	#0x30
	lda	##0
	tcd
	sep	#0x30
	sec
	xce
	jmp	RESET
	end


;	This entry calls the 802 NMI handler.

sv802nmi
	rep	#0x30
	pha			; Save 'real' state :
	phx			; acc, x, y
	phy			
	phb			; data bank register.
	phd			; direct register.

	sep	#0x30		; Set 8 bit registers.
	jmp	nmint

;	This entry calls an 802 interrupt handler.

sv802int
	rep	#0x30		; MUST use 16 bit here.
	pha			; Save 'real' state.
	phx
	phy
	phb			; data bank register.
	phd			; direct register.
	sep	#0x30		; Set 8 bit registers.

	bit	MISCC		; Vertical blank ?
	bpl	int0		; Branch if no.
	jmp	BLINT
int0
	lda	AUXC		; Aux port byte available ?
	bit	#1
	bne	int1
	jmp	AXINT
int1
	lda	ACIAC		; IRQ from host ACIA ?
	bit	#1		; Receive data reg. full ?
	beq	int2		; Branch if no.
	jmp	rcvint		; Data from host, go get it.
int2
	bit	#2		; Transmit reg. empty ?
	beq	int3		; Branch if no.
	jmp	trnint		; Yes, send next byte.
int3
	brl	rti802		; Bogus int, just rti.








