;	driver for ACT printers.  Calls kernel's cnout routine to send

trysnd:
	php
	jsl	>0,Cnout
	bcs	$errxit
	plp
	rts

$errxit:
	plp			; should do something drastic here!
	rts	

act:

$nsizx 	equ 	temp+16
$nsizy	equ	temp+14
$zoom 	equ	temp+8

	php
	rep	#0x30
	phy
	phx
	pha
	sep	#0x30

	lda	#3		; set ACT into raster mode
	bsl	trysnd	

	lda	#2		; set picture size
	bsl	trysnd
	
	ldx	#0
	ldy	#4
$1:	lda	<$nsizy,x	; nsizx, nsizy has horizontal &
	bsl	trysnd		; vertical picture size
	inx
	dey
	bne	$1
	
	lda	#1		; 1 for sending color table
	bsl	trysnd
	lda	#0		; low byte of table size
	bsl	trysnd
	lda	#1		; high byte
	bsl	trysnd

	ldx	#0
	ldy	#0

$2:	lda	Redclt,x
	bsl	trysnd
	lda	Grnclt,x
	bsl	trysnd
	lda	Bluclt,x
	bsl	trysnd
	inx
	dey
	bne	$2

	rep	#0x30
	pla
	plx
	ply
	plp
	rts

;	Print "aoi" to Act printer
;	different veriety coming up!

pai:	

$x0 	equ 	temp
$y0 	equ 	temp+2
$x1 	equ 	temp+4
$y1 	equ 	temp+6
$zoom 	equ 	temp+8
$sizx 	equ 	temp+12
$sizy	equ	temp+10
$nsizx	equ	temp+16
$nsizy	equ	temp+14
$tempct	equ	temp+18
$numcop	equ	temp+20

	php
	rep	#0x30
	lda	Capctl
	pha

	
	jsl	>0,Gcoor	; get lower left corner
	stx	<$x0
	sty	<$y0

	jsl	>0,Gcoor	; get upper right corner
	stx	<$x1
	sty	<$y1

	sep	#0x20
	jsl	>0,Getb		; get zoom factor, min = 1
	cmp	#0		; max = 8
	beq	$l1
	cmp	#9
	bcs	$l1
	sta	<$zoom
	stz	<$zoom+1
	bra	$1
$l1	brl	$exit		; br if zoom = 0

$1
	jsl	>0,Getb		; get number of copies
	cmp	#0
	beq	$l1		; br if copies = 0
	sta	<$numcop
	stz	<$numcop+1

	rep	#0x20
	
	lda	<$x1
	sec
	sbc	<$x0
	inc	a
	sta	<$sizx		; picture size = x1 - x0 + 1
	lda	<$y1		;                y1 - y0 + 1
	sec
	sbc	<$y0
	inc	a
	sta	<$sizy		

$2	bit	Dpdone-1
	bvc	$2

	lda	<$sizx		; real picture size = zoom(sizx)
	sta	0xfe00		
	lda	<$zoom
	sta	0xfe04
	sta	DaMul

$3	bit	Dpdone-1
	bvc	$3

	lda	0xfe02
	pha

	lda	<$sizy
	sta	0xfe00
	lda	<$zoom
	sta	0xfe04
	sta	DaMul

	pla
	and	##0x7ff
	cmp	##1281
	bcc	$4		; br if size within limit
	lda	##1280
$4	sta	<$sizx	

$5	bit	Dpdone-1
	bvc	$5

	lda	0xfe02
	and	##0x7ff
	cmp	##1025
	bcc	$6		; br if size within limit
	lda	##1024
$6	sta	<$sizy	

	lda	Capctl		; leave x as major axis
	and	##255-7		; and both axis inc up
	sta	Capctl		

$start
	lda	<$sizx
	sta	<$nsizx
	lda	<$sizy
	sta	<$nsizy

	bsl	act		; init printer

	lda	<$x0		; start at x0,y0 
	sta	Xcap

	lda	Capctl
	and	##0x10
	bne	$ovly		; if overlay displayed we need to do
				; differently
	lda	##0x20
	trb	Capctl
$line
	ldy	<$zoom
$line1
	lda	<$y0
	sta	Ycap
	lda	<$nsizy		; counter for each line
	sta	<$tempct
	lda	##7		; header(newline) for ACT
	jsl	>0,Cnout

$loop	lda	Vmimin		; move from y0 towards y1	
	and	<rmask
	ldx	<$zoom
$l4	jsl	>0,Cnout
	dec	<$tempct
	beq	$l2		; br until done with current line
	dex	
	bne	$l4
	bra	$loop
$l2	dec	<$nsizx
	bne	$9		; br when done with all lines
	brl	$done
$9
	dey
	bne	$line1
	bit	Vmimaj
	bra	$line

$ovly
	lda	##0x20
	tsb	Capctl
	ldy	<$zoom
$loop2
	lda	<$y0
	sta	Ycap
	lda	<$nsizy		; counter for each line
	sta	<$tempct
	lda	##7		; header(newline) for ACT
	jsl	>0,Cnout

$loop1	ldx	<$zoom		; here if overlay displayed.if bit
	lda	Vm		; clear then send memory color & read mask
	and	##0xff
	beq	$clear		; else send overlay color
	lda	Rbovcl
$l6	jsl	>0,Cnout
	dec	<$tempct
	beq	$l5
	dex
	bne	$l6
	bit	Vmimin
	bra	$loop1
$l5	dec	<$nsizx
	beq	$done		; br when done with all lines
	dey
	bne	$loop2
	bit	Vmimaj
	bra	$ovly
$clear
	lda	##0x20
	trb	Capctl		; disable overlay first
	lda	Vmimin
	and	<rmask		; and with mask
$l7	jsl	>0,Cnout
	dec	<$tempct
	bne	$l8
	lda	##0x20
	tsb	Capctl
	bra	$l5
$l8	dex
	bne	$l7
	lda	##0x20
	tsb	Capctl
	bra	$loop1
$done
	dec	<$numcop
	beq	$exit
	brl	$start

$exit
	rep	#0x30
	pla
	sta	Capctl
	plp
	rtl

	end
