
init:
	sep	#0x20
	stz	DmaCtl		; make sure data flag is off.
	stz	ParOut+1	; ditto parallel interface signals.
	stz	ParStat		; ditto ram copy of parallel signals.
	
	rep	#0x30
	lda	StkBas
	tcs
	cli
	
	lda	##Intdrp
	tcd

;
; get heap if not already done and 
; init direct page.
;
	bsl	inibuf

	sep	#0x20
	lda	#1
	sta	Leds
	lda	#2
	sta	<color
	sta	<ocolor
	sta	<acolor
	lda	#0xff
	sta	<wmask
	sta	<rmask

	lda	#vbmask
$w1:	bit	Vbflag
	bne	$w1
$w2:	bit	Vbflag
	beq	$w2
	sta	DaRst		; flicker free reset.

	bsl	eeinit		; set defaults from eeprom.
;
;flush keyboard and host queues.
;need a kernel routine to do this.
;

$w14:	bit	Iqcnt3+1
	bpl	$w15
	jsl	>0,GetKey
	bcc	$w14

	lda	<autovt		; don't flush host if it's for VT100.
	bne	$w15
$w15:	bit	Iqcnt2+1
	bpl	$w11
	jsl	>0,GetHst
	bcc	$w15

$w11:	bit	Dpdone		; dpu busy ?
	bvc	$w11		; wait if yes.
	rep	#0x20
	stz	Xorg
	stz	Yorg
	stz	Xwbot
	stz	Ywbot
	lda	##0x500
	sta	Xwtop
	lda	##0x400
	sta	Ywtop
	sep	#0x20
	stz	DaBclr		; set bkgrnd color = 0.
	jsl	>0,Erase	; erase screen.
$w12:	bit	Dpdone		; dpu busy ?
	bvc	$w12		; wait if yes.
	lda	#0x20		; select overlay plane.
	sta	Capctl
	jsl	>0,Erase	; erase overlay plane.
$w13:	bit	Dpdone		; dpu busy ?
	bvc	$w13		; wait if yes.

	stz	Capctl

	stz	Blink
	bsl	blkini		; init blink table
	bsl	cltini		; set up color table.
	bsl	chinit		; init alpha parameters.
	sep	#0x20
	lda	<color
	sta	DaColr
	sta	Rbovcl

	lda	#1		; set default direction for
	sta	<sucbyt		; non-aoi pixel transfers
				; (x major up, y down).
	bsl	cinit		; init cursor parameters.

	bsl	logo		; go draw logo

	sep	#0x20
	lda	#2
	sta	Beeper

	lda	#10		; do an lf to home alpha cursor.
	brl	alpha		; enter alpha idle loop.

;
; wait for next graphics command.
;
idle:
	sep	#0x20

	lda	#ledint		; turn on intrp led.
	tsb	Leds
	lda	#ledbsy		; turn off busy led.
	trb	Leds
$11:
	bit	<locsw
	bmi	$local

	jsl	>0,ChkKbd	; handle any keyboard action.

$2:
	lda	<cdmflg
	bne	$3
	bit	PolDev		; parallel data avail ?
	bmi	$3		; br if yes.
;
; if serial input
; 	if bit 7 of autovt goto vt100
;	else if bit 6 ignore it
;	else go use it.
;
	bit	Iqcnt2+1	; host serial input avail ?
	bpl	$21		; br if no.
	bit	<autovt		; auto vt100 enabled ?
	bmi	$avt		; yes, call vt100 to handle it.
	bvs	$21		; no, but save for vt100.
	bra	$3		; go use it.
$avt	bsl	rcurs
	bsl	racurs
	jsl	>0,Vt100
	brl	idle
	bmi	$3

$21:	bsl	curs		; no, service cursor
	brl	idle
$3:
	bit	<curson		; cursor drawn ?
	bvc	$31		; br if no.
	bsl	rcurs		; yes, erase first.
$31:	jsl	>0,Get		; get command.
	bra	cmd


$local:
	jsl	>0,ChkKbd
	bcs	$21
	bsl	rcurs
;	bra	cmd


cmd:	sep	#0x20
	cmp	#0
	beq	idle
	bit	<ftype		; single char cmds ?
	bmi	$hoser		; br if no.
	jsl	>0,Teki
	cmp	#0x20		; control char ?
	bcc	alpha		; go to alpha mode if yes.
	jsl	>0,Dispa	; go execute command
	brl	idle
$hoser
	sta	<temp		; save first finger.
	sec			; upper case only - check.
	sbc	#'A'
	cmp	#'Z'-'A'
	bcc	$ok
	brl	idle		; ignore if not upper case.
$ok:
	jsl	>0,Get		; get finger 2.
	sta	<temp+1		; save it.
	jsl	>0,Get		; get 3rd finger.
	sta	<temp+2		; save it.
;
; search the 3 finger table.
;
	phk
	pla
	sta	<temp2+2
	rep	#0x30
	per	finger		; addr 3 finger table.
	ply			; point y reg at table.
	sty	<temp2
	ldy	##0
	ldx	##32		; opcode of first table entry.
	lda	<temp		; first 2 fingers.
$loop:
	cmp	[<temp2],y	; match 2 fingers ?
	bne	$next
	sep	#0x20		; first 2 fingers match, check 3rd.
	lda	<temp+2		; get 3rd finger.
	iny			; point to 3rd in table.
	iny
	cmp	[<temp2],y	; match ?
	rep	#0x20
	beq	$found
	lda	<temp
	bra	$nxt1
$next:
	iny			; nope, point y at next 3 fingers.
	iny
$nxt1	iny
	inx			; set x to next opcode.
	cpx	##nfuncs+33	; more opcodes ?
	bcc	$loop		; loop if yes.
$uif:
	sep	#0x30		; uif, enter alpha mode.
	lda	#0
	brl	alpha
$found:
	txa			; get corresponding opcode.
	cmp	##32		; first entry (FFD) ?
	bne	$real		; br if no.
	lda	##12		; yes, map to FF and go to alpha.
	brl	alpha
$real:	jsl	>0,Dispa	; real opcode, go execute.
	brl	idle		; resume graphics idle.
;
; alpha idle loop
;

alpha:
	sep	#0x20
	sta	<temp
	lda	#ledint+ledbsy	; turn off interp,bsy leds.
	trb	Leds
	lda	<temp
	beq	$wait
;
; Handle a byte in alpha mode.
;
$loop:
	bit	<acflag		; alpha cursor drawn ?
	bpl	$100		; br if no.
	bsl	racurs		; yes, erase it.
$100:	bit	<curson		; graphics cursor drawn ?
	bvc	$tekb		; br if no.
	bsl	rcurs		; yes, erase it.
$tekb:
	jsl	>0,Teka
	cmp	#27		; ESC ?
	bne	$102		; br if no.
	brl	idle		; yes, enter graphics idle loop.
$102:	jsl	>0,Dchar	; no, display char.

	rep	#0x20
	lda	Vcount		; make it seem to be
	dec	a		; time to draw alpha cursor.
	sta	<actime
	sep	#0x20

$wait:
$11:
	bit	<locsw
	bmi	$local
	jsl	>0,ChkKbd	; handle any keyboard action.
	bcs	$2
	sta	<rdykey		; we're in ginmod, send the key
	bsl	curs		; and service cursor (send coords).
$2:
	lda	<cdmflg
	bne	$3
	bit	PolDev		; parallel data avail ?
	bmi	$3		; br if yes.

;
; if serial input
; 	if bit 7 of autovt goto vt100
;	else if bit 6 ignore it
;	else go use it.
;
	bit	Iqcnt2+1	; host serial input avail ?
	bpl	$21		; br if no.
	bit	<autovt		; auto vt100 enabled ?
	bmi	$avt		; yes, call vt100 to handle it.
	bvs	$21		; no, but save for vt100.
	bra	$3		; go use it.
$avt
	bsl	rcurs
	bsl	racurs
	jsl	>0,Vt100
	bra	$wait		; back from VT100, resume idle.
	bmi	$3
$21:
	bit	<curson		; no input, gfx cursor on ?
	bpl	$211		; br if no, do alpha cursor.
	bit	<acflag		; yes, erase alpha cursor if drawn.
	bpl	$210
	bsl	racurs
$210:	bsl	curs		; yes, update gfx cursor.
	bra	$wait		; go check for input.
$211:	bvc	$212		; erase gfx cursor if drawn.
	bsl	rcurs
$212:	bsl	acursr		; no gfx cursor, do alpha cursor.
	bra	$wait		; go wait for input.
$3:
	jsl	>0,Get		; get input byte.
	brl	$loop

$local:
	jsl	>0,ChkKbd	; anything for us from kbd ?
	bcs	$21		; br if no, handle cursor.
	brl	$loop


;
; Call this routine when Setupk flag is
; observed to be set, meaning setup/reset key hit.
; If key prior to setup key was gold, kludge calls the
; setup routine, else it abandons the caller
; and jumps to idle, unless there were 2 setup keys in
; a row, in which case it does a full reset.
; In every case, queued keys are gobbled until
; a setup key is found.
; If setup is requested while busy light is on, after setup
; returns jump to idle, else just return.  Using Leds as
; a mode indicator is probably hosed.
; 

kludge:
	php
	rep	#0x30
	pha
	phx
	phy
	sep	#0x30	

$loop:	jsl	>0,GetKey
	cmp	#0xfe		; setup key ?
	beq	$reskey		; br if yes.
	stz	<resflg		; clear "last key reset" flag.
	cmp	#0366		; gold key ?
	beq	$1		; br if yes.
	stz	<gldmod		; no,clear "last key gold" flag.
	bra	$2		; get next key.
$1:	lda	#128
	sta	<gldmod
$2:	bit	Iqcnt3+1	; more keys buffered ? (should be).
	bmi	$loop		; go get 'em.
;
; error if we're here. flag was set but key not in buffer.
; assume buffer was full and do a reset.
;
$reset:	stz	Setupk		; clear setup key flag.
	brl	init		; go reset.

$reskey:	
	inc	Setupk
	bit	<gldmod		; found the setup key,
	bmi	$setup		; br if last was gold, enter setup.
	bit	<resflg		; last key setup ?
	bmi	$reset		; 
	dec	<resflg
$idle:	rep	#0x20
	lda	StkBas
	tcs
	bsl	racurs		; in case we were in alpha mode.
	brl	idle		; enter graphics idle loop.
$setup:
	stz	<gldmod
	jsl	>0,Setup
	lda	#ledbsy		; did we interrupt a graphics cmd ?	
	bit	Leds
	bne	$idle		; br if yes, abort it.
	rep	#0x30		; no, just return (I hope harmlessly).
	ply
	plx
	pla
	plp
	rts
;
; get heap space for various buffers
;

inibuf:

;$size	equ	256+32+240+64+64+23+256+59 ;gfx cursor+def'n+stipples
				;+alf cursor + sks buffer
				; + window list+first window element
$size	equ	994

	php
	rep	#0x30
	lda	<buffer
	bne	$ini1
	pea	##$size
	jsl	>0,GetHeap
	pla
$ini1:	pha

	lda	<wheap
	beq	$f2			; br if power up reset
	ldy	##0			; free heap used by windows
$f1	iny
	iny
	cpy	##256			; max 128 windows
	bcs	$f2
	lda	(<wheap),y
	beq	$f1
	pha
	jsl	>0,FreHeap
	bra	$f1
$f2:
	ldy	##3
	lda	<spfptr		; release any heap from spfnt
	sta	<temp
	beq	$f3		; br if none was declared
$f4:
	pha			; save addr to be released
	lda	(<temp),y	; get next node addr
	sta	<temp		; save it
	jsl	>0,FreHeap	; free current node
	lda	<temp		; get new addr
	bne	$f4		; br if not end of list yet

$f3:
; zero out direct page.
;
	tdc
	tax
	tay
	iny
	stz	<0
	lda	##254
	mvn	>0,>0

	pla
	sta	<buffer

;
; zero out buffer.
;

	tax
	tay
	iny
	stz	0,x
	lda	##$size-2
;	lda	##$size-256-60-2	;kludge to preserve wheap
	mvn	>0,>0

;
; set up the various pointers into the buffer.
;
	lda	<buffer
	sta	<curbuf
	adc	##256
	sta	<curpat
	adc	##32
	sta	<stpbuf
	adc	##240
	sta	<acbuf
	adc	##64
	sta	<sksbuf	
	adc	##64	
	sta	<savptr
	adc	##23
	sta	<wheap
	adc	##256
	sta	(<wheap)
	adc	##60
;	sta	<whoever needs more

	plp
	rts
	
;
; Set up default color table.
;

cltini:
	php
	rep	#0x30

	ldx	##Redclt
	txy
	iny
	iny
	lda	##3*256-3
	stz	Redclt

	mvn	>0,>0

	lda	##0xffff
	sta	Bluclt+4
	sta	Bluclt+6
	sta	Grnclt+2
	sta	Grnclt+6

	sep	#0x30
	sta	Redclt+1
	sta	Redclt+3
	sta	Redclt+5
	sta	Redclt+7

	ldy	#0		; first color.
	ldx	#8		; # colors.
	jsl	>0,SetClt

	plp
	rts
;
; Init alpha parameters.
;

chinit:	php
	rep	#0x20

	stz	<fntptr		; point to 12x16 font
				; (set bank later).
	lda	##14
	sta	<cwidth		; char box width.
	lda	##24
	sta	<chight		; ditto height.

	lda	##1
	sta	<lftmar		; left margin.
	lda	##4
	sta	<botmar		; bottom margin.
	lda	##1023-22
	sta	<topmar		; top margin.
	lda	##1279-14
	sta	<rgtmar		; right margin

	lda	##3
	sta	<desc		; descender amt.
	lda	##24-16		; dist from Y cap to bottom
	sta	<fudge		;  of char box (chight-csy).

	sep	#0x20
	lda	#ROM
	sta	<fntbnk		; bank addr of font.

	lda	#12
	sta	<csx		; bits per char row.
	lda	#16
	sta	<csy		; rows per char.

	stz	<chrsiz	
;	stz	<chropt		; eep option

	lda	#128+64
	trb	DaCtl

	plp
	rts

blkini:				; init blink table
	php
	rep	#0x30
	pha
	phx
	phy
	
	ldx	##Bltab
	txy
	iny
	stz	0,x
	lda	##256-2
	mvn	>0,>0

	ply	
	plx
	pla
	plp
	rts

savfnt:
	php
	rep	#0x30
	pha
	phx
	phy

	sep	#0x10
	ldy	#0

	lda	<fntptr
	sta	(<savptr),y
	iny
	iny
	lda	<cwidth
	sta	(<savptr),y
	iny
	iny
	lda	<chight
	sta	(<savptr),y
	iny
	iny
	lda	<lftmar
	sta	(<savptr),y
	iny
	iny
	lda	<botmar
	sta	(<savptr),y
	iny
	iny
	lda	<topmar
	sta	(<savptr),y
	iny
	iny
	lda	<rgtmar
	sta	(<savptr),y
	iny
	iny
	lda	<desc
	sta	(<savptr),y
	iny
	iny
	lda	<fudge
	sta	(<savptr),y
	iny
	iny
	sep	#0x20
	lda	<fntbnk
	sta	(<savptr),y
	iny
	lda	<csx
	sta	(<savptr),y
	iny
	lda	<csy
	sta	(<savptr),y
	iny
	lda	<chrsiz
	sta	(<savptr),y
	iny
	lda	<chropt
	sta	(<savptr),y
$done:
	rep	#0x30
	ply
	plx
	pla
	plp
	rts

resfnt:
	php
	rep	#0x30
	pha
	phx
	phy

	sep	#0x10
	ldy	#0

	lda	(<savptr),y
	sta	<fntptr
	iny
	iny
	lda	(<savptr),y
	sta	<cwidth
	iny
	iny
	lda	(<savptr),y
	sta	<chight
	iny
	iny
	lda	(<savptr),y
	sta	<lftmar
	iny
	iny
	lda	(<savptr),y
	sta	<botmar
	iny
	iny
	lda	(<savptr),y
	sta	<topmar
	iny
	iny
	lda	(<savptr),y
	sta	<rgtmar
	iny
	iny
	lda	(<savptr),y
	sta	<desc
	iny
	iny
	lda	(<savptr),y
	sta	<fudge
	iny
	iny
	sep	#0x20
	lda	(<savptr),y
	sta	<fntbnk
	iny
	lda	(<savptr),y
	sta	<csx
	iny
	lda	(<savptr),y
	sta	<csy
	iny
	lda	(<savptr),y
	sta	<chrsiz
	iny
	lda	(<savptr),y
	sta	<chropt

$wait:	bit	Dpdone
	bvc	$wait
	lda	DaCtl
	and	#255-128-64
	ora	<chrsiz
	sta	DaCtl
$done:
	rep	#0x30
	ply
	plx
	pla
	plp
	rts
	
;
; init vars from defaults in eeprom.
; currently, those are (in eeprom order)
; destructive chars,
; local echo,
; tek priority,
; ignore rubout from serial input (not supported yet),
; and "what to do with serial input" 
;
eeinit:
	php
	sep	#0x30
	phb
	lda	#EEP
	pha
	plb
	
$1:	lda	>0,0xff1e	; wait for eeprom ready.
	bpl	$1

	lda	#128
	ldx	eeopt0
	trb	<chropt
	cpx	#'Y'
	bne	$2
	tsb	<chropt
$2:	ldx	eeopt0+1
	lsr	a
	trb	<locsw
	cpx	#'Y'
	bne	$3
	tsb	<locsw
$3:	ldx	eeopt0+2
	lda	#128
	trb	<tekpri
	cpx	#'Y'
	bne	$4
	tsb	<tekpri
$4:	ldx	eeopt0+4
	stz	<autovt
	beq	$6
	lda	#128
	cpx	#'2'
	beq	$5
	lsr	a
	cpx	#'1'
	beq	$5
	bra	$done
$5:	tsb	<autovt
$6:	ldx	eeopt0+3
	lda	#128
	trb	<rubopt
	cpx	#'N'
	beq	$7
	tsb	<rubopt
$7:	ldx	eeopt0+5		; bit pad type.
	stx	<bptype
	lda	#'1'			; assume uses packed binary format.
	cpx	#'K'			; Kurta ?
	beq	$8
	cpx	#'L'			; Logitek mouse ?
	beq	$8
	cpx	#'M'			; Summa mouse ?
	beq	$8
	lda	#'D'			; not binary, assume decimal.
$8:	sta	<cudfmt	
$done:
	plb
	plp
	rts

; logo writing routine.  Stored in eeprom at xxxx

logo:
	rep	#0x30
	php
	phx
	phy

$wait
	lda	0xff1e-1		; wait for eeprom to be ready
	bpl	$wait

	lda	>EEP,logomk
	cmp	##0x1549		; check for magic word
	beq	$l1			; br if stuff in ee is valid

	lda	>ROM,logofn+2		; get # in array
	tay
	ldx	##0
	sep	#0x20
$loop
	lda	>ROM,logofn,x
	sta	>EEP,logomk,x
	inx
	dey
	beq	$l1			; br when done
$w1
	lda	0xff1e			; wait for eeprom to be ready
	bpl	$w1
	bra	$loop
$l1
	rep	#0x20
	ldx	##4			; byte(0,1)=magic word
					; byte(2,3)=# bytes
	stz	0xfe02			; dy = 0

$line
	bit	Dpdone-1
	bvc	$line	
	lda	>EEP,logomk,x		; xpos
	sta	Xcap
	inx
	inx
	lda 	>EEP,logomk,x		; ypos
	sta	Ycap
	inx
	inx

	lda	>EEP,logomk,x		; starting color
	sta	DaColr
	inx
	
	lda	>EEP,logomk,x
	and	##0xff
	sta	0xfe00			; dx
	inx
	sta	0xfec8			; dvr
$3
	lda	>EEP,logomk,x
	and	##0xff
	bne	$l2
	inx				; reached end of line
	bra	$line			; advance to next
$l2
	inx
	cmp	##0xff
	beq	$done

$2	bit	Dpdone-1
	bvc	$2

	sta	0xfe00			; new dx
	lda	DaColr			; switch color
	eor	##2
	sta	DaColr
	sta	0xfec8
	bra	$3
$done
	lda	>EEP,logomk,x
	inx
	inx
	sta	<xpos
	lda	>EEP,logomk,x
	inx
	inx
	sta	<ypos
	lda	>EEP,logomk,x
	inx
	sta	DaColr
$back
	lda	>EEP,logomk,x
	inx
	and	##0xff
	beq	$done1
	jsl	>0,Dchar
	bra	$back

$done1
	rep	#0x30
	ply
	plx
	plp
	rts
	
	end
