#include <stdio.h>
#include <math.h>

#define INF (HUGE)
#define MINF (-INF)

#define MXVERTS 20
int ingon[MXVERTS][2],outgon[MXVERTS][2];
int invnum,outvnum;	/* number vertices in ingon, outgon */
int inidx, outidx;	/* index of current vertex */
int oc1,oc2;		/* outcodes of endpoints of current vertex */

int	xleft, xright, ybottom, ytop;

main()
{
	int i;
	double x,y;	/* current vertex */
	double dx,dy;	/* dist to next vertex */
	double xin,xout,yin,yout;
	double tinx,tiny,toutx,touty;
	double tin1,tout1,tin2,tout2;
		
	tapint();
	sif('M');
	ods(1);
	stp(2);etp(1);dca(0,0);
	getwindow();
	invnum = getverts(); /* get vertex list in ingon */
	etp(0);
	sec(4);
	pgon(invnum,ingon);
	
/*
 * main loop, process edge ingon[i], ingon[i+1]
 */

outidx = 0;
for(i=0;i<invnum;i++){
	printf("edge #%d(%d %d)(%d %d)\t",i,
	ingon[i][0],ingon[i][1],
	ingon[i+1][0],ingon[i+1][1]);

	oc1 = outcode(ingon[i][0],ingon[i][1]);
	oc2 = outcode(ingon[i+1][0],ingon[i+1][1]);


	if((oc1|oc2) == 0){	/* test for trivial accept */
		outv(0,(double)ingon[i+1][0],(double)ingon[i+1][1]);
		continue;
	}
	if(oc1 == oc2){		/* same outcode, trivial reject */
		printf("reject\n");
		continue;
	}

/*
 * if edge doesn't intersect window
 * 	if leaving corner and no intersection,
 * 	output corner vertex and do next edge.
 * 	if in side, do next edge.
 */
	if(oc1&oc2){
		switch(oc1){
		case 5 : outv(9,(double)xleft,(double)ybottom);break;
		case 6 : outv(9,(double)xright,(double)ybottom);break;
		case 9 : outv(9,(double)xleft,(double)ytop);break;
		case 10: outv(9,(double)xright,(double)ytop);break;
		default: break; /* in side, no output. */
		}
		continue;
	}
/*
 * This edge may intersect the window.
 */
	x = (double)ingon[i][0];		
	y = (double)ingon[i][1];		

	dx = ingon[i+1][0] - x;
	dy = ingon[i+1][1] - y;





	if(dx > 0){ /* edge points to right */
		xin = xleft;
		xout = xright;
	}else{
		xin = xright;
		xout = xleft;
	}
	if(dy > 0){ /* edge points up */
		yin = ybottom;
		yout = ytop;
	}else{
		yin = ytop;
		yout = ybottom;
	}

	tinx = dx ? (xin-x)/dx : MINF;
	tiny = dy ? (yin-y)/dy : MINF;


	if(tinx < tiny){ /* first entry at x then y */
		tin1 = tinx;
		tin2 = tiny;
	}else{
		tin1 = tiny;
		tin2 = tinx;
	}

	if(1.0 < tin1)
		printf("halt 1\n");
	else{/*case 2 or 3 or 4 or 6 */
		if(0.0 < tin1) /* case 5 */
			outv(5,xin,yin);			

		if(1.0 >= tin2){ /* case 3 or 4 or 6 */
			if(dx != 0.0)
				toutx = (xout-x)/dx;
			else if((xleft <= x)
			     && (x <= xright))
				toutx = INF;
				else toutx = MINF;
			if(dy != 0.0)
				touty = (yout-y)/dy;
			else if((ybottom <= y)
			     && (y <= ytop))
				touty = INF;
				else touty = MINF;
		
			if(toutx < touty)
				tout1 = toutx;
			else	tout1 = touty;
	
		if((0.0 < tin2) || (0.0 < tout1)){
			/* case 4 or 6 */
			if(tin2 <= tout1){/* case 4 */
				if(0.0 < tin2) /* x,y outside*/
				   if(tinx > tiny)
					outv(40,xin,y+tinx*dy);
				   else outv(41,x+tiny*dx,yin);
				if(1.0 > tout1) /* next outside*/
				   if(toutx < touty)
					outv(42,xout,y+toutx*dy);
				   else outv(43,x+touty*dx,yout);
				else outv(44,
				   (double)ingon[i+1][0],
				   (double)ingon[i+1][1]);

			} /* end case 4 */
			else /* case 6 */
			if(tinx > tiny)
				outv(60,xin,yout);
			else	outv(61,xout,yin);
		} /* end case 4 or 6 */

	} /* end case 3,4,6 */

} /* case 2,3,4,6 */

} /* end of edge */

	sec(2);
	pgon(outidx,outgon);

}

pgon(n,verts)
int n;
int (*verts)[2];
{
	int i,x,y;
	printf("%d edges\n",n);
	mov(x = (*verts)[0],y = (*verts)[1]);
	verts++;
	for(i=1;i<n;i++){
		dva((*verts)[0],(*verts)[1]);
		verts++;
	}
	dva(x,y);

}
		

outv(c,x,y)		/* add vertex to output array */
int c;
double x,y;
{
	if(outidx > MXVERTS){
		printf("too much output\n");
		exit(1);
	}
	outgon[outidx][0] = x;
	outgon[outidx][1] = y;

	printf("case %d %d %d\n",c, outgon[outidx][0],
			  outgon[outidx][1]);
	outidx++;
}

getwindow()
{
	int x0,y0,x1,y1;
	int ff = 0xff;

	printf("enter window x0 y0 x1 y1\n");
	scanf("%d %d %d %d",&x0,&y0,&x1,&y1);
	xleft = x0;
	ybottom = y0;
	xright = x1;
	ytop = y1;

	mov(x0,y0);
	sec(8);
	sct(8,1,&ff,&ff,&ff);
	dra(x1,y1);


}


getverts()
{

	while(pick(inidx))
		inidx++;
	ingon[inidx][0] = ingon[0][0];
	ingon[inidx][1] = ingon[0][1];
	
	return(inidx);
}
pick(i)
int i;
{
	int id,x,y,stat;
	char buf[4];
	stat = 0;
	do
		rtp(&id,&stat,&x,&y);
	while(!(stat&15));

	if(x > 100){
		mov(x,y);
		sprintf(buf,"%d",i);
		txt(buf,0);
		ingon[i][0] = x;
		ingon[i][1] = y;
	}
	while(stat)
		rtp(&id,&stat,&id,&id);
	return(x>100);
}

outcode(x,y)
int x,y;
{
	int i = 0;

	if(x < xleft)
		i = 1;
	else if (x > xright)
		i = 2;
	if(y < ybottom)
		i |= 4;
	else if (y > ytop)
		i |= 8;

	return(i);
}

side(c)		/* return true if outcode c is a side region */
int c;
{
	return((c == 1)||(c == 2)||(c == 4)||(c == 10));
}
corner(c)	/* return true if outcode c is a corner region */
int c;
{
	return((c == 5)||(c == 6)||(c == 9)||(c == 10));
}

ods(c)
int c;
{
	obyte("+@",2);
	obyte(&c,1);
}
