;
; VT100 direct page etc.
;
	psect	1

;byte	equ	1
;word	equ	2

ENQ	equ	5
BEL	equ	7
BS	equ	8
HT	equ	9
LF	equ	10
VT	equ	11
FF	equ	12
CR	equ	13
SO	equ	14
SI	equ	15
XON	equ	17
XOFF	equ	19
CAN	equ	24
SUB	equ	26
ESC	equ	27


eetabs	equ	0	; eeprom offset for tabs array.
option	equ	132	; ditto options array (5 bytes).

vtled	equ	0x10
spfn79	equ	0x130e	; 7x9 graphic fonts
sp1280	equ	0x0f0e	; 12x16 graphic fonts
;
; Current line info.  Before changing <cury, copy
; the variables back to the array of line records,
; then copy the info for the new line to here.
;

txtptr	struct word	; points to text for current line (constant).
txtbnk	struct byte	; text bank (0 normally, prom in setup mode).
			; the long address is only used in routine 
			; dsplin (vtdisp.asm).
attptr	struct word	; ditto video attributes (ul,rv,font) (constant).
ncol	struct word	; max col/#chars current line.
nchr	equ ncol+1	; # chars on current line.
chrsiz	struct word	; char size(single/double)/special chars flag.
spflag	equ chrsiz+1	; temp in vtdisp

txtbuf	struct word	; pointer to beginning of text buffer.
attbuf	struct word	; pointer to beginning of attribute buffer.
linmap	struct word	; pointer to array of line numbers, ordered
			; so that linmap[i] is the index into the
			; following arrays of the i'th line on the
			; screen.  Originally linmap[i] = 2i, but
			; scrolling changes that.
curidx	struct byte	; 2*linmap[(cury-1)], for indexing following arrays.
txtmap	struct word	; pointer to array of pointers into txtbuf.
			; txtmap[curidx] points to the text 
			; displayed on current line of the screen.
attmap	struct word	; ditto attbuf.
lsizes	struct word	; lsizes[curidx] lowbyte == ncol,
			; high byte == nchr.
lflags	struct word	; lflags[curidx] low byte == chrsiz,
			; high byte == spflag.


colmax	struct byte	; window width (in characters).
rowmax	struct byte	; window height (in characters).
curx	struct byte	; current cursor position (1..ncol).
cury	struct byte	; (1..rowmax).
srtop	struct byte	; top line of scrolling region.
srbot	struct byte	; bottom line of scrolling region.
spattr	struct byte	; current char attributes (ul,rv,fonts)
g0set	struct byte	; Current G0 char set - UK,ASCII, or gfx
g1set	struct byte	; Current G1 char set - UK,ASCII, or gfx
g01sel	struct byte	; current selected char set
savx	struct byte	; saved cursor position.
savy	struct byte
savg0	struct byte	; saved g0set.

nlmode	struct byte	; bit 7 = newline, 6 = autowrap
vtmode	struct byte	; bit 7 = ANSI, 6 = echo.
clmode	struct byte	; bit 7 = 132 column mode, 6 = smooth/jump scroll
rvmode	struct byte	; bit 7 = hide gfx planes, 6 = keyclick
xonena	struct byte	; bit 7 = auto XON/XOFF, 6  = margin bell
xitena	struct byte	; bit 7 = exit to aed when parallel input avail.
			; bit 6 = don't redraw screen on entry.
akmode	struct byte	; bit 7 = alt kpad, 6 = cursor key.
ormode	struct byte	; bit 7 = origin mode.
lckout	struct byte	; bit 7 = local mode, 6 = kbd lockout,
			;     5 = noscroll mode.
tabs	struct word	; pointer to tab array.

hstqcb	struct word	; points to host qcb.
bytcnt	struct word	; points to Iqcnt (hi byte) for host input q.

parcnt	struct byte	; # parameters read by escbfn.
pncnt	struct byte	; # parameters returned by getps/getpn.
prvflg	struct byte	; flag set if first Pn starts with '?'.
maxpar	equ	10
param	struct maxpar	; decoded parameter buffer.
xpos	struct word
ypos	struct word

daflag	struct byte	; drawing acc flag char size flag bits.
cwidth	struct word
chight	struct word
desc	struct word
csx	struct byte
csy	struct byte
cslop	struct word	; dist from cap to bottom of char box.
fntptr	struct word	; pointer to current font.
fntbnk	struct byte	; font bank addr.

xorg	struct word
yorg	struct word

saveda	struct word	; points to buffer for saving/restoring
			; da registers via SaveDa/RstrDa.

;savctl	struct byte	; saved capctl and foreground, bkgrnd colors.
;savclr	struct byte
;svbclr	struct byte
svrmsk	struct byte	; need this for hide gfx option.
;svflag	struct byte

curbuf	struct word	; points to saved pixels under cursor.
cutime	struct word	; when to next draw/erase cursor.
oldcx	struct word	; curx,cury where cursor last drawn.
cdrawn	struct byte	; cursor drawn flag.

setab	struct byte	; bit 7 = in setup a mode.
lstmsg	struct byte	; current setup b option.
stack	struct word	; saved stack pointer on entry.

dcount	struct byte	; index into dstrng.
dstrng	struct 6	; used for binary/decimal string conversion.

vauto	struct byte	; signals whether last char was at ncol, so next
			; char can do autowrap
temp	struct word
temp1	struct word
temp2	struct word
temp3	struct word

	end
