/*	Graphics terminal subroutines with DMA for AED's 767.
*****************************************************************
*								*
*	All rights reserved:	VENTURCOM INC.	1982,83		*
*								*
*	This source listing is supplied in accordance with	*
*	the Software Agreement you have with VenturCom and	*
*	the Western Electric Company.				*
*								*
*****************************************************************/

#include <stdio.h>

#define	AEDOUTDEV	"/dev/aedbytes"
#define	AEDOUTFD	aed6fd
#define	AEDOUTOP	aed6op

/*	There are 2 new entries to aedsubs - dmaraster and aoidma.
	Both are called from TAP - see TAP functions rda,wda,rrd,wrd.
	dmaraster and aoidma are similar to ibyte,obyte in that they
	mostly just open a file if not open if possible and then
	issue read or write, as the case may be.  They're different
	in that one arg is a read/write flag.  Also the DMA functions
	require buffers to start on an integer boundary.

	The scd(buf,n) routine has changed - n is BYTE count.

	Ibyte and obyte no longer care if their buffers start on
	integer boundaries.			

*/
 
		
#define AOIDMADEV	"/dev/aedimaoi"	
static int aed3op = 0;
static int aed3fd;

#define IMADMADEV	"/dev/aedimage"
static int aed1op = 0;
static int aed1fd;


static char	aeddbfl = 0;
static	int	aed5op = 0;
static	int	aed5fd;
static	int	aed6op = 0;
static	int	aed6fd;

/*	aed_dummy is used as a one byte buffer	*/
/*	to read/write the first byte when the users */
/*	buffer is on an odd address.		*/
	
static int 	aed_dummy;



obyte(aedbfr,i) 
char *aedbfr; 
unsigned i;	/*	BYTE count	*/
{
	register char *pntr;
	register j;
	if(aed6op == 0){
		if((aed6fd = open("/dev/aedbytes",2)) < 1){
	fprintf(stderr,"open err (aedsubs-obyte:/dev/aedbytes)\n");
			exit(1);
		}
		aed6op++;
	}
	if(i==0){
		printf("aed- zero byte count\n");
		return (-1);
	}
	if((int)aedbfr&1){
/*
fprintf(stderr,"warning-odd address buf (aedsubs-obyte)\n");
*/
		aed_dummy = *aedbfr++;
		if((j = write(aed6fd,&aed_dummy,1) != 1)){
			fprintf("write error %d\n",j);
			exit(1);
		}
		if(--i == 0)
			return;
	}
/* end of fix	*/

		if((j = write(aed6fd,aedbfr,i)) != i){
fprintf(stderr,"write err %d (aedsubs-obyte:/dev/aedbytes)\n",j);
			exit(1);
		}
		if(aeddbfl){
			pntr = aedbfr;
			for (j=0;j<i;j++)fprintf(stdout,"b%o\n",*pntr++);
		}
}

aoidma(aedbfr,i,rw)
char *aedbfr;
unsigned i;		/*	WORD count	*/
char rw;		/*	0=read, else write	*/
{
	int j;
	if((int)aedbfr &01){
		fprintf(stderr,"aoidma - odd address\n");
		exit(1);
	}
	if(i == 0){
		fprintf(stderr,"aoidma - zero word count\n");
		exit(1);
	}
	if(aed3op == 0){
		if((aed3fd = open(AOIDMADEV,2)) <0){
			fprintf(stderr,"open failed on DMAOUT\n");
			exit(1);
		} 
		aed3op++;
	}
	switch(rw){
	case 0:	/* read aoi	*/
		if(( j = read(aed3fd,aedbfr,i)) != i){
			fprintf(stderr,"aoidmain - read error\n");
			exit(1);
		}
		break;

	default: /* write aoi	*/
		if(( j = write(aed3fd,aedbfr,i)) != i){
			fprintf(stderr,"aoidmaout - write error\n");
			exit(1);
		}
		break;

	}	/* end of read/write switch	*/
}

dmaraster(aedbfr,i,rw)
char *aedbfr;
unsigned i;	/*	WORD count	*/
char rw;	/* 0= read, else write	*/
{
	int j;

	if((int)aedbfr & 1){
		fprintf(stderr,"raster - odd address\n");
		exit(1);
	}
	if(i == 0){
		fprintf(stderr,"dmaraster - zero word count\n");
		exit(1);
	}
	if(aed1op == 0){
		if((aed1fd = open(IMADMADEV,2)) < 0 ){
			fprintf(stderr,"open /image failed\n");
			exit(1);
		}
		aed1op++;
	}
	switch(rw){
	case 0:	/* read	*/
		if(( j=read(aed1fd,aedbfr,i)) != i){
			fprintf(stderr,"read raster failed %d %d\n",i,j);
			exit(1);
		}
		break;
	default: /* write	*/
		if((j=write(aed1fd,aedbfr,i)) != i){
			fprintf(stderr,"write raster failed %d %d\n",i,j);
			exit(1);
		}
		break;

	}	/* end of rw switch	*/
}

ibyte(aedbfr,n) 
char *aedbfr; 
unsigned n;	/*	BYTE count	*/
{
	char *pntr;
	register j;

	if(aeddbfl)fprintf(stdout,"ibyte(%o,%d);\n",aedbfr,n);

	if(aed6op == 0){
		if((aed6fd = open("GD:",2)) < 1){
	fprintf(stderr,"open error (aedsubs-ibyte:/dev/aedbytes)\n");
			exit(1);
		}
		aed6op++;

	}
	if(n == 0){
		fprintf(stderr,"ibyte - zero byte count\n");
		exit(1);
	}

	if((int)aedbfr&1){
/*
fprintf(stderr,"odd address buf (aedsubs-ibyte)\n");
*/
/* odd address fix -- roy 10/5/83 */
/*
user buffer is on odd address, so read first byte into
an even addressed temp, copy it to user buf, inc user pointer,
dec user count, read rest in usual way.
*/
		if((j = read(aed6fd,&aed_dummy,1)) != 1){
			fprintf(stderr," read error %d\n",j);
			exit(1);
		}
		*aedbfr++ = aed_dummy;
		if(--n == 0)
			return; 
	}
/* end of fix	*/

	if((j = read(aed6fd,aedbfr,n)) != n){
		fprintf(stderr,"read err %d (aedsubs-ibyte:/dev/aedbytes)\n",j);
		exit(1);
	}
	if(aeddbfl){
		pntr = aedbfr;
		for (j=0;j<n;j++)fprintf(stdout,"i%o\n",*pntr++);
	}
}

scd(aedbfr,i) 
char *aedbfr; 
unsigned i;	/*	BYTE count	*/

{
	register j;
	register char *pntr;
	if(aeddbfl)fprintf(stdout,"scd(%o,%d);\n",aedbfr,i);
	if(aed5op == 0){
		if((aed5fd = open("GD:",1)) < 1){
			fprintf(stderr,"open err (aedsubs:/dev/aedwrcmd)\n");
			exit(1);
		}
		aed5op++;
	}
	if((int)aedbfr&1){
		fprintf(stderr,"odd address buf (aedsubs-scd)\n");
		exit(1);
	}
	if(i == 0){
		fprintf(stderr,"scd - zero byte count\n");
		exit(1);
	}
	if((j = write(aed5fd,aedbfr,i)) != i){
		fprintf(stderr,"write err %d (aedsubs-scd:/dev/aedwrcmd)\n",j);
		exit(1);
	}
	if(aeddbfl){
		pntr = aedbfr;
		for (j=0;j<i;j++)fprintf(stdout,"d%o\n",*pntr++);
	}
}
aeddebug(arg){
	if(arg) arg = 1;
	if(arg != aeddbfl){	
		if(arg)printf("aed debug printing on:\n");		
		else printf("aed debug printing off.\n");
		aeddbfl = arg;
	}
}
