/*  Copyright 1987 President and Fellows of Harvard University

Permission to use, copy, modify, and distribute this program
for any purpose and without fee is hereby granted, provided
that this copyright and permission notice appear on all copies
and supporting documentation, the name of Harvard University not
be used in advertising or publicity pertaining to distribution of
the program without specific prior permission, and notice be given
in supporting documentation that copying and distribution is
by permission of Harvard University.  Harvard University makes
no representations about the suitability of this software for
any purpose.  It is provided "as is" without express or implied warranty. */

/* Dan Lanciani - 1987 */
/* PC/IP driver for AppleTalk/TOPS */
/* Please send changes to ddl@harvard.harvard.edu or sob@harvard.harvard.edu */

#include <task.h>
#include <q.h>
#include <netq.h>
#include <net.h>
#include <custom.h>
#include <netbuf.h>
#include <stdio.h>
#include "at.h"

extern int MaxLnh;
extern NET *at_net;
extern DDPParams DDPPr;

static far
comp()
{
	tk_wake(at_net->n_demux);
}

at_demux()
{
	register PACKET p;
	extern long cticks;

	while(1) {
		if(!(p = a_getfree())) {
			tk_yield();
			continue;
		}
		DDPPr.atd_compfun = comp;
		DDPPr.ddp_buffptr = (BuffPtr)p->nb_prot;
		DDPPr.ddp_buffsize = LBUF - MaxLnh;
		at(&DDPPr);
		while(DDPPr.atd_status > 0)
			tk_block();
		if(DDPPr.atd_status) {
			putfree(p);
			continue;
		}
		p->nb_tstamp = cticks;
		indemux(p, p->nb_len = DDPPr.ddp_buffsize, at_net);
	}
}
