
/*****************************************************************************

       Copyright  1993, 1994 Digital Equipment Corporation,
                       Maynard, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, provided  
that the copyright notice and this permission notice appear in all copies  
of software and supporting documentation, and that the name of Digital not  
be used in advertising or publicity pertaining to distribution of the software 
without specific, written prior permission. Digital grants this permission 
provided that you prominently mark, as not part of the original, any 
modifications made to this software or documentation.

Digital Equipment Corporation disclaims all warranties and/or guarantees  
with regard to this software, including all implied warranties of fitness for 
a particular purpose and merchantability, and makes no representations 
regarding the use of, or the results of the use of, the software and 
documentation in terms of correctness, accuracy, reliability, currentness or
otherwise; and you rely on the software, documentation and results solely at 
your own risk. 

******************************************************************************/

/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/


#include "osf.h"
#include "regdefs.h"

#ifdef _WIN32
/*
 * Tell assembler that byte instructions are OK
 */
	.arch   ev6
	.tune   ev6
#endif /* _WIN32 */


/*
 *  GNU CC demands that __main exists.
 */
	.text
	.align 4
	.globl __main
	.ent __main
__main:
	ret	zero, (ra)
	.end __main

	.text
	.align 4
	.globl	mb
	.ent	mb 2
mb:
	.option	O1
	.frame	sp, 0, ra
	mb
	ret	zero, (ra)
	.end	mb

	.text
	.align 4
	.globl imb
	.ent imb
imb:
	/*
	 * Instruction barrier interface;
	 * simply call the PAL code instruction.
	 */
	.frame sp, 0, ra
	call_pal PAL_IMB_ENTRY
	ret zero, (ra)
	.end imb


        .text
        .align 4
        .globl draina
        .ent draina
draina:
        /* STIG:
         * drain aborts interface;
         * simply call the PAL code instruction.
         */
        .frame sp, 0, ra
        call_pal PAL_DRAINA_ENTRY
        ret zero, (ra)
        .end draina


	.text
	.align 4
	.globl	rpcc
	.ent	rpcc 2
rpcc:
	.option	O1
	.frame	sp, 0, ra
	rpcc	v0
	zapnot	v0, 0xF, v0		/* STIG: blow off the high longword */
	ret	zero, (ra)
	.end	rpcc

	.text
	.align 4
	.globl	getsp
	.ent	getsp 2
getsp:
	.option	O1
	.frame	sp, 0, ra
	bis	sp, zero, v0
	ret	zero, (ra)
	.end	getsp

	.text
	.align 4
	.globl	cServe
	.ent	cServe 2
cServe:
	.option	O1
	.frame	sp, 0, ra
	call_pal PAL_CSERVE_ENTRY
	ret	zero, (ra)
	.end	cServe

	.text
	.align 4
	.globl	wrfen
	.ent	wrfen 2
wrfen:
	.option	O1
	.frame	sp, 0, ra
	call_pal PAL_WRFEN_ENTRY
	ret	zero, (ra)
	.end	wrfen

	.text
	.align 4
	.globl	swppal
	.ent	swppal 2
swppal:
	.option	O1
	.frame	sp, 0, ra
	call_pal PAL_SWPPAL_ENTRY
	ret	zero, (ra)
	.end	swppal

	.text
	.align 4
	.globl	halt
	.ent	halt 2
halt:
	.option	O1
	.frame	sp, 0, ra
	call_pal PAL_HALT_ENTRY
	ret	zero, (ra)
	.end	halt

	.text
	.align 4
	.globl	wait_cycles
	.ent	wait_cycles 2
wait_cycles:
	.option O1
	.frame	sp, 0, ra
/*
 *	a0 contains the number of wait cycles.
 */
	rpcc	t0			/*  read cycle counter */
	zap	a0, 0xf0, a0		/* mask off upper longword */
again:	rpcc	t2			/*  read cycle counter again */
	subl	t2, t0, t2		/* check for wrapping */
	bge 	t2, noshft		/* check to see if negative */

	lda	t3, 1(zero)             /* we need to add 2^32 */
	sll	t3, 32, t3		/* shift the add amount */
	addq	t3, t2, t2		/* add 0x100000000 to it for wrapping */

noshft:	cmplt	t2, a0, t2		/* compare these for usec timer */
	bne	t2, again		/* stay in... */
	ret	zero, (ra)
	.end	wait_cycles

	.text
	.align 4
	.globl swpipl
	.ent swpipl
swpipl:
	/* C access to swap IPL pal routine */
	.frame sp,0,ra
	call_pal PAL_SWPIPL_ENTRY
	ret zero,(ra)
	.end swpipl	

	.text
	.align 4
	.globl wrmces
	.ent wrmces
wrmces: 
	/* Write the machine check error status register */
	.frame sp,0,ra
	call_pal PAL_WRMCES_ENTRY
	ret zero,(ra)
	.end wrmces


	.text
	.align 4
	.globl rdmces
	.ent rdmces
rdmces: 
	/* Read the machine check error status register */
	.frame sp,0,ra
	call_pal PAL_RDMCES_ENTRY
	ret zero,(ra)
	.end rdmces

	.text
	.align 4
	.globl wripir
	.ent wripir
wripir:
	/* write an inter-processor interrupt request */
	.frame sp,0,ra
	call_pal PAL_WRIPIR_ENTRY
	ret zero,(ra)
	.end wripir


/*----------------------------------------------------------------------*/
/* Atomic test-and-set - takes a variable and sets to one if zero,
 * or blocks until it is set to zero elsewhere */

        .text
        .align 4
        .globl  atomic_tas
	.ent	atomic_tas
atomic_tas:
	.frame  sp, 0, ra		/* empty stack frame */

try_again:
	ldl_l	t0, 0(a0)
	
	/* if zero, make it one and store, otherwise skip round again */
	bne	t0, no_store		/* fwd branch if non-zero */
	bis	a1, zero, t0		/* write my mask value */

	stl_c	t0, 0(a0)
	beq	t0, no_store		/* fwd branch if beaten to it */

	ret	zero, (ra)

no_store:
	br	try_again

	.end	atomic_tas


/*----------------------------------------------------------------------*/
/* Secondary CPU polling loop for Linux kernel entry */

	.text
	.align 4
	.globl	secondary_polling_loop
	.ent	secondary_polling_loop
secondary_polling_loop:
	
BIPset:
	ldq	t0, 0(a4)
	and	t0, 1, t1
	bne	t1, BIPset			/* loop while BIP is set */

	bis	t0, 1, t0			/* set BIP again to confirm */
	stq	t0, 0(a4)			/* kernel takes this as ack */

	/* load in kernel entry point, passed in as pointer */
	ldq	a1, 0(a1)
	br	r31, swppal			/* all other parameters set */

	/* never reached */
	.end	secondary_polling_loop


/*----------------------------------------------------------------------*/

	.text
	.align 4
	.globl	CleanBCache
	.ent	CleanBCache 2
CleanBCache:
	.option O1
	.frame	sp, 0, ra
/*
 *	Make sure that the cache is not dirty by reading
 *	the contents of memory twice the size of the BCache.
 *
 *	a0 must contain the memory size (2xBCache) to sweep.
 */
	mb	/* Flush the Write Buffer first */
Sweep0:
	ldq	t0, 0xFFF&-32(a0)	/* Load  next cache block.	*/
	lda     a0, -32(a0)		/* Decrement pointer		*/
	bgt     a0, Sweep0		/* Loop until done		*/
	ret	zero, (ra)
	.end	CleanBCache

