/*
 * Debug Monitor Entry code
 */
/*****************************************************************************

       Copyright  1993, 1994 Digital Equipment Corporation,
                       Maynard, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted, provided
that the copyright notice and this permission notice appear in all copies
of software and supporting documentation, and that the name of Digital not
be used in advertising or publicity pertaining to distribution of the software
without specific, written prior permission. Digital grants this permission
provided that you prominently mark, as not part of the original, any
modifications made to this software or documentation.

Digital Equipment Corporation disclaims all warranties and/or guarantees
with regard to this software, including all implied warranties of fitness for
a particular purpose and merchantability, and makes no representations
regarding the use of, or the results of the use of, the software and
documentation in terms of correctness, accuracy, reliability, currentness or
otherwise; and you rely on the software, documentation and results solely at
your own risk.

******************************************************************************/
/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/



#include "osf.h"
#include "cserve.h"
#include "ledcodes.h"
#include "impure.h"
#include "memory.h"

#define DFLT_PALADDR

/* this code is entered on successful uncompression of the main code segment
 * of the diagnostics.  The init header will have set up the stack correctly
 * and also handles all the data passed through by the PALcode */

/* on entry, a0 contains the address of the system data table.  This is a 
 * layer of indirection into the PALcode impure region.  It could easily 
 * be a pointer to the impure region, but isn't for historical reasons. */

/* a1 contains a flag which is set when we are the secondary CPU.  In which
 * case we don't have to do the full gamut of initialisations.  However,
 * currently there are no initialisations here that don't need doing on all
 * CPUs.
 */


/* This code may also be entered on exit from the Linux kernel.  In which 
 * case, we're in the wrong superpage mode and using the wrong palcode!
 * A swappal is needed before any memory accesses can be made. 
 */

        .text
	.set	noat
	.set	noreorder

        .globl  __start
        .ent    __start, 0
__start:

	/*--------------------------------------------------------------------*/
	/* Write to the LEDs, using EV6 Superpage mode */
	/* [Assumes VA_48 is set] */

        ldah    t0, 0x8(zero)		/* 0x0000000000080000 */
        lda     t0, 0x01fc(t0)		/* 0x00000000000801FC */
        sll     t0, 24, t0		/* 0x00000801FC000000 */
        lda     t1, -1(zero)		/* 0xFFFFFFFFFFFFFFFF */
        sll     t1, 47, t1		/* 0xFFFF800000000000 */
        bis     t0, t1, t0		/* 0xFFFF8801FC000000 */
        bis     t0, 0x80, t0		/* 0xFFFF8801FC000080 = superpage LED*/
        lda     t1, LED_INIT1(zero)	
        stb     t1, 0(t0)		/* Write to LEDs in IO space */



	/* save off a copy of the arguments a0, a1, a2... */
	bis	a0, zero, s0		/* sysdata pointer */
	bis	a1, zero, s1		/* full_init_needed flag ptr */
	bis	a2, zero, s2		/* compressed image start ptr */
	bis	a3, zero, s3		/* compressed image end ptr */
	bis	a4, zero, s4		/* myid */

	/*--------------------------------------------------------------------*/
	/* Setup the global offset table (GOT) for addressing */

        br      t1, 2f                  # get the current PC
2:      ldgp    gp, 0(t1)               # init gp


	/*--------------------------------------------------------------------*/
	/* Do we zap the BSS?  Only if diags_do_inits is TRUE */
	/* Note: we depend here on serialised access until main init is done */

bsszap:
	ldbu	t0, diags_do_inits
	beq	t0, donezap		/* If zero, BSS is already in use */

	/* Obtain the addresses of the start and end of the BSS */
	lda	t1, _bss
	lda	t2, _uncompressed_end

bsszaploop:
	stb	zero, 0(t1)		/* zero another byte of BSS */
	addq	t1, 1, t1
	cmpule	t1, t2, t0
	bne	t0, bsszaploop

donezap:

#if 0
	/*--------------------------------------------------------------------*/
	/* If a0=0, the halt code was reset, otherwise something unusual */

	beq	a0, entry_complications_cleared


	/*--------------------------------------------------------------------*/
	/* Perform extra initialisations that are required if we got here 
	 * other than via simple powerup... */

entry_not_via_reset:

	/* Check PALbase to see if we're the right PALcode (ie diags PALcode) */

	lda     a2, CSERVE_K_RD_IMPURE	/* load the impure region pointer */
	call_pal PAL_CSERVE_ENTRY

	ldq	t0, CNS__PAL_BASE( v0 )	/* get PAL_BASE and compare */
	lda	t1, 32( zero )
	sll	t1, 10, t1		/* lda	t1, DFLT_PALADDR( zero ) */
	subq	t0, t1, t2
	beq	t2, envr__pal_ok

	/* At this point we can't assume we're using the same superpage mode
	 * we compiled with but can assume 1-1 mapping.  Zap out the 
	 * superpage mode bits wherever relevant  */

	zap	gp, 0xE0, gp				/* strip superpage */

	/* SWPPAL back to our own PALcode - assuming its still there */

	bis	t1, zero, a0				/* new PAL base */
	lda	a1, envr__pal_ok			/* new PC */
	zap	a1, 0xE0, a1				/* strip superpage */
	lda	a2, mypcb				/* new PCB */
	zap	a2, 0xE0, a2				/* strip superpage */
	lda	a3, 1( zero )				/* VPTBR: lsb=>1-1 */

	call_pal PAL_SWPPAL_ENTRY			/* off we go */

	/* if we get here something failed in the SWPPAL */
	halt

envr__pal_ok:

entry_complications_cleared:

#endif
	/*--------------------------------------------------------------------*/
	/* Install the unexpected fault (and machine check) handlers */

        lda     a0, 1(zero)			/* Enable floating point unit */
        call_pal PAL_WRFEN_ENTRY

	bis	gp, zero, a0
	call_pal PAL_WRKGP_ENTRY

	lda	a0, simplehandler(gp)
	lda	a1, 0(zero)			/* Entry on Ints */
	call_pal PAL_WRENT_ENTRY

	/* write all other entry points to catch bizarre errors */
	lda	a0, unexpectedArith(gp)
	lda	a1, 1(zero)			/* Arith */
	call_pal PAL_WRENT_ENTRY

	lda	a0, unexpectedMM(gp)
	lda	a1, 2(zero)			/* MM */
	call_pal PAL_WRENT_ENTRY

	lda	a0, unexpectedIF(gp)
	lda	a1, 3(zero)			/* IF */
	call_pal PAL_WRENT_ENTRY

	lda	a0, unexpectedUna(gp)
	lda	a1, 4(zero)			/* Una */
	call_pal PAL_WRENT_ENTRY

	lda	a0, unexpectedSys(gp)
	lda	a1, 5(zero)			/* Sys */
	call_pal PAL_WRENT_ENTRY



	/*--------------------------------------------------------------------*/
	/* Write to the LEDs, using EV6 Superpage mode */
	/* [Assumes VA_48 is set] */

        ldah    t0, 0x8(zero)		/* 0x0000000000080000 */
        lda     t0, 0x01fc(t0)		/* 0x00000000000801FC */
        sll     t0, 24, t0		/* 0x00000801FC000000 */
        lda     t1, -1(zero)		/* 0xFFFFFFFFFFFFFFFF */
        sll     t1, 47, t1		/* 0xFFFF800000000000 */
        bis     t0, t1, t0		/* 0xFFFF8801FC000000 */
        bis     t0, 0x80, t0		/* 0xFFFF8801FC000080 = superpage LED*/
        lda     t1, LED_INIT1(zero)	
        stb     t1, 0(t0)		/* Write to LEDs in IO space */




	/*--------------------------------------------------------------------*/
	/* Every good C program has a main() */


        bis     s0, zero, a0		/* sysdata area pointer */
        bis     s1, zero, a1		/* full init flag pointer */
	bis	s2, zero, a2		/* compressed image start ptr */
	bis	s3, zero, a3		/* compressed image end ptr */
	bis	s4, zero, a4		/* MyID */

        lda     pv, dbm_main
        jsr     ra, (pv)


/*
 *      The Debug Monitor should never return.
 *      However, just incase...
 */
        call_pal PAL_HALT_ENTRY

.end    __start


	.data

/* A static-defined PCB for SWPPAL purposes above */
mypcb:
	.quad	0x00000000007FFFF8	/* KSP (should I superpage it?) */
	.quad 	0			/* USP */
	.quad	0			/* PTBR */
	.quad	0			/* PCC */
	.quad	0			/* ASN */
	.quad	0			/* UNIQUE */
	.quad	0			/* FLAGS */
	.quad	0			/* RESERVED1 */
	.quad	0			/* RESERVED2 */ 



/*----------------------------------------------------------------------*/
/* Basic interrupt setup before C handler routine. */

/* NOTE - during this routine, everything that is used (except a0-a2) must 
 * first be saved */

	.text
	.globl	simplehandler
	.ent 	simplehandler

simplehandler:
/* Our first job is to set up a stack for register saving - I don't know how
 * many registers will be used by the C-code so I'm being defensive and saving
 * the lot, including callee save */
/* GCC can use floating point registers to store constants between read and
 * write into the stack frame, so better save all them too */
	lda	sp, -488(sp)			/* 61 8-byte registers */

	stq	$0, 0(sp)
	stq	$1, 8(sp)
	stq	$2, 16(sp)
	stq	$3, 24(sp)
	stq	$4, 32(sp)
	stq	$5, 40(sp)
	stq	$6, 48(sp)
	stq	$7, 56(sp)
	stq	$8, 64(sp)
	stq	$9, 72(sp)
	stq	$10, 80(sp)
	stq	$11, 88(sp)
	stq	$12, 96(sp)
	stq	$13, 104(sp)
	stq	$14, 112(sp)
	stq	$15, 120(sp)
	stq	$16, 128(sp)
	stq	$17, 136(sp)
	stq	$18, 144(sp)
	stq	$19, 152(sp)
	stq	$20, 160(sp)
	stq	$21, 168(sp)
	stq	$22, 176(sp)
	stq	$23, 184(sp)
	stq	$24, 192(sp)
	stq	$25, 200(sp)
	stq	$26, 208(sp)
	stq	$27, 216(sp)
	stq	$28, 224(sp)
	stq	$29, 232(sp)

	stt	$f0, 240(sp)
	stt	$f1, 248(sp)
	stt	$f2, 256(sp)
	stt	$f3, 264(sp)
	stt	$f4, 272(sp)
	stt	$f5, 280(sp)
	stt	$f6, 288(sp)
	stt	$f7, 296(sp)
	stt	$f8, 304(sp)
	stt	$f9, 312(sp)
	stt	$f10, 320(sp)
	stt	$f11, 328(sp)
	stt	$f12, 336(sp)
	stt	$f13, 344(sp)
	stt	$f14, 352(sp)
	stt	$f15, 360(sp)
	stt	$f16, 368(sp)
	stt	$f17, 376(sp)
	stt	$f18, 384(sp)
	stt	$f19, 392(sp)
	stt	$f20, 400(sp)
	stt	$f21, 408(sp)
	stt	$f22, 416(sp)
	stt	$f23, 424(sp)
	stt	$f24, 432(sp)
	stt	$f25, 440(sp)
	stt	$f26, 448(sp)
	stt	$f27, 456(sp)
	stt	$f28, 464(sp)
	stt	$f29, 472(sp)
	stt	$f30, 480(sp)


	/*--------------------------------------------------------------------*/
	/* save of state complete, we can now happily play with the registers */

	/* Setup the global offset table (GOT) for addressing */

        br      t1, 3f                  # get the current PC
3:      ldgp    gp, 0(t1)               # init gp


#ifdef DEBUG_INTS
	mov 	a0, s0
	mov	a1, s1
	mov	a2, s2

        /* LED write */
        lda     pv, outled(gp)
        lda     a0, led_k_ksp_initialized(zero)
        jsr     ra, (pv)
        ldgp    gp, 0(ra)               # restore gp

	mov	s0, a0
	mov	s1, a1
	mov	s2, a2

#endif	/* DEBUG_INTS */ 

	/* set up procedure variable and jump to C environment */
	lda	pv, UnexpectedInterruptHandler(gp)
	jsr	ra, (pv)
	ldgp	gp, 0(ra)		/* restore GP */

/* reload state of the register file from stack */
	
	ldq	$0, 0(sp)
	ldq	$1, 8(sp)
	ldq	$2, 16(sp)
	ldq	$3, 24(sp)
	ldq	$4, 32(sp)
	ldq	$5, 40(sp)
	ldq	$6, 48(sp)
	ldq	$7, 56(sp)
	ldq	$8, 64(sp)
	ldq	$9, 72(sp)
	ldq	$10, 80(sp)
	ldq	$11, 88(sp)
	ldq	$12, 96(sp)
	ldq	$13, 104(sp)
	ldq	$14, 112(sp)
	ldq	$15, 120(sp)
	ldq	$16, 128(sp)
	ldq	$17, 136(sp)
	ldq	$18, 144(sp)
	ldq	$19, 152(sp)
	ldq	$20, 160(sp)
	ldq	$21, 168(sp)
	ldq	$22, 176(sp)
	ldq	$23, 184(sp)
	ldq	$24, 192(sp)
	ldq	$25, 200(sp)
	ldq	$26, 208(sp)
	ldq	$27, 216(sp)
	ldq	$28, 224(sp)
	ldq	$29, 232(sp)

        ldt     $f0, 240(sp)		/* FP regs too (paranoia) */
        ldt     $f1, 248(sp)
        ldt     $f2, 256(sp)
        ldt     $f3, 264(sp)
        ldt     $f4, 272(sp)
        ldt     $f5, 280(sp)
        ldt     $f6, 288(sp)
        ldt     $f7, 296(sp)
        ldt     $f8, 304(sp)
        ldt     $f9, 312(sp)
        ldt     $f10, 320(sp)
        ldt     $f11, 328(sp)
        ldt     $f12, 336(sp)
        ldt     $f13, 344(sp)
        ldt     $f14, 352(sp)
        ldt     $f15, 360(sp)
        ldt     $f16, 368(sp)
        ldt     $f17, 376(sp)
        ldt     $f18, 384(sp)
        ldt     $f19, 392(sp)
        ldt     $f20, 400(sp)
        ldt     $f21, 408(sp)
        ldt     $f22, 416(sp)
        ldt     $f23, 424(sp)
        ldt     $f24, 432(sp)
        ldt     $f25, 440(sp)
        ldt     $f26, 448(sp)
        ldt     $f27, 456(sp)
        ldt     $f28, 464(sp)
        ldt     $f29, 472(sp)
        ldt     $f30, 480(sp)

	lda	sp, 488(sp)		/* restore stack pointer */

	call_pal PAL_RTI_ENTRY		/* see if that returns us correctly */

	.end 	simplehandler

	
/*----------------------------------------------------------------------*/
/* Handlers for odd bits and bobs */

	.globl	unexpectedException
	.ent	unexpectedException
unexpectedException:
	
	lda	sp, -224(sp)		/* 28 integer regs = 224 bytes */

	stq	$0, 0(sp)
	stq	$1, 8(sp)
	stq	$2, 16(sp)
	stq	$3, 24(sp)
	stq	$4, 32(sp)
	stq	$5, 40(sp)
	stq	$6, 48(sp)
	stq	$7, 56(sp)
	stq	$8, 64(sp)
	stq	$9, 72(sp)
	stq	$10, 80(sp)
	stq	$11, 88(sp)
	stq	$12, 96(sp)
	stq	$13, 104(sp)
	stq	$14, 112(sp)
	stq	$15, 120(sp)
	stq	$19, 128(sp)
	stq	$20, 136(sp)
	stq	$21, 144(sp)
	stq	$22, 152(sp)
	stq	$23, 160(sp)
	stq	$24, 168(sp)
	stq	$25, 176(sp)
	stq	$26, 184(sp)
	stq	$27, 192(sp)
	stq	$28, 200(sp)
	stq	$29, 208(sp)
	stq	$30, 216(sp)


	/* Setup the global offset table (GOT) for addressing */
	br	t1, unexp_getgp
unexp_getgp:
	ldgp	gp, 0(t1)

	/* set up procedure variable and jump to C environment */
	lda	pv, UnexpectedFault(gp)
	bis	sp, zero, a0		/* pointer to the data above */
	jsr	ra, (pv)

	halt				/* stop (neatly??) on return */

	.end	unexpectedException



/* Boilerplate duplication here because I can at least look for the 
 * address on the IO bus and track down the error (when Linux kernel loads) */

	.globl	unexpectedArith
	.ent	unexpectedArith
unexpectedArith:

	lda	sp, -32(sp)

	stq	a0, 8(sp)
	stq	a1, 16(sp)
	stq	a2, 24(sp)

	lda	a0, 1(zero)		/* 1 = Arithmetic exception */
	stq	a0, 0(sp)
	br	unexpectedException	/* save the rest of the stuff */

	.end	unexpectedArith


	.globl	unexpectedMM
	.ent	unexpectedMM
unexpectedMM:
	lda	sp, -32(sp)

	stq	a0, 8(sp)
	stq	a1, 16(sp)
	stq	a2, 24(sp)

	lda	a0, 2(zero)		/* 2 = Memory management exception */
	stq	a0, 0(sp)
	br	unexpectedException	/* save the rest of the stuff */

	.end	unexpectedMM


	.globl	unexpectedIF
	.ent	unexpectedIF
unexpectedIF:
	lda	sp, -32(sp)

	stq	a0, 8(sp)
	stq	a1, 16(sp)
	stq	a2, 24(sp)

	lda	a0, 3(zero)		/* 3 = Instruction Fault */
	stq	a0, 0(sp)
	br	unexpectedException	/* save the rest of the stuff */

	.end	unexpectedIF


	.globl	unexpectedUna
	.ent	unexpectedUna
unexpectedUna:
	lda	sp, -32(sp)

	stq	a0, 8(sp)
	stq	a1, 16(sp)
	stq	a2, 24(sp)

	lda	a0, 4(zero)		/* 4 = Unaligned trap exception */
	stq	a0, 0(sp)
	br	unexpectedException	/* save the rest of the stuff */

	.end	unexpectedUna


	.globl	unexpectedSys
	.ent	unexpectedSys
unexpectedSys:
	lda	sp, -32(sp)

	stq	a0, 8(sp)
	stq	a1, 16(sp)
	stq	a2, 24(sp)

        lda     a0, 5(zero)             /* 5 = System fault */
	stq	a0, 0(sp)
	br	unexpectedException	/* save the rest of the stuff */

	.end	unexpectedSys



/*----------------------------------------------------------------------*/

        .globl  _exit
        .ent    _exit, 0
_exit:
        call_pal PAL_HALT_ENTRY
.end    _exit


