/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/
/* top-level access - C test controller routine */

/* generic routines made available to test functions */

void mem_logerr( const String tst_name, const String tst_symptom,
                 SMP_ptr physaddr,
                 unsigned long actual, unsigned long expected );

void dump_cacheline( String name, SMP_ptr ptr, SMP_ptr exp);


/* additional control of mem driver: savvy progs can set a time limit */
extern unsigned memtest_secs;			


/*--------------------------------------------------------------------*/
/* Access mechanism to individual memory test routines */

typedef size_t (*tst_fn)( SMP_ptr start, size_t bytes );

typedef struct {
        String name;
        tst_fn write, read;
} tst_t;

extern const tst_t tst[];	/* exported table of available memory tests */
extern const unsigned ntests;

/*--------------------------------------------------------------------*/
