/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/
/* SMP IPI ping-pong test */
/* Begun by Stig Telfer, Alpha Processor Inc, 11 July 2000 */

#undef TRACE_ENABLE 

#include "lib.h"
#include "uilib.h"
#include "smp.h"
#include "memory.h"
#include "cmos_rtc.h"
#include "platform.h"


/*----------------------------------------------------------------------*/

#define IPI_ITERS 10000UL


DBM_STATUS smp_ipitest( int argc, char *argv[] )
{
    int i, last_pp_count;
    static volatile uint8 test_complete = FALSE;
    unsigned long stime, etime, ticks;
    int ipl;
    unsigned long latency;

    if( smp_online_count <= 1 )
    {
	mobo_logf( LOG_WARN "SMP: Not enough processors online to run test\n" );
	return STATUS_WARNING;
    } 
    diags_subsys_stat( SYS_SMP, DEV_STRESSING );

    ipl = swpipl( 0 );			/* need to enable IPI interrupts */

    if ( smp_primary() )
    {
	mobo_cls();
	printf_dbm( "Inter-processor Interrupt Ping-Pong test\n" );

        stime = rpcc();                                 /* timing info */

	for ( i=0; i<IPI_ITERS; i++ )
	{
	    last_pp_count = smp_ipi_pingpongs;
	    smp_ipi( 1, IPI_PING, 0 );
	    
	    /* Wait for the second processor to 'pong' our 'ping' */
	    while( last_pp_count == smp_ipi_pingpongs )
		    /* timeout? */;
	}

        etime = rpcc();                                 /* timing info */
        if ( stime >= etime ) etime += 1UL << 32;       /* wraparound? */
        ticks = etime - stime;           /* elapsed time in CPU cycles */
	latency = (ticks * primary_impure->CYCLE_CNT) / (2*IPI_ITERS*1000UL);

	mobo_logf( LOG_INFO
		   "IPI: %d ping-pongs complete, IPI latency is %d nsec\n",
		    IPI_ITERS, latency );

	mobo_alertf( "Test passed",
		     "Inter-processor interrupt latency measured as %d nsec\n",
			latency );

	test_complete = TRUE;

    } else {

	/* Secondary CPUs hang around and get IPL'ed every now and then... */

	while( !test_complete )
	{
	    TRACE( "tock\n" );
	    msleep( 500 );
	}
    }

    swpipl( ipl );
    smp_sync();				/* ensure all CPUs are still up */

    test_complete = FALSE;
    diags_subsys_stat( SYS_SMP, DEV_PASSED );
    return STATUS_SUCCESS;
}

