/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/
/* Begun by Stig Telfer, API NetWorks, 27 November 2000 
 *
 * $Id: pcf-eprom.c,v 1.2 2001/02/21 20:23:12 stig Exp $
 * $Author: stig $
 * $Revision: 1.2 $
 *
 * $Log: pcf-eprom.c,v $
 * Revision 1.2  2001/02/21 20:23:12  stig
 * Added new commands:
 *  'asset' - read and modify asset information EEPROMs on the motherboard
 *  'eeprom' - read the EEPROMs and test writes using the last byte
 * BUG(S) FIXED: 57-0104-0A (Spec: EEproms on motherboards, slot Bs empty)
 *
 * Revision 1.1  2000/11/27 17:04:50  stig
 * Added PCF8582 256-byte EEPROM support to I2C driver (first implementation).
 * This paves the way to some form of asset management control.
 * BUG(S) FIXED:
 * BACKEND RELATED:
 *
 */

#undef TRACE_ENABLE

#include "lib.h"
#include "uilib.h"
#include "southbridge.h"

#include "i2c.h"
#include "i2c/pcf-eprom.h"


/*------------------------------------------------------------------------*/
/* Public interface */

DBM_STATUS pcfeprom_read( uint8 addr, uint8 off, size_t n, uint8 *data )
{
    TRACE( "Reading EEPROM device at 0x%02X, address 0x%02X\n", addr, off );
    return i2cdev_read( addr, off, n, data );
}


DBM_STATUS pcfeprom_write( uint8 addr, uint8 off, size_t n, uint8 *data )
{
    DBM_STATUS sval;

    TRACE( "Writing EEPROM device at 0x%02X, address 0x%02X\n", addr, off );
    sval = i2cdev_write( addr, off, n, data );

    /* ROM appears to want some time in order to clear the write */
    msleep( 50 );

    return sval;
}

