/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/
/* CPU architecture revision specific code */
/* Begun April 28 by Stig Telfer, Alpha Processor Inc. */

/* interpretation of machine check logout frames, used by the machine check
 * handler.  The second argument (interpretation) must be an allocated 
 * string buffer.  The first returns a String pointer from the function's
 * internal string data */

void cpu_mchkinterp( String interp, int scb, LogoutFrame_t *L);

/* bus/cpu ECC syndrome bits for this processor */
int cpu_syn2bit(unsigned long, unsigned long);

/* List interesting data from the PALcode impure region */
void cpu_impuredump( void );

/* Register interesting information about this processor */
void cpu_info_submit( const unsigned cpuid );

