#ifndef DIAGS__LIB_H_LOADED
#define DIAGS__LIB_H_LOADED
/*****************************************************************************

       Copyright  1993, 1994 Digital Equipment Corporation,
                       Maynard, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, provided  
that the copyright notice and this permission notice appear in all copies  
of software and supporting documentation, and that the name of Digital not  
be used in advertising or publicity pertaining to distribution of the software 
without specific, written prior permission. Digital grants this permission 
provided that you prominently mark, as not part of the original, any 
modifications made to this software or documentation.

Digital Equipment Corporation disclaims all warranties and/or guarantees  
with regard to this software, including all implied warranties of fitness for 
a particular purpose and merchantability, and makes no representations 
regarding the use of, or the results of the use of, the software and 
documentation in terms of correctness, accuracy, reliability, currentness or
otherwise; and you rely on the software, documentation and results solely at 
your own risk. 

******************************************************************************/
/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/

/*
 *  $Id: lib.h,v 1.39 2001/02/07 18:29:05 stig Exp $;
 */

#include <stddef.h>
#include <stdarg.h>

#include "diag_conf.h"		/* pick up makefile-driven configuration opts */
#include "version.h"		/* version details */
#include "dbmtypes.h"
#include "specifics.h"		/* pick up platform-dependent overrides */
#include "memory.h"
#include "time.h"
#include "asmstuff.h"
#include "file.h"
#include "console.h"
#include "impure_struct.h"
#include "smp.h"


/* Misc definitions */

#undef TRUE
#define TRUE 1

#undef FALSE
#define FALSE 0

#define _MIN(a,b) (((a)<(b)) ? (a) : (b))
#define _MAX(a,b) (((a)>(b)) ? (a) : (b))

#ifndef RAND_MAX
#define RAND_MAX	2147483647	/* max value returned by rand	*/
#endif

#ifndef HZ	/* jiffies tick rate, may be overridden in specifics */
#define HZ	1024
#endif

#define ARRAYLEN( ptr )		( sizeof( ptr ) / sizeof( ptr[0] ))

/*--------------------------------------------------------------------*/
/* The following macros are used for printing out status information 
 * and internal error messages; such messages go to standard error in 
 * environments in which there is a standard error file */


/*
 * Tracing with debug prints using the TRACE_ENABLE
 * macros (see prtrace.h) can be performed by
 * two different means. (1) Defining TRACE_ENABLE
 * will build in the tracing at compile time.
 * (2) Defining TRACE_ENABLE will also build
 * in tracing at compile time.  However, most
 * of it can be enabled or disabled at run
 * time with the debug monitor prtrace command.
 */

#ifdef TRACE_ENABLE

#define TRACE(format, args...) \
	mobo_logf( LOG_DBG __FUNCTION__ ": " format , ## args)
#else

#define TRACE( format, args... )

#endif	/* TRACE_ENABLE */


/* A handy assertion-style macro for testing for internally-caused errors */

#define BUGCHECK( expr )						\
    { 									\
	if( expr )	__asm__ __volatile__("call_pal 129 # bugchk");	\
    }

/*--------------------------------------------------------------------*/
/* How is the diagnostic firmware supposed to behave?  Depends on the reason 
 * for invocation */

/* when we enter the diagnostics, it could be for any one of several
 * reasons.  Each different purpose may require different behaviour */

enum startupcode {

	/* Fixed values passed up from the SROM */

        PASSTHROUGH=0,          /* Pass-through to BIOS or SRM */
        FACTORY=1,		/* clear NVRAM settings */
        BIOSRECOVER=2,		/* BIOS is corrupt, recover it (FSB) */
        ADERECOVER=3,		/* This image is corrupt, BIOS recovers it */
        DIAGSLEVEL0=4,		/* Diags level 0 (batch) */
        DIAGSLEVEL1=5,		/* Diags level 1 (batch) */
        DIAGSLEVEL2=6,		/* Diags level 2 (batch) */
        DIAGSLEVEL3=7,		/* Diags level 3 (batch) */
        DIAGSINT0=8,		/* Interactive diags level 0 */
        DIAGSINT1=9,		/* Interactive diags level 1 */
        DIAGSINT2=10,		/* Interactive diags level 2 */
        DIAGSINT3=11,		/* Interactive diags level 3 */
        MFRG0=12,		/* Manufacturing diags test level 0 */
        MFRG1=13,		/* Manufacturing diags test level 1 */
        MFRG2=14,		/* Manufacturing diags test level 2 */
        PARANOIA=15,		/* Paranoid mode - for very sick boards */

	/* These codes are from the NVRAM, not generated by the PALcode/SROM */
	BOOTMANAGER,		/* Initial configuration and boot manager */
	EMBEDLINUX,		/* Linux kernel and PALcode embedded in ROM */

	UNSPECIFIED		/* Startup mode was not defined in PALcode */
};

extern unsigned char StartupMode;

String halt_code_string( int halt_code );
extern unsigned char halt_code;


/* Defined by the linker to mark start and end of compressed diags image */

extern unsigned char _uncompressed_start,
		     _uncompressed_text_end,
		     _edata,
		     _bss,
		     _ebss,
		     _uncompressed_end;


/* passed in by init uncompressing code */

extern unsigned char *diags_do_decompress;
extern unsigned char *compressed_img_start, *compressed_img_end;

/*--------------------------------------------------------------------*/
/* Interface presented by the diagnostics component */

/* If a diagnostic test requires the presence of initialised subsystems, it
 * says so by setting these masking bits */

/* NB if you add something here, add a companion entry in dbm/main.c */

enum systems {  SYS_NONE        = 0,
                SYS_PCI         = 1 << 0,	/* PCI config done, rsrcs set */
                SYS_ISA         = 1 << 1,	/* IO ports (superIO) enabled */
                SYS_VGA         = 1 << 2,	/* VGA card setup and init */
                SYS_IRQ         = 1 << 3,	/* Interrupt system */
		SYS_SMP		= 1 << 4,	/* Multi-processing */
		SYS_I2C		= 1 << 5,	/* I2C bus setup */
		SYS_CONS	= 1 << 6,	/* User console online */
		SYS_MEM		= 1 << 7	/* Memory system */
};



/* Status of a test can be set by calling mobo_state with one of these args */

enum dev_state {        DEV_UNKNOWN     = 0,
                        DEV_SETUP       = 1,
                        DEV_PROBING     = 2,
                        DEV_PROBED      = 3,
                        DEV_STRESSING   = 4,
                        DEV_PASSED      = 5,
			DEV_NOTCONFIG   = 6,
                        DEV_FAILED      = 7
};

/* Get the diags to run a command as though a user had typed it */
DBM_STATUS diags_usercmd( const String C );

/* Set the state of a subsystem as presented by the diags interface */
void diags_subsys_stat(enum systems sy, enum dev_state st);


/* Bring the default (or a likely alternative) console online for interaction */
void bring_up_console( void );

/*--------------------------------------------------------------------*/


/*
 *  Sysdata is a structure containing system specific data.
 */
extern ImpureRgn_t *impure[], *primary_impure;



/* Date and time details */

extern const char DaysOfWeek[], MonthsOfYear[];

/* This variable is updated on every timer periodic interrupt -
 * interrupts must be enabled for any effect */

extern unsigned long volatile jiffies;






/* Data download via Xmodem */

extern int XReceive( void *Address, io_dev D );

/* These functions are not implemented locally (in DBM); they are 
   taken from the host's build environment.
*/
extern char  *strcpy(char *, const char *);
extern char  *strncpy(char *, const char *, size_t );
extern int   strcmp(const char *, const char *);
extern int   strncmp(const char *,const char *,size_t );
extern char *strncat(char *s1, const char *s2, size_t n);
extern char *strcat(char *s1, const char *s2);
extern char *strchr(const char *s, int c);
extern char *strrchr(const char *s, int c);
extern char *strstr(const char *s1, const char *s2);
extern void *memmove(void *s1, const void *s2, size_t n);



/*::::::::::::::
beep.c
::::::::::::::*/
extern void tone(int period , int duration);
extern void Beep(int msec , int freq);
extern void BeepCode(int code);



/*::::::::::::::
calloc.c
::::::::::::::*/
extern void *calloc(size_t num_of_elts, size_t elt_size);
void cfree(void *pointer);


/*::::::::::::::
ctype.c
::::::::::::::*/
extern int isalnum(int c);
extern int isalpha(int c);
extern int isascii(int c);
extern int iscntrl(int c);
extern int isdigit(int c);
extern int isgraph(int c);
extern int islower(int c);
extern int isprint(int c);
extern int ispunct(int c);
extern int isspace(int c);
extern int isupper(int c);
extern int isxdigit(int c);
extern int tolower(int c);
extern int toupper(int c);



/*::::::::::::::
exit.c
::::::::::::::*/
extern void exit (int status);
extern void abort (void);




/*::::::::::::::
printf_dbm.c
::::::::::::::*/

#if _WIN32
#define PRINTF_L_LARGE
#define PRINTF_sl_  "L"
#else
#define PRINTF_sl_  "l"
#endif

#include "printf_dbm.h"


/*::::::::::::::
rand.c
::::::::::::::*/
extern smp_mutex drandom_mutex;		/* an assist to enforce coherency */
extern uint64 seed_cache[ MAX_CPUS ];
extern uint32 random(void);
extern uint64 qrandom(void);
extern int srandom( unsigned int seed);


/*::::::::::::::
rw.c
::::::::::::::*/
#ifdef _WIN32
/*
** defined in asmstuff.h and asmstuff.s because NT uses 32 bit pointers
** and we support 64 bit!
*/
#else
#define WriteB(address,value)	    (*(ub *)(address)=(ub)(value))
#define ReadB(address)		    (*(ub *)(address))
#define WriteW(address,value)	    (*(uw *)(address)=(uw)(value))
#define ReadW(address)		    (*(uw *)(address))
#define WriteL(address,value)	    (*(ui *)(address)=(ui)(value))
#define ReadL(address)		    (*(ui *)(address))
#define WriteQ(address,value)	    (*(ul *)(address)=(ul)(value))
#define ReadQ(address)		    (*(ul *)(address))
#define WriteFloat(address,value)   (*(float *)(address)=(float)(value))
#define ReadFloat(address)	    (*(float *)(address))
#define WriteDouble(address,value)  (*(double *)(address)=(double)(value))
#define ReadDouble(address)	    (*(double *)(address))
#endif

/*::::::::::::::
scanf.c
::::::::::::::*/
extern int scanf(const char *f, ... );
extern int sscanf( const char *str, const char *f, ...);
extern int fscanf( FILE * OutFile, const char * CtrlStr, ... );






/*::::::::::::::
strtod.c
::::::::::::::*/
extern double atof(const char *nptr);
extern double strtod(const char *nptr, char **endptr);


/*::::::::::::::
strtoul.c
::::::::::::::*/
extern ul strtoul64( const char *nptr, char **endptr, int base);
extern unsigned long int strtoul( const char *nptr, char **endptr, int base);
extern long int strtol( const char *nptr, char **endptr, int base);
extern int atoi(const char * nptr);
extern long int atol(const char *nptr);


/*::::::::::::::
string.c
::::::::::::::*/
extern size_t strlen(char * s);
extern int memcmp(const void * pcs , const void * pct , size_t n);
extern void * memset(void * ps , int c , size_t n);
extern void * memcpy(void * ps , const void * pct , size_t n);

extern void rton( String S );	/* Convert \r to \n ... */
extern void ntor( String S );	/* ... and vice versa */


 
/*::::::::::::::
time.c
::::::::::::::*/
extern struct tm * localtime(const time_t * tp);
extern void usleep(unsigned long usecs);
extern void msleep(unsigned long ms);
extern void sleep(ui seconds);
extern time_t gettime(void );

/* writes formatted CMOS date, nb the user must allocate sufficient buffer */
extern DBM_STATUS datestamp( String S );
extern void system_datestamp( const String prefix );



/*::::::::::::::
bios.c
::::::::::::::*/
extern DBM_STATUS go_bios( int argc, char *argv[] );


/*::::::::::::::
interrupts.c
::::::::::::::*/
extern DBM_STATUS ipl( int argc, char *argv[] );


/*::::::::::::::
linux.c
::::::::::::::*/
extern DBM_STATUS go_linux( int argc, char *argv[] );

/* Take a previously-used configuration from the firmware and reboot it */
extern DBM_STATUS reboot_linux( void );


/*::::::::::::::
flashfw.c
::::::::::::::*/
extern DBM_STATUS reflash( int argc, char *argv[] );


/*::::::::::::::
dld.c
::::::::::::::*/
extern DBM_STATUS dld( int argc, char *argv[] );


#endif /* DIAGS__LIB_H_LOADED */
