/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/
/* Init-state I/O - really simple stuff for messages before the main
 * program is decompressed */

#include "init.h"		/* our primordial world */
#include "cserve.h"
#include "sromport.h"

/*
 * This code remains uncompressed, so keep it as simple as possible
 */

void init_ioport(void)
{
    /* On Swordfish, the SROM doesn't pass up the UART calibration, so 
     * this pointer is never set */

    /* Under certain circumstances, we should skip the auto-bauding,
     * because it is blocking and there may be nobody listening.  All SROM
     * IO is then silently dropped.  In the full diags, selecting SROM as an
     * IO stream would then lead to an auto-bauding */

    if ( I->AUTOBAUD == 0 )
        I->AUTOBAUD = cServe(0, 0, CSERVE_K_SROM_INIT);
}

void init_putstr(const char *msg)
{
    if( I->AUTOBAUD == 0 || I->AUTOBAUD == SROM_NO_AUTOBAUD )
	return;					/* not putting out msgs */

    while (*msg) {
	if ( *msg == '\n' ) {
	    cServe(0, '\n', CSERVE_K_SROM_PUTC, I->AUTOBAUD );
	    cServe(0, '\r', CSERVE_K_SROM_PUTC, I->AUTOBAUD );
	} else {
	    cServe(0, (unsigned long)*msg, CSERVE_K_SROM_PUTC, I->AUTOBAUD );
	}
	msg++;
    }
}

