#ifndef DIAGS__SWORDFISH_H__LOADED
#define DIAGS__SWORDFISH_H__LOADED
/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/
/* (c) 1999 Alpha Processor, Inc, begun 19 April 1999 by Stig Telfer */
/* Details and definitions for the Swordfish (UP2000) platform */


/* PCI device IDs */

/* NOTE - these numbers are drawn from the Swordfish spec IDSEL numbers - 
 * they are almost certainly wrong: note the 0x18, 0x19, 0x20 pseudosequence */

#define PCI0_DEC_TSU	0	/* bridge to PCI bus */
#define PCI0_CYP_ISA	5	/* NB has 4 functions: ISA, IDE0, IDE1, USB */
#define PCI0_AIC_SCSI	6

#define PCI0_SLOT1	7
#define PCI0_SLOT2	8
#define PCI0_SLOT3	9

#define PCI1_SLOT4	7
#define PCI1_SLOT5	8
#define PCI1_SLOT6	9


/* Global standard definitions */

#define PLAT_ISAID      PCI0_CYP_ISA
#define PLAT_IDEID      PCI0_CYP_ISA
#define PLAT_PMUID      PCI0_CYP_ISA
#define PLAT_USBID      PCI0_CYP_ISA


/*----------------------------------------------------------------------*/
/* UP2000/DP264-specific TIGbus IO magic numbers */
/* These routines can only be accessed by code that _knows_ it is in a
 * Tsunami system: ie, it can only be called from the platform and northbridge
 * modules */

/* the '>> 6' here is for conformity with writing the the flash ROM, for which
 * the addresses are shifted up by 6 */

#define TIG_GPEN4       (0x28000000UL >> 6)     /* motherboard jumper block */
#define TIG_GPEN5       (0x30000000UL >> 6)     /* CPU0 jumper block */
#define TIG_ROMENA      (0x30000040UL >> 6)     /* disable/enable writes*/
#define TIG_CPU0START	(0x30000A00UL >> 6)     /* for CPU0 start from SROM */
#define TIG_CPU1START	(0x30000A40UL >> 6)     /* for CPU1 start from SROM */
#define TIG_GPEN6       (0x38000000UL >> 6)     /* CPU1 jumper block */
#define TIG_SWRST	(0x38000100UL >> 6)     /* write 0, then 1 to reset */
#define TIG_PALREV      (0x38000140UL >> 6)     /* 7:5 major, 4:0 minor */


/*--------------------------------------------------------------------*/
/* UP2000/DP264 interrupt line configurations */


/* I2C SMBus */

#define I2C_INT_L	(1UL<<17)	/* I2C interrupt */
#define I2C_IOINT_L	(1UL<<48)	/* I2C interrupt (DP264 only) */
#define SLOTB_THRM_WARN	(1UL<<50)	/* Slot-B thermal warning (UP2K only) */


/* On-board Adaptec SCSI controller (NB UP2000 uses only ADPTA) */

#define PCI0_IRQ_ADPTA	(1UL<<19)	/* on-board SCSI int A */
#define PCI0_IRQ_ADPTB	(1UL<<18)	/* on-board SCSI int B (DP264 only) */


/* Cypress Southbridge interrupts */

#define PCI0_NMI	(1UL<<53)	/* NMI raised by southbridge */
#define PCI0_SMI_INT	(1UL<<54)	/* SMI raised by southbridge */
#define PCI0_INT	(1UL<<55)	/* ISA IRQ from southbridge */


/* Pchip error interrupts */

#define PCI0_BUS_ERROR	(1UL<<62)	/* Error on PCI bus 0 */
#define PCI1_BUS_ERROR	(1UL<<61)	/* Error on PCI bus 1 */


/* Slots on PCI bus 0 */

#define PCI0_IRQ_INTD2	(1UL<<20)	/* PCI bus 0 slot 2 IRQ D */
#define PCI0_IRQ_INTC2	(1UL<<21)	/* PCI bus 0 slot 2 IRQ C */
#define PCI0_IRQ_INTB2	(1UL<<22)	/* PCI bus 0 slot 2 IRQ B */
#define PCI0_IRQ_INTA2	(1UL<<23)	/* PCI bus 0 slot 2 IRQ A */

#define PCI0_IRQ_INTD1	(1UL<<24)	/* PCI bus 0 slot 1 IRQ D */
#define PCI0_IRQ_INTC1	(1UL<<25)	/* PCI bus 0 slot 1 IRQ C */
#define PCI0_IRQ_INTB1	(1UL<<26)	/* PCI bus 0 slot 1 IRQ B */
#define PCI0_IRQ_INTA1	(1UL<<27)	/* PCI bus 0 slot 1 IRQ A */

#define PCI0_IRQ_INTD0	(1UL<<28)	/* PCI bus 0 slot 0 IRQ D */
#define PCI0_IRQ_INTC0	(1UL<<29)	/* PCI bus 0 slot 0 IRQ C */
#define PCI0_IRQ_INTB0	(1UL<<30)	/* PCI bus 0 slot 0 IRQ B */
#define PCI0_IRQ_INTA0	(1UL<<31)	/* PCI bus 0 slot 0 IRQ A */


/* Slots on PCI bus 1 */

#define PCI1_IRQ_INTD2	(1UL<<36)	/* PCI bus 1 slot 2 IRQ D */
#define PCI1_IRQ_INTC2	(1UL<<37)	/* PCI bus 1 slot 2 IRQ C */
#define PCI1_IRQ_INTB2	(1UL<<38)	/* PCI bus 1 slot 2 IRQ B */
#define PCI1_IRQ_INTA2	(1UL<<39)	/* PCI bus 1 slot 2 IRQ A */

#define PCI1_IRQ_INTD1	(1UL<<40)	/* PCI bus 1 slot 1 IRQ D */
#define PCI1_IRQ_INTC1	(1UL<<41)	/* PCI bus 1 slot 1 IRQ C */
#define PCI1_IRQ_INTB1	(1UL<<42)	/* PCI bus 1 slot 1 IRQ B */
#define PCI1_IRQ_INTA1	(1UL<<43)	/* PCI bus 1 slot 1 IRQ A */

#define PCI1_IRQ_INTD0	(1UL<<44)	/* PCI bus 1 slot 0 IRQ D */
#define PCI1_IRQ_INTC0	(1UL<<45)	/* PCI bus 1 slot 0 IRQ C */
#define PCI1_IRQ_INTB0	(1UL<<46)	/* PCI bus 1 slot 0 IRQ B */
#define PCI1_IRQ_INTA0	(1UL<<47)	/* PCI bus 1 slot 0 IRQ A */


#define IRQ_ERR_NXM	(1UL<<63)	/* Triggers when "chip detects NXM" */


/*--------------------------------------------------------------------*/
/* UP2000/DP264 CMOS/RTC configuration overrides */

/* The square-wave pin (bit 3) is enabled in place of periodic interrupts
 * on Swordfish/DP264 family motherboards.  IRQ8 connection is ignored */

#define CM_STATUSB__INIT	(STATUSB_SQR | STATUSB_BIN | STATUSB_24HR) 


/*--------------------------------------------------------------------*/
/* I2C bus layout */

/* I2C bus from UP2000 tech ref */
#define SWORD_I2C_LM75_0	0x94		/* Slot-B 0 thermal sensor */
#define SWORD_I2C_LM75_1	0x9C		/* Slot-B 1 thermal sensor */
#define SWORD_I2C_PCF8582_MB	0xA2		/* Motherboard EPROM */
#define SWORD_I2C_PCF8582_0	0xA4		/* Slot-B 0 EPROM */
#define SWORD_I2C_PCF8582_1	0xAC		/* Slot-B 1 EPROM */


/* Extra devices on UP2000+ */

#define SWPLUS_I2C_ADM_0	0x58		/* Primary ADM9240 */
#define SWPLUS_I2C_ADM_1	0x5A		/* Secondary ADM9240 */


/* PCF8574 8-bit register (U72) Control / Status register 0 */
/*    p0: primary cpu present (RO: 0 == asserted)
 *    p1: secondary cpu present (RO: 0 == asserted)
 *    p2: primary cpu core power good (RO: 1 == asserted)
 *    p3: secondary cpu core power good (RO: 1 == asserted)
 *    p4: primary cpu SRAM power level  (RO: 0 == 2.5V, 1 == 3.3V)
 *    p5: secondary cpu SRAM power level (RO: 0 == 2.5V, 1 == 3.3V)
 *    p6: assert halt (RW: 0 == asserted 1 == deasserted)
 *    p7: system reset (RW: 1->0->1 asserts reset)
 *    int: interrupt line 32
 */
#define SWPLUS_I2C_PCF8574_0		0x70		
#define SWPLUS_I2C_PCF8574_0_ALT	0x40	/* See bodges, plat_i2cinit */
#define		SWPL_R0_P0_PRESENT	(1<<0)
#define		SWPL_R0_P1_PRESENT	(1<<1)
#define		SWPL_R0_P0_CORE		(1<<2)
#define		SWPL_R0_P1_CORE		(1<<3)
#define		SWPL_R0_P0_SRAM		(1<<4)
#define		SWPL_R0_P1_SRAM		(1<<5)
#define		SWPL_R0_HALT_ASSRT	(1<<6)
#define		SWPL_R0_RESET		(1<<7)


/* PCF8574 8-bit register (U1) Control / Status register 1 */
/*    p0: system fail LED (RO: 0 == illuminated)
 *    p1: PSU power ok LED (RO: 0 == illuminated)
 *    p2: PSU AC Fail  (RO: 0 == asserted)
 *    p3: slot B module type mismatch (RO: 0 == asserted)
 *    p4: rack PSU connected (RO: 0 == RACK PSU 1 == ATX PSU)
 *    p5: slot B module speed mismatch (RO: 0 == asserted)
 *    p6: PSU output inhibit (RW: 0 == asserted 1 == deasserted)
 *    p7: system fail LED (RW: 0 == illuminated 1 == deasserted)
 */
#define SWPLUS_I2C_PCF8574_1		0x72
#define SWPLUS_I2C_PCF8574_1_ALT	0x42	/* See bodges, plat_i2cinit */
#define		SWPL_R1_SYSFAIL		(1<<0)
#define		SWPL_R1_PWRGOOD		(1<<1)
#define		SWPL_R1_ACFAIL		(1<<2)
#define		SWPL_R1_TYPE_MATCH	(1<<3)
#define		SWPL_R1_RACKPSU		(1<<4)
#define		SWPL_R1_SPEED_MATCH	(1<<5)
#define		SWPL_R1_PSU_INHIBIT	(1<<6)
#define		SWPL_R1_SYSFAILCTL	(1<<7)


/* PCF8574 8-bit register (U6) Motherboard revision byte */
#define SWPLUS_I2C_PCF8574_2		0x78
#define SWPLUS_I2C_PCF8574_2_ALT	0x48	/* See bodges, plat_i2cinit */

#define TEMP_MAX_MOBO	45
#define TEMP_HYST_MOBO	40


/*--------------------------------------------------------------------*/
/* magic functions */

extern unsigned char up2k_get_behav_code( void );

enum RTC_failuremodes {
    RTC_OK,                     /* Timer is working as far as we can tell */
    RTC_ERRATIC,                /* Timer is irregular beyond acceptability */
    RTC_FAST,                   /* Timer is going significantly fast */
    RTC_SLOW,                   /* Timer is going significantly slow */
    RTC_STOPPED                 /* Timer isn't even going */
};

extern int up2k_rtc_status;
extern double up2k_rtc_xbar, up2k_rtc_sigma;

extern DBM_STATUS up2k_rtc_analyse( void );


#endif		/* DIAGS__SWORDFISH_H__LOADED */
