/*
 *        Copyright (c) Digital Equipment Corporation, 1990
 *        All Rights Reserved.  Unpublished-rights reserved
 *        under the copyright laws of the United States.
 *
 *        The software contained on this media is proprietary to"
 *        and embodies confidential technology of Digital.  Possession,
 *        use, duplication or dissemination of the software and media
 *        is authorized only pursuant to a valid written license from
 *        Digital.
 *
 *        RESTRICTED RIGHTS LEGEND  Use, duplication, or disclosure"
 *        by the U.S. Government is subject to restrictions as set 
 *        forth in subparagraph (c)(1)(ii) of DFARS 252.227-7013, or 
 *        in FAR 52.227-19, as applicable.
 */

/*
 *++
 *  FACILITY:
 *
 *      Color Frame Buffer Test Routines 
 *
 *  ABSTRACT:
 *
 *      BT459 RAMDAC test .
  *
 *  AUTHORS:
 *
 *      James Peacock
 *
 *
 *  CREATION DATE:      02-11-91
 *
 *  MODIFICATION HISTORY:
 *      Initial Modification	
 *
 *
 *--
*/

/**
** INCLUDES
**/
#include   "cp$src:platform.h"
#include "cp$src:common.h"
#include "cp$inc:prototypes.h"
#include "cp$src:tga_sfbp_include.h"
#include "cp$src:tga_sfbp_callbacks.h"
#include "cp$src:tga_sfbp_prom_defines.h"
#include "cp$src:tga_sfbp_def.h"
#include "cp$src:tga_sfbp_protos.h"
#include "cp$src:tga_sfbp_463.h"
#include "cp$src:tga_sfbp_485.h"
#include "cp$src:tga_sfbp_ext.h"
#include "cp$src:tga_sfbp_crb_def.h"
#include "cp$src:tga_sfbp_ctb_def.h"
#include "cp$src:prdef.h"

extern    int      TGAInterruptCount[];

#define ClockIpl  21
#define DeviceIpl 16
#define HaltIpl	  31

extern  int TgaVector[];


/*+
* ===========================================================================
* = int$$assert_test - Interrupt Assert Test =
* ===========================================================================
*
* OVERVIEW:
*       Verify the module can interrupt cpu.
* 
* FORM OF CALL:
*       int$$assert_test (argc,argv,ccv,scia_ptr,data_ptr,param )
*
* ARGUMENTS:
*       argc        - argument count
*       argv        - argument array
*       ccv         - callback vector
*       scia_ptr    - shared driver pointer
*       data_ptr    - driver data pointer
*       param       - error parameter array
*
* FUNCTIONAL DESCRIPTION:
*       This routine verifies that the module can assert an enf of frame interrupt.
*
	The Interrupt Status register is a bitfield combination of the
	conditions which caused the interrupt. The status bits can be
	cleared by writing ones to the bits.  Once all enabled status
	bits have been cleared, the SFB+ will deassert its interrupt
	line.

	Interrupt Enable is provided in bits<19:16> and controls
        whether interrupts generated by the SFB+ will be posted
	If the enable bit for a specific condition is set, interrupts
	will be posted, if the enable bit is not set, interrupts
	will not be posted.

	31                 21 20     16 15                   5 4       0
	+--------------------+---------+----------------------+--------+
	|      ignore        | Enable  |         ignore       | Status |
	+--------------------+---------+----------------------+--------+

	Status Bits:	<4> - Timer
			<3> - Parity error
			<2> - DMA error
			<1> - At shift addr
			<0> - End of Frame

	End of Frame interrupts are issued by the video logic at the start
	of vertical retrace.

	Shift Address interrupts are issued by the memory system when a
	a serial transfer operation is performed to a row address that
	matched the Interrupt Shift Address register value.

	DMA error interrupts are issued when the Bus logic receives an
	system error condition during a DMA operation.

	Parity error interrupts are issued by the bus logic when bad parity
	is received on read addresses, write addresses or write data captured
	by the bus logic.

	Timer interrupts occur between 6us and 8us after the timer interrupt
	status bit is cleared.  The timer interrupt is useful for generating
	the timing references necessary to program the option EEPROM.

	Value at init: 0
*
*       
--*/
int     int$$assert_test (int argc,char *argv,CCV *ccv,SCIA *scia_ptr, SFBP *data_ptr,int param[])

{
register  int      pixel=0,count,i,done,s=1,seconds;

 /* Since this is polled...we don't have to enable interrupts	*/
 /* Clear any requests and poll for it				*/

 data_ptr->sfbp$l_int_poll = 1;
 (*gfx_func_ptr->pv_disable_interrupt) (scia_ptr,data_ptr,end_of_frame);
 (*gfx_func_ptr->pv_clear_int_req)     (scia_ptr,data_ptr,end_of_frame);
 s=(*bt_func_ptr->pv_bt_wait_interrupt)(scia_ptr,data_ptr,FALSE,pixel,end_of_frame,FALSE);

 if (!(s&1))
      {
      param[0] = sfbp$k_a_sfbp_reg_space | sfbp$k_int_status;
      param[1] = 1<<end_of_frame;
      param[2] = (*gfx_func_ptr->pv_sfbp_read_reg)(scia_ptr,sfbp$k_int_status);
      s = 0;
      }
 
(*gfx_func_ptr->pv_disable_interrupt) (scia_ptr,data_ptr,end_of_frame);

return (s);
}


/*+
* ===========================================================================
* = int$$noassert_test - No Interrupt Assert Test =
* ===========================================================================
*
* OVERVIEW:
*       Verify the module can not interrupt cpu.
* 
* FORM OF CALL:
*       int$$noassert_test (arc,argv,ccv,scia_ptr,data_ptr,param )
*
* ARGUMENTS:
*       argc        - argument count
*       argv        - argument array
*       ccv         - callback vector
*       scia_ptr    - shared driver pointer
*       data_ptr    - driver data pointer
*       param       - error parameter array
*
* FUNCTIONAL DESCRIPTION:
*               Verify the module will not assert an interrupt when disabled.
*
--*/
int     int$$noassert_test (int argc,char *argv,CCV *ccv,SCIA *scia_ptr, SFBP *data_ptr,int param[])

{
register int      pixel,i,done,s=1;

/* Problem with this test with interrupts coming in */
 data_ptr->sfbp$l_int_poll = 0;
 TGAInterruptCount[data_ptr->sfbp$l_slot_number] = 0;

 (*gfx_func_ptr->pv_disable_interrupt) (scia_ptr,data_ptr,end_of_frame);
 (*gfx_func_ptr->pv_clear_int_req)     (scia_ptr,data_ptr,end_of_frame);
 s=(*bt_func_ptr->pv_bt_wait_interrupt)(scia_ptr,data_ptr,FALSE,pixel,end_of_frame,FALSE);

 if (s&1)
      {
      param[0] = sfbp$k_a_sfbp_reg_space | sfbp$k_int_status;
      param[1] = 0;
      param[2] = (*gfx_func_ptr->pv_sfbp_read_reg)(scia_ptr,sfbp$k_int_status);
      return (0);
      }

(*gfx_func_ptr->pv_disable_interrupt) (scia_ptr,data_ptr,end_of_frame);

return (1);

}


/*+
* ===========================================================================
* = int$$timer_test - Interrupt timer Test =
* ===========================================================================
*
* OVERVIEW:
*       Verify the module can interrupt cpu.
* 
* FORM OF CALL:
*       int$$timer_test (argc,argv,ccv,scia_ptr,data_ptr,param )
*
* ARGUMENTS:
*       argc        - argument count
*       argv        - argument array
*       ccv         - callback vector
*       scia_ptr    - shared driver pointer
*       data_ptr    - driver data pointer
*       param       - error parameter array
*
* FUNCTIONAL DESCRIPTION:                                               
*       This routine verifies that the module can timer an enf of frame interrupt.
*
	The Interrupt Status register is a bitfield combination of the
	conditions which caused the interrupt. The status bits can be
	cleared by writing ones to the bits.  Once all enabled status
	bits have been cleared, the SFB+ will detimer its interrupt
	line.

	Interrupt Enable is provided in bits<19:16> and controls
        whether interrupts generated by the SFB+ will be posted
	If the enable bit for a specific condition is set, interrupts
	will be posted, if the enable bit is not set, interrupts
	will not be posted.

	31                 21 20     16 15                   5 4       0
	+--------------------+---------+----------------------+--------+
	|      ignore        | Enable  |         ignore       | Status |
	+--------------------+---------+----------------------+--------+

	Status Bits:	<4> - Timer
			<3> - Parity error
			<2> - DMA error
			<1> - At shift addr
			<0> - End of Frame

	End of Frame interrupts are issued by the video logic at the start
	of vertical retrace.

	Shift Address interrupts are issued by the memory system when a
	a serial transfer operation is performed to a row address that
	matched the Interrupt Shift Address register value.

	DMA error interrupts are issued when the Bus logic receives an
	system error condition during a DMA operation.

	Parity error interrupts are issued by the bus logic when bad parity
	is received on read addresses, write addresses or write data captured
	by the bus logic.

	Timer interrupts occur between 6us and 8us after the timer interrupt
	status bit is cleared.  The timer interrupt is useful for generating
	the timing references necessary to program the option EEPROM.

	Value at init: 0
*
*       
--*/
int     int$$timer_test (int argc,char *argv,CCV *ccv,SCIA *scia_ptr, SFBP *data_ptr,int param[])

{
register  int      pixel=0,count,i,done,s=1,seconds;

 /* The timer bit should be set/clear always     */

 data_ptr->sfbp$l_int_poll = 1;
 (*gfx_func_ptr->pv_disable_interrupt) (scia_ptr,data_ptr,timer);
 (*gfx_func_ptr->pv_clear_int_req)     (scia_ptr,data_ptr,timer);
 s=(*bt_func_ptr->pv_bt_wait_interrupt)(scia_ptr,data_ptr,FALSE,pixel,timer,FALSE);

 if (!(s&1))     
      {
      param[0] = sfbp$k_a_sfbp_reg_space | sfbp$k_int_status;
      param[1] = 1<<timer;
      param[2] = (*gfx_func_ptr->pv_sfbp_read_reg)(scia_ptr,sfbp$k_int_status);
      s = 0;
      }
 
(*gfx_func_ptr->pv_disable_interrupt) (scia_ptr,data_ptr,timer);
     
return (s);

}


/*+
* ===========================================================================
* = int$$assert_post_test - Interrupt Assert Post Test =
* ===========================================================================
*
* OVERVIEW:
*       Verify the module can interrupt cpu.
* 
* FORM OF CALL:
*       int$$assert_post_test (argc,argv,ccv,scia_ptr,data_ptr,param )
*
* ARGUMENTS:
*       argc        - argument count
*       argv        - argument array
*       ccv         - callback vector
*       scia_ptr    - shared driver pointer
*       data_ptr    - driver data pointer
*       param       - error parameter array
*
* FUNCTIONAL DESCRIPTION:
*       This routine verifies that the module can assert an enf of frame interrupt.
*
	The Interrupt Status register is a bitfield combination of the
	conditions which caused the interrupt. The status bits can be
	cleared by writing ones to the bits.  Once all enabled status
	bits have been cleared, the SFB+ will deassert its interrupt
	line.

	Interrupt Enable is provided in bits<19:16> and controls
        whether interrupts generated by the SFB+ will be posted
	If the enable bit for a specific condition is set, interrupts
    	will be posted, if the enable bit is not set, interrupts
    	will not be posted.
    
    	31                 21 20     16 15                   5 4       0
    	+--------------------+---------+----------------------+--------+
    	|      ignore        | Enable  |         ignore       | Status |
    	+--------------------+---------+----------------------+--------+
    
    	Status Bits:	<4> - Timer
    			<3> - Parity error
    			<2> - DMA error
    			<1> - At shift addr
    			<0> - End of Frame
    
    	End of Frame interrupts are issued by the video logic at the start
    	of vertical retrace.
    
    	Shift Address interrupts are issued by the memory system when a
    	a serial transfer operation is performed to a row address that
    	matched the Interrupt Shift Address register value.
    
    	DMA error interrupts are issued when the Bus logic receives an
    	system error condition during a DMA operation.
    
    	Parity error interrupts are issued by the bus logic when bad parity
    	is received on read addresses, write addresses or write data captured
    	by the bus logic.
    
    	Timer interrupts occur between 6us and 8us after the timer interrupt
    	status bit is cleared.  The timer interrupt is useful for generating
    	the timing references necessary to program the option EEPROM.
    
    	Value at init: 0
*   
*       
--*/
int     int$$assert_post_test (int argc,char *argv,CCV *ccv,SCIA *scia_ptr, SFBP *data_ptr,int param[])
    
{   
register int      pixel=0,count,i,done,s=1,seconds;

 /* If polled...skip the test	*/    
 if (TgaVector[data_ptr->sfbp$l_slot_number]==0)return (1);

 /* Here we wait for flag set in ISR routine	*/
 /* Although we could wait for a process signal */
 /* Disable and clear and then enable..wait	*/

 TGAInterruptCount[data_ptr->sfbp$l_slot_number] = 0;
 data_ptr->sfbp$l_int_poll = 0;
 (*gfx_func_ptr->pv_disable_interrupt) (scia_ptr,data_ptr,end_of_frame);
 (*gfx_func_ptr->pv_clear_int_req)     (scia_ptr,data_ptr,end_of_frame);
 (*gfx_func_ptr->pv_enable_interrupt)  (scia_ptr,data_ptr,end_of_frame);
 s=(*bt_func_ptr->pv_bt_wait_interrupt)(scia_ptr,data_ptr,FALSE,pixel,end_of_frame,FALSE);

 if (!(s&1))
       {
       param[0] = sfbp$k_a_sfbp_reg_space | sfbp$k_int_status;
       param[1] = 1<<end_of_frame;
       param[2] = (*gfx_func_ptr->pv_sfbp_read_reg)(scia_ptr,sfbp$k_int_status)&1;
       s = 0;
       }
 
 (*gfx_func_ptr->pv_disable_interrupt) (scia_ptr,data_ptr,end_of_frame);

return (s);
}



/*+
* ===========================================================================
* = int$$scanline_test - End Scanline Interrupt Test =
* ===========================================================================
*
* OVERVIEW:
*       Scanline Interrupt Test 
* 
* FORM OF CALL:
*       int$$scanline_test (arc,argv,ccv,scia_ptr,data_ptr,param )
*
* ARGUMENTS:
*       argc        - argument count
*       argv        - argument array
*       ccv         - callback vector
*       scia_ptr    - shared driver pointer
*       data_ptr    - driver data pointer
*       param       - error parameter array
*
* FUNCTIONAL DESCRIPTION:
*               Enable end of scanline interrupts. The video ram shift register
*               contains the video ram row which will give us an interrupt at
*               the end of the scan load. This register should be loaded with
*               zero and the scanline interrupt enabled.
*
*	The Video Shift Address register defines VRAM row address where an
	interrupt should be issued after the contents are loaded into the VRAM
	serial shift register.  When this register is read, the last address
	shifted into the VRAM serial register is provided in bits<25:16>.

	31                    20 19               10 9                 0
	+-----------------------+-------------------+------------------+
	|        ignore         |  Last Shift Addr  |  Intr Shift Addr |
	+-----------------------+-------------------+------------------+

	Value at init: 0

(Software notes)

	Double-buffering applications on the 8-bit systems have to copy the
	back buffer to the front buffer.  In order to prevent tearing of
	images, in which the monitor displays some data from an old image and
	some data from a new image in one frame, the double-buffering extension
	software MAY want to delay the copy until the last line of the window
	has been displayed in the current frame.  Then scramble like hell to
	copy the new data into the window.  (Actually, you can start the copy a
	little earlier...you really just need to ensure that the copy won't
	catch up to the display to the monitor.)


*
--*/
int     int$$scanline_test (int argc,char *argv,CCV *ccv,SCIA *scia_ptr, SFBP *data_ptr,int param[])

{
 register int pixel=0,s=1,temp;

 data_ptr->sfbp$l_int_poll = 1;
      
 temp = 10;
 (*gfx_func_ptr->pv_sfbp_write_reg)(scia_ptr,sfbp$k_video_status,temp,LW);
 (*gfx_func_ptr->pv_clear_int_req)    (scia_ptr,data_ptr,end_of_scan);
 s=(*bt_func_ptr->pv_bt_wait_interrupt) (scia_ptr,data_ptr,FALSE,pixel,end_of_scan,FALSE);
 if (!(s&1))
       {
       param[0] = sfbp$k_a_sfbp_reg_space | sfbp$k_int_status;
       param[1] = 1<<end_of_scan;
       param[2] = (*gfx_func_ptr->pv_sfbp_read_reg)(scia_ptr,sfbp$k_int_status);
       }
      
 return ( s&1 ? 1 : 0);
}

