/*
TAPEINFO is a Linux utility to dump the inquiry and log pages of the
Hewlett-Packard C1533A tape drive.

Copyright 1995 Eric L. Smith

TAPEINFO is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License version 2 as published by the Free
Software Foundation.  Note that I am not granting permission to redistribute
or modify TAPEINFO under the terms of any later version of the General Public
License.

This program is distributed in the hope that it will be useful (or at least
amusing), but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
Public License for more details.

You should have received a copy of the GNU General Public License along with
this program (in the file "COPYING"); if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

$Header: /usr/home/kolwynia/eric/tapeinfo/RCS/scsicmd.c,v 1.1 1995/09/11 18:20:50 eric Exp eric $
*/

#include "/usr/src/linux/drivers/scsi/sg.h"

#include "scsicmd.h"

#ifdef SCSI_DEBUG
#include <stdio.h>
#endif /* SCSI DEBUG */


int scsi_command (int fid,
		  unsigned char *command,
		  int cmd_len,
		  unsigned char *reply,
		  int reply_len)
{
  int count, result;
  static char buf [4096 + sizeof (struct sg_header)];
  static struct sg_header * hdr = (struct sg_header *) & buf [0];

  hdr->pack_len = sizeof (struct sg_header) + cmd_len;
  hdr->reply_len = sizeof (struct sg_header) + reply_len;

  memcpy (buf + sizeof (struct sg_header), command, cmd_len);

#ifdef SCSI_DEBUG
  fprintf (stderr, "hdr->pack_len = %d, hdr->reply_len = %d\n",
	   hdr->pack_len, hdr->reply_len);
#endif /* SCSI_DEBUG */

  if (write (fid, buf, hdr->pack_len) == -1)
    return -1;

  if ((count = read (fid, buf, hdr->reply_len)) == -1) 
    return -2;

#ifdef SCSI_DEBUG
  fprintf (stderr, "count = %d, hdr->pack_len = %d, hdr->reply_len = %d\n",
	   count, hdr->pack_len, hdr->reply_len);
#endif /* SCSI_DEBUG */

  if (hdr->result) 
    return -3;

  if (count > sizeof (struct sg_header)) 
    {
      count -= sizeof (struct sg_header);
      memcpy (reply, buf + sizeof (struct sg_header), count);
    }
  else
    count = 0;

  return count;
}


