
// The global 16 bit variable delay_count must contain the
// CPU clock freq in Hz divided by 4000 and must have been 
// set before calling this routine for the first time.
// ms_delay calibrated for ATmega168 in 2013 by HJS. 

// Some includes 
#include <inttypes.h>
#include <avr/io.h>
#include <avr/pgmspace.h>
#include <avr/interrupt.h>

#include "IBM_keyboard.h"

extern uint16_t delay_count;

void ms_delay(uint16_t ms) {
   uint16_t cnt;
   asm volatile (
      "\n"
      "L_dl1%=:"     "\n\t"
      "mov %A0, %A2" "\n\t"
      "mov %B0, %B2" "\n"
      "L_dl2%=:"     "\n\t"
      "sbiw %A0, 1"  "\n\t"
      "brne L_dl2%=" "\n\t"
      "dec %1"       "\n\t"
      "brne L_dl1%=" "\n\t"
      : "=&w" (cnt)
      : "r" (ms), "r" (delay_count)
   );
}


